/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util.simulate;

import com.blisscloud.ezuc.client.annotation.SimulateAndroid;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.Parcelable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

@SimulateAndroid(androidClassName="android.os.Bundle")
public class Bundle {
    public static final Bundle EMPTY = new Bundle();
    static final int BUNDLE_MAGIC = 1279544898;
    HashMap<String, Object> mMap = null;
    private boolean mHasFds = false;
    private boolean mFdsKnown = true;
    private boolean mAllowFds = true;
    private ClassLoader mClassLoader;

    public Bundle() {
        this.mMap = new HashMap();
        this.mClassLoader = this.getClass().getClassLoader();
    }

    public Bundle(ClassLoader loader) {
        this.mMap = new HashMap();
        this.mClassLoader = loader;
    }

    public Bundle(int capacity) {
        this.mMap = new HashMap(capacity);
        this.mClassLoader = this.getClass().getClassLoader();
    }

    public Bundle(Bundle b) {
        this.mMap = b.mMap != null ? new HashMap<String, Object>(b.mMap) : null;
        this.mHasFds = b.mHasFds;
        this.mFdsKnown = b.mFdsKnown;
        this.mClassLoader = b.mClassLoader;
    }

    public void setClassLoader(ClassLoader loader) {
        this.mClassLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public boolean setAllowFds(boolean allowFds) {
        boolean orig = this.mAllowFds;
        this.mAllowFds = allowFds;
        return orig;
    }

    public Object clone() {
        return new Bundle(this);
    }

    public boolean containsKey(String key) {
        return this.mMap.containsKey(key);
    }

    public void put(String key, Object obj) {
        this.mMap.put(key, obj);
    }

    public Object get(String key) {
        return this.mMap.get(key);
    }

    public void remove(String key) {
        this.mMap.remove(key);
    }

    public void putAll(Bundle map) {
        this.mMap.putAll(map.mMap);
        this.mHasFds |= map.mHasFds;
        this.mFdsKnown = this.mFdsKnown && map.mFdsKnown;
    }

    public Set<String> keySet() {
        return this.mMap.keySet();
    }

    public void putBoolean(String key, boolean value) {
        this.mMap.put(key, value);
    }

    public void putByte(String key, byte value) {
        this.mMap.put(key, value);
    }

    public void putChar(String key, char value) {
        this.mMap.put(key, Character.valueOf(value));
    }

    public void putShort(String key, short value) {
        this.mMap.put(key, value);
    }

    public void putInt(String key, int value) {
        this.mMap.put(key, value);
    }

    public void putLong(String key, long value) {
        this.mMap.put(key, value);
    }

    public void putFloat(String key, float value) {
        this.mMap.put(key, Float.valueOf(value));
    }

    public void putDouble(String key, double value) {
        this.mMap.put(key, value);
    }

    public void putString(String key, String value) {
        this.mMap.put(key, value);
    }

    public void putCharSequence(String key, CharSequence value) {
        this.mMap.put(key, value);
    }

    public void putIntegerArrayList(String key, ArrayList<Integer> value) {
        this.mMap.put(key, value);
    }

    public void putStringArrayList(String key, ArrayList<String> value) {
        this.mMap.put(key, value);
    }

    public void putCharSequenceArrayList(String key, ArrayList<CharSequence> value) {
        this.mMap.put(key, value);
    }

    public void putSerializable(String key, Serializable value) {
        this.mMap.put(key, value);
    }

    public void putBooleanArray(String key, boolean[] value) {
        this.mMap.put(key, value);
    }

    public void putByteArray(String key, byte[] value) {
        this.mMap.put(key, value);
    }

    public void putShortArray(String key, short[] value) {
        this.mMap.put(key, value);
    }

    public void putCharArray(String key, char[] value) {
        this.mMap.put(key, value);
    }

    public void putIntArray(String key, int[] value) {
        this.mMap.put(key, value);
    }

    public void putLongArray(String key, long[] value) {
        this.mMap.put(key, value);
    }

    public void putFloatArray(String key, float[] value) {
        this.mMap.put(key, value);
    }

    public void putDoubleArray(String key, double[] value) {
        this.mMap.put(key, value);
    }

    public void putStringArray(String key, String[] value) {
        this.mMap.put(key, value);
    }

    public void putCharSequenceArray(String key, CharSequence[] value) {
        this.mMap.put(key, value);
    }

    public void putJSONArray(String key, JSONArray array) {
        this.mMap.put(key, array);
    }

    public void putJSONObject(String key, JSONObject obj) {
        this.mMap.put(key, obj);
    }

    public void putBundle(String key, Bundle value) {
        this.mMap.put(key, value);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public void putBoolean(String key, Boolean ch) {
        this.mMap.put(key, ch);
    }

    private void typeWarning(String key, Object value, String className, Object defaultValue, ClassCastException e) {
        StringBuilder sb = new StringBuilder();
        sb.append("Key ");
        sb.append(key);
        sb.append(" expected ");
        sb.append(className);
        sb.append(" but value was a ");
        sb.append(value.getClass().getName());
        sb.append(".  The default value ");
        sb.append(defaultValue);
        sb.append(" was returned.");
        Log.w(Bundle.class.getSimpleName(), sb.toString());
        Log.w(Bundle.class.getSimpleName(), "Attempt to cast generated internal exception:", e);
    }

    private void typeWarning(String key, Object value, String className, ClassCastException e) {
        this.typeWarning(key, value, className, "<null>", e);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
            return Boolean.parseBoolean(o.toString());
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Boolean", defaultValue, e);
            return defaultValue;
        }
    }

    public byte getByte(String key) {
        return this.getByte(key, (byte)0);
    }

    public Byte getByte(String key, byte defaultValue) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            if (o instanceof Byte) {
                return (Byte)o;
            }
            return Byte.parseByte(o.toString());
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Byte", defaultValue, e);
            return defaultValue;
        }
    }

    public char getChar(String key) {
        return this.getChar(key, '\u0000');
    }

    public void putChar(String key, Character ch) {
        this.mMap.put(key, ch);
    }

    public char getChar(String key, char defaultValue) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            return ((Character)o).charValue();
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Character", Character.valueOf(defaultValue), e);
            return defaultValue;
        }
    }

    public short getShort(String key) {
        return this.getShort(key, (short)0);
    }

    public short getShort(String key, short defaultValue) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            if (o instanceof Short) {
                return (Short)o;
            }
            return Short.parseShort(o.toString());
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Short", defaultValue, e);
            return defaultValue;
        }
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public void putInt(String key, Integer i) {
        this.mMap.put(key, i);
    }

    public int getInt(String key, int defaultValue) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            if (o instanceof Integer) {
                return (Integer)o;
            }
            return Integer.parseInt(o.toString());
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Integer", defaultValue, e);
            return defaultValue;
        }
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public void putLong(String key, Long i) {
        this.mMap.put(key, i);
    }

    public long getLong(String key, long defaultValue) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            if (o instanceof Long) {
                return (Long)o;
            }
            return Long.parseLong(o.toString());
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Long", defaultValue, e);
            return defaultValue;
        }
    }

    public float getFloat(String key) {
        return this.getFloat(key, 0.0f);
    }

    public void putFloat(String key, Float f) {
        this.mMap.put(key, f);
    }

    public float getFloat(String key, float defaultValue) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            if (o instanceof Float) {
                return ((Float)o).floatValue();
            }
            return Float.parseFloat(o.toString());
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Float", Float.valueOf(defaultValue), e);
            return defaultValue;
        }
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public void putDouble(String key, Double d) {
        this.mMap.put(key, d);
    }

    public double getDouble(String key, double defaultValue) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return defaultValue;
        }
        try {
            if (o instanceof Double) {
                return (Double)o;
            }
            return Double.parseDouble(o.toString());
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Double", defaultValue, e);
            return defaultValue;
        }
    }

    public String getString(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            if (o instanceof String) {
                return (String)o;
            }
            return o.toString();
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "String", e);
            return null;
        }
    }

    public String getString(String key, String defaultValue) {
        String s = this.getString(key);
        return s == null ? defaultValue : s;
    }

    public CharSequence getCharSequence(String key) {
        Object o = this.mMap.get(key);
        try {
            return (CharSequence)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "CharSequence", e);
            return null;
        }
    }

    public CharSequence getCharSequence(String key, CharSequence defaultValue) {
        CharSequence cs = this.getCharSequence(key);
        return cs == null ? defaultValue : cs;
    }

    public Bundle getBundle(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (Bundle)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Bundle", e);
            return null;
        }
    }

    public <T extends Parcelable> T getParcelable(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (T)((Parcelable)o);
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Parcelable", e);
            return null;
        }
    }

    public Parcelable[] getParcelableArray(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (Parcelable[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Parcelable[]", e);
            return null;
        }
    }

    public <T extends Parcelable> ArrayList<T> getParcelableArrayList(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList", e);
            return null;
        }
    }

    public Serializable getSerializable(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (Serializable)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "Serializable", e);
            return null;
        }
    }

    public ArrayList<Integer> getIntegerArrayList(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<Integer>", e);
            return null;
        }
    }

    public ArrayList<String> getStringArrayList(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<String>", e);
            return null;
        }
    }

    public ArrayList<CharSequence> getCharSequenceArrayList(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (ArrayList)o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "ArrayList<CharSequence>", e);
            return null;
        }
    }

    public boolean[] getBooleanArray(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (boolean[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "byte[]", e);
            return null;
        }
    }

    public byte[] getByteArray(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (byte[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "byte[]", e);
            return null;
        }
    }

    public short[] getShortArray(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (short[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "short[]", e);
            return null;
        }
    }

    public char[] getCharArray(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (char[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "char[]", e);
            return null;
        }
    }

    public int[] getIntArray(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (int[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "int[]", e);
            return null;
        }
    }

    public long[] getLongArray(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (long[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "long[]", e);
            return null;
        }
    }

    public float[] getFloatArray(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (float[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "float[]", e);
            return null;
        }
    }

    public double[] getDoubleArray(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (double[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "double[]", e);
            return null;
        }
    }

    public String[] getStringArray(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (String[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "String[]", e);
            return null;
        }
    }

    public CharSequence[] getCharSequenceArray(String key) {
        Object o = this.mMap.get(key);
        if (o == null) {
            return null;
        }
        try {
            return (CharSequence[])o;
        }
        catch (ClassCastException e) {
            this.typeWarning(key, o, "CharSequence[]", e);
            return null;
        }
    }

    public JSONArray getJSONArray(String key) {
        return (JSONArray)this.mMap.get(key);
    }

    public JSONObject getJSONObject(String key) {
        return (JSONObject)this.mMap.get(key);
    }

    public int size() {
        return this.mMap.size();
    }

    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public void clear() {
        this.mMap.clear();
        this.mHasFds = false;
        this.mFdsKnown = true;
    }
}

