/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util.simulate;

import com.blisscloud.ezuc.client.annotation.SimulateAndroid;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

@SimulateAndroid(androidClassName="android.database.Cursor")
public class Cursor {
    Statement statement;
    ResultSet resultSet;

    public Cursor(Statement statement, ResultSet resultSet) {
        this.statement = statement;
        this.resultSet = resultSet;
    }

    public boolean isFirst() {
        try {
            return this.resultSet.isFirst();
        }
        catch (SQLException e) {
            this.close();
            throw new RuntimeException(e);
        }
    }

    public boolean isLast() {
        try {
            return this.resultSet.isLast();
        }
        catch (SQLException e) {
            this.close();
            throw new RuntimeException(e);
        }
    }

    public boolean isBeforeFirst() {
        try {
            return this.resultSet.isBeforeFirst();
        }
        catch (SQLException e) {
            this.close();
            throw new RuntimeException(e);
        }
    }

    public boolean isAfterLast() {
        try {
            return this.resultSet.isAfterLast();
        }
        catch (SQLException e) {
            this.close();
            throw new RuntimeException(e);
        }
    }

    public boolean moveToFirst() {
        try {
            return this.resultSet.first();
        }
        catch (SQLException e) {
            this.close();
            throw new RuntimeException(e);
        }
    }

    public boolean moveToNext() {
        try {
            return this.resultSet.next();
        }
        catch (SQLException e) {
            this.close();
            throw new RuntimeException(e);
        }
    }

    public long getLong(int columnIndex) {
        try {
            return this.resultSet.getLong(columnIndex + 1);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int getInt(int columnIndex) {
        try {
            return this.resultSet.getInt(columnIndex + 1);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getString(int columnIndex) {
        try {
            return this.resultSet.getString(columnIndex + 1);
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int getCount() {
        try {
            this.resultSet.last();
            return this.resultSet.getRow();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public int getColumnIndexOrThrow(String columnName) throws IllegalArgumentException {
        try {
            return this.resultSet.findColumn(columnName) - 1;
        }
        catch (SQLException e) {
            this.close();
            throw new IllegalArgumentException(columnName + " is not found!");
        }
    }

    public void close() {
        try {
            this.resultSet.close();
            this.statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

