/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.util.simulate;

import com.blisscloud.sip.SipPhoneService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.ext.LoggerWrapper;

public class Log {
    private static final Logger mainLogger = LoggerFactory.getLogger(Log.class);
    private static final Logger phoneLogger = LoggerFactory.getLogger(SipPhoneService.class);
    private static LoggerWrapper mainWrapper = null;
    private static LoggerWrapper phoneWrapper = null;
    private static Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoggerWrapper getMainWrapper() {
        if (mainWrapper == null) {
            Object object = lock;
            synchronized (object) {
                mainWrapper = new LoggerWrapper(mainLogger, SipPhoneService.class.getSimpleName());
            }
        }
        return mainWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoggerWrapper getPhoneWrapper() {
        if (phoneWrapper == null) {
            Object object = lock;
            synchronized (object) {
                phoneWrapper = new LoggerWrapper(phoneLogger, SipPhoneService.class.getSimpleName());
            }
        }
        return phoneWrapper;
    }

    public static LoggerWrapper getLogWrapper(String tag) {
        if (tag != null && (tag.contains("SipPhoneService") || tag.contains("MyAccount") || tag.contains("MyCall") || tag.contains("MyEndpoint"))) {
            return Log.getPhoneWrapper();
        }
        return Log.getMainWrapper();
    }

    public static void v(String tag, String msg) {
        Log.getLogWrapper(tag).info("[" + tag + "] " + msg);
    }

    public static void i(String tag, String msg) {
        Log.getLogWrapper(tag).info("[" + tag + "] " + msg);
    }

    public static void i(String tag, String msg, Throwable t) {
        Log.getLogWrapper(tag).info("[" + tag + "] " + msg, t);
    }

    public static void d(String tag, String msg) {
        Log.getLogWrapper(tag).debug("[" + tag + "] " + msg);
    }

    public static void w(String tag, String msg) {
        Log.getLogWrapper(tag).warn("[" + tag + "] " + msg);
    }

    public static void w(String tag, String msg, Throwable tr) {
        Log.getLogWrapper(tag).warn("[" + tag + "] " + msg, tr);
    }

    public static void w(String tag, Throwable tr) {
        Log.getLogWrapper(tag).warn("[" + tag + "] ", tr);
    }

    public static void e(String tag, String msg) {
        Log.getLogWrapper(tag).error("[" + tag + "] " + msg);
    }

    public static void e(String tag, String msg, Throwable tr) {
        Log.getLogWrapper(tag).error("[" + tag + "] " + msg, tr);
    }
}

