/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnumUtils {
    private static final Logger LOGGER = Logger.getLogger(EnumUtils.class.getName());

    public static <E extends Enum<E>, K> Map<K, E> createLookupMap(E[] values, Function<E, K> idExtractor) {
        HashMap<K, E> lookupMap = new HashMap<K, E>();
        for (E item : values) {
            K id = idExtractor.apply(item);
            if (lookupMap.containsKey(id)) {
                LOGGER.log(Level.WARNING, "Duplicate id [{0}] in enum {1}", new Object[]{id, item.getClass().getSimpleName()});
            }
            lookupMap.put(id, item);
        }
        return lookupMap;
    }
}

