/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.agent;

import com.blisscloud.ezuc.client.util.simulate.Log;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class AttachDataBean {
    public static final String MATCH_TYPE_ANI = "ANI";
    public static final String MATCH_TYPE_DNIS = "DNIS";
    public static final String MATCH_TYPE_IDENTITY = "IDENTITY";
    public static final String MATCH_TYPE_CNO = "CNO";
    private Long startTime;
    private String callId;
    private String cancelCallId;
    private String skillGroupCancelCallId;
    private String linkId;
    private String ani;
    private String dnis;
    private String identity;
    private String direction;
    private String inboundRuleInfo;
    private String menuRuleInfo;
    private String sipCallId;
    private boolean hasAttData;
    private int csize;
    private String pids;
    private String orgInboundNum;
    private String cmatchType = "ANI";
    private Map<String, String> mExtraData = new HashMap<String, String>();
    private Map<String, String> attachData;
    private Set<String> callGroupSet;
    private String groupId;
    private int submitCount;
    private List<Long> summaryCategoryIds;
    private List<Long> summaryOutcomeIds;
    private String summaryNote;
    private JSONObject customerDetail;
    private String agentName;
    private Long customerId;
    private String campReqName;
    private String campReqId;
    private String campReqInfo1;
    private String campReqInfo2;
    private String campReqInfo3;

    public Map<String, String> getAttachData() {
        return this.attachData;
    }

    public Set<String> getCallGroupSet() {
        return this.callGroupSet;
    }

    public void setAttachData(Map<String, String> attachData) {
        this.attachData = attachData;
    }

    public void setCallGroupSet(Set<String> callGroupSet) {
        this.callGroupSet = callGroupSet;
    }

    public void setAttachData(JSONObject obj) {
        try {
            this.attachData = this.convert(obj);
            HashSet<String> ignoreSet = new HashSet<String>();
            String startTimeStr = this.handleData(this.attachData, "STARTTIME", ignoreSet, null);
            if (StringUtils.isNotBlank((CharSequence)startTimeStr)) {
                this.startTime = Long.parseLong(startTimeStr);
            }
            if (this.attachData.containsKey("CSIZE")) {
                String cSize = this.attachData.get("CSIZE");
                try {
                    this.csize = Integer.parseInt(cSize);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (this.attachData.containsKey("PIDS")) {
                this.pids = this.attachData.get("PIDS");
            }
            if (this.attachData.containsKey("ORG_INBOUND_NUM")) {
                this.orgInboundNum = this.attachData.get("ORG_INBOUND_NUM");
            }
            if (this.attachData.containsKey("CMATCH_TYPE")) {
                this.cmatchType = this.attachData.get("CMATCH_TYPE");
            } else if ("INBOUND".equals(this.direction)) {
                this.cmatchType = MATCH_TYPE_ANI;
            } else if ("OUTBOUND".equals(this.direction)) {
                this.cmatchType = MATCH_TYPE_DNIS;
            }
            if (this.attachData.containsKey("CID")) {
                String cidStr = this.attachData.get("CID");
                try {
                    this.customerId = Long.parseLong(cidStr);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.dnis = this.handleData(this.attachData, MATCH_TYPE_DNIS, ignoreSet, this.dnis);
            this.ani = this.handleData(this.attachData, MATCH_TYPE_ANI, ignoreSet, this.ani);
            this.identity = this.handleData(this.attachData, MATCH_TYPE_IDENTITY, ignoreSet, this.identity);
            this.direction = this.handleData(this.attachData, "DIRECTION", ignoreSet, this.direction);
            this.inboundRuleInfo = this.handleData(this.attachData, "INBOUND_RULE_INFO", ignoreSet, this.inboundRuleInfo);
            this.menuRuleInfo = this.handleData(this.attachData, "MENU_RULE_INFO", ignoreSet, this.menuRuleInfo);
            this.linkId = this.handleData(this.attachData, "LINK_ID", ignoreSet, this.linkId);
            this.callId = this.handleData(this.attachData, "CALL_ID", ignoreSet, this.callId);
            this.cancelCallId = this.handleData(this.attachData, "CANCEL_CALL_ID", ignoreSet, this.cancelCallId);
            this.skillGroupCancelCallId = this.handleData(this.attachData, "GROUP_CANCEL_CALL_ID", ignoreSet, this.skillGroupCancelCallId);
            this.sipCallId = this.handleData(this.attachData, "SIP_CALL_ID", ignoreSet, this.sipCallId);
            Iterator<String> iter = this.attachData.keySet().iterator();
            if (iter != null) {
                while (iter.hasNext()) {
                    String key = iter.next();
                    if (ignoreSet.contains(key)) continue;
                    String value = this.attachData.get(key);
                    this.mExtraData.put(key, value);
                }
            }
        }
        catch (JSONException e) {
            Log.e(AttachDataBean.class.getName(), "ERROR:" + e.getMessage(), e);
        }
    }

    public void cleanCustomer() {
        this.agentName = null;
        this.customerDetail = null;
        this.customerId = null;
        this.attachData.remove("CID");
        this.attachData.put("CSIZE", String.valueOf(0));
        this.cmatchType = MATCH_TYPE_ANI;
    }

    public Set<String> getCallIdSet() {
        HashSet<String> callSet = new HashSet<String>();
        callSet.add(this.callId);
        if (StringUtils.isNotBlank((CharSequence)this.skillGroupCancelCallId)) {
            callSet.add(this.skillGroupCancelCallId);
        }
        if (StringUtils.isNotBlank((CharSequence)this.cancelCallId)) {
            callSet.add(this.cancelCallId);
            if (this.callGroupSet != null) {
                callSet.addAll(this.callGroupSet);
            }
        }
        return callSet;
    }

    public boolean isCallId(String callId) {
        return this.getCallIdSet().contains(callId);
    }

    public void updateCustomer(JSONObject customerObj) {
        try {
            this.agentName = customerObj.has("CAGENT_NAME") ? customerObj.getString("CAGENT_NAME") : null;
            this.customerDetail = customerObj.has("CDETAIL") ? customerObj.getJSONObject("CDETAIL") : null;
            if (customerObj.has("CID")) {
                this.attachData.put("CID", String.valueOf(customerObj.getLong("CID")));
                this.customerId = customerObj.getLong("CID");
            } else {
                this.attachData.remove("CID");
                this.customerId = null;
            }
            this.pids = null;
            this.attachData.put("CSIZE", String.valueOf(1));
        }
        catch (JSONException e) {
            Log.e(AttachDataBean.class.getName(), "ERROR:" + e.getMessage(), e);
        }
    }

    public void updateCustomerInfo(String agentName, JSONObject customerDetail) {
        this.agentName = agentName;
        this.customerDetail = customerDetail;
    }

    public void determineCustomer(JSONObject customerObj) {
        try {
            this.agentName = customerObj.has("agentName") ? customerObj.getString("agentName") : null;
            this.customerDetail = customerObj;
            if (customerObj.has("id")) {
                this.attachData.put("CID", String.valueOf(customerObj.getLong("id")));
                this.customerId = customerObj.getLong("id");
            } else {
                this.attachData.remove("CID");
                this.customerId = null;
            }
            this.attachData.put("CSIZE", String.valueOf(1));
        }
        catch (JSONException e) {
            Log.e(AttachDataBean.class.getName(), "ERROR:" + e.getMessage(), e);
        }
    }

    private String handleData(Map<String, String> data, String key, HashSet<String> ignoreSet, String defaultData) throws JSONException {
        if (data.containsKey(key)) {
            this.hasAttData = true;
            ignoreSet.add(key);
            return data.get(key);
        }
        return defaultData;
    }

    private Map<String, String> convert(JSONObject attObj) throws JSONException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (attObj != null) {
            Iterator nameItr = attObj.keys();
            while (nameItr.hasNext()) {
                String name = (String)nameItr.next();
                attributes.put(name, attObj.getString(name));
            }
        }
        return attributes;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public int getSubmitCount() {
        return this.submitCount;
    }

    public void setSubmitCount(int submitCount) {
        this.submitCount = submitCount;
    }

    public void addSubmitCount() {
        ++this.submitCount;
    }

    public String getSummaryNote() {
        return this.summaryNote;
    }

    public void setSummaryNote(String summaryNote) {
        this.summaryNote = summaryNote;
    }

    public JSONObject getCustomerDetail() {
        return this.customerDetail;
    }

    public void setCustomerDetail(JSONObject customerDetail) {
        this.customerDetail = customerDetail;
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public String getCallId() {
        return this.callId;
    }

    public String getCancelCallId() {
        return this.cancelCallId;
    }

    public String getLinkId() {
        return this.linkId;
    }

    public String getAni() {
        return this.ani;
    }

    public String getDnis() {
        return this.dnis;
    }

    public String getDirection() {
        return this.direction;
    }

    public String getInboundRuleInfo() {
        return this.inboundRuleInfo;
    }

    public String getMenuRuleInfo() {
        return this.menuRuleInfo;
    }

    public String getSipCallId() {
        return this.sipCallId;
    }

    public boolean isHasAttData() {
        return this.hasAttData;
    }

    public int getCsize() {
        return this.csize;
    }

    public Map<String, String> getmExtraData() {
        return this.mExtraData;
    }

    public void setStartTime(Long startTime) {
        this.startTime = startTime;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public void setCancelCallId(String cancelCallId) {
        this.cancelCallId = cancelCallId;
    }

    public void setLinkId(String linkId) {
        this.linkId = linkId;
    }

    public void setAni(String ani) {
        this.ani = ani;
    }

    public void setDnis(String dnis) {
        this.dnis = dnis;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public void setInboundRuleInfo(String inboundRuleInfo) {
        this.inboundRuleInfo = inboundRuleInfo;
    }

    public void setMenuRuleInfo(String menuRuleInfo) {
        this.menuRuleInfo = menuRuleInfo;
    }

    public void setSipCallId(String sipCallId) {
        this.sipCallId = sipCallId;
    }

    public void setHasAttData(boolean hasAttData) {
        this.hasAttData = hasAttData;
    }

    public void setCsize(int csize) {
        this.csize = csize;
    }

    public void setmExtraData(Map<String, String> mExtraData) {
        this.mExtraData = mExtraData;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    public Long getCustomerId() {
        return this.customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public List<Long> getSummaryCategoryIds() {
        return this.summaryCategoryIds;
    }

    public List<Long> getSummaryOutcomeIds() {
        return this.summaryOutcomeIds;
    }

    public void setSummaryCategoryIds(List<Long> summaryCategoryIds) {
        this.summaryCategoryIds = summaryCategoryIds;
    }

    public void setSummaryOutcomeIds(List<Long> summaryOutcomeIds) {
        this.summaryOutcomeIds = summaryOutcomeIds;
    }

    public String getMatchType() {
        return this.cmatchType;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getOrgInboundNum() {
        return this.orgInboundNum;
    }

    public void setOrgInboundNum(String orgInboundNum) {
        this.orgInboundNum = orgInboundNum;
    }

    public String getCustomerStrId() {
        try {
            return this.customerDetail.getString("strId");
        }
        catch (JSONException e) {
            return "";
        }
    }

    public String getPids() {
        return this.pids;
    }

    public void setPids(String pids) {
        this.pids = pids;
    }

    public String getCampReqName() {
        return this.campReqName;
    }

    public void setCampReqName(String campReqName) {
        this.campReqName = campReqName;
    }

    public String getCampReqId() {
        return this.campReqId;
    }

    public void setCampReqId(String campReqId) {
        this.campReqId = campReqId;
    }

    public String getCampReqInfo1() {
        return this.campReqInfo1;
    }

    public void setCampReqInfo1(String campReqInfo1) {
        this.campReqInfo1 = campReqInfo1;
    }

    public String getCampReqInfo2() {
        return this.campReqInfo2;
    }

    public void setCampReqInfo2(String campReqInfo2) {
        this.campReqInfo2 = campReqInfo2;
    }

    public String getCampReqInfo3() {
        return this.campReqInfo3;
    }

    public void setCampReqInfo3(String campReqInfo3) {
        this.campReqInfo3 = campReqInfo3;
    }
}

