/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.agent;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Handler;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.NetworkService;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.manager.task.ChatEventDownloadController;
import com.blisscloud.mobile.ezuc.manager.task.FetchEmpTaskController;
import com.blisscloud.mobile.ezuc.manager.task.PhotoTaskController;
import com.blisscloud.mobile.ezuc.manager.task.VerifyEnterpriseNoTask;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.ICheckCompleteListener;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCTimerTask;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.util.EntityUtils;

public class ConnectionAgent
implements ICheckCompleteListener {
    private static final long CHECKDURATION = 600000L;
    private static final int MAX_UCRM_WAIT_TIME_IN_SECOND = 30;
    private static final int MAX_PHONE_WAIT_TIME_IN_SECOND = 30;
    private static final int SECOND = 1000;
    public static final int START_PROCESS_LOGIN = 0;
    public static final int START_PROCESS_NETWORK_CONNECTED = 1;
    public static final int START_PROCESS_CONNECTION_LOST = 2;
    public static final int START_PROCESS_RECONNECTED = 4;
    private Context mCtx;
    private BroadcastReceiver receiver = null;
    private IntentFilter intentFilter = null;
    private VerifyEnterpriseNoTask mEnterpriseTask;
    private Handler ucrmHandler = null;
    private Handler phoneHandler = null;
    private Handler photoTaskHandler = null;
    private Handler phoneNormalStopHandler = null;
    private Handler phoneForceStopHandler = null;
    private Handler ststusBarHandler = null;
    private Handler statusButtonHandler = null;
    private Runnable suspendPhotoTaskTimer = null;
    private Runnable ucrmConnectTimer = null;
    private Runnable phoneStartTimer = null;
    private Runnable phoneNormalStopTimer = null;
    private Runnable phoneForceStopTimer = null;
    private Runnable statusBarTimer = null;
    private Runnable statusButtonTimer = null;
    private int ucrmTryCount = 0;
    private int phoneTryCount = 0;
    public long expectedConnectionTime = -1L;
    public boolean isUcrmRunning = false;
    public long expectedPhoneTime = -1L;
    public boolean isPhoneRunning = false;
    private static Object lock = new Object();
    private static volatile ConnectionAgent instance;
    private boolean isClosing = false;
    private Timer checkLocalTimer = new Timer("ConnectionAgentTimer");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConnectionAgent getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new ConnectionAgent(UCChatClient.context);
                }
            }
        }
        return instance;
    }

    public static void stopInstance() {
        Log.w(PhoneAgent.class.getSimpleName(), "PhoneAgent onDestroy!!! " + Thread.currentThread().getName());
        if (instance != null) {
            instance.onDestroy();
            instance = null;
        }
    }

    public ConnectionAgent(Context ctx) {
        Log.i(ConnectionAgent.class.getSimpleName(), "ConnectionAgent init .........");
        this.mCtx = ctx;
        this.receiver = this.createReceiver();
        this.intentFilter = this.createIntentFilter();
        this.ucrmHandler = new Handler("ConnectionAgentUcrmHandler");
        this.phoneHandler = new Handler("ConnectionAgentPhoneHandler");
        this.phoneNormalStopHandler = new Handler("ConnectionAgentPhoneNormalStopHandler");
        this.phoneForceStopHandler = new Handler("ConnectionAgentPhoneForceStopHandler");
        this.photoTaskHandler = new Handler("ConnectionAgentPhotoTaskHandler");
        this.ststusBarHandler = new Handler("ConnectionAgentStatusBarHandler");
        this.statusButtonHandler = new Handler("ConnectionAgentStatusButtonHandler");
        this.ucrmConnectTimer = new Runnable(){

            @Override
            public void run() {
                try {
                    Log.w(ConnectionAgent.this.getClass().getSimpleName(), ">> ucrmConnectTimer start running [" + (System.currentTimeMillis() - ConnectionAgent.this.expectedConnectionTime) + "]");
                    boolean isNetworkConnected = NetworkService.getInstance().isOnline();
                    if (!isNetworkConnected) {
                        Log.w(ConnectionAgent.this.getClass().getSimpleName(), "isNetworkConnected is " + isNetworkConnected + ", skip!`");
                        return;
                    }
                    if (WebAgent.getInstance().isConnected()) {
                        Log.w(ConnectionAgent.this.getClass().getSimpleName(), "ucrm isConnected is true, skip!");
                        return;
                    }
                    if (WebAgent.getInstance().isConnecting()) {
                        Log.w(ConnectionAgent.this.getClass().getSimpleName(), "ucrm isConnecting is true, skip!");
                        return;
                    }
                    boolean isUriNotReady = ConnectionAgent.this.isUriNotReady();
                    if (isUriNotReady) {
                        Log.w(ConnectionAgent.this.getClass().getSimpleName(), "isUriNotReady(): " + isUriNotReady + ", skip!`");
                        return;
                    }
                    Log.i(ConnectionAgent.this.getClass().getSimpleName(), "connect check now ....");
                    ConnectionAgent.this.isUcrmRunning = true;
                    ConnectionAgent.this.checkInOfficeFlag();
                    FetchEmpTaskController.suspendInstance(false);
                    PhotoTaskController.suspendInstance(false);
                    ChatEventDownloadController.suspendInstance(false);
                    Log.d(ConnectionAgent.this.getClass().getSimpleName(), "connect ucrm now ....");
                    WebAgent.getInstance().connect();
                    Log.d(ConnectionAgent.this.getClass().getSimpleName(), "ucrmConnectTimer end <<");
                }
                catch (Throwable t) {
                    Log.e(ConnectionAgent.this.getClass().getSimpleName(), t.getMessage(), t);
                }
            }
        };
        this.phoneStartTimer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PhoneAgent agent;
                Log.w(ConnectionAgent.this.getClass().getSimpleName(), ">> phoneStartTimer start running [" + (System.currentTimeMillis() - ConnectionAgent.this.expectedPhoneTime) + "]");
                boolean online = NetworkService.getInstance().isOnline();
                if (!online) {
                    Log.w(ConnectionAgent.this.getClass().getSimpleName(), "phoneStartTimer network is done skip!");
                    return;
                }
                PhoneAgent phoneAgent = agent = PhoneAgent.getInstance();
                synchronized (phoneAgent) {
                    if (PhoneAgent.isRegistered != PhoneAgent.STAT_NOT_REGISTERED) {
                        Log.w(ConnectionAgent.this.getClass().getSimpleName(), "phoneStartTimer PhoneAgent.isRegistered:" + PhoneAgent.isRegistered + " skip!");
                        return;
                    }
                    ConnectionAgent.this.isPhoneRunning = true;
                    Log.d(ConnectionAgent.this.getClass().getSimpleName(), "connect phone service now ....");
                    agent.startPhoneEngine();
                    Log.d(ConnectionAgent.this.getClass().getSimpleName(), "phoneStartTimer end << ");
                }
            }
        };
        this.phoneNormalStopTimer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PhoneAgent agent;
                Log.d(ConnectionAgent.this.getClass().getSimpleName(), ">> phoneNormalStopTimer start running ...");
                PhoneAgent phoneAgent = agent = PhoneAgent.getInstance();
                synchronized (phoneAgent) {
                    Log.d(ConnectionAgent.this.getClass().getSimpleName(), "phoneNormalStopTimer PhoneAgent.isRegistered:" + PhoneAgent.isRegistered);
                    if (PhoneAgent.isRegistered == PhoneAgent.STAT_PROCESSING) {
                        ConnectionAgent.this.phoneForceStopHandler.postDelayed(ConnectionAgent.this.phoneForceStopTimer, 0L);
                        return;
                    }
                    Log.d(ConnectionAgent.this.getClass().getSimpleName(), "stop phone service now ....");
                    agent.stopPhoneEngine();
                }
                Log.d(ConnectionAgent.this.getClass().getSimpleName(), "phoneNormalStopTimer end << ");
            }
        };
        this.phoneForceStopTimer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PhoneAgent agent;
                Log.d(ConnectionAgent.this.getClass().getSimpleName(), ">> phoneForceStopTimer start running ...");
                PhoneAgent phoneAgent = agent = PhoneAgent.getInstance();
                synchronized (phoneAgent) {
                    Log.i(ConnectionAgent.this.getClass().getSimpleName(), "phoneForceStopTimer PhoneAgent.isRegistered:" + PhoneAgent.isRegistered);
                    Log.d(ConnectionAgent.this.getClass().getSimpleName(), "force stop phone service now ....");
                    agent.forceStopPhoneEngine();
                }
                Log.d(ConnectionAgent.this.getClass().getSimpleName(), "phoneForceStopTimer end << ");
            }
        };
        this.statusBarTimer = new Runnable(){

            @Override
            public void run() {
                if (PreferencesUtil.isSyncOldChatEventDone(ConnectionAgent.this.mCtx)) {
                    BroadcastUtil.sendStatusBarUpdateEvent(ConnectionAgent.this.mCtx);
                }
            }
        };
        this.statusButtonTimer = new Runnable(){

            @Override
            public void run() {
                if (PreferencesUtil.isSyncOldChatEventDone(ConnectionAgent.this.mCtx)) {
                    BroadcastUtil.sendStatusButtonUpdateEvent(ConnectionAgent.this.mCtx);
                }
            }
        };
        this.suspendPhotoTaskTimer = new Runnable(this){

            @Override
            public void run() {
                FetchEmpTaskController.suspendInstance(true);
                PhotoTaskController.suspendInstance(true);
                ChatEventDownloadController.suspendInstance(true);
            }
        };
        this.mCtx.registerReceiver(this.receiver, this.intentFilter);
        this.checkLocalTimer.schedule((TimerTask)new UCTimerTask(){

            @Override
            public void doRun() {
                ConnectionAgent.this.checkLocalConnection();
            }
        }, 60000L, 300000L);
    }

    public BroadcastReceiver createReceiver() {
        return new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                int reason;
                String action = intent.getAction();
                if ("ezuc.intent.action.event.WAKEUP_RECONNECT_EVENT".equals(action)) {
                    boolean isConnected = WebAgent.getInstance().isConnected();
                    boolean isLogin = WebAgent.isLogin;
                    Log.i(ConnectionAgent.class.getSimpleName(), "Reconnect Request getWebAgent().isConnected(): " + isConnected + ", WebAgent.isLogin:" + isLogin);
                    if (PhoneAgent.isRegistered != PhoneAgent.STAT_REGISTERED) {
                        ConnectionAgent.this.startPhoneProcess(true);
                    }
                    if (!isConnected || !isLogin) {
                        ConnectionAgent.this.stopUcrmProcess();
                        ConnectionAgent.this.startUcrmProcess(true);
                    }
                } else if ("ezuc.intent.action.event.UCRM_CONNECTION_REQUEST".equals(action)) {
                    Log.i(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] connection request received ......");
                    ConnectionAgent.this.stopPhoneProcess("urcm connection timeout", false);
                    ConnectionAgent.this.stopUcrmProcess();
                    ConnectionAgent.this.startUcrmProcess(true);
                } else if ("ezuc.intent.action.event.UCRM_LOGIN_REQUEST".equals(action)) {
                    Log.i(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] login request received ......");
                    ConnectionAgent.this.startUcrmLoginProcess();
                } else if ("ezuc.intent.action.event.UCRM_CONNECTION_LOST".equals(action)) {
                    Log.w(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] connection lost received ......");
                    ConnectionAgent.this.stopPhoneProcess("urcm connection lost", false);
                    ConnectionAgent.this.startUcrmProcess(false);
                } else if ("ezuc.intent.action.event.UCRM_CONNECTION_EXCEPTION".equals(action)) {
                    Log.w(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] connection exception received ......");
                    ConnectionAgent.this.stopPhoneProcess("urcm connection exception", false);
                    ConnectionAgent.this.recheckEnterpriseNo();
                } else if ("ezuc.intent.action.event.UCRM_CONNECTION_TIMEOUT".equals(action)) {
                    Log.w(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] connection timeout received ......");
                    ConnectionAgent.this.stopPhoneProcess("urcm connection timeout", false);
                    ConnectionAgent.this.stopUcrmProcess();
                    ConnectionAgent.this.startUcrmProcess(false);
                } else if ("ezuc.intent.action.event.UCRM_CONNECTION_OPEN".equals(action)) {
                    Log.i(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] connection open received ......");
                    ConnectionAgent.this.ucrmTryCount = 0;
                } else if ("ezuc.intent.action.event.UC_NETWORK_CONNECTED".equals(action)) {
                    Log.i(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] network connected received ......");
                    ConnectionAgent.this.startUcrmProcess(true);
                } else if ("ezuc.intent.action.event.UC_NETWORK_CHANGED".equals(action)) {
                    Log.w(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] network changed received ......");
                    ConnectionAgent.this.stopPhoneProcess("network disconnected event", true);
                    ConnectionAgent.this.stopUcrmProcess();
                    ConnectionAgent.this.startUcrmProcess(true);
                } else if ("ezuc.intent.action.event.UC_NETWORK_DISCONNECTED".equals(action)) {
                    Log.w(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] network disconnected received ......");
                    ConnectionAgent.this.stopPhoneProcess("network disconnected event", true);
                    ConnectionAgent.this.stopUcrmProcess();
                } else if ("ezuc.intent.action.event.PHONE_SERVICE_BOUNDED".equals(action)) {
                    Log.i(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] phone service bounded ......");
                    ConnectionAgent.this.startPhoneProcess(true);
                } else if ("ezuc.intent.action.event.PHONE_SERVICE_START_AFTER_LOGIN".equals(action)) {
                    String place = intent.getStringExtra("PLACE");
                    Log.i(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] phone service start received ......" + place);
                    ConnectionAgent.this.startPhoneProcess(true);
                } else if ("ezuc.intent.action.event.PHONE_SERVICE_RESTART_REQUEST".equals(action)) {
                    String place = intent.getStringExtra("PLACE");
                    Log.i(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] phone service restart received ......" + place);
                    ConnectionAgent.this.stopPhoneProcess(place, true);
                    ConnectionAgent.this.startPhoneProcess(true);
                } else if ("ezuc.intent.action.event.PHONE_SERVICE_STOP_REQUEST".equals(action)) {
                    String place = intent.getStringExtra("PLACE");
                    Log.w(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] phone service stop received ......" + place);
                    ConnectionAgent.this.stopPhoneProcess(place, false);
                } else if ("ezuc.intent.action.event.PHONE_SERVICE_REGISTRATION_REQUEST".equals(action)) {
                    Log.w(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] phone service registration request received ......");
                    ConnectionAgent.this.startPhoneProcess(false);
                } else if ("ezuc.intent.action.event.PHONE_STATE_SIP_CONNECTION_FAIL".equals(action)) {
                    Log.w(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] phone service connection failed received ......");
                    ConnectionAgent.this.startPhoneProcess(true);
                } else if ("ezuc.intent.action.event.PHONE_STATE_SIP_REGISTER_SUCCESS".equals(action)) {
                    Log.i(ConnectionAgent.this.getClass().getSimpleName(), "[EVENT] phone service registration success received ......");
                    ConnectionAgent.this.phoneTryCount = 0;
                } else if ("ezuc.intent.action.event.WEB_LOGOUT_DONE".equals(action) && (reason = intent.getIntExtra("LOGOUTREASON", -1)) == 2002) {
                    ConnectionAgent.this.isClosing = true;
                }
                if ("ezuc.intent.action.event.PHONE_STATE_SIP_REGISTER_SUCCESS".equals(action) || "ezuc.intent.action.event.NOTIFY_DATA_DOWNLOAD_START".equals(action) || "ezuc.intent.action.event.NOTIFY_DATA_DOWNLOAD_END".equals(action) || "ezuc.intent.action.event.NOTIFY_DATA_DOWNLOAD_PROGRESS".equals(action) || "ezuc.intent.action.event.PHONE_STATE_CHANGED".equals(action) || "ezuc.intent.action.event.WEB_LOGIN_DONE".equals(action)) {
                    ConnectionAgent.this.updateStatusBar(0);
                    ConnectionAgent.this.updateStatusBtn(0);
                } else if ("ezuc.intent.action.event.UC_NETWORK_CONNECTED".equals(action) || "ezuc.intent.action.event.UC_NETWORK_CHANGED".equals(action) || "ezuc.intent.action.event.UC_NETWORK_DISCONNECTED".equals(action) || "ezuc.intent.action.event.UC_WIFI_INVALID".equals(action) || "ezuc.intent.action.event.PHONE_STATE_SIP_UNREGISTER_DONE".equals(action) || "ezuc.intent.action.event.PHONE_STATE_SIP_REGISTER_FAIL".equals(action) || "ezuc.intent.action.event.PHONE_STATE_SIP_CONNECTION_FAIL".equals(action) || "ezuc.intent.action.event.WEB_DISCONNECTED".equals(action)) {
                    ConnectionAgent.this.updateStatusBar(2);
                    ConnectionAgent.this.updateStatusBtn(2);
                }
            }
        };
    }

    public IntentFilter createIntentFilter() {
        IntentFilter filter = new IntentFilter();
        filter.addAction("ezuc.intent.action.event.WAKEUP_RECONNECT_EVENT");
        filter.addAction("ezuc.intent.action.event.PHONE_STATE_SIP_REGISTER_SUCCESS");
        filter.addAction("ezuc.intent.action.event.PHONE_STATE_SIP_UNREGISTER_DONE");
        filter.addAction("ezuc.intent.action.event.PHONE_STATE_SIP_REGISTER_FAIL");
        filter.addAction("ezuc.intent.action.event.PHONE_STATE_SIP_CONNECTION_FAIL");
        filter.addAction("ezuc.intent.action.event.NOTIFY_DATA_DOWNLOAD_START");
        filter.addAction("ezuc.intent.action.event.NOTIFY_DATA_DOWNLOAD_END");
        filter.addAction("ezuc.intent.action.event.NOTIFY_DATA_DOWNLOAD_PROGRESS");
        filter.addAction("ezuc.intent.action.event.UC_WIFI_INVALID");
        filter.addAction("ezuc.intent.action.event.WEB_LOGIN_DONE");
        filter.addAction("ezuc.intent.action.event.WEB_DISCONNECTED");
        filter.addAction("ezuc.intent.action.event.WEB_LOGOUT_DONE");
        filter.addAction("ezuc.intent.action.event.PHONE_STATE_CHANGED");
        filter.addAction("ezuc.intent.action.event.UCRM_LOGIN_REQUEST");
        filter.addAction("ezuc.intent.action.event.UCRM_CONNECTION_REQUEST");
        filter.addAction("ezuc.intent.action.event.UCRM_CONNECTION_LOST");
        filter.addAction("ezuc.intent.action.event.UCRM_CONNECTION_OPEN");
        filter.addAction("ezuc.intent.action.event.UCRM_CONNECTION_TIMEOUT");
        filter.addAction("ezuc.intent.action.event.UCRM_CONNECTION_EXCEPTION");
        filter.addAction("ezuc.intent.action.event.UC_NETWORK_CONNECTED");
        filter.addAction("ezuc.intent.action.event.UC_NETWORK_CHANGED");
        filter.addAction("ezuc.intent.action.event.UC_NETWORK_DISCONNECTED");
        filter.addAction("ezuc.intent.action.event.PHONE_SERVICE_BOUNDED");
        filter.addAction("ezuc.intent.action.event.PHONE_SERVICE_START_AFTER_LOGIN");
        filter.addAction("ezuc.intent.action.event.PHONE_SERVICE_RESTART_REQUEST");
        filter.addAction("ezuc.intent.action.event.PHONE_SERVICE_STOP_REQUEST");
        filter.addAction("ezuc.intent.action.event.PHONE_SERVICE_REGISTRATION_REQUEST");
        return filter;
    }

    private void startUcrmLoginProcess() {
        Log.i(this.getClass().getSimpleName(), "startUcrmLoginProcess ....... ");
        if (!NetworkService.getInstance().isOnline()) {
            Log.w(this.getClass().getSimpleName(), "startUcrmLoginProcess ........ no network skip!");
            return;
        }
        this.ucrmTryCount = 0;
        this.phoneTryCount = 0;
        long delay = 500L;
        Log.i(this.getClass().getSimpleName(), "startUcrmLoginProcess ....... [delay: " + delay + "]");
        this.ucrmHandler.removeCallbacks(this.ucrmConnectTimer);
        this.expectedConnectionTime = System.currentTimeMillis() + delay;
        this.isUcrmRunning = false;
        this.ucrmHandler.postDelayed(this.ucrmConnectTimer, delay);
        Log.i(this.getClass().getSimpleName(), "startUcrmLoginProcess .......");
    }

    private void startUcrmProcess(boolean speed) {
        Log.i(this.getClass().getSimpleName(), "startUcrmProcess ....... [speed: " + speed + "]");
        if (!NetworkService.getInstance().isOnline()) {
            Log.w(this.getClass().getSimpleName(), "startUcrmProcess ........ no network skip!");
            return;
        }
        if (!PreferencesUtil.isRemainLoggedIn(this.mCtx)) {
            Log.w(this.getClass().getSimpleName(), "startUcrmProcess skip! ==> isLogin:" + PreferencesUtil.isRemainLoggedIn(this.mCtx) + ", speed:" + speed);
            return;
        }
        if (this.isClosing) {
            return;
        }
        Random generator = new Random();
        int first = generator.nextInt(2);
        long delay = 1000L;
        if (!speed) {
            delay = Math.min(30000, (1 + this.ucrmTryCount * 5) * 1000) + (first == 1 ? 500 : 0);
            ++this.ucrmTryCount;
        } else {
            delay = first == 1 ? 500L : 0L;
            this.ucrmTryCount = 0;
        }
        this.ucrmHandler.removeCallbacks(this.ucrmConnectTimer);
        this.expectedConnectionTime = System.currentTimeMillis() + delay;
        this.isUcrmRunning = false;
        this.ucrmHandler.postDelayed(this.ucrmConnectTimer, delay);
    }

    private synchronized void stopUcrmProcess() {
        Log.i(this.getClass().getSimpleName(), "  stopUcrmProcess ......");
        this.ucrmTryCount = 0;
        this.phoneTryCount = 0;
        this.ucrmHandler.removeCallbacks(this.ucrmConnectTimer);
        this.expectedConnectionTime = -1L;
        this.isUcrmRunning = false;
        this.photoTaskHandler.postDelayed(this.suspendPhotoTaskTimer, 0L);
        WebAgent.getInstance().cleanConnection();
    }

    protected boolean isUriNotReady() {
        return TextUtils.isEmpty((CharSequence)PreferencesUtil.getHost(this.mCtx));
    }

    private void recheckEnterpriseNo() {
        String mode = PreferencesUtil.getEnterpriseNoMode(this.mCtx);
        if ("MODE_ENT_NO".equalsIgnoreCase(mode)) {
            long checktime = PreferencesUtil.getUCRMCheckTime(this.mCtx);
            Log.i(ConnectionAgent.class.getSimpleName(), "recheckEnterpriseNo: server exception checktime:" + checktime);
            if (checktime > 0L) {
                long diff = System.currentTimeMillis() - checktime;
                Log.i(ConnectionAgent.class.getSimpleName(), "recheckEnterpriseNo: server exception current time diff:" + diff);
                if (diff < 600000L) {
                    return;
                }
            }
            Log.i(ConnectionAgent.class.getSimpleName(), "recheckEnterpriseNo: processing now ...");
            long newCheckTime = System.currentTimeMillis();
            PreferencesUtil.setUCRMCheckTime(this.mCtx, newCheckTime);
            Log.i(ConnectionAgent.class.getSimpleName(), "recheckEnterpriseNo: server exception:refetch enterprise data:" + newCheckTime);
            if (this.mEnterpriseTask != null) {
                this.mEnterpriseTask.cancel(true);
                this.mEnterpriseTask = null;
            }
            this.mEnterpriseTask = new VerifyEnterpriseNoTask(this.mCtx, PreferencesUtil.getEnterpriseNo(this.mCtx), this);
            this.mEnterpriseTask.execute(new Void[0]);
        }
    }

    @Override
    public void onCheckCompleted(Object data, int type) {
        if (data instanceof String && type == 0) {
            BroadcastUtil.sendNewUcrmConfigEvent(this.mCtx);
        }
    }

    public void startPhoneProcess(boolean speed) {
        Log.i(this.getClass().getSimpleName(), "startPhoneProcess .......... [speed: " + speed + "]");
        if (!NetworkService.getInstance().isOnline()) {
            Log.w(this.getClass().getSimpleName(), "startPhoneProcess ........ no network skip!");
            return;
        }
        if (!PreferencesUtil.hasPhoneCallLicense(this.mCtx)) {
            Log.w(this.getClass().getSimpleName(), "startPhoneProcess ........ no voice license skip!");
            return;
        }
        if (!WebAgent.getInstance().isConnected() || WebAgent.siteSelectionListRequired) {
            if (!WebAgent.getInstance().isConnected()) {
                Log.w(this.getClass().getSimpleName(), "startPhoneProcess ........  WebAgent.getInstance(mCtx).isConnected() is " + WebAgent.getInstance().isConnected() + ", skip!");
            }
            if (WebAgent.siteSelectionListRequired) {
                Log.w(this.getClass().getSimpleName(), "startPhoneProcess ........  WebAgent.siteSelectionListRequired is " + WebAgent.siteSelectionListRequired + ", skip!");
            }
            return;
        }
        this.phoneHandler.removeCallbacks(this.phoneStartTimer);
        long delay = 1000L;
        if (!speed) {
            delay = Math.min(30000, (1 + this.phoneTryCount * 2) * 1000);
            ++this.phoneTryCount;
            Log.i(this.getClass().getSimpleName(), "startPhoneProcess delay " + delay);
        } else {
            this.phoneTryCount = 0;
        }
        this.expectedPhoneTime = System.currentTimeMillis() + delay;
        this.isPhoneRunning = false;
        this.phoneHandler.postDelayed(this.phoneStartTimer, delay);
    }

    public void stopPhoneProcess(String place, boolean forceStop) {
        Log.i(this.getClass().getSimpleName(), "  stopPhoneProcess ........... [" + place + "]");
        this.phoneTryCount = 0;
        this.phoneHandler.removeCallbacks(this.phoneStartTimer);
        this.phoneNormalStopHandler.removeCallbacks(this.phoneNormalStopTimer);
        this.phoneForceStopHandler.removeCallbacks(this.phoneForceStopTimer);
        this.expectedPhoneTime = -1L;
        this.isPhoneRunning = false;
        if (forceStop) {
            this.phoneForceStopHandler.postDelayed(this.phoneForceStopTimer, 500L);
        } else {
            this.phoneNormalStopHandler.postDelayed(this.phoneNormalStopTimer, 200L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatusBar(int delayedSeconds) {
        ConnectionAgent connectionAgent = this;
        synchronized (connectionAgent) {
            this.ststusBarHandler.removeCallbacks(this.statusBarTimer);
            this.ststusBarHandler.postDelayed(this.statusBarTimer, delayedSeconds * 1000);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateStatusBtn(int delayedSeconds) {
        ConnectionAgent connectionAgent = this;
        synchronized (connectionAgent) {
            this.statusButtonHandler.removeCallbacks(this.statusButtonTimer);
            this.statusButtonHandler.postDelayed(this.statusButtonTimer, delayedSeconds * 1000);
        }
    }

    public void onDestroy() {
        if (this.mCtx != null) {
            this.mCtx.unregisterReceiver(this.receiver);
        }
        if (this.checkLocalTimer != null) {
            this.checkLocalTimer.cancel();
        }
    }

    private void checkLocalConnection() {
        Integer result;
        boolean isLogin = WebAgent.isLogin;
        if (!isLogin) {
            return;
        }
        boolean isLocalIp = ConnectionAgent.isLocalIp(PreferencesUtil.getHost(this.mCtx));
        if (!isLocalIp) {
            return;
        }
        if (!PreferencesUtil.isInOffice(this.mCtx) && (result = this.doCheckOffice(PreferencesUtil.getHost(this.mCtx), "8080")) != null) {
            int statusCode = result;
            Log.i(ConnectionAgent.class.getSimpleName(), "checkLocalConnection statusCode:" + statusCode + ", reconnect now ...");
            BroadcastUtil.sendUcrmConnectionRequestEvent(this.mCtx);
        }
    }

    public void checkInOfficeFlag() {
        boolean isLocalIp = ConnectionAgent.isLocalIp(PreferencesUtil.getHost(this.mCtx));
        if (!isLocalIp) {
            PreferencesUtil.setInOfficeFlag(this.mCtx, false);
            return;
        }
        Integer result = this.doCheckOffice(PreferencesUtil.getHost(this.mCtx), "8080");
        if (result != null) {
            int statusCode = result;
            Log.i(ConnectionAgent.class.getSimpleName(), "checkInOffice statusCode:" + statusCode);
            PreferencesUtil.setInOfficeFlag(this.mCtx, true);
        } else {
            Log.i(ConnectionAgent.class.getSimpleName(), "checkInOffice not in office");
            PreferencesUtil.setInOfficeFlag(this.mCtx, false);
        }
    }

    public synchronized void checkInOfficePbxFlag(String p) {
        if (!ConnectionAgent.isLocalIp(PreferencesUtil.getSipRealm(this.mCtx))) {
            PreferencesUtil.setInOfficePbxFlag(this.mCtx, false);
            return;
        }
        Log.i(ConnectionAgent.class.getSimpleName(), "check checkInOfficePbxFlag now ..." + p);
        Integer result = this.doCheckOffice(PreferencesUtil.getSipRealm(this.mCtx), "8080");
        if (result != null) {
            int statusCode = result;
            Log.i(ConnectionAgent.class.getSimpleName(), "checkInOffice statusCode:" + statusCode);
            PreferencesUtil.setInOfficePbxFlag(this.mCtx, true);
        } else {
            PreferencesUtil.setInOfficePbxFlag(this.mCtx, false);
        }
    }

    public static void main(String[] args) throws Exception {
        boolean isLocalIp1 = ConnectionAgent.isLocalIp("192.168.1.1");
        System.out.println("==>" + isLocalIp1);
        boolean isLocalIp2 = ConnectionAgent.isLocalIp("10.117.212.45");
        System.out.println("==>" + isLocalIp2);
        boolean isLocalIp3 = ConnectionAgent.isLocalIp("localhost");
        System.out.println("==>" + isLocalIp3);
        boolean isLocalIp4 = ConnectionAgent.isLocalIp("www.google.com");
        System.out.println("==>" + isLocalIp4);
    }

    private static boolean isLocalIp(String ip) {
        InetAddress address;
        try {
            address = InetAddress.getByName(ip);
        }
        catch (UnknownHostException exception) {
            return false;
        }
        return address.isSiteLocalAddress() || address.isAnyLocalAddress() || address.isLinkLocalAddress() || address.isLoopbackAddress() || address.isMulticastAddress();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer doCheckOffice(String ip, String port) {
        String link = "http://" + ip + ":" + port + "/index.jsp";
        Log.i(ConnectionAgent.class.getSimpleName(), "checkInOffice start ..... link:" + link);
        HttpGet request = new HttpGet(link);
        DefaultHttpClient client = new DefaultHttpClient();
        HttpConnectionParams.setConnectionTimeout((HttpParams)client.getParams(), (int)1500);
        HttpConnectionParams.setSoTimeout((HttpParams)client.getParams(), (int)1500);
        long start = System.currentTimeMillis();
        try {
            HttpResponse r = client.execute((HttpUriRequest)request);
            HttpEntity entity = r.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            Log.d(ConnectionAgent.class.getSimpleName(), "Normal office check link:" + link + ", time spent: " + (System.currentTimeMillis() - start) + " ms");
            if (responseString.contains("/ucrm") || responseString.contains("/ucpbx")) {
                Integer n = r.getStatusLine().getStatusCode();
                return n;
            }
            Integer n = null;
            return n;
        }
        catch (Throwable e) {
            Log.d(ConnectionAgent.class.getSimpleName(), "Exception office check link:" + link + ", time spent: " + (System.currentTimeMillis() - start) + " ms");
            Log.d(ConnectionAgent.class.getSimpleName(), "checkInOffice Fail:" + e.getLocalizedMessage());
            Integer n = null;
            return n;
        }
        finally {
            request.releaseConnection();
        }
    }
}

