/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.connection.file;

import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.FaxTransferInfo;
import com.blisscloud.mobile.ezuc.callback.FaxTransferCallBack;
import com.blisscloud.mobile.ezuc.connection.file.CustomMultiPartEntity;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.net.URI;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.util.EntityUtils;
import org.json.JSONObject;

public class FaxTransferConnection {
    private Context mCtx;
    private FaxTransferCallBack callBack;
    private Thread mThread;

    public FaxTransferConnection(Context context) {
        this.mCtx = context.getApplicationContext();
    }

    public void onDestroy() {
        this.mThread = null;
        this.callBack = null;
    }

    public void setCallBack(FaxTransferCallBack callback) {
        this.callBack = callback;
    }

    public void uploadFile(FaxTransferInfo info) {
        this.mThread = new UploadFileThread(this.mCtx, info);
        this.mThread.start();
    }

    public synchronized void cancel() {
        this.mThread.interrupt();
        this.mThread = null;
        this.callBack = null;
    }

    class UploadFileThread
    extends Thread
    implements CustomMultiPartEntity.ProgressListener {
        FaxTransferInfo fileInfo;
        long totalSize;
        Context ctx;
        int lastPercent = -1;

        public UploadFileThread(Context ctx, FaxTransferInfo fileInfo) {
            this.fileInfo = fileInfo;
            this.ctx = ctx;
            this.setName("UC-UploadFaxThread[" + fileInfo.getFile().getAbsolutePath() + "]");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HttpClient mHttpClient = CommonUtil.getHttpsClient(this.ctx, true, 100000, 100000);
            String checkURL = "https://" + CommonUtil.getHttpsIpPort(this.ctx) + "/ucrm/fax/checkFax";
            String uploadURL = "https://" + CommonUtil.getHttpsIpPort(this.ctx) + "/ucrm/fax/submitFax";
            String accessKey = PreferencesUtil.getAccessKey(this.ctx);
            try {
                HttpGet httpGet = new HttpGet();
                httpGet.setURI(new URI(checkURL + "?accessKey=" + accessKey));
                HttpResponse checkResponse = mHttpClient.execute((HttpUriRequest)httpGet);
                int respondCode = checkResponse.getStatusLine().getStatusCode();
                HttpEntity checkEntity = checkResponse.getEntity();
                EntityUtils.consume((HttpEntity)checkEntity);
                if (respondCode != 200) {
                    UploadFileThread uploadFileThread = this;
                    synchronized (uploadFileThread) {
                        if (FaxTransferConnection.this.callBack != null) {
                            FaxTransferConnection.this.callBack.notifyUploadFileFailed(this.fileInfo, -1, null);
                        }
                    }
                    return;
                }
                HttpPost httpPost = new HttpPost();
                httpPost.setURI(new URI(uploadURL));
                CustomMultiPartEntity multipartContent = new CustomMultiPartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, null, Charset.forName("UTF-8"), this);
                multipartContent.addPart("upload", (ContentBody)new FileBody(this.fileInfo.getFile()));
                multipartContent.addPart("tenantId", (ContentBody)new StringBody(PreferencesUtil.getTenantId(this.ctx).toString()));
                multipartContent.addPart("employeeId", (ContentBody)new StringBody(PreferencesUtil.getUserId(this.ctx).toString()));
                long siteId = PreferencesUtil.getSipUsePbxSite(this.ctx);
                multipartContent.addPart("siteId", (ContentBody)new StringBody(String.valueOf(siteId)));
                multipartContent.addPart("phoneNumber", (ContentBody)new StringBody(this.fileInfo.getPhoneNumber()));
                if (this.fileInfo.getEncodingType() != null) {
                    multipartContent.addPart("encodingType", (ContentBody)new StringBody(this.fileInfo.getEncodingType()));
                }
                multipartContent.addPart("accessKey", (ContentBody)new StringBody(accessKey));
                this.totalSize = multipartContent.getContentLength();
                httpPost.setEntity((HttpEntity)multipartContent);
                HttpResponse uploadResponse = mHttpClient.execute((HttpUriRequest)httpPost);
                HttpEntity uploadEntity = uploadResponse.getEntity();
                String uploadResult = EntityUtils.toString((HttpEntity)uploadEntity);
                EntityUtils.consume((HttpEntity)uploadEntity);
                Log.i(FaxTransferConnection.class.getSimpleName(), uploadResult);
                JSONObject jsonObj = new JSONObject(uploadResult);
                int returnCode = jsonObj.getInt("returnCode");
                UploadFileThread uploadFileThread = this;
                synchronized (uploadFileThread) {
                    if (FaxTransferConnection.this.callBack != null) {
                        if (returnCode == 0) {
                            FaxTransferConnection.this.callBack.notifyUploadFileSucceed(this.fileInfo);
                        } else {
                            String returnInfo = jsonObj.getString("returnInfo");
                            FaxTransferConnection.this.callBack.notifyUploadFileFailed(this.fileInfo, returnCode, returnInfo);
                        }
                    }
                }
            }
            catch (Throwable e) {
                Log.e(FaxTransferConnection.class.getSimpleName(), "notifyUploadFileFailed", e);
                UploadFileThread uploadFileThread = this;
                synchronized (uploadFileThread) {
                    if (FaxTransferConnection.this.callBack != null) {
                        FaxTransferConnection.this.callBack.notifyUploadFileFailed(this.fileInfo, -1, null);
                    }
                }
            }
        }

        @Override
        public void transferred(long num) {
            int percent = (int)((double)num / (double)this.totalSize * 100.0);
            if (percent != this.lastPercent) {
                this.lastPercent = percent;
                FaxTransferConnection.this.callBack.notifyUploadFileProgress(this.fileInfo, percent);
            }
        }
    }
}

