/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteContactType;
import com.blisscloud.ezuc.bean.LiteGenderType;
import com.blisscloud.ezuc.bean.LiteGroupMember;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.LiteMyGroup;
import com.blisscloud.ezuc.bean.LiteOutPrefix;
import com.blisscloud.ezuc.bean.web.LiteBirthdayHideType;
import com.blisscloud.ezuc.bean.web.LiteTeleNumber;
import com.blisscloud.ezuc.bean.web.LiteTeleNumberType;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinHelper;
import java.util.ArrayList;

public class ContactDataHelper {
    public static final int UNPLAYED = 0;
    public static final int PLAYED = 1;
    public static final int UNREAD = 0;
    public static final int READ = 1;
    public static String[] contactSelectColumnsForMerge = new String[]{"jid", "surName", "givenName", "otherName", "dispNameForPinYin"};
    public static String[] externalSelectColumnsForMerge = new String[]{"id", "name"};
    public static String[] contactSelectColumns = new String[]{"jid", "empId", "surName", "givenName", "otherName", "dispName", "dispNameForPinYin", "extDispName", "siteId", "ext", "extList", "account", "photoFlag", "personalPhoto", "personalPhotoTimestamp", "email", "gender", "departmentNamePath", "departmentIdPath", "birthday", "disabled", "locked", "outboundPrefixId", "birthdayHideType", "extendedNumber1", "extendedNumber2", "extendedNumber3", "extendedNumber4"};
    public static String[] externalContactSelectColumns = new String[]{"id", "name", "nameForPinYin", "company", "comapnytel", "title", "organization", "photoFlag", "personalPhoto", "personalPhotoTimestamp", "email", "birthday"};
    public static String[] numberSelectColumns = new String[]{"contactJid", "type", "number"};
    public static String[] empOutboundPrefixSelectColumns = new String[]{"contactJid", "siteId", "outboundPrefixId", "pbxOutboundPrefixId"};

    public static void setGroupValue(Cursor cursor, LiteMyGroup group) {
        group.setId(cursor.getLong(0));
        group.setName(cursor.getString(1));
    }

    public static void setContactValue(Cursor cursor, LiteMyContact contact) {
        contact.setId(cursor.getLong(0));
        contact.setName(cursor.getString(1));
        contact.setNameForPinYin(cursor.getString(2));
        contact.setCompany(cursor.getString(3));
        contact.setCompanyTel(cursor.getString(4));
        contact.setTitle(cursor.getString(5));
        contact.setOrganization(cursor.getString(6));
        contact.setPhotoFlag(Boolean.parseBoolean(cursor.getString(7)));
        contact.setPersonalPhoto(cursor.getString(8));
        contact.setPersonalPhotoTimestamp(cursor.getLong(9));
        contact.setEmail(cursor.getString(10));
        contact.setBirthDayStr(cursor.getString(11));
    }

    public static void setContactValue(Cursor cursor, LiteContact contact) {
        contact.setJid(cursor.getString(0));
        contact.setId(cursor.getLong(1));
        contact.setSurName(cursor.getString(2));
        contact.setGivenName(cursor.getString(3));
        contact.setOtherName(cursor.getString(4));
        contact.setDispName(cursor.getString(5));
        contact.setDispNameForPinYin(cursor.getString(6));
        contact.setExtDispName(cursor.getString(7));
        contact.setSiteId(cursor.getLong(8));
        contact.setExt(cursor.getString(9));
        String extListStr = cursor.getString(10);
        if (extListStr != null) {
            String[] array = extListStr.split(",");
            ArrayList<String> extList = new ArrayList<String>();
            for (int i = 0; array != null && i < array.length; ++i) {
                extList.add(array[i]);
            }
            contact.setExtList(extList);
        }
        contact.setAccount(cursor.getString(11));
        contact.setPhotoFlag(cursor.getInt(12) == 1);
        contact.setPersonalPhoto(cursor.getString(13));
        contact.setPersonalPhotoTimestamp(cursor.getLong(14));
        contact.setEmail(cursor.getString(15));
        contact.setGender(LiteGenderType.getValue(cursor.getInt(16)));
        contact.setDepartmentNamePath(cursor.getString(17));
        contact.setDepartmentIdPath(cursor.getString(18));
        contact.setBirthDayStr(cursor.getString(19));
        int disable = cursor.getInt(20);
        contact.setDisabled(disable != 0);
        int locked = cursor.getInt(21);
        contact.setLocked(locked != 0);
        contact.setOutboundPrefixId(cursor.getLong(22));
        contact.setBirthdayHideType(LiteBirthdayHideType.getValue(cursor.getInt(23)));
        contact.setExtendedPhoneNumber1(cursor.getString(24));
        contact.setExtendedPhoneNumber2(cursor.getString(25));
        contact.setExtendedPhoneNumber3(cursor.getString(26));
        contact.setExtendedPhoneNumber4(cursor.getString(27));
    }

    public static void setNumberValue(Cursor cursor, LiteTeleNumber number) {
        number.setType(LiteTeleNumberType.getValue(cursor.getInt(1)));
        number.setNumber(cursor.getString(2));
    }

    public static void setOutPrefixValue(Cursor cursor, LiteOutPrefix outPrefix) {
        outPrefix.setSiteId(cursor.getLong(1));
        outPrefix.setOutboundPrefixId(cursor.getLong(2));
        outPrefix.setSiteOutboundPrefixId(cursor.getLong(3));
    }

    public static ContentValues createGroupContactAddValues(long id, LiteGroupMember member) {
        ContentValues phonevalues = new ContentValues();
        phonevalues.put("groupId", id);
        phonevalues.put("id", member.getMemberId());
        if (LiteContactType.CONTACT.equals((Object)member.getType())) {
            phonevalues.put("type", 2);
        } else if (LiteContactType.EMPLOYEE.equals((Object)member.getType())) {
            phonevalues.put("type", 1);
        } else {
            phonevalues.put("type", 3);
        }
        return phonevalues;
    }

    public static ContentValues createNumberAddValues(LiteContact contact, LiteTeleNumber number) {
        ContentValues phonevalues = new ContentValues();
        phonevalues.put("contactJid", contact.getJid());
        phonevalues.put("type", number.getType().getId());
        phonevalues.put("number", number.getNumber());
        return phonevalues;
    }

    public static ContentValues createNumberAddValues(LiteMyContact contact, LiteTeleNumber number) {
        ContentValues phonevalues = new ContentValues();
        phonevalues.put("id", contact.getId());
        phonevalues.put("type", number.getType().getId());
        phonevalues.put("number", number.getNumber());
        return phonevalues;
    }

    public static ContentValues createOutPrefixAddValues(LiteContact contact, LiteOutPrefix liteOutPrefix) {
        ContentValues values = new ContentValues();
        values.put("contactJid", contact.getJid());
        values.put("siteId", liteOutPrefix.getSiteId());
        values.put("outboundPrefixId", liteOutPrefix.getOutboundPrefixId());
        values.put("pbxOutboundPrefixId", liteOutPrefix.getSiteOutboundPrefixId());
        return values;
    }

    public static ContentValues createContactAddValues(LiteContact contact, int contactType, int scope) {
        ContentValues values = ContactDataHelper.createContactUpdateValues(contact, scope);
        values.put("jid", contact.getJid());
        values.put("type", contactType);
        values.put("siteId", contact.getSiteId());
        return values;
    }

    public static ContentValues createContactUpdateValues(LiteContact contact, int scope) {
        String[] args;
        ContentValues values = new ContentValues();
        values.put("empId", contact.getId());
        values.put("surName", contact.getSurName());
        values.put("givenName", contact.getGivenName());
        values.put("otherName", contact.getOtherName());
        values.put("dispName", contact.getDispName());
        String displayNameForPinYin = ContactDataHelper.genPinYin(contact);
        values.put("dispNameForPinYin", displayNameForPinYin);
        values.put("extDispName", contact.getExtDispName());
        values.put("ext", contact.getExt());
        values.put("birthday", contact.getBirthDayStr());
        values.put("birthdayHideType", contact.getBirthdayHideType().getId());
        StringBuffer b = new StringBuffer();
        for (int i = 0; contact.getExtList() != null && i < contact.getExtList().size(); ++i) {
            if (i != 0) {
                b.append(",");
            }
            b.append(contact.getExtList().get(i));
        }
        values.put("extList", b.toString());
        StringBuffer c = new StringBuffer();
        for (int i = 0; contact.getExtList() != null && i < contact.getExtList().size(); ++i) {
            if (i != 0) {
                c.append(" ");
            }
            c.append(contact.getExtList().get(i));
        }
        values.put("extForSearch", c.toString());
        values.put("account", contact.getAccount());
        values.put("photoFlag", contact.isPhotoFlag());
        values.put("personalPhoto", contact.getPersonalPhoto());
        values.put("personalPhotoTimestamp", contact.getPersonalPhotoTimestamp());
        values.put("email", contact.getEmail());
        values.put("gender", contact.getGender().getId());
        values.put("departmentNamePath", contact.getDepartmentNamePath());
        String selfDept = null;
        if (contact.getDepartmentNamePath() != null && (args = contact.getDepartmentNamePath().split("/")).length > 0) {
            selfDept = args[args.length - 1];
        }
        values.put("deptForSearch", selfDept);
        values.put("departmentIdPath", contact.getDepartmentIdPath());
        values.put("disabled", contact.isDisabled() ? 1 : 0);
        values.put("locked", contact.isLocked() ? 1 : 0);
        values.put("outboundPrefixId", contact.getOutboundPrefixId());
        values.put("abscope", scope);
        values.put("extendedNumber1", contact.getExtendedPhoneNumber1());
        values.put("extendedNumber2", contact.getExtendedPhoneNumber2());
        values.put("extendedNumber3", contact.getExtendedPhoneNumber3());
        values.put("extendedNumber4", contact.getExtendedPhoneNumber4());
        return values;
    }

    public static String genPinYin(LiteContact contact) {
        Object displayNameForPinYin = contact.getDispNameForPinYin();
        if (TextUtils.isBlank((CharSequence)displayNameForPinYin) && TextUtils.isNotBlank((CharSequence)contact.getOtherName())) {
            String pinYinResult = PinyinHelper.convertToPinyinString((String)contact.getOtherName(), (String)" ", (PinyinFormat)PinyinFormat.WITHOUT_TONE);
            if (TextUtils.isBlank((CharSequence)contact.getSurName()) && TextUtils.isBlank((CharSequence)contact.getGivenName())) {
                displayNameForPinYin = pinYinResult;
            } else if (TextUtils.isNotBlank((CharSequence)contact.getSurName()) && TextUtils.isBlank((CharSequence)contact.getGivenName())) {
                displayNameForPinYin = contact.getSurName() + " " + pinYinResult;
            } else if (TextUtils.isBlank((CharSequence)contact.getSurName()) && TextUtils.isNotBlank((CharSequence)contact.getGivenName())) {
                displayNameForPinYin = contact.getGivenName() + " " + pinYinResult;
            } else if (TextUtils.isNotBlank((CharSequence)contact.getSurName()) && TextUtils.isNotBlank((CharSequence)contact.getGivenName())) {
                displayNameForPinYin = contact.getGivenName() + " " + contact.getSurName() + " " + pinYinResult;
            }
        }
        return displayNameForPinYin;
    }

    public static ContentValues createGroupUpdateValues(LiteMyGroup group) {
        ContentValues values = new ContentValues();
        values.put("id", group.getId());
        values.put("name", group.getName());
        return values;
    }

    public static ContentValues createContactAddValues(LiteMyContact contact) {
        ContentValues values = ContactDataHelper.createContactUpdateValues(contact);
        return values;
    }

    public static ContentValues createContactUpdateValues(LiteMyContact contact) {
        ContentValues values = new ContentValues();
        values.put("id", contact.getId());
        values.put("name", contact.getName());
        String pinYinResult = PinyinHelper.convertToPinyinString((String)contact.getName(), (String)" ", (PinyinFormat)PinyinFormat.WITHOUT_TONE);
        values.put("nameForPinYin", pinYinResult);
        values.put("company", contact.getCompany());
        values.put("comapnytel", contact.getCompanyTel());
        values.put("title", contact.getTitle());
        values.put("organization", contact.getOrganization());
        values.put("photoFlag", contact.isPhotoFlag());
        values.put("personalPhoto", contact.getPersonalPhoto());
        values.put("personalPhotoTimestamp", contact.getPersonalPhotoTimestamp());
        values.put("email", contact.getEmail());
        values.put("birthday", contact.getBirthDayStr());
        return values;
    }

    public static ContentValues createVocieValues(VoiceItem item) {
        ContentValues values = new ContentValues();
        values.put("startTime", item.getBeginTime());
        values.put("endTime", item.getEndTime());
        values.put("callerType", item.getType());
        values.put("callerDbId", item.getDBId());
        values.put("id", item.getId());
        values.put("listen", item.isPlayed() ? 1 : 0);
        values.put("read", item.isRead() ? 1 : 0);
        values.put("callerIdName", item.getName());
        values.put("callerIdNumber", item.getNumber());
        values.put("callerSite", item.getSite());
        values.put("type", item.getGroup());
        values.put("url", item.getUrl());
        values.put("chatPocketId", item.getPacketId());
        values.put("outboundTrunk", item.isOutboundTrunk() ? 1 : 0);
        return values;
    }

    public static void setVoiceValue(Cursor cursor, VoiceItem item) {
        item.setId(cursor.getLong(cursor.getColumnIndexOrThrow("id")));
        item.setBeginTime(cursor.getLong(cursor.getColumnIndexOrThrow("startTime")));
        item.setEndTime(cursor.getLong(cursor.getColumnIndexOrThrow("endTime")));
        item.setType(cursor.getString(cursor.getColumnIndexOrThrow("callerType")));
        item.setDBId(cursor.getString(cursor.getColumnIndexOrThrow("callerDbId")));
        int isPlayed = cursor.getInt(cursor.getColumnIndexOrThrow("listen"));
        item.setPlayed(1 == isPlayed);
        int isRead = cursor.getInt(cursor.getColumnIndexOrThrow("read"));
        item.setRead(1 == isRead);
        item.setName(cursor.getString(cursor.getColumnIndexOrThrow("callerIdName")));
        item.setNumber(cursor.getString(cursor.getColumnIndexOrThrow("callerIdNumber")));
        item.setSite(cursor.getString(cursor.getColumnIndexOrThrow("callerSite")));
        item.setGroup(cursor.getInt(cursor.getColumnIndexOrThrow("type")));
        item.setUrl(cursor.getString(cursor.getColumnIndexOrThrow("url")));
        item.setPacketId(cursor.getString(cursor.getColumnIndexOrThrow("chatPocketId")));
        int outboundTrunk = cursor.getInt(cursor.getColumnIndexOrThrow("outboundTrunk"));
        item.setOutboundTrunk(outboundTrunk == 1);
    }
}

