/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.bean.web.LiteBulletinAttachment;
import com.blisscloud.ezuc.bean.web.LiteBulletinDetail;
import com.blisscloud.ezuc.bean.web.LiteBulletinHeader;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.DatabaseUtils;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.db.BulletinDBConst;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class UCDBBulletin
extends UCDBBase {
    public static final String TABLE_BULLETIN = "Bulletin";
    public static final String TABLE_BULLETIN_ATTACHMENT = "BulletinAttachment";

    public static void createBulletinTable(SQLiteDatabase db) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ");
        sql.append(TABLE_BULLETIN);
        sql.append("(");
        sql.append("id");
        sql.append(" NUMERIC PRIMARY KEY,");
        sql.append("typeName");
        sql.append(" LONGVARCHAR,");
        sql.append("subject");
        sql.append(" LONGVARCHAR,");
        sql.append("summary");
        sql.append(" LONGVARCHAR,");
        sql.append("content");
        sql.append(" LONGVARCHAR,");
        sql.append("timestamp");
        sql.append(" NUMERIC,");
        sql.append("read");
        sql.append(" INTEGER,");
        sql.append("mark");
        sql.append(" INTEGER,");
        sql.append("detailLoad");
        sql.append(" INTEGER,");
        sql.append("readCount");
        sql.append(" INTEGER,");
        sql.append("subjectPhotoUrl");
        sql.append(" LONGVARCHAR");
        sql.append(")");
        db.execSQL(sql.toString());
        StringBuilder sql2 = new StringBuilder();
        sql2.append("CREATE TABLE ");
        sql2.append(TABLE_BULLETIN_ATTACHMENT);
        sql2.append("(");
        sql2.append("id");
        sql2.append(" NUMERIC,");
        sql2.append("attachmentIndex");
        sql2.append(" INTEGER,");
        sql2.append("attachmentName");
        sql2.append(" LONGVARCHAR,");
        sql2.append("attachmentUrl");
        sql2.append(" LONGVARCHAR,");
        sql2.append("attachmentSize");
        sql2.append(" NUMERIC");
        sql2.append(")");
        db.execSQL(sql2.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addBulletinHeader(Context ctx, LiteBulletinHeader bulletinHeader) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "addBulletinHeader...." + String.valueOf(bulletinHeader));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("id", bulletinHeader.getId());
                values.put("typeName", bulletinHeader.getTypeName());
                values.put("subject", bulletinHeader.getSubject());
                values.put("summary", bulletinHeader.getSummary());
                values.put("timestamp", bulletinHeader.getStart());
                values.put("read", bulletinHeader.isRead() ? 1 : 0);
                values.put("mark", bulletinHeader.isMark() ? 1 : 0);
                values.put("detailLoad", 0);
                db.insert(TABLE_BULLETIN, null, values);
            }
            finally {
                UCDBBulletin.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBulletinHeader(Context ctx, LiteBulletinHeader bulletinHeader) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "updateBulletinHeader...." + String.valueOf(bulletinHeader));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("id", bulletinHeader.getId());
                values.put("typeName", bulletinHeader.getTypeName());
                values.put("subject", bulletinHeader.getSubject());
                values.put("summary", bulletinHeader.getSummary());
                values.put("timestamp", bulletinHeader.getStart());
                values.put("read", bulletinHeader.isRead() ? 1 : 0);
                values.put("mark", bulletinHeader.isMark() ? 1 : 0);
                db.update(TABLE_BULLETIN, values, "id = ?", new String[]{String.valueOf(bulletinHeader.getId())});
            }
            finally {
                UCDBBulletin.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existBulletinById(Context ctx, long bulletinId) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "existBulletinById...." + bulletinId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_BULLETIN, "id=?", new String[]{String.valueOf(bulletinId)});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBBulletin.closeDb(db);
                throw throwable;
            }
            UCDBBulletin.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isBulletinLoadedById(Context ctx, long bulletinId) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "isBulletinLoadedById...." + bulletinId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                block6: {
                    boolean bl;
                    db = null;
                    cursor = null;
                    try {
                        db = helper.getReadableDatabase();
                        cursor = db.query(TABLE_BULLETIN, new String[]{"detailLoad"}, "id=?", new String[]{String.valueOf(bulletinId)}, null, null, null, null);
                        if (cursor == null || !cursor.moveToFirst()) break block5;
                        int load = cursor.getInt(0);
                        if (load != 0) break block6;
                        bl = false;
                    }
                    catch (Throwable throwable) {
                        UCDBBulletin.closeCursor(cursor);
                        UCDBBulletin.closeDb(db);
                        throw throwable;
                    }
                    UCDBBulletin.closeCursor(cursor);
                    UCDBBulletin.closeDb(db);
                    return bl;
                }
                boolean bl = true;
                UCDBBulletin.closeCursor(cursor);
                UCDBBulletin.closeDb(db);
                return bl;
            }
            UCDBBulletin.closeCursor(cursor);
            UCDBBulletin.closeDb(db);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteBulletinHeader getBulletinHeader(Context ctx, long bulletinId) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "getBulletinHeader...." + bulletinId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block4: {
                LiteBulletinHeader liteBulletinHeader;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_BULLETIN, BulletinDBConst.bulletinHeaderSelectColumns, "id=?", new String[]{String.valueOf(bulletinId)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block4;
                    LiteBulletinHeader bulletinHeader = new LiteBulletinHeader();
                    BulletinDBConst.setBulletinHeaderValue(cursor, bulletinHeader);
                    liteBulletinHeader = bulletinHeader;
                }
                catch (Throwable throwable) {
                    UCDBBulletin.closeCursor(cursor);
                    UCDBBulletin.closeDb(db);
                    throw throwable;
                }
                UCDBBulletin.closeCursor(cursor);
                UCDBBulletin.closeDb(db);
                return liteBulletinHeader;
            }
            UCDBBulletin.closeCursor(cursor);
            UCDBBulletin.closeDb(db);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteBulletinDetail getBulletinDetail(Context ctx, long bulletinId) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "getBulletinDetail...." + bulletinId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor2;
            Cursor cursor;
            SQLiteDatabase db;
            block7: {
                LiteBulletinDetail liteBulletinDetail;
                db = null;
                cursor = null;
                cursor2 = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_BULLETIN, BulletinDBConst.bulletinSelectColumns, "id=?", new String[]{String.valueOf(bulletinId)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block7;
                    LiteBulletinDetail bulletin = new LiteBulletinDetail();
                    BulletinDBConst.setBulletinDetailValue(cursor, bulletin);
                    ArrayList<LiteBulletinAttachment> list = new ArrayList<LiteBulletinAttachment>();
                    cursor2 = db.query(TABLE_BULLETIN_ATTACHMENT, BulletinDBConst.bulletinAttachmentSelectColumns, "id=?", new String[]{String.valueOf(bulletinId)}, null, null, null, null);
                    if (cursor2 != null && cursor2.moveToFirst()) {
                        do {
                            LiteBulletinAttachment bulletinAtt = new LiteBulletinAttachment();
                            BulletinDBConst.setBulletinAttachmentValue(cursor2, bulletinAtt);
                            list.add(bulletinAtt);
                        } while (cursor2.moveToNext());
                    }
                    bulletin.setFiles(list);
                    liteBulletinDetail = bulletin;
                }
                catch (Throwable throwable) {
                    UCDBBulletin.closeCursor(cursor2);
                    UCDBBulletin.closeCursor(cursor);
                    UCDBBulletin.closeDb(db);
                    throw throwable;
                }
                UCDBBulletin.closeCursor(cursor2);
                UCDBBulletin.closeCursor(cursor);
                UCDBBulletin.closeDb(db);
                return liteBulletinDetail;
            }
            LiteBulletinDetail liteBulletinDetail = null;
            UCDBBulletin.closeCursor(cursor2);
            UCDBBulletin.closeCursor(cursor);
            UCDBBulletin.closeDb(db);
            return liteBulletinDetail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteBulletinAttachment getBulletinAttachment(Context ctx, long bulletinId, int index) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "getBulletinAttachment...." + bulletinId + ", " + index);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteBulletinAttachment liteBulletinAttachment;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_BULLETIN_ATTACHMENT, BulletinDBConst.bulletinAttachmentSelectColumns, "id=? and attachmentIndex=?", new String[]{String.valueOf(bulletinId), String.valueOf(index)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    LiteBulletinAttachment bulletinAtt = new LiteBulletinAttachment();
                    BulletinDBConst.setBulletinAttachmentValue(cursor, bulletinAtt);
                    liteBulletinAttachment = bulletinAtt;
                }
                catch (Throwable throwable) {
                    UCDBBulletin.closeCursor(cursor);
                    UCDBBulletin.closeDb(db);
                    throw throwable;
                }
                UCDBBulletin.closeCursor(cursor);
                UCDBBulletin.closeDb(db);
                return liteBulletinAttachment;
            }
            LiteBulletinAttachment liteBulletinAttachment = null;
            UCDBBulletin.closeCursor(cursor);
            UCDBBulletin.closeDb(db);
            return liteBulletinAttachment;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countBulletinUnread(Context ctx) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "countBulletinUnread....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            int n;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                String selection = "read =?";
                String[] selectionArgs = new String[]{String.valueOf(0)};
                n = (int)DatabaseUtils.queryNumEntries(db, TABLE_BULLETIN, selection, selectionArgs);
            }
            catch (Throwable throwable) {
                UCDBBulletin.closeDb(db);
                throw throwable;
            }
            UCDBBulletin.closeDb(db);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteBulletinHeader> getBulletinList(Context ctx, String searchKey) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "getBulletinList....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            ArrayList<LiteBulletinHeader> bulletinHeaderList = new ArrayList<LiteBulletinHeader>();
            try {
                db = helper.getReadableDatabase();
                String orderby = " timestamp DESC";
                String selection = null;
                String[] selectionArgs = null;
                if (TextUtils.isNotBlank((CharSequence)searchKey)) {
                    String searchKeyUpper = searchKey.trim().toUpperCase(Locale.US);
                    selection = "UPPER(subject) LIKE ? OR UPPER(typeName) LIKE ? OR UPPER(content) LIKE ?";
                    selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                }
                if ((cursor = db.query(TABLE_BULLETIN, BulletinDBConst.bulletinHeaderSelectColumns, selection, selectionArgs, null, null, orderby, null)) != null && cursor.moveToFirst()) {
                    do {
                        LiteBulletinHeader bulletin = new LiteBulletinHeader();
                        BulletinDBConst.setBulletinHeaderValue(cursor, bulletin);
                        bulletinHeaderList.add(bulletin);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBBulletin.closeCursor(cursor);
                UCDBBulletin.closeDb(db);
                throw throwable;
            }
            UCDBBulletin.closeCursor(cursor);
            UCDBBulletin.closeDb(db);
            return bulletinHeaderList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteBulletinHeader> getBulletinListByUnread(Context ctx, String searchKey) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "getBulletinListByUnread....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            ArrayList<LiteBulletinHeader> bulletinHeaderList = new ArrayList<LiteBulletinHeader>();
            try {
                db = helper.getReadableDatabase();
                String orderby = " read ASC, timestamp DESC";
                String selection = null;
                String[] selectionArgs = null;
                if (TextUtils.isNotBlank((CharSequence)searchKey)) {
                    String searchKeyUpper = searchKey.trim().toUpperCase(Locale.US);
                    selection = "UPPER(subject) LIKE ? OR UPPER(typeName) LIKE ? OR UPPER(content) LIKE ?";
                    selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                }
                if ((cursor = db.query(TABLE_BULLETIN, BulletinDBConst.bulletinHeaderSelectColumns, selection, selectionArgs, null, null, orderby, null)) != null && cursor.moveToFirst()) {
                    do {
                        LiteBulletinHeader bulletin = new LiteBulletinHeader();
                        BulletinDBConst.setBulletinHeaderValue(cursor, bulletin);
                        bulletinHeaderList.add(bulletin);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBBulletin.closeCursor(cursor);
                UCDBBulletin.closeDb(db);
                throw throwable;
            }
            UCDBBulletin.closeCursor(cursor);
            UCDBBulletin.closeDb(db);
            return bulletinHeaderList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteBulletinHeader> getBulletinListByMarked(Context ctx, String searchKey) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "getBulletinListByMarked....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            ArrayList<LiteBulletinHeader> bulletinHeaderList = new ArrayList<LiteBulletinHeader>();
            try {
                db = helper.getReadableDatabase();
                String orderby = " mark DESC, timestamp DESC";
                String selection = null;
                String[] selectionArgs = null;
                if (TextUtils.isNotBlank((CharSequence)searchKey)) {
                    String searchKeyUpper = searchKey.trim().toUpperCase(Locale.US);
                    selection = "UPPER(subject) LIKE ? OR UPPER(typeName) LIKE ? OR UPPER(content) LIKE ?";
                    selectionArgs = new String[]{"%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%", "%" + searchKeyUpper + "%"};
                }
                if ((cursor = db.query(TABLE_BULLETIN, BulletinDBConst.bulletinHeaderSelectColumns, selection, selectionArgs, null, null, orderby, null)) != null && cursor.moveToFirst()) {
                    do {
                        LiteBulletinHeader bulletin = new LiteBulletinHeader();
                        BulletinDBConst.setBulletinHeaderValue(cursor, bulletin);
                        bulletinHeaderList.add(bulletin);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBBulletin.closeCursor(cursor);
                UCDBBulletin.closeDb(db);
                throw throwable;
            }
            UCDBBulletin.closeCursor(cursor);
            UCDBBulletin.closeDb(db);
            return bulletinHeaderList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteBulletinHeader> getBulletinListNotFullloaded(Context ctx) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "getBulletinListNotFullloaded....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            ArrayList<LiteBulletinHeader> bulletinHeaderList = new ArrayList<LiteBulletinHeader>();
            try {
                db = helper.getReadableDatabase();
                String orderby = " timestamp DESC";
                cursor = db.query(TABLE_BULLETIN, BulletinDBConst.bulletinHeaderSelectColumns, "detailLoad=?", new String[]{String.valueOf(0)}, null, null, orderby, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteBulletinHeader bulletin = new LiteBulletinHeader();
                        BulletinDBConst.setBulletinHeaderValue(cursor, bulletin);
                        bulletinHeaderList.add(bulletin);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBBulletin.closeCursor(cursor);
                UCDBBulletin.closeDb(db);
                throw throwable;
            }
            UCDBBulletin.closeCursor(cursor);
            UCDBBulletin.closeDb(db);
            return bulletinHeaderList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markBulletinAsMarked(Context ctx, long bulletinId, boolean isMarked) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "markBulletinAsMarked....bulletinId:" + bulletinId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("mark", isMarked ? 1 : 0);
                db.update(TABLE_BULLETIN, values, "id = ?", new String[]{String.valueOf(bulletinId)});
            }
            finally {
                UCDBBulletin.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markBulletinAsReaded(Context ctx, long bulletinId) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "markBulletinAsReaded....bulletinId:" + bulletinId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("read", 1);
                db.update(TABLE_BULLETIN, values, "id = ?", new String[]{String.valueOf(bulletinId)});
            }
            finally {
                UCDBBulletin.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBulletinReadcount(Context ctx, long bulletinId, int readcount) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "saveBulletinReadcount....bulletinId:" + bulletinId + ", readcount:" + readcount);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getWritableDatabase();
                int oldCount = 0;
                cursor = db.query(TABLE_BULLETIN, new String[]{"readCount"}, "id = ?", new String[]{String.valueOf(bulletinId)}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    oldCount = cursor.getInt(0);
                }
                if (oldCount < readcount) {
                    ContentValues values = new ContentValues();
                    values.put("readCount", readcount);
                    db.update(TABLE_BULLETIN, values, "id = ?", new String[]{String.valueOf(bulletinId)});
                }
            }
            catch (Throwable throwable) {
                UCDBBulletin.closeCursor(cursor);
                UCDBBulletin.closeDb(db);
                throw throwable;
            }
            UCDBBulletin.closeCursor(cursor);
            UCDBBulletin.closeDb(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveBulletinDetails(Context ctx, LiteBulletinDetail bulletinDetail) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "saveBulletinDetails....bulletin:" + String.valueOf(bulletinDetail));
        if (bulletinDetail == null) {
            return;
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("id", bulletinDetail.getId());
                values.put("content", bulletinDetail.getContent());
                values.put("readCount", bulletinDetail.getCount());
                values.put("subjectPhotoUrl", bulletinDetail.getSubjectPhoto());
                values.put("detailLoad", 1);
                db.update(TABLE_BULLETIN, values, "id = ?", new String[]{String.valueOf(bulletinDetail.getId())});
                db.delete(TABLE_BULLETIN_ATTACHMENT, "id = ?", new String[]{String.valueOf(bulletinDetail.getId())});
                ArrayList<LiteBulletinAttachment> files = bulletinDetail.getFiles();
                for (int i = 0; files != null && i < files.size(); ++i) {
                    LiteBulletinAttachment file = files.get(i);
                    ContentValues attValues = new ContentValues();
                    attValues.put("id", bulletinDetail.getId());
                    attValues.put("attachmentIndex", file.getIndex());
                    attValues.put("attachmentName", file.getFileName());
                    attValues.put("attachmentUrl", file.getUrl());
                    attValues.put("attachmentSize", file.getSize());
                    db.insert(TABLE_BULLETIN_ATTACHMENT, null, attValues);
                }
            }
            finally {
                UCDBBulletin.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteBulletin(Context ctx, long bulletinId) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "deleteBulletin...." + bulletinId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_BULLETIN, "id = ?", new String[]{String.valueOf(bulletinId)});
                db.delete(TABLE_BULLETIN_ATTACHMENT, "id = ?", new String[]{String.valueOf(bulletinId)});
            }
            finally {
                UCDBBulletin.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllBulletin(Context ctx) {
        UCDBHelper helper;
        UCDBBulletin._log(UCDBBulletin.class.getSimpleName(), "deleteAllBulletin....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_BULLETIN, null, null);
                db.delete(TABLE_BULLETIN_ATTACHMENT, null, null);
            }
            finally {
                UCDBBulletin.closeDb(db);
            }
        }
    }
}

