/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoomType;
import com.blisscloud.ezuc.bean.web.LiteConferenceUserStatus;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.DatabaseUtils;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.db.MeetmeDataHelper;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UCDBConf
extends UCDBBase {
    public static final String TABLE_CONFERENCE_ROOM = "ConferenceRoom";
    public static final String TABLE_CONFERENCE_ROOM_USER = "ConferenceRoomUser";

    public static void createConferenceRoomTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS ConferenceRoom");
        String CREATE_CONFERENCE_ROOM_TABLE = "CREATE TABLE ConferenceRoom(roomId NUMERIC PRIMARY KEY,type INTEGER,authType INTEGER,roomNo LONGVARCHAR,name LONGVARCHAR,siteName LONGVARCHAR,password LONGVARCHAR,adminPassword LONGVARCHAR,chatRoomId LONGVARCHAR,managerId NUMERIC,managerName LONGVARCHAR,chairManId LONGVARCHAR,allMuted INTEGER,locked INTEGER,managerCount INTEGER,initDone INTEGER DEFAULT 0)";
        db.execSQL(CREATE_CONFERENCE_ROOM_TABLE);
    }

    public static void createConferenceUserTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS ConferenceRoomUser");
        String CREATE_CONFERENCE_USER_TABLE = "CREATE TABLE ConferenceRoomUser(roomId NUMERIC,userNo LONGVARCHAR,callerIdNumber LONGVARCHAR,callerIdNumberSiteId LONGVARCHAR,callerIdName LONGVARCHAR,admin LONGVARCHAR,monitor LONGVARCHAR,muted LONGVARCHAR,request LONGVARCHAR,talking LONGVARCHAR,joinedTime LONGVARCHAR,callerDbId LONGVARCHAR,callerType LONGVARCHAR)";
        db.execSQL(CREATE_CONFERENCE_USER_TABLE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfRoom(Context ctx, LiteConferenceRoom room) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "addConfRoom...." + String.valueOf(room));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.insert(TABLE_CONFERENCE_ROOM, null, MeetmeDataHelper.createConfRoomAddValues(room));
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteConferenceRoom getConfRoom(Context ctx, long roomId) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "getConfRoom...." + roomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteConferenceRoom liteConferenceRoom;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CONFERENCE_ROOM, MeetmeDataHelper.confSelectColumns, "roomId=?", new String[]{String.valueOf(roomId)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    LiteConferenceRoom confRoom = new LiteConferenceRoom();
                    MeetmeDataHelper.setConfRoomValue(cursor, confRoom);
                    liteConferenceRoom = confRoom;
                }
                catch (Throwable throwable) {
                    UCDBConf.closeCursor(cursor);
                    UCDBConf.closeDb(db);
                    throw throwable;
                }
                UCDBConf.closeCursor(cursor);
                UCDBConf.closeDb(db);
                return liteConferenceRoom;
            }
            LiteConferenceRoom liteConferenceRoom = null;
            UCDBConf.closeCursor(cursor);
            UCDBConf.closeDb(db);
            return liteConferenceRoom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteConferenceRoom getConfRoomByChatRoomId(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "getConfRoomByChatroomId...." + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteConferenceRoom liteConferenceRoom;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CONFERENCE_ROOM, MeetmeDataHelper.confSelectColumns, "chatRoomId=?", new String[]{String.valueOf(chatRoomId)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    LiteConferenceRoom confRoom = new LiteConferenceRoom();
                    MeetmeDataHelper.setConfRoomValue(cursor, confRoom);
                    liteConferenceRoom = confRoom;
                }
                catch (Throwable throwable) {
                    UCDBConf.closeCursor(cursor);
                    UCDBConf.closeDb(db);
                    throw throwable;
                }
                UCDBConf.closeCursor(cursor);
                UCDBConf.closeDb(db);
                return liteConferenceRoom;
            }
            LiteConferenceRoom liteConferenceRoom = null;
            UCDBConf.closeCursor(cursor);
            UCDBConf.closeDb(db);
            return liteConferenceRoom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteConferenceRoom getConfRoomByRoomNo(Context ctx, String roomNo) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "getConfRoomByRoomNo...." + roomNo);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteConferenceRoom liteConferenceRoom;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CONFERENCE_ROOM, MeetmeDataHelper.confSelectColumns, "roomNo=?", new String[]{String.valueOf(roomNo)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    LiteConferenceRoom confRoom = new LiteConferenceRoom();
                    MeetmeDataHelper.setConfRoomValue(cursor, confRoom);
                    liteConferenceRoom = confRoom;
                }
                catch (Throwable throwable) {
                    UCDBConf.closeCursor(cursor);
                    UCDBConf.closeDb(db);
                    throw throwable;
                }
                UCDBConf.closeCursor(cursor);
                UCDBConf.closeDb(db);
                return liteConferenceRoom;
            }
            LiteConferenceRoom liteConferenceRoom = null;
            UCDBConf.closeCursor(cursor);
            UCDBConf.closeDb(db);
            return liteConferenceRoom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteConferenceRoom getStaticConfRoomByChatRoomId(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "getStaticConfRoomByChatRoomId...." + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteConferenceRoom liteConferenceRoom;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CONFERENCE_ROOM, MeetmeDataHelper.confSelectColumns, "chatRoomId =? and type =?", new String[]{String.valueOf(chatRoomId), String.valueOf(LiteConferenceRoomType.STATIC.getId())}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    LiteConferenceRoom confRoom = new LiteConferenceRoom();
                    MeetmeDataHelper.setConfRoomValue(cursor, confRoom);
                    liteConferenceRoom = confRoom;
                }
                catch (Throwable throwable) {
                    UCDBConf.closeCursor(cursor);
                    UCDBConf.closeDb(db);
                    throw throwable;
                }
                UCDBConf.closeCursor(cursor);
                UCDBConf.closeDb(db);
                return liteConferenceRoom;
            }
            LiteConferenceRoom liteConferenceRoom = null;
            UCDBConf.closeCursor(cursor);
            UCDBConf.closeDb(db);
            return liteConferenceRoom;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, LiteConferenceRoom> getStaticConfRoomMapByJidSet(Context ctx, Set<String> chatRoomJidSet) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "getStaticConfRoomMapByJidSet...." + String.valueOf(chatRoomJidSet));
        HashMap<String, LiteConferenceRoom> map = new HashMap<String, LiteConferenceRoom>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            HashMap<String, LiteConferenceRoom> hashMap;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CONFERENCE_ROOM, MeetmeDataHelper.confSelectColumns, "chatRoomId IN (" + UCDBConf.jidsStrToQueryStr(chatRoomJidSet) + ") AND type =?", new String[]{String.valueOf(LiteConferenceRoomType.STATIC.getId())}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteConferenceRoom confRoom = new LiteConferenceRoom();
                        MeetmeDataHelper.setConfRoomValue(cursor, confRoom);
                        map.put(confRoom.getChatRoomId(), confRoom);
                    } while (cursor.moveToNext());
                }
                hashMap = map;
            }
            catch (Throwable throwable) {
                UCDBConf.closeCursor(cursor);
                UCDBConf.closeDb(db);
                throw throwable;
            }
            UCDBConf.closeCursor(cursor);
            UCDBConf.closeDb(db);
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, LiteConferenceRoom> getAllConfRoomMapByJidSet(Context ctx) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "getAllConfRoomMapByJidSet....");
        HashMap<String, LiteConferenceRoom> map = new HashMap<String, LiteConferenceRoom>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            HashMap<String, LiteConferenceRoom> hashMap;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CONFERENCE_ROOM, MeetmeDataHelper.confSelectColumns, null, null, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteConferenceRoom confRoom = new LiteConferenceRoom();
                        MeetmeDataHelper.setConfRoomValue(cursor, confRoom);
                        if (!TextUtils.isNotBlank((CharSequence)confRoom.getChatRoomId())) continue;
                        map.put(confRoom.getChatRoomId(), confRoom);
                    } while (cursor.moveToNext());
                }
                hashMap = map;
            }
            catch (Throwable throwable) {
                UCDBConf.closeCursor(cursor);
                UCDBConf.closeDb(db);
                throw throwable;
            }
            UCDBConf.closeCursor(cursor);
            UCDBConf.closeDb(db);
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteConferenceRoom> getAllConfRooms(Context ctx) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "getAllConfRooms....");
        ArrayList<LiteConferenceRoom> confRoomList = new ArrayList<LiteConferenceRoom>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<LiteConferenceRoom> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String selectQuery = "SELECT " + MeetmeDataHelper.getConfSelectColumnsStr() + " FROM ConferenceRoom";
                cursor = db.rawQuery(selectQuery, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteConferenceRoom confRoom = new LiteConferenceRoom();
                        MeetmeDataHelper.setConfRoomValue(cursor, confRoom);
                        confRoomList.add(confRoom);
                    } while (cursor.moveToNext());
                }
                arrayList = confRoomList;
            }
            catch (Throwable throwable) {
                UCDBConf.closeCursor(cursor);
                UCDBConf.closeDb(db);
                throw throwable;
            }
            UCDBConf.closeCursor(cursor);
            UCDBConf.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteConferenceRoom> getAllStaticConfRooms(Context ctx) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "getAllStaticConfRooms....");
        ArrayList<LiteConferenceRoom> confRoomList = new ArrayList<LiteConferenceRoom>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<LiteConferenceRoom> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CONFERENCE_ROOM, MeetmeDataHelper.confSelectColumns, "type=? AND initDone= 1", new String[]{String.valueOf(LiteConferenceRoomType.STATIC.getId())}, null, null, "name ASC", null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteConferenceRoom confRoom = new LiteConferenceRoom();
                        MeetmeDataHelper.setConfRoomValue(cursor, confRoom);
                        confRoomList.add(confRoom);
                    } while (cursor.moveToNext());
                }
                arrayList = confRoomList;
            }
            catch (Throwable throwable) {
                UCDBConf.closeCursor(cursor);
                UCDBConf.closeDb(db);
                throw throwable;
            }
            UCDBConf.closeCursor(cursor);
            UCDBConf.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateConfRoom(Context ctx, LiteConferenceRoom room) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "updateConfRoom...." + String.valueOf(room));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.update(TABLE_CONFERENCE_ROOM, MeetmeDataHelper.createConfRoomUpdateValues(room), "roomId = ?", new String[]{String.valueOf(room.getRoomId())});
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateConfRoomLockState(Context ctx, long roomId, boolean status) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "updateConfRoomLockState....roomId:" + roomId + ", status:" + status);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.update(TABLE_CONFERENCE_ROOM, MeetmeDataHelper.createConfRoomLockStateUpdateValues(status), "roomId = ?", new String[]{String.valueOf(roomId)});
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateConfRoomInitDoneState(Context ctx, long roomId, boolean isDone) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "updateConfRoomInitDoneState....roomId:" + roomId + ", isDone:" + isDone);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.update(TABLE_CONFERENCE_ROOM, MeetmeDataHelper.createConfRoomIsDoneUpdateValues(isDone), "roomId = ?", new String[]{String.valueOf(roomId)});
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isConfInitDone(Context ctx, LiteConferenceRoom room) {
        UCDBConf._log(UCDBConf.class.getSimpleName(), "updateConfRoom...." + String.valueOf(room));
        UCDBHelper helper = UCDBHelper.getDB(ctx);
        Cursor cursor = null;
        UCDBHelper uCDBHelper = helper;
        synchronized (uCDBHelper) {
            SQLiteDatabase db;
            block4: {
                boolean bl;
                db = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CONFERENCE_ROOM, new String[]{"initDone"}, "roomId = ?", new String[]{String.valueOf(room.getRoomId())}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block4;
                    bl = cursor.getInt(0) != 0;
                }
                catch (Throwable throwable) {
                    UCDBConf.closeCursor(cursor);
                    UCDBConf.closeDb(db);
                    throw throwable;
                }
                UCDBConf.closeCursor(cursor);
                UCDBConf.closeDb(db);
                return bl;
            }
            UCDBConf.closeCursor(cursor);
            UCDBConf.closeDb(db);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteConfRoom(Context ctx, Long roomId) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "deleteConfRoom...." + roomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CONFERENCE_ROOM, "roomId = ?", new String[]{String.valueOf(roomId)});
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllConfRooms(Context ctx) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "deleteAllConfRooms....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CONFERENCE_ROOM, null, null);
                db.delete(TABLE_CONFERENCE_ROOM_USER, null, null);
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllConfRoomUsers(Context ctx, long roomId) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "deleteAllConfRoomUsers...." + roomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CONFERENCE_ROOM_USER, "roomId=?", new String[]{String.valueOf(roomId)});
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllConfRoomUsers(Context ctx) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "deleteAllConfRoomUsers....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CONFERENCE_ROOM_USER, null, null);
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existMeetmeById(Context ctx, Long roomId) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "existMeetmeById...." + roomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_CONFERENCE_ROOM, "roomId=?", new String[]{String.valueOf(roomId)});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBConf.closeDb(db);
                throw throwable;
            }
            UCDBConf.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConfRoomUser(Context ctx, Long roomId, LiteConferenceUserStatus userStatus) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "addConfRoomUser...." + roomId + "," + String.valueOf(userStatus));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.insert(TABLE_CONFERENCE_ROOM_USER, null, MeetmeDataHelper.createConfRoomUserAddValues(roomId, userStatus));
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LiteConferenceUserStatus getConfRoomUser(Context ctx, long roomId, String userNo) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "getConfRoomUser...." + roomId + "," + userNo);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                LiteConferenceUserStatus liteConferenceUserStatus;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CONFERENCE_ROOM_USER, MeetmeDataHelper.confUsersSelectColumns, "userNo=? and roomId =?", new String[]{userNo, String.valueOf(roomId)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    LiteConferenceUserStatus userStatus = new LiteConferenceUserStatus();
                    MeetmeDataHelper.setConfUserStatusValue(cursor, userStatus);
                    liteConferenceUserStatus = userStatus;
                }
                catch (Throwable throwable) {
                    UCDBConf.closeCursor(cursor);
                    UCDBConf.closeDb(db);
                    throw throwable;
                }
                UCDBConf.closeCursor(cursor);
                UCDBConf.closeDb(db);
                return liteConferenceUserStatus;
            }
            LiteConferenceUserStatus liteConferenceUserStatus = null;
            UCDBConf.closeCursor(cursor);
            UCDBConf.closeDb(db);
            return liteConferenceUserStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateConfRoomUser(Context ctx, Long roomId, LiteConferenceUserStatus userStatus) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "updateConfRoomUser...." + roomId + "," + String.valueOf(userStatus));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.update(TABLE_CONFERENCE_ROOM_USER, MeetmeDataHelper.createConfRoomUserUpdateValues(userStatus), "userNo=? and roomId =?", new String[]{userStatus.getUserNo(), String.valueOf(roomId)});
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void leaveConfRoomUser(Context ctx, Long roomId, Set<String> userNums) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "leaveConfRoomUser....roomId: " + roomId + ", userNum: " + String.valueOf(userNums));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CONFERENCE_ROOM_USER, "userNo IN (" + UCDBConf.jidsStrToQueryStr(userNums) + ") and roomId =?", new String[]{String.valueOf(roomId)});
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void leaveConfRoomByEmployeeId(Context ctx, Long roomId, long employeeId) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "leaveConfRoomByEmployeeId....roomId: " + roomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CONFERENCE_ROOM_USER, "callerType =? and callerDbId =? and roomId =?", new String[]{"EMPLOYEE", String.valueOf(employeeId), String.valueOf(roomId)});
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void muteConfRoomUser(Context ctx, Long roomId, Set<String> userNums, boolean isMute) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "muteConfRoomUser....roomId: " + roomId + ", userNum: " + String.valueOf(userNums));
        ContentValues values = new ContentValues();
        if (isMute) {
            values.put("muted", "1");
        } else {
            values.put("muted", "");
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.update(TABLE_CONFERENCE_ROOM_USER, values, "userNo IN (" + UCDBConf.jidsStrToQueryStr(userNums) + ") and roomId =?", new String[]{String.valueOf(roomId)});
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteConfRoomUser(Context ctx, Long roomId, String userNo) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "deleteConfRoomUser...." + roomId + "," + userNo);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CONFERENCE_ROOM_USER, "userNo=? and roomId =?", new String[]{userNo, String.valueOf(roomId)});
            }
            finally {
                UCDBConf.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<Long, List<LiteConferenceUserStatus>> getConfRoomUsersByRoomIdSet(Context ctx, Set<Long> roomIdSet) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "getConfRoomUsersByRoomIdSet...." + String.valueOf(roomIdSet));
        HashMap<Long, List<LiteConferenceUserStatus>> map = new HashMap<Long, List<LiteConferenceUserStatus>>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            HashMap<Long, List<LiteConferenceUserStatus>> hashMap;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CONFERENCE_ROOM_USER, MeetmeDataHelper.confUsersSelectColumns, "roomId IN (" + UCDBConf.jidsLongToQueryStr(roomIdSet) + ")", null, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteConferenceUserStatus userStatus;
                        Long roomId;
                        if (!map.containsKey(roomId = Long.valueOf(MeetmeDataHelper.setConfUserStatusValue(cursor, userStatus = new LiteConferenceUserStatus())))) {
                            map.put(roomId, new ArrayList());
                        }
                        ((List)map.get(roomId)).add(userStatus);
                    } while (cursor.moveToNext());
                }
                hashMap = map;
            }
            catch (Throwable throwable) {
                UCDBConf.closeCursor(cursor);
                UCDBConf.closeDb(db);
                throw throwable;
            }
            UCDBConf.closeCursor(cursor);
            UCDBConf.closeDb(db);
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LiteConferenceUserStatus> getConfRoomUsers(Context ctx, Long roomId) {
        UCDBHelper helper;
        UCDBConf._log(UCDBConf.class.getSimpleName(), "getConfRoomUsers...." + roomId);
        ArrayList<LiteConferenceUserStatus> confRoomUserList = new ArrayList<LiteConferenceUserStatus>();
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<LiteConferenceUserStatus> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_CONFERENCE_ROOM_USER, MeetmeDataHelper.confUsersSelectColumns, "roomId=?", new String[]{String.valueOf(roomId)}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        LiteConferenceUserStatus userStatus = new LiteConferenceUserStatus();
                        MeetmeDataHelper.setConfUserStatusValue(cursor, userStatus);
                        confRoomUserList.add(userStatus);
                    } while (cursor.moveToNext());
                }
                arrayList = confRoomUserList;
            }
            catch (Throwable throwable) {
                UCDBConf.closeCursor(cursor);
                throw throwable;
            }
            UCDBConf.closeCursor(cursor);
            return arrayList;
        }
    }
}

