/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.cc.SummaryTreeCache;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.DatabaseUtils;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.bean.ExternalCallMessage;
import com.blisscloud.mobile.ezuc.bean.FileBean;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MessageHeader;
import com.blisscloud.mobile.ezuc.bean.MsgBean;
import com.blisscloud.mobile.ezuc.bean.MsgKey;
import com.blisscloud.mobile.ezuc.bean.MsgState;
import com.blisscloud.mobile.ezuc.bean.NoticeBean;
import com.blisscloud.mobile.ezuc.db.ChatDataHelper;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;

public class UCDBMessage
extends UCDBBase {
    public static final String TABLE_MESSAGE = "Message";

    public static void createChatMessageTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS Message");
        String CREATE_CHAT_MESSAGE = "CREATE TABLE Message(id INTEGER PRIMARY KEY IDENTITY,chatRoomId LONGVARCHAR,chatMsgId LONGVARCHAR,status LONGVARCHAR,fromJid LONGVARCHAR,toJid LONGVARCHAR,content LONGVARCHAR,contentType LONGVARCHAR,timeZone LONGVARCHAR,fileName LONGVARCHAR,fileSize NUMERIC DEFAULT 0,fileLocalPath LONGVARCHAR,fileDownloadURL LONGVARCHAR,createTime NUMERIC,serverTime NUMERIC,msg_type INTEGER,playstatus INTEGER DEFAULT 0,isListen INTEGER DEFAULT 0,duration NUMERIC DEFAULT 0,noticeContent LONGVARCHAR, noticeThumbnail LONGVARCHAR, chatEventId NUMERIC, syncEventId NUMERIC,readCount INTEGER DEFAULT 0, readerList LONGVARCHAR, atMe INTEGER DEFAULT 0, extraProps LONGVARCHAR, lazyContent INTEGER DEFAULT 0, phoneNumber LONGVARCHAR, phoneMergeFlag INTEGER DEFAULT 1, isRecalled INTEGER DEFAULT 0, isOutboundTrunk INTEGER DEFAULT 0, mimeType LONGVARCHAR, extraText LONGVARCHAR, contactRecordId NUMERIC DEFAULT 0, title LONGVARCHAR )";
        db.execSQL(CREATE_CHAT_MESSAGE);
    }

    public static ContentValues createAddMsgValues(MsgBean msg, long serverReceiveTime) {
        ContentValues values = new ContentValues();
        values.put("chatRoomId", msg.getChatRoomId());
        if (msg.getPacketId() != null && !"".equals(msg.getPacketId().trim())) {
            values.put("chatMsgId", msg.getPacketId());
        }
        values.put("status", msg.getStatus());
        values.put("fromJid", msg.getFromJid());
        if (msg.getToJid() != null && !"".equals(msg.getToJid().trim())) {
            values.put("toJid", msg.getToJid());
        }
        values.put("content", msg.getContent());
        values.put("contentType", Message.ContentType.TEXT.name());
        values.put("timeZone", TimeZone.getDefault().getID());
        values.put("createTime", System.currentTimeMillis());
        values.put("serverTime", serverReceiveTime);
        values.put("msg_type", msg.getMsgType());
        values.put("playstatus", msg.isRead() ? 1 : 0);
        values.put("isListen", msg.isPlayed() ? 1 : 0);
        values.put("duration", msg.getDuration());
        values.put("chatEventId", msg.getChatEventId());
        values.put("syncEventId", msg.getSyncEventId());
        values.put("readCount", msg.getReadCount());
        values.put("readerList", msg.getReaderList());
        values.put("atMe", msg.isAtMe() ? 1 : 0);
        values.put("extraProps", msg.getProps());
        values.put("lazyContent", msg.isLazy() ? 1 : 0);
        values.put("phoneNumber", msg.getPhoneNumber());
        values.put("isOutboundTrunk", msg.isOutboundTrunk() ? 1 : 0);
        values.put("contactRecordId", msg.getContactLogId());
        values.put("title", msg.getTitle());
        return values;
    }

    public static ContentValues createAddFileValues(FileBean file, long serverReceiveTime) {
        ContentValues values = new ContentValues();
        values.put("chatRoomId", file.getChatRoomId());
        if (file.getPacketId() != null && !"".equals(file.getPacketId().trim())) {
            values.put("chatMsgId", file.getPacketId());
        }
        values.put("status", file.getStatus());
        values.put("fromJid", file.getFromJid());
        if (file.getToJid() != null && !"".equals(file.getToJid().trim())) {
            values.put("toJid", file.getToJid());
        }
        values.put("content", file.getFileContent());
        values.put("contentType", Message.ContentType.FILE.name());
        values.put("fileName", file.getFileName());
        values.put("fileSize", file.getFileSize());
        values.put("fileLocalPath", file.getFileLocalPath());
        values.put("fileDownloadURL", file.getFileDownloadURL());
        values.put("timeZone", TimeZone.getDefault().getID());
        values.put("createTime", System.currentTimeMillis());
        values.put("serverTime", serverReceiveTime);
        values.put("msg_type", file.getMsgType());
        values.put("playstatus", file.isRead() ? 1 : 0);
        values.put("isListen", file.isPlayed() ? 1 : 0);
        values.put("duration", file.getDuration());
        values.put("chatEventId", file.getChatEventId());
        values.put("syncEventId", file.getSyncEventId());
        values.put("readCount", file.getReadCount());
        values.put("readerList", file.getReaderList());
        values.put("atMe", 0);
        values.put("extraProps", file.getProps());
        values.put("lazyContent", file.isLazy() ? 1 : 0);
        values.put("mimeType", file.getMimeType());
        values.put("extraText", file.getExtraText());
        return values;
    }

    public static ContentValues createNoticeValues(NoticeBean notice, long serverReceiveTime) {
        ContentValues values = new ContentValues();
        values.put("chatRoomId", "bc_announcer_blisscloud@blisscloud.com");
        if (notice.getPacketId() != null && !"".equals(notice.getPacketId().trim())) {
            values.put("chatMsgId", notice.getPacketId());
        }
        values.put("status", notice.getStatus());
        values.put("fromJid", "bc_announcer_blisscloud@blisscloud.com");
        values.put("content", notice.getSubject());
        values.put("lazyContent", notice.isLazy() ? 1 : 0);
        values.put("contentType", Message.ContentType.TEXT.name());
        values.put("timeZone", TimeZone.getDefault().getID());
        values.put("createTime", System.currentTimeMillis());
        values.put("serverTime", serverReceiveTime);
        values.put("msg_type", 99);
        values.put("duration", notice.getFileSize());
        values.put("fileName", notice.getFileName());
        values.put("fileDownloadURL", notice.getFileDownloadURL());
        values.put("noticeContent", notice.getContent());
        values.put("noticeThumbnail", notice.getThumbnail());
        values.put("chatEventId", notice.getChatEventId());
        values.put("syncEventId", -1);
        values.put("playstatus", notice.isRead() ? 1 : 0);
        values.put("isListen", notice.isPlayed() ? 1 : 0);
        values.put("readCount", 0);
        values.put("atMe", 0);
        return values;
    }

    public static long convertTimestampToLocal(long serverReceiveTime) {
        Calendar now = Calendar.getInstance();
        now.setTimeZone(TimeZone.getTimeZone("UTC"));
        now.setTimeInMillis(serverReceiveTime);
        now.setTimeZone(TimeZone.getDefault());
        return now.getTimeInMillis();
    }

    private static long calculateMsgTime(long newMsgTimestamp, boolean isOldEvent) {
        if (isOldEvent) {
            return newMsgTimestamp;
        }
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long newCurrentMessage(Context ctx, MsgBean newMsg) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "addMessage...." + String.valueOf(newMsg));
        if (TextUtils.isBlank((CharSequence)newMsg.getChatRoomId())) {
            return -1L;
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long l;
            SQLiteDatabase db = null;
            try {
                long id;
                db = helper.getWritableDatabase();
                long currentTime = System.currentTimeMillis();
                l = id = db.insert(TABLE_MESSAGE, null, UCDBMessage.createAddMsgValues(newMsg, currentTime));
            }
            catch (Throwable throwable) {
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long addMessage(Context ctx, MsgBean newMsg, long serverReceiveTime, boolean isOldEvent) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "addMessage...." + String.valueOf(newMsg) + "," + serverReceiveTime);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long l;
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                long newMsgTimestamp = UCDBMessage.calculateMsgTime(UCDBMessage.convertTimestampToLocal(serverReceiveTime), isOldEvent);
                l = db.insert(TABLE_MESSAGE, null, UCDBMessage.createAddMsgValues(newMsg, newMsgTimestamp));
            }
            catch (Throwable throwable) {
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long addFile(Context ctx, FileBean newFile) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "addFile...." + String.valueOf(newFile));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long l;
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                long currentTime = System.currentTimeMillis();
                l = db.insert(TABLE_MESSAGE, null, UCDBMessage.createAddFileValues(newFile, currentTime));
            }
            catch (Throwable throwable) {
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long addFile(Context ctx, FileBean newFile, long serverReceiveTime, boolean isOldEvent) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "addFile...." + String.valueOf(newFile) + "," + serverReceiveTime + "," + isOldEvent);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long l;
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                long newMsgTimestamp = UCDBMessage.calculateMsgTime(UCDBMessage.convertTimestampToLocal(serverReceiveTime), isOldEvent);
                l = db.insert(TABLE_MESSAGE, null, UCDBMessage.createAddFileValues(newFile, newMsgTimestamp));
            }
            catch (Throwable throwable) {
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMessageExist(Context ctx, String packetId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "isMessageExist 1 ..." + packetId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_MESSAGE, "chatMsgId=?", new String[]{packetId});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isMessageExist(Context ctx, String chatRoomId, String packetId, String fromJid, String toJid) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "isMessageExist 2 ..." + chatRoomId + "," + packetId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            boolean bl;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_MESSAGE, "chatMsgId=? AND chatRoomId=? AND fromJid=? AND toJid=?", new String[]{packetId, chatRoomId, fromJid, toJid});
                bl = count > 0L;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateMessageContent(Context ctx, long chatEventId, String content) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateMessageContent...." + chatEventId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("content", content);
                values.put("lazyContent", 0);
                db.update(TABLE_MESSAGE, values, "chatEventId=?", new String[]{String.valueOf(chatEventId)});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateNoticeThumbnail(Context ctx, long chatEventId, String thumbnail) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateNoticeThumbnail...." + chatEventId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("noticeThumbnail", thumbnail);
                values.put("lazyContent", 0);
                db.update(TABLE_MESSAGE, values, "chatEventId=?", new String[]{String.valueOf(chatEventId)});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long addNoticeMessage(Context ctx, NoticeBean notice, long serverReceiveTime, boolean isOldEvent) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "addNoticeMessage...." + String.valueOf(notice) + "," + serverReceiveTime);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_MESSAGE, "chatMsgId=? AND chatRoomId=? AND status=? AND fromJid=? ", new String[]{notice.getPacketId(), "bc_announcer_blisscloud@blisscloud.com", notice.getStatus(), "bc_announcer_blisscloud@blisscloud.com"});
                if (count > 0L) {
                    long l = -1L;
                    return l;
                }
                long newMsgTimestamp = UCDBMessage.calculateMsgTime(UCDBMessage.convertTimestampToLocal(serverReceiveTime), isOldEvent);
                long l = db.insert(TABLE_MESSAGE, null, UCDBMessage.createNoticeValues(notice, newMsgTimestamp));
                return l;
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long addIncomingMessage(Context ctx, MsgBean msg, long serverReceiveTime, boolean isOldEvent) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "addIncomingMessage...." + String.valueOf(msg) + "," + serverReceiveTime + "," + isOldEvent);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getWritableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_MESSAGE, "chatMsgId=? AND chatRoomId=? AND status=? AND fromJid=? AND toJid=?", new String[]{msg.getPacketId(), msg.getChatRoomId(), msg.getStatus(), msg.getFromJid(), msg.getToJid()});
                if (count > 0L) {
                    long l = -1L;
                    return l;
                }
                long newMsgTimestamp = UCDBMessage.calculateMsgTime(UCDBMessage.convertTimestampToLocal(serverReceiveTime), isOldEvent);
                long l = db.insert(TABLE_MESSAGE, null, UCDBMessage.createAddMsgValues(msg, newMsgTimestamp));
                return l;
            }
            finally {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long addIncomingFile(Context ctx, FileBean file, long serverReceiveTime, boolean isOldEvent) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "addIncomingFile...." + String.valueOf(file) + "," + serverReceiveTime + "," + isOldEvent);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getWritableDatabase();
                long count = DatabaseUtils.queryNumEntries(db, TABLE_MESSAGE, "chatMsgId=? AND chatRoomId=? AND status=? AND fromJid=? AND toJid=?", new String[]{file.getPacketId(), file.getChatRoomId(), file.getStatus(), file.getFromJid(), file.getToJid()});
                if (count > 0L) {
                    long l = -1L;
                    return l;
                }
                long newMsgTimestamp = UCDBMessage.calculateMsgTime(UCDBMessage.convertTimestampToLocal(serverReceiveTime), isOldEvent);
                long l = db.insert(TABLE_MESSAGE, null, UCDBMessage.createAddFileValues(file, newMsgTimestamp));
                return l;
            }
            finally {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatMsgReadCountInfo(Context ctx, String packetId, int readCount, String readerList) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateChatMsgReadCountInfo...." + packetId + "," + readCount + "," + readerList);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block6: {
                db = null;
                cursor = null;
                try {
                    int readCountOld;
                    db = helper.getWritableDatabase();
                    cursor = db.query(TABLE_MESSAGE, new String[]{"readCount"}, "chatMsgId=?", new String[]{packetId}, null, null, null);
                    if (cursor == null || !cursor.moveToFirst() || (readCountOld = cursor.getInt(0)) < readCount) break block6;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return;
            }
            db.update(TABLE_MESSAGE, ChatDataHelper.createUpdateMsgReadCountValues(readCount, readerList), "chatMsgId=?", new String[]{packetId});
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String findChatRoomJidByPacketId(Context ctx, String packetId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findChatRoomJidByPacketId...." + packetId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                String string;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_MESSAGE, new String[]{"chatRoomId"}, "chatMsgId =?", new String[]{packetId}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    string = cursor.getString(0);
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return string;
            }
            String string = null;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatMsgStatus(Context ctx, String packetId, String status) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateChatMsgStatus ...." + packetId + "," + status);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.update(TABLE_MESSAGE, ChatDataHelper.createUpdateMsgValues(status), "chatMsgId=?", new String[]{packetId});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatMsgStatus(Context ctx, String packetId, String status, String fileDownloadURL) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateChatMsgStatus 3 ...." + packetId + "," + status);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.update(TABLE_MESSAGE, ChatDataHelper.createUpdateMsgValues(status, fileDownloadURL), "chatMsgId=?", new String[]{packetId});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatEventId(Context ctx, String packetId, long chatEventId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateChatMsgChatEventId...." + packetId + "," + chatEventId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.update(TABLE_MESSAGE, ChatDataHelper.createUpdateMsgChatEventValues(chatEventId), "chatMsgId=?", new String[]{packetId});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSyncEventId(Context ctx, String packetId, long syncEventId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateChatMsgSyncEventId...." + packetId + "," + syncEventId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.update(TABLE_MESSAGE, ChatDataHelper.createUpdateMsgSyncEventValues(syncEventId), "chatMsgId=?", new String[]{packetId});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatEventAndUrl(Context ctx, String packetId, Long chatEventId, Long syncChatEventId, String fileDownloadURL) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateChatMsgStatus 3 ....packetId:" + packetId + ", chatEventId:" + chatEventId + ", fileDownloadURL:" + fileDownloadURL);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.update(TABLE_MESSAGE, ChatDataHelper.createUpdateMsgValues(chatEventId, syncChatEventId, fileDownloadURL), "chatMsgId=?", new String[]{packetId});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> findHasMsgChatRoomIds(Context ctx) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findHasMsgChatRoomIds....");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT M.");
        sql.append("chatRoomId");
        sql.append(" FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" M");
        sql.append(", ");
        sql.append("ChatRoom");
        sql.append(" R WHERE M.");
        sql.append("chatRoomId");
        sql.append(" = R.");
        sql.append("chatRoomId");
        sql.append(" AND R.");
        sql.append("type");
        sql.append(" != ");
        sql.append(3);
        sql.append(" AND M.");
        sql.append("isRecalled");
        sql.append(" = 0 ");
        sql.append(" GROUP BY M.chatRoomId");
        String[] selectionArgs = new String[]{};
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<String> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                ArrayList<String> chatRoomIdList = new ArrayList<String>();
                db = helper.getReadableDatabase();
                cursor = db.rawQuery(sql.toString(), selectionArgs);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String chatRoomId = cursor.getString(0);
                        chatRoomIdList.add(chatRoomId);
                    } while (cursor.moveToNext());
                }
                arrayList = chatRoomIdList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean findHasMsgChatRoomId(Context ctx, String jid) {
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findHasMsgChatRoomId....");
        sql = new StringBuilder();
        sql.append("SELECT M.");
        sql.append("chatRoomId");
        sql.append(" FROM ");
        sql.append("Message");
        sql.append(" M");
        sql.append(", ");
        sql.append("ChatRoom");
        sql.append(" R WHERE M.");
        sql.append("chatRoomId");
        sql.append(" = R.");
        sql.append("chatRoomId");
        sql.append(" AND R.");
        sql.append("chatRoomId");
        sql.append(" = ? AND R.");
        sql.append("type");
        sql.append(" != ");
        sql.append(3);
        sql.append(" AND M.");
        sql.append("isRecalled");
        sql.append(" = 0 ");
        sql.append(" GROUP BY M.chatRoomId");
        selectionArgs = new String[]{jid};
        var5_5 = helper = UCDBHelper.getDB(ctx);
        synchronized (var5_5) {
            db = null;
            cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.rawQuery(sql.toString(), selectionArgs);
                if (cursor != null && cursor.moveToFirst()) {
                    while (true) {
                        chatRoomId = cursor.getString(0);
                        if (!chatRoomId.equals(jid)) continue;
                        var9_10 = true;
                        break;
                    }
                }
                ** GOTO lbl68
            }
            catch (Throwable var10_11) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw var10_11;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return var9_10;
            {
                if (cursor.moveToNext()) ** continue;
lbl68:
                // 2 sources

                var8_9 = false;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return var8_9;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> findHasMsgChatRoomIds(Context ctx, String searchKey) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findHasMsgChatRoomIds....searchKey:" + searchKey);
        String meetmePrefix = OutboundPrefixManager.getMeetmePrefix(ctx);
        ArrayList<String> chatRoomIdList = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT M.");
        sql.append("chatRoomId");
        sql.append(" FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" M");
        sql.append(", ");
        sql.append("ChatRoom");
        sql.append(" R");
        sql.append(" WHERE ");
        sql.append("M.");
        sql.append("chatRoomId");
        sql.append(" = R.");
        sql.append("chatRoomId");
        sql.append(" AND M.");
        sql.append("isRecalled");
        sql.append(" = 0 ");
        sql.append(" AND R.");
        sql.append("type");
        sql.append(" != ");
        sql.append(3);
        sql.append(" AND M.");
        sql.append("chatRoomId");
        sql.append(" IN (");
        sql.append(" SELECT ");
        sql.append("jid");
        sql.append(" ID FROM ");
        sql.append("Contact");
        sql.append(" WHERE (");
        Locale locale = I18NUtil.getAppLocale();
        if (Locale.TAIWAN.equals(locale)) {
            sql.append("UPPER(");
            sql.append("dispName");
            sql.append(") like ?");
            sql.append(" OR UPPER(");
            sql.append("deptForSearch");
            sql.append(") LIKE ?");
            sql.append(" OR UPPER(");
            sql.append("extForSearch");
            sql.append(") LIKE ?");
        } else {
            sql.append("UPPER(");
            sql.append("dispName");
            sql.append(") like ?");
            sql.append(" OR UPPER(");
            sql.append("dispNameForPinYin");
            sql.append(") like ?");
            sql.append(" OR UPPER(");
            sql.append("deptForSearch");
            sql.append(") LIKE ?");
            sql.append(" OR UPPER(");
            sql.append("extForSearch");
            sql.append(") LIKE ?");
        }
        sql.append(")");
        sql.append(" UNION ");
        sql.append("SELECT ");
        sql.append("jid");
        sql.append(" ID FROM ");
        sql.append("DeletedJidContact");
        sql.append(" WHERE (");
        sql.append("UPPER(");
        sql.append("otherName");
        sql.append(") like ?");
        sql.append(" OR UPPER(");
        sql.append("surName");
        sql.append(") like ?");
        sql.append(" OR UPPER(");
        sql.append("givenName");
        sql.append(") like ?");
        sql.append(")");
        sql.append(" UNION ");
        sql.append("SELECT ");
        sql.append("chatRoomId");
        sql.append(" ID FROM ");
        sql.append("ConferenceRoom");
        sql.append(" WHERE (");
        sql.append("UPPER(");
        sql.append("name");
        sql.append(") like ?");
        sql.append(" OR ('" + meetmePrefix + "' || ");
        sql.append("roomNo");
        sql.append(") LIKE ?");
        sql.append(")");
        sql.append("UNION ");
        sql.append("SELECT ");
        sql.append("chatRoomId");
        sql.append(" ID FROM ");
        sql.append("ChatRoom");
        sql.append(" WHERE UPPER(");
        sql.append("subject");
        sql.append(") like ? ");
        sql.append("UNION ");
        sql.append("SELECT A.");
        sql.append("chatRoomId");
        sql.append(" ID FROM ");
        sql.append("ChatRoom");
        sql.append(" A, ");
        sql.append("ChatRoomParticipant");
        sql.append(" B, ");
        sql.append("Contact");
        sql.append(" C ");
        sql.append("WHERE (");
        if (Locale.TAIWAN.equals(locale)) {
            sql.append("UPPER(C.");
            sql.append("dispName");
            sql.append(") like ?");
            sql.append(" OR UPPER(C.");
            sql.append("deptForSearch");
            sql.append(") LIKE ?");
            sql.append(" OR UPPER(C.");
            sql.append("extForSearch");
            sql.append(") LIKE ?");
        } else {
            sql.append("UPPER(C.");
            sql.append("dispName");
            sql.append(") like ? ");
            sql.append("OR UPPER(C.");
            sql.append("dispNameForPinYin");
            sql.append(") like ?");
            sql.append(" OR UPPER(C.");
            sql.append("deptForSearch");
            sql.append(") LIKE ?");
            sql.append(" OR UPPER(C.");
            sql.append("extForSearch");
            sql.append(") LIKE ?");
        }
        sql.append(") AND B.");
        sql.append("jid");
        sql.append(" = C.");
        sql.append("jid");
        sql.append(" AND A.");
        sql.append("chatRoomId");
        sql.append(" = B.");
        sql.append("chatRoomId");
        sql.append(" GROUP BY A.");
        sql.append("chatRoomId");
        sql.append(")");
        sql.append(" GROUP BY M.chatRoomId");
        String[] data = null;
        String upperSearchKey = searchKey.toUpperCase(Locale.US);
        data = Locale.TAIWAN.equals(locale) ? new String[]{"%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%"} : new String[]{"%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%"};
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<String> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.rawQuery(sql.toString(), data);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String chatRoomId = cursor.getString(0);
                        chatRoomIdList.add(chatRoomId);
                    } while (cursor.moveToNext());
                }
                arrayList = chatRoomIdList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> findHasMsgExternalIds(Context ctx, String searchKey) {
        UCDBHelper helper;
        Locale locale;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findHasMsgExternalIds....searchKey:" + searchKey);
        ArrayList<String> chatRoomIdList = new ArrayList<String>();
        StringBuilder selection = new StringBuilder();
        selection.append("chatRoomId");
        selection.append(" IN (SELECT (");
        selection.append("id");
        selection.append(" || '");
        selection.append("@externalcontact");
        selection.append("') FROM ");
        selection.append("ExternalContact");
        selection.append(" WHERE ");
        String[] args = null;
        String upperSearchKey = searchKey;
        if (TextUtils.isNotBlank((CharSequence)searchKey)) {
            upperSearchKey = searchKey.trim().toUpperCase();
        }
        if (Locale.TAIWAN.equals(locale = I18NUtil.getAppLocale())) {
            selection.append("(");
            selection.append("UPPER(");
            selection.append("name");
            selection.append(") like ?");
            selection.append(" OR UPPER(");
            selection.append("comapnytel");
            selection.append(") LIKE ?");
            selection.append(" OR UPPER(");
            selection.append("organization");
            selection.append(") LIKE ?");
            selection.append(")");
            args = new String[]{"%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%"};
        } else {
            selection.append("(");
            selection.append("UPPER(");
            selection.append("name");
            selection.append(") like ?");
            selection.append(" OR UPPER(");
            selection.append("nameForPinYin");
            selection.append(") like ?");
            selection.append(" OR UPPER(");
            selection.append("comapnytel");
            selection.append(") LIKE ?");
            selection.append(" OR UPPER(");
            selection.append("organization");
            selection.append(") LIKE ?");
            selection.append(")");
            args = new String[]{"%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%", "%" + upperSearchKey + "%"};
        }
        selection.append(")");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_MESSAGE, new String[]{"chatRoomId"}, selection.toString(), args, "chatRoomId", "COUNT(*)>0", null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String chatRoomId = cursor.getString(0);
                        chatRoomIdList.add(chatRoomId);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
        }
        return chatRoomIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countNotReadMsg(Context ctx, String chatRoomId, String myJid) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "countNotReadMsg...." + chatRoomId);
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT count(*) FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" WHERE ");
        sql.append("chatRoomId");
        sql.append(" = ? AND ");
        sql.append("playstatus");
        sql.append(" = ? AND ");
        sql.append("isRecalled");
        sql.append(" = 0 AND ");
        sql.append("fromJid");
        sql.append(" != ? ");
        String[] selectionArgs = new String[]{chatRoomId, "0", myJid};
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            int n;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                int count = 0;
                cursor = db.rawQuery(sql.toString(), selectionArgs);
                if (cursor != null && cursor.moveToFirst()) {
                    count = cursor.getInt(0);
                }
                n = count;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> countNotReadMsgForAllRooms(Context ctx, Set<String> jidList, String myJid) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "countNotReadMsgForAllRooms....");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT chatRoomId, count(*) FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" WHERE ");
        sql.append("playstatus");
        sql.append(" = ? AND ");
        sql.append("fromJid");
        sql.append(" != ? AND ");
        sql.append("isRecalled");
        sql.append(" = 0 AND ");
        sql.append("chatRoomId");
        sql.append(" IN (" + UCDBMessage.jidsStrToQueryStr(jidList) + ") ");
        sql.append(" GROUP BY chatRoomId");
        String[] selectionArgs = new String[]{"0", myJid};
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            HashMap<String, Integer> hashMap;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                HashMap<String, Integer> map = new HashMap<String, Integer>();
                cursor = db.rawQuery(sql.toString(), selectionArgs);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String key = cursor.getString(0);
                        int count = cursor.getInt(1);
                        map.put(key, count);
                    } while (cursor.moveToNext());
                }
                hashMap = map;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> hasMeCountForAllRooms(Context ctx, Set<String> jidList, String myJid) {
        HashMap<String, Integer> hashMap;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "countNotReadMsgForAllRooms....");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT chatRoomId, count(*) FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" WHERE ");
        sql.append("playstatus");
        sql.append(" = ? AND ");
        sql.append("fromJid");
        sql.append(" != ? AND ");
        sql.append("atMe");
        sql.append(" = ? AND ");
        sql.append("chatRoomId IN (" + UCDBMessage.jidsStrToQueryStr(jidList) + ") ");
        sql.append(" AND ");
        sql.append("isRecalled");
        sql.append(" = 0 ");
        sql.append(" GROUP BY chatRoomId");
        String[] selectionArgs = new String[]{"0", myJid, "1"};
        UCDBHelper helper = UCDBHelper.getDB(ctx);
        Cursor cursor = null;
        try {
            SQLiteDatabase db = helper.getReadableDatabase();
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            cursor = db.rawQuery(sql.toString(), selectionArgs);
            if (cursor != null && cursor.moveToFirst()) {
                do {
                    String key = cursor.getString(0);
                    int count = cursor.getInt(1);
                    map.put(key, count);
                } while (cursor.moveToNext());
            }
            hashMap = map;
        }
        catch (Throwable throwable) {
            UCDBMessage.closeCursor(cursor);
            throw throwable;
        }
        UCDBMessage.closeCursor(cursor);
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countNoReadChatMsg(Context ctx, String myJid) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "countNoReadChatMsg....");
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT count(*) FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" M, ");
        sql.append("ChatRoom");
        sql.append(" R WHERE M.");
        sql.append("chatRoomId");
        sql.append(" = R.");
        sql.append("chatRoomId");
        sql.append(" AND M.");
        sql.append("playstatus");
        sql.append(" = ? AND M.");
        sql.append("isRecalled");
        sql.append(" = 0 AND M.");
        sql.append("fromJid");
        sql.append(" != ? AND R.");
        sql.append("type");
        sql.append(" != ");
        sql.append(3);
        String[] selectionArgs = new String[]{"0", myJid};
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            int n;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                int count = 0;
                cursor = db.rawQuery(sql.toString(), selectionArgs);
                if (cursor != null && cursor.moveToFirst()) {
                    count = cursor.getInt(0);
                }
                n = count;
            }
            catch (Throwable t) {
                int n2;
                try {
                    n2 = 0;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return n2;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long getOldestEventId(Context ctx) {
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "getOldestEventId....");
        StringBuilder sql = new StringBuilder();
        UCDBHelper helper = UCDBHelper.getDB(ctx);
        sql.append("SELECT MIN (chatEventId) ");
        sql.append("FROM Message ");
        sql.append("WHERE chatEventId IS NOT NULL AND chatEventId > 0");
        UCDBHelper uCDBHelper = helper;
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                Long l;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.rawQuery(sql.toString(), null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    long oldestEventId = cursor.getLong(0);
                    l = oldestEventId;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return l;
            }
            Long l = null;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int lastExternalCallUnread(Context ctx, String myJid) {
        UCDBHelper helper;
        ArrayList<Integer> callTypeList = UCDBMessage.getCallTypeList();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT count(*) FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" M, ");
        sql.append("ChatRoom");
        sql.append(" R WHERE M.");
        sql.append("chatRoomId");
        sql.append(" = R.");
        sql.append("chatRoomId");
        sql.append(" AND M.");
        sql.append("playstatus");
        sql.append(" = ? AND M.");
        sql.append("fromJid");
        sql.append(" != ? AND R.");
        sql.append("type");
        sql.append(" = ");
        sql.append(3);
        sql.append(" AND M.");
        sql.append("msg_type IN (");
        for (int i = 0; i < callTypeList.size(); ++i) {
            int typeToHide = callTypeList.get(i);
            if (i != 0) {
                sql.append(",");
            }
            sql.append(typeToHide);
        }
        sql.append(")");
        String[] selectionArgs = new String[]{"0", myJid};
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block7: {
                int n;
                db = null;
                cursor = null;
                try {
                    int count;
                    db = helper.getReadableDatabase();
                    cursor = db.rawQuery(sql.toString(), selectionArgs);
                    if (cursor == null || !cursor.moveToFirst()) break block7;
                    n = count = cursor.getInt(0);
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return n;
            }
            int n = 0;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ExternalCallMessage getExternalCallMsg(Context ctx, Long contactRecordId) {
        UCDBHelper helper;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int ii = 0;
        String[] stringArray = ChatDataHelper.msgSelectColumns;
        int n = stringArray.length;
        for (int i = 0; i < n; ++ii, ++i) {
            String key = stringArray[i];
            if (ii != 0) {
                sql.append(",");
            }
            sql.append("M.");
            sql.append(key);
        }
        sql.append(", D.categoryIds");
        sql.append(", D.outcomeIds");
        sql.append(", D.note");
        sql.append(", D.appId");
        sql.append(", D.customerId");
        sql.append(", D.customerName");
        sql.append(", D.customerNo");
        sql.append(", REC.recordSiteId");
        sql.append(", REC.encodedRecordKey");
        sql.append(", REC.fileSize");
        sql.append(" FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" M LEFT OUTER JOIN ");
        sql.append("ContactSummary");
        sql.append(" D on M.contactRecordId = D.contactLogId");
        sql.append(" LEFT OUTER JOIN ");
        sql.append("Recording");
        sql.append(" REC on M.contactRecordId = REC.contactLogId");
        sql.append(",");
        sql.append("ChatRoom");
        sql.append(" R WHERE M.");
        sql.append("chatRoomId");
        sql.append(" = R.");
        sql.append("chatRoomId");
        sql.append(" AND R.");
        sql.append("type");
        sql.append(" = ");
        sql.append(3);
        sql.append(" AND M.contactRecordId = ?");
        ArrayList<String> selectList = new ArrayList<String>();
        selectList.add(contactRecordId.toString());
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block6: {
                ExternalCallMessage externalCallMessage;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.rawQuery(sql.toString(), selectList.toArray(new String[selectList.size()]));
                    if (cursor == null || !cursor.moveToFirst()) break block6;
                    ExternalCallMessage msg = new ExternalCallMessage();
                    ChatDataHelper.setMsgValue(cursor, msg);
                    int startIndex = 34;
                    msg.setSummaryCategoryIds(cursor.getString(startIndex++));
                    msg.setSummaryOutcomeIds(cursor.getString(startIndex++));
                    msg.setSummaryNote(cursor.getString(startIndex++));
                    msg.setAppId(cursor.getLong(startIndex++));
                    msg.setCustomerId(cursor.getLong(startIndex++));
                    msg.setCustomerName(cursor.getString(startIndex++));
                    msg.setCustomerNo(cursor.getString(startIndex++));
                    msg.setRecordSiteId(cursor.getLong(startIndex++));
                    msg.setEncodedRecordKey(cursor.getString(startIndex++));
                    msg.setFileSize(cursor.getLong(startIndex++));
                    externalCallMessage = msg;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return externalCallMessage;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ExternalCallMessage> findExternalCallMsgList(Context ctx, List<Integer> callTypeList, String number, String summary, String customerNo, String customerName, Date startTime, Date endTime, int pageIndex, int pageSize) {
        UCDBHelper helper;
        ArrayList<ExternalCallMessage> msgList = new ArrayList<ExternalCallMessage>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int ii = 0;
        for (String key : ChatDataHelper.msgSelectColumns) {
            if (ii != 0) {
                sql.append(",");
            }
            sql.append("M.");
            sql.append(key);
            ++ii;
        }
        sql.append(", D.categoryIds");
        sql.append(", D.outcomeIds");
        sql.append(", D.note");
        sql.append(", D.appId");
        sql.append(", D.customerId");
        sql.append(", D.customerName");
        sql.append(", D.customerNo");
        sql.append(", REC.recordSiteId");
        sql.append(", REC.encodedRecordKey");
        sql.append(", REC.fileSize");
        sql.append(" FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" M LEFT OUTER JOIN ");
        sql.append("ContactSummary");
        sql.append(" D on M.contactRecordId = D.contactLogId");
        sql.append(" LEFT OUTER JOIN ");
        sql.append("Recording");
        sql.append(" REC on M.contactRecordId = REC.contactLogId");
        sql.append(",");
        sql.append("ChatRoom");
        sql.append(" R WHERE M.");
        sql.append("chatRoomId");
        sql.append(" = R.");
        sql.append("chatRoomId");
        sql.append(" AND R.");
        sql.append("type");
        sql.append(" = ");
        sql.append(3);
        UCDBMessage.handleDataTypeFuzzy(callTypeList, number, sql);
        ArrayList<Object> selectList = new ArrayList<Object>();
        if (startTime != null) {
            sql.append(" AND M.serverTime >= ? ");
            selectList.add(String.valueOf(startTime.getTime()));
        }
        if (endTime != null) {
            sql.append(" AND M.serverTime <= ? ");
            selectList.add(String.valueOf(endTime.getTime()));
        }
        if (TextUtils.isNotBlank((CharSequence)number)) {
            sql.append(" AND M.phoneNumber like ? ");
            selectList.add("%" + number.trim() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)customerName)) {
            sql.append(" AND LOWER(D.customerName) like ? ");
            selectList.add("%" + customerName.trim().toLowerCase() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)customerNo)) {
            sql.append(" AND LOWER(D.customerNo) like ? ");
            selectList.add("%" + customerNo.trim().toLowerCase() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)summary)) {
            List<Long> summaryItemList = SummaryTreeCache.matchSummaryItemList(summary);
            if (summaryItemList != null && summaryItemList.size() > 0) {
                sql.append(" AND (");
                for (Long sid : summaryItemList) {
                    sql.append("D.categoryIds like ',%" + sid + ",%'");
                    sql.append(" OR ");
                }
                for (Long sid : summaryItemList) {
                    sql.append("D.outcomeIds like ',%" + sid + ",%'");
                    sql.append(" OR ");
                }
                sql.append("LOWER(D.note) like ? ");
                sql.append(") ");
            } else {
                sql.append(" AND LOWER(D.note) like ? ");
            }
            selectList.add("%" + summary.trim().toLowerCase() + "%");
        }
        sql.append(" ORDER BY M.serverTime DESC");
        sql.append(" OFFSET " + pageSize * (pageIndex - 1));
        sql.append(" LIMIT " + pageSize);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.rawQuery(sql.toString(), selectList.toArray(new String[selectList.size()]));
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        ExternalCallMessage msg = new ExternalCallMessage();
                        ChatDataHelper.setMsgValue(cursor, msg);
                        int startIndex = 34;
                        msg.setSummaryCategoryIds(cursor.getString(startIndex++));
                        msg.setSummaryOutcomeIds(cursor.getString(startIndex++));
                        msg.setSummaryNote(cursor.getString(startIndex++));
                        msg.setAppId(cursor.getLong(startIndex++));
                        msg.setCustomerId(cursor.getLong(startIndex++));
                        msg.setCustomerName(cursor.getString(startIndex++));
                        msg.setCustomerNo(cursor.getString(startIndex++));
                        msg.setRecordSiteId(cursor.getLong(startIndex++));
                        msg.setEncodedRecordKey(cursor.getString(startIndex++));
                        msg.setFileSize(cursor.getLong(startIndex++));
                        msgList.add(msg);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
        }
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int countExternalCallMsgList(Context ctx, List<Integer> callTypeList, String number, String summary, String customerNo, String customerName, Date startTime, Date endTime) {
        if (callTypeList == null) return 0;
        if (callTypeList.size() == 0) {
            return 0;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT count(*) FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" M LEFT OUTER JOIN ");
        sql.append("ContactSummary");
        sql.append(" D on M.contactRecordId = D.contactLogId");
        sql.append(",");
        sql.append("ChatRoom");
        sql.append(" R WHERE M.");
        sql.append("chatRoomId");
        sql.append(" = R.");
        sql.append("chatRoomId");
        sql.append(" AND R.");
        sql.append("type");
        sql.append(" = ");
        sql.append(3);
        UCDBMessage.handleDataTypeFuzzy(callTypeList, number, sql);
        ArrayList<Object> selectList = new ArrayList<Object>();
        if (startTime != null) {
            sql.append(" AND M.serverTime >= ? ");
            selectList.add(String.valueOf(startTime.getTime()));
        }
        if (endTime != null) {
            sql.append(" AND M.serverTime <= ? ");
            selectList.add(String.valueOf(endTime.getTime()));
        }
        if (TextUtils.isNotBlank((CharSequence)number)) {
            sql.append(" AND M.phoneNumber like ? ");
            selectList.add("%" + number.trim() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)customerName)) {
            sql.append(" AND LOWER(D.customerName) like ? ");
            selectList.add("%" + customerName.trim().toLowerCase() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)customerNo)) {
            sql.append(" AND LOWER(D.customerNo) like ? ");
            selectList.add("%" + customerNo.trim().toLowerCase() + "%");
        }
        if (StringUtils.isNotBlank((CharSequence)summary)) {
            List<Long> summaryItemList = SummaryTreeCache.matchSummaryItemList(summary);
            if (summaryItemList != null && summaryItemList.size() > 0) {
                sql.append(" AND (");
                for (Long sid : summaryItemList) {
                    sql.append("D.categoryIds like '%," + sid + ",%'");
                    sql.append(" OR ");
                }
                for (Long sid : summaryItemList) {
                    sql.append("D.outcomeIds like '%," + sid + ",%'");
                    sql.append(" OR ");
                }
                sql.append("LOWER(D.note) like ? ");
                sql.append(") ");
            } else {
                sql.append(" AND LOWER(D.note) like ? ");
            }
            System.out.println("sql:" + String.valueOf(sql));
            selectList.add("%" + summary.trim().toLowerCase() + "%");
        }
        UCDBHelper helper = UCDBHelper.getDB(ctx);
        Iterator<Long> iterator = helper;
        synchronized (iterator) {
            Cursor cursor;
            SQLiteDatabase db;
            block15: {
                int n;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.rawQuery(sql.toString(), selectList.toArray(new String[selectList.size()]));
                    if (cursor == null || !cursor.moveToFirst()) break block15;
                    n = cursor.getInt(0);
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return n;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ExternalCallMessage> findExternalCallMsgList(Context ctx, long contactRecordId, int pageIndex, int pageSize) {
        UCDBHelper helper;
        ArrayList<ExternalCallMessage> msgList = new ArrayList<ExternalCallMessage>();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int ii = 0;
        for (String key : ChatDataHelper.msgSelectColumns) {
            if (ii != 0) {
                sql.append(",");
            }
            sql.append("M.");
            sql.append(key);
            ++ii;
        }
        sql.append(", D.categoryIds");
        sql.append(", D.outcomeIds");
        sql.append(", D.note");
        sql.append(", D.appId");
        sql.append(", D.customerId");
        sql.append(", D.customerName");
        sql.append(", D.customerNo");
        sql.append(", REC.recordSiteId");
        sql.append(", REC.encodedRecordKey");
        sql.append(", REC.fileSize");
        sql.append(" FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" M LEFT OUTER JOIN ");
        sql.append("ContactSummary");
        sql.append(" D on M.contactRecordId = D.contactLogId");
        sql.append(" LEFT OUTER JOIN ");
        sql.append("Recording");
        sql.append(" REC on M.contactRecordId = REC.contactLogId");
        sql.append(",");
        sql.append("ChatRoom");
        sql.append(" R WHERE M.");
        sql.append("chatRoomId");
        sql.append(" = R.");
        sql.append("chatRoomId");
        sql.append(" AND R.");
        sql.append("type");
        sql.append(" = ");
        sql.append(3);
        sql.append(" AND M.");
        sql.append("contactRecordId");
        sql.append(" = ? ");
        ArrayList<String> selectList = new ArrayList<String>();
        selectList.add(String.valueOf(contactRecordId));
        sql.append(" ORDER BY M.serverTime DESC");
        sql.append(" OFFSET " + pageSize * (pageIndex - 1));
        sql.append(" LIMIT " + pageSize);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.rawQuery(sql.toString(), selectList.toArray(new String[selectList.size()]));
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        ExternalCallMessage msg = new ExternalCallMessage();
                        ChatDataHelper.setMsgValue(cursor, msg);
                        int startIndex = 34;
                        msg.setSummaryCategoryIds(cursor.getString(startIndex++));
                        msg.setSummaryOutcomeIds(cursor.getString(startIndex++));
                        msg.setSummaryNote(cursor.getString(startIndex++));
                        msg.setAppId(cursor.getLong(startIndex++));
                        msg.setCustomerId(cursor.getLong(startIndex++));
                        msg.setCustomerName(cursor.getString(startIndex++));
                        msg.setCustomerNo(cursor.getString(startIndex++));
                        msg.setRecordSiteId(cursor.getLong(startIndex++));
                        msg.setEncodedRecordKey(cursor.getString(startIndex++));
                        msg.setFileSize(cursor.getLong(startIndex++));
                        msgList.add(msg);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
        }
        return msgList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int countExternalCallMsgList(Context ctx, long contactRecordId) {
        UCDBHelper helper;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT count(*) FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" M, ");
        sql.append("ChatRoom");
        sql.append(" R WHERE M.");
        sql.append("chatRoomId");
        sql.append(" = R.");
        sql.append("chatRoomId");
        sql.append(" AND R.");
        sql.append("type");
        sql.append(" = ");
        sql.append(3);
        sql.append(" AND M.");
        sql.append("contactRecordId");
        sql.append(" = ? ");
        ArrayList<String> selectList = new ArrayList<String>();
        selectList.add(String.valueOf(contactRecordId));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block4: {
                int n;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.rawQuery(sql.toString(), selectList.toArray(new String[selectList.size()]));
                    if (cursor == null || !cursor.moveToFirst()) break block4;
                    n = cursor.getInt(0);
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return n;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return 0;
        }
    }

    private static void handleDataTypeFuzzy(List<Integer> callTypeList, String number, StringBuilder sql) {
        if (TextUtils.isBlank((CharSequence)number)) {
            sql.append(" AND M.");
            if (callTypeList == null || callTypeList.size() == 0) {
                sql.append("msg_type is null");
            } else {
                sql.append("msg_type IN (");
                for (int i = 0; i < callTypeList.size(); ++i) {
                    int typeToShow = callTypeList.get(i);
                    if (i != 0) {
                        sql.append(",");
                    }
                    sql.append(typeToShow);
                }
                sql.append(")");
            }
        } else {
            sql.append(" AND (");
            boolean isFuzzyEnabled = PreferencesUtil.isFuzzyOutboundNumber(UCChatClient.context);
            boolean start = true;
            for (int i = 0; i < callTypeList.size(); ++i) {
                int callType = callTypeList.get(i);
                if (callType == 223 || callType == 225 || callType == 1005 || callType == 12) {
                    if (!start) {
                        sql.append(" OR ");
                    }
                    sql.append("(");
                    sql.append("M.msg_type=" + callType);
                    sql.append(")");
                    start = false;
                    continue;
                }
                if (callType == 221 || callType == 222) {
                    if (isFuzzyEnabled) continue;
                    if (!start) {
                        sql.append(" OR ");
                    }
                    sql.append("(");
                    sql.append("M.msg_type=" + callType);
                    sql.append(")");
                    start = false;
                    continue;
                }
                if (callType != 1006 && callType != 13) continue;
                if (!isFuzzyEnabled) {
                    if (!start) {
                        sql.append(" OR ");
                    }
                    sql.append("(");
                    sql.append("M.msg_type=" + callType);
                    sql.append(")");
                    start = false;
                    continue;
                }
                if (!start) {
                    sql.append(" OR ");
                }
                sql.append("(");
                sql.append("M.msg_type=" + callType + " AND M.isOutboundTrunk=0");
                sql.append(")");
                start = false;
            }
            sql.append(")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Message lastExternalCallMsg(Context ctx) {
        UCDBHelper helper;
        ArrayList<Integer> callList = UCDBMessage.getCallTypeList();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int ii = 0;
        String[] stringArray = ChatDataHelper.msgSelectColumns;
        int n = stringArray.length;
        for (int i = 0; i < n; ++ii, ++i) {
            String key = stringArray[i];
            if (ii != 0) {
                sql.append(",");
            }
            sql.append("M.");
            sql.append(key);
        }
        sql.append(" FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" M, ");
        sql.append("ChatRoom");
        sql.append(" R WHERE M.");
        sql.append("chatRoomId");
        sql.append(" = R.");
        sql.append("chatRoomId");
        sql.append(" AND R.");
        sql.append("type");
        sql.append(" = ");
        sql.append(3);
        sql.append(" AND M.");
        sql.append("msg_type IN (");
        for (int i = 0; i < callList.size(); ++i) {
            int typeToHide = callList.get(i);
            if (i != 0) {
                sql.append(",");
            }
            sql.append(typeToHide);
        }
        sql.append(") ORDER BY M.serverTime DESC LIMIT 1");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block9: {
                Message message;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.rawQuery(sql.toString(), null);
                    if (cursor == null || !cursor.moveToFirst()) break block9;
                    Message msg = new Message();
                    ChatDataHelper.setMsgValue(cursor, msg);
                    message = msg;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return message;
            }
            Message message = null;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return message;
        }
    }

    private static ArrayList<Integer> getCallTypeList() {
        ArrayList<Integer> callList = new ArrayList<Integer>();
        callList.add(221);
        callList.add(223);
        callList.add(222);
        callList.add(225);
        callList.add(1005);
        callList.add(1006);
        callList.add(12);
        callList.add(13);
        return callList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Message> getLastMsgMap(Context ctx, Set<String> jidSet) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "getLastMsgMap...." + String.valueOf(jidSet));
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int ii = 0;
        for (String key : ChatDataHelper.msgSelectColumns) {
            if (ii != 0) {
                sql.append(",");
            }
            sql.append("m.");
            sql.append(key);
            ++ii;
        }
        sql.append(" FROM Message m ");
        sql.append("INNER JOIN (SELECT chatRoomId, MAX(serverTime) AS MaxTime  FROM Message WHERE isRecalled = 0 GROUP BY chatRoomId) groupedm ");
        sql.append("ON m.chatRoomId = groupedm.chatRoomId ");
        sql.append("AND m.serverTime = groupedm.MaxTime");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            HashMap<String, Message> hashMap;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                HashMap<String, Message> map = new HashMap<String, Message>();
                cursor = db.rawQuery(sql.toString(), null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        Message message = new Message();
                        ChatDataHelper.setMsgValue(cursor, message);
                        map.put(message.getChatRoomJid(), message);
                    } while (cursor.moveToNext());
                }
                hashMap = map;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Message findLastMsg(Context ctx, String chatRoomId, long timestamp) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findLastMsg....chatRoomId:" + chatRoomId + ", timestamp:" + timestamp);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block6: {
                Message message2;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    String additionalCond = "";
                    boolean isShowMeetme = PreferencesUtil.isMeetmeShowEnabled(ctx, chatRoomId);
                    if (!isShowMeetme) {
                        additionalCond = " AND msg_type not in (231,232,233,234)";
                    }
                    if ((cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgSelectColumns, "chatRoomId = ? AND serverTime > ? AND isRecalled = 0 " + additionalCond, new String[]{chatRoomId, String.valueOf(timestamp)}, null, null, "serverTime DESC", "1")) == null || !cursor.moveToFirst()) break block6;
                    Message message = new Message();
                    ChatDataHelper.setMsgValue(cursor, message);
                    message2 = message;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return message2;
            }
            Message message = null;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSendingMsgsAsError(Context ctx) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateSendingMsgsAsError....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("status", "UPLOAD_FAILED");
                db.update(TABLE_MESSAGE, values, "status = ?", new String[]{"UPLOADING"});
                ContentValues values2 = new ContentValues();
                values2.put("status", "E");
                db.update(TABLE_MESSAGE, values2, "status = ?", new String[]{"UPLOAD_SUCCEED"});
                ContentValues values3 = new ContentValues();
                values3.put("status", "E");
                db.update(TABLE_MESSAGE, values3, "status = ?", new String[]{"N"});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Message getMsg(Context ctx, long msgId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "getMsg...." + msgId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                Message message2;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgSelectColumns, "id=?", new String[]{String.valueOf(msgId)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    Message message = new Message();
                    ChatDataHelper.setMsgValue(cursor, message);
                    message2 = message;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return message2;
            }
            Message message = null;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MessageHeader findNextNoPlayedAudioMsg(Context ctx, String chatRoomId, long msgTimestamp, String myJid) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findNextNoPlayedAudioMsg....msgTimestamp:" + msgTimestamp);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                MessageHeader messageHeader;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgHeaderSelectColumns, "chatRoomId=? AND serverTime > ? AND msg_type in (1,6) AND fromJid != ?", new String[]{chatRoomId, String.valueOf(msgTimestamp), myJid}, null, null, null, "1");
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    MessageHeader message = new MessageHeader();
                    ChatDataHelper.setMsgValue(cursor, message);
                    messageHeader = message;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return messageHeader;
            }
            MessageHeader messageHeader = null;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return messageHeader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Message findNextToPlayImageMsg(Context ctx, String chatRoomId, long msgTimestamp, long currentMsgId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findNextToPlayImageMsg....msgTimestamp:" + msgTimestamp);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                Message message2;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgSelectColumns, "chatRoomId=? AND serverTime >= ? AND msg_type in (5) AND id != ? AND isRecalled = 0 ", new String[]{chatRoomId, String.valueOf(msgTimestamp), String.valueOf(currentMsgId)}, null, null, "serverTime ASC", "1");
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    Message message = new Message();
                    ChatDataHelper.setMsgValue(cursor, message);
                    message2 = message;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return message2;
            }
            Message message = null;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Message findPrevToPlayImageMsg(Context ctx, String chatRoomId, long msgTimestamp, long currentMsgId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findNextToPlayImageMsg....msgTimestamp:" + msgTimestamp);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                Message message2;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgSelectColumns, "chatRoomId=? AND serverTime <= ? AND msg_type in (5) AND id != ? AND isRecalled = 0 ", new String[]{chatRoomId, String.valueOf(msgTimestamp), String.valueOf(currentMsgId)}, null, null, "serverTime DESC", "1");
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    Message message = new Message();
                    ChatDataHelper.setMsgValue(cursor, message);
                    message2 = message;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return message2;
            }
            Message message = null;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Message findMsgByPacketId(Context ctx, String packetId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findMsg....findMsgByPacketId:" + packetId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                Message message2;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgSelectColumns, "chatMsgId =?", new String[]{packetId}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    Message message = new Message();
                    ChatDataHelper.setMsgValue(cursor, message);
                    message2 = message;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return message2;
            }
            Message message = null;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MessageHeader findMsgHeaderByPacketId(Context ctx, String packetId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findMsgHeaderByPacketId:" + packetId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                MessageHeader messageHeader;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgHeaderSelectColumns, "chatMsgId =?", new String[]{packetId}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    MessageHeader message = new MessageHeader();
                    ChatDataHelper.setMsgValue(cursor, message);
                    messageHeader = message;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return messageHeader;
            }
            MessageHeader messageHeader = null;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return messageHeader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Message> findSendingUploadingMsgByPacketIdList(Context ctx, List<String> packetIdList) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findSendingMsgByPacketIdList....packetIdList:" + String.valueOf(packetIdList));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<Message> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<Message> messageList = new ArrayList<Message>();
                cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgSelectColumns, "chatMsgId in (" + UCDBMessage.jidsStrToQueryStr(packetIdList) + ") AND status in ('UPLOADING','N')", null, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        Message message = new Message();
                        ChatDataHelper.setMsgValue(cursor, message);
                        messageList.add(message);
                    } while (cursor.moveToNext());
                }
                arrayList = messageList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Message findMsgByEventId(Context ctx, long eventId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findMsgByEventId....eventId:" + eventId);
        if (eventId <= 0L) {
            return null;
        }
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block6: {
                Message message2;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgSelectColumns, "chatEventId =? OR syncEventId =?", new String[]{String.valueOf(eventId), String.valueOf(eventId)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block6;
                    Message message = new Message();
                    ChatDataHelper.setMsgValue(cursor, message);
                    message2 = message;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return message2;
            }
            Message message = null;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return message;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MessageHeader> findMsgsBefore(Context ctx, String chatRoomId, long timestamp, Integer limit) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findMsgsBefore....chatRoomId:" + chatRoomId + " timestamp:" + timestamp);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<MessageHeader> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<MessageHeader> messageList = new ArrayList<MessageHeader>();
                String additionalCond = "";
                boolean isShowMeetme = PreferencesUtil.isMeetmeShowEnabled(ctx, chatRoomId);
                if (!isShowMeetme) {
                    additionalCond = " AND msg_type not in (231,232,233,234)";
                }
                if ((cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgHeaderSelectColumns, "chatRoomId = ? AND serverTime < ? AND isRecalled = 0 " + additionalCond, new String[]{chatRoomId, String.valueOf(timestamp)}, null, null, "serverTime DESC", limit != null ? String.valueOf(limit) : null)) != null && cursor.moveToFirst()) {
                    do {
                        MessageHeader message = new MessageHeader();
                        ChatDataHelper.setMsgValue(cursor, message);
                        messageList.add(message);
                    } while (cursor.moveToNext());
                }
                arrayList = messageList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MessageHeader> findMsgsAfter(Context ctx, String chatRoomId, long timestamp, Integer limit) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findMsgsAfter....chatRoomId:" + chatRoomId + " timestamp:" + timestamp);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<MessageHeader> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String additionalCond = "";
                boolean isShowMeetme = PreferencesUtil.isMeetmeShowEnabled(ctx, chatRoomId);
                if (!isShowMeetme) {
                    additionalCond = " AND msg_type not in (231,232,233,234)";
                }
                ArrayList<MessageHeader> messageList = new ArrayList<MessageHeader>();
                cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgHeaderSelectColumns, "chatRoomId = ? AND serverTime > ? AND isRecalled = 0 " + additionalCond, new String[]{chatRoomId, String.valueOf(timestamp)}, null, null, "serverTime ASC", limit != null ? String.valueOf(limit) : null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        MessageHeader message = new MessageHeader();
                        ChatDataHelper.setMsgValue(cursor, message);
                        messageList.add(message);
                    } while (cursor.moveToNext());
                }
                Collections.reverse(messageList);
                arrayList = messageList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> findMsgsEventIdList(Context ctx, String chatRoomId) {
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findMsgsEventIdList....chatRoomId:" + chatRoomId);
        UCDBHelper helper = UCDBHelper.getDB(ctx);
        HashSet<Long> eventIdSet = new HashSet<Long>();
        UCDBHelper uCDBHelper = helper;
        synchronized (uCDBHelper) {
            long eventId;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_MESSAGE, new String[]{"chatEventId"}, "chatRoomId=? AND chatEventId IS NOT NULL AND chatEventId > 0", new String[]{chatRoomId}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        if ((eventId = cursor.getLong(0)) == -1L) continue;
                        eventIdSet.add(eventId);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_MESSAGE, new String[]{"syncEventId"}, "chatRoomId=? AND syncEventId IS NOT NULL AND syncEventId > 0", new String[]{chatRoomId}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        eventId = cursor.getLong(0);
                        eventIdSet.add(eventId);
                    } while (cursor.moveToNext());
                }
            }
            finally {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
            }
        }
        return eventIdSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<MsgState> findAllMsgIds(Context ctx, Set<Long> eventIds) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findUnreadMsgIds....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            HashSet<MsgState> hashSet;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                HashSet<MsgState> messageList = new HashSet<MsgState>();
                cursor = db.query(TABLE_MESSAGE, new String[]{"chatEventId", "playstatus"}, "chatEventId in (" + UCDBMessage.jidsLongToQueryStr(eventIds) + ")", null, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        Long id = cursor.getLong(0);
                        Integer playStatus = cursor.getInt(1);
                        if (id <= 0L) continue;
                        MsgState stat = new MsgState();
                        stat.setId(id);
                        stat.setPlayStatus(playStatus);
                        messageList.add(stat);
                    } while (cursor.moveToNext());
                }
                hashSet = messageList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return hashSet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long[]> findUnreadMsgIds(Context ctx) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findUnreadMsgIds....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<Long[]> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<Long[]> messageList = new ArrayList<Long[]>();
                cursor = db.query(TABLE_MESSAGE, new String[]{"id", "chatEventId"}, "playstatus =? AND chatEventId IS NOT NULL AND chatEventId > 0", new String[]{"0"}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        Long[] xx = new Long[]{cursor.getLong(0), cursor.getLong(1)};
                        messageList.add(xx);
                    } while (cursor.moveToNext());
                }
                arrayList = messageList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long[]> findUnreadPhoneMsgIds(Context ctx, String myJid) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findUnreadPhoneMsgIds....");
        ArrayList<Long[]> messageList = new ArrayList<Long[]>();
        ArrayList<Integer> callTypeList = UCDBMessage.getCallTypeList();
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT M.id, M.chatEventId FROM ");
        sql.append(TABLE_MESSAGE);
        sql.append(" M, ");
        sql.append("ChatRoom");
        sql.append(" R WHERE M.");
        sql.append("chatRoomId");
        sql.append(" = R.");
        sql.append("chatRoomId");
        sql.append(" AND M.");
        sql.append("playstatus");
        sql.append(" = ? AND M.");
        sql.append("fromJid");
        sql.append(" != ? AND R.");
        sql.append("type");
        sql.append(" = ");
        sql.append(3);
        sql.append(" AND M.");
        sql.append("msg_type IN (");
        for (int i = 0; i < callTypeList.size(); ++i) {
            int typeToHide = callTypeList.get(i);
            if (i != 0) {
                sql.append(",");
            }
            sql.append(typeToHide);
        }
        sql.append(") AND M.");
        sql.append("chatEventId IS NOT NULL AND M.chatEventId > 0");
        String[] selectionArgs = new String[]{"0", myJid};
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<Long[]> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                cursor = db.rawQuery(sql.toString(), selectionArgs);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        Long[] xx = new Long[]{cursor.getLong(0), cursor.getLong(1)};
                        messageList.add(xx);
                    } while (cursor.moveToNext());
                }
                arrayList = messageList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long[]> findUnreadMsgIds(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findUnreadMsgIds....chatRoomId:" + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<Long[]> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<Long[]> messageList = new ArrayList<Long[]>();
                cursor = db.query(TABLE_MESSAGE, new String[]{"id", "chatEventId"}, "chatRoomId=? AND playstatus=? AND chatEventId IS NOT NULL AND chatEventId > 0", new String[]{chatRoomId, "0"}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        Long[] xx = new Long[]{cursor.getLong(0), cursor.getLong(1)};
                        messageList.add(xx);
                    } while (cursor.moveToNext());
                }
                arrayList = messageList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Message> findUnreadVociemailMsgIds(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findUnreadVocieMsgIds....chatRoomId:" + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<Message> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<Message> messageList = new ArrayList<Message>();
                cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgSelectColumns, "chatRoomId=? AND playstatus=? AND msg_type in (12,1005)", new String[]{chatRoomId, "0"}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        Message message = new Message();
                        ChatDataHelper.setMsgValue(cursor, message);
                        messageList.add(message);
                    } while (cursor.moveToNext());
                }
                arrayList = messageList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Long> findAllMsgIds(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findAllMsgIds....chatRoomId:" + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<Long> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<Long> messageList = new ArrayList<Long>();
                cursor = db.query(TABLE_MESSAGE, new String[]{"id"}, "chatRoomId=?", new String[]{chatRoomId}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        messageList.add(cursor.getLong(0));
                    } while (cursor.moveToNext());
                }
                arrayList = messageList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Message> findUnreadPersonalRecordMsgIds(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findUnreadRecordMsgIds....chatRoomId:" + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<Message> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<Message> messageList = new ArrayList<Message>();
                cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgSelectColumns, "chatRoomId=? AND playstatus=? AND msg_type in (13,1006)", new String[]{chatRoomId, "0"}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        Message message = new Message();
                        ChatDataHelper.setMsgValue(cursor, message);
                        messageList.add(message);
                    } while (cursor.moveToNext());
                }
                arrayList = messageList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MessageHeader> findMsgsInit(Context ctx, String chatRoomId, int limit) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findMsgsInit....chatRoomId:" + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<MessageHeader> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<MessageHeader> messageList = new ArrayList<MessageHeader>();
                String additionalCond = "";
                boolean isShowMeetme = PreferencesUtil.isMeetmeShowEnabled(ctx, chatRoomId);
                if (!isShowMeetme) {
                    additionalCond = " AND msg_type not in (231,232,233,234)";
                }
                if ((cursor = db.query(TABLE_MESSAGE, ChatDataHelper.msgHeaderSelectColumns, "chatRoomId = ? ANd isRecalled = 0 " + additionalCond, new String[]{chatRoomId}, null, null, "serverTime DESC", String.valueOf(limit))) != null && cursor.moveToFirst()) {
                    do {
                        MessageHeader message = new MessageHeader();
                        ChatDataHelper.setMsgValue(cursor, message);
                        messageList.add(message);
                    } while (cursor.moveToNext());
                }
                arrayList = messageList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<MsgKey> findMediaMsgIds(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findMediaMsgIds....chatRoomId:" + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<MsgKey> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<MsgKey> messageList = new ArrayList<MsgKey>();
                cursor = db.query(TABLE_MESSAGE, new String[]{"id"}, "chatRoomId =? AND msg_type =?", new String[]{chatRoomId, String.valueOf(5)}, null, null, "serverTime ASC");
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        messageList.add(new MsgKey(0, cursor.getLong(0)));
                    } while (cursor.moveToNext());
                }
                arrayList = messageList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatRoomMsgReadStatus(Context ctx, long msgId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateChatRoomMsgReadStatus...." + msgId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = ChatDataHelper.createUpdateMsgReadValues();
                db.update(TABLE_MESSAGE, values, "id=?", new String[]{String.valueOf(msgId)});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatRoomMsgReadStatus(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateChatRoomMsgReadStatus...." + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = ChatDataHelper.createUpdateMsgReadValues();
                db.update(TABLE_MESSAGE, values, "chatRoomId=? AND playstatus=?", new String[]{chatRoomId, "0"});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatRoomMsgReadStatusByChatEventId(Context ctx, long eventId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateChatRoomMsgReadStatusByChatEventId...." + eventId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = ChatDataHelper.createUpdateMsgReadValues();
                db.update(TABLE_MESSAGE, values, "chatEventId=?", new String[]{String.valueOf(eventId)});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatRoomMsgPlayedStatusByChatEventId(Context ctx, long eventId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateChatRoomMsgPlayedStatusByChatEventId...." + eventId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = ChatDataHelper.createUpdateMsgPlayedValues();
                db.update(TABLE_MESSAGE, values, "chatEventId=?", new String[]{String.valueOf(eventId)});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatRoomMsgPlayedStatus(Context ctx, long msgId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateChatRoomMsgPlayedStatus...." + msgId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = ChatDataHelper.createUpdateMsgPlayedValues();
                db.update(TABLE_MESSAGE, values, "id=?", new String[]{String.valueOf(msgId)});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatRoomMsgReadPlayedStatusByPacketId(Context ctx, String packetId, boolean isRead, boolean isPlayed) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateChatRoomMsgReadPlayedStatusByPacketId....packetId:" + packetId + ", isPlayed:" + isPlayed);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = ChatDataHelper.createUpdateMsgReadPlayedValues(isRead, isPlayed);
                db.update(TABLE_MESSAGE, values, "chatMsgId=?", new String[]{String.valueOf(packetId)});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recallChatRoomMsg(Context ctx, String packetId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "recallChatRoomMsg...." + packetId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = ChatDataHelper.createUpdateMsgRecalledValues();
                db.update(TABLE_MESSAGE, values, "chatMsgId=?", new String[]{String.valueOf(packetId)});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateChatMsgType(Context ctx, String packetId, int msgType) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "updateChatMsgType...." + packetId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("msg_type", msgType);
                db.update(TABLE_MESSAGE, values, "chatMsgId=?", new String[]{String.valueOf(packetId)});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> findMsgUrlList(Context ctx, String roomJid) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findMsgUrlList....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<String[]> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<String[]> urlList = new ArrayList<String[]>();
                cursor = db.query(TABLE_MESSAGE, new String[]{"fileDownloadURL", "fileName"}, "chatRoomId = ? and msg_type IN (4,5,2,11) and fileDownloadURL IS NOT NULL", new String[]{roomJid}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String[] result = new String[]{cursor.getString(0), cursor.getString(1)};
                        urlList.add(result);
                    } while (cursor.moveToNext());
                }
                arrayList = urlList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String[]> findMsgUrlList(Context ctx, String roomJid, long timestamp) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findMsgUrlList....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<String[]> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<String[]> urlList = new ArrayList<String[]>();
                cursor = db.query(TABLE_MESSAGE, new String[]{"fileDownloadURL", "fileName"}, "chatRoomId = ? and msg_type IN (4,5,2,11) and fileDownloadURL IS NOT NULL and serverTime <= ?", new String[]{roomJid, String.valueOf(timestamp)}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        String[] result = new String[]{cursor.getString(0), cursor.getString(1)};
                        urlList.add(result);
                    } while (cursor.moveToNext());
                }
                arrayList = urlList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] findMsgUrlListByMsgId(Context ctx, long msgId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findMsgUrlListByMsgId....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                String[] stringArray;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_MESSAGE, new String[]{"fileDownloadURL", "fileName"}, "id = ? and msg_type IN (4,5,2,11) and fileDownloadURL IS NOT NULL ", new String[]{String.valueOf(msgId)}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    String[] result = new String[]{cursor.getString(0), cursor.getString(1)};
                    stringArray = result;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return stringArray;
            }
            String[] stringArray = null;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] findMsgUrlListPacketId(Context ctx, String packetId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "findMsgUrlListPacketId....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                String[] stringArray;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_MESSAGE, new String[]{"fileDownloadURL", "fileName"}, "chatMsgId = ? and msg_type IN (4,5,2,11) and fileDownloadURL IS NOT NULL ", new String[]{packetId}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    String[] result = new String[]{cursor.getString(0), cursor.getString(1)};
                    stringArray = result;
                }
                catch (Throwable throwable) {
                    UCDBMessage.closeCursor(cursor);
                    UCDBMessage.closeDb(db);
                    throw throwable;
                }
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                return stringArray;
            }
            String[] stringArray = null;
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMessages(Context ctx, String chatRoomId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "deleteMessages...." + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_MESSAGE, "chatRoomId = ?", new String[]{chatRoomId});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMessages(Context ctx, String chatRoomId, long timestamp) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "deleteMessages...." + chatRoomId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_MESSAGE, "chatRoomId = ? AND serverTime <= ?", new String[]{chatRoomId, String.valueOf(timestamp)});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllMessages(Context ctx) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "deleteAllMessages....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_MESSAGE, null, null);
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteChatRoomMsg(Context ctx, String packetId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "deleteChatRoomMsg...." + packetId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_MESSAGE, "chatMsgId=?", new String[]{packetId});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteMessage(Context ctx, Long msgId) {
        UCDBHelper helper;
        UCDBMessage._log(UCDBMessage.class.getSimpleName(), "deleteMessage...." + msgId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_MESSAGE, "id = ?", new String[]{String.valueOf(msgId)});
            }
            finally {
                UCDBMessage.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> findPosition(Context ctx, String searchCond) {
        UCDBHelper helper;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            HashMap<String, Integer> hashMap;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                int length = searchCond.length();
                String sql = "WITH RECURSIVE Positions (id,chatRoomId,content, position, depth) AS (  SELECT m.id, m.chatRoomId, m.content, INSTR(m.content, ?), 1   FROM Message m  WHERE INSTR(m.content, ?) > 0 and m.msg_type=?  UNION ALL  SELECT p.id, p.chatRoomId, p.content, INSTR(SUBSTRING(p.content, p.position + " + length + "), ?) + p.position +" + length + "-1, p.depth + 1   FROM Positions p  WHERE INSTR(SUBSTRING(content, p.position + " + length + "), ?) > 0 and p.depth < 100 ) ";
                sql = sql + "SELECT chatRoomId, count(position) FROM Positions WHERE position > 0 GROUP BY chatRoomId";
                cursor = db.rawQuery(sql.toString(), new String[]{searchCond, searchCond, String.valueOf(0), searchCond, searchCond});
                HashMap<String, Integer> countMap = new HashMap<String, Integer>();
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        countMap.put(cursor.getString(0), cursor.getInt(1));
                    } while (cursor.moveToNext());
                }
                hashMap = countMap;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Integer> findContent(Context ctx, String searchCond) {
        UCDBHelper helper;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            HashMap<String, Integer> hashMap;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String sql = " SELECT chatRoomId, count(chatMsgId)  FROM Message WHERE " + UCDBMessage.getContentCond() + " GROUP BY chatRoomId";
                cursor = db.rawQuery(sql.toString(), new String[]{searchCond, searchCond, searchCond, searchCond, searchCond});
                HashMap<String, Integer> countMap = new HashMap<String, Integer>();
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        countMap.put(cursor.getString(0), cursor.getInt(1));
                    } while (cursor.moveToNext());
                }
                hashMap = countMap;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> findContent(Context ctx, String chatRoomJid, String searchCond) {
        UCDBHelper helper;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<String> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                String sql = " SELECT chatMsgId FROM Message WHERE " + UCDBMessage.getContentCond() + " AND chatRoomId = ? ORDER BY serverTime";
                cursor = db.rawQuery(sql.toString(), new String[]{searchCond, searchCond, searchCond, searchCond, searchCond, chatRoomJid});
                ArrayList<String> packetIdList = new ArrayList<String>();
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        packetIdList.add(cursor.getString(0));
                    } while (cursor.moveToNext());
                }
                arrayList = packetIdList;
            }
            catch (Throwable throwable) {
                UCDBMessage.closeCursor(cursor);
                UCDBMessage.closeDb(db);
                throw throwable;
            }
            UCDBMessage.closeCursor(cursor);
            UCDBMessage.closeDb(db);
            return arrayList;
        }
    }

    private static String getContentCond() {
        String cond1 = "INSTR(LOWER(content), LOWER(?)) > 0 AND msg_type = 0";
        String cond2 = "INSTR(LOWER(fileName), LOWER(?)) > 0 AND msg_type in (2,11)";
        String cond3 = "INSTR(LOWER(extraText), LOWER(?)) > 0 AND msg_type in (5,4,11)";
        String cond4 = "INSTR(LOWER(content), LOWER(?)) > 0 AND msg_type in (8,9)";
        String cond5 = "INSTR(LOWER(title), LOWER(?)) > 0 AND msg_type in (8,9)";
        return "isRecalled = 0 and (" + cond1 + " or " + cond2 + " or " + cond3 + " or " + cond4 + " or " + cond5 + ")";
    }
}

