/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.bean.RemoteMark;
import com.blisscloud.mobile.ezuc.db.RemoteMarkDBConst;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import java.util.ArrayList;
import java.util.List;

public class UCDBRemoteMark
extends UCDBBase {
    public static final String TABLE_REMOTE_MARK = "RemoteMark";
    public static final int TYPE_BULLETIN = 0;
    public static final int TYPE_PERSONAL_RECORD_READ = 1;
    public static final int TYPE_VOICE_MESSAGE_READ = 2;
    public static final int TYPE_CHAT_EVENT_READ = 3;
    public static final int TYPE_MARK_EVENT = 4;
    public static final int TYPE_UNMARK_EVENT = 5;
    public static final int TYPE_DELETE_ROOM_JID_EVENT = 6;
    public static final int TYPE_DELETE_USER_JID_EVENT = 7;
    public static final int TYPE_DELETE_EVENT_ID_EVENT = 8;
    public static final int TYPE_CHAT_EVENT_PLAYED = 9;
    public static final int TYPE_PERSONAL_RECORD_DELETED = 10;
    public static final int TYPE_VOICE_MESSAGE_DELETED = 11;
    public static final int TYPE_SYNC_CHATROOM_INFO = 12;
    public static final int TYPE_FAX_DOC_READ = 13;
    public static final int TYPE_FAX_DOC_DELETED = 14;

    public static void createRemoteMarkTable(SQLiteDatabase db) {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ");
        sql.append(TABLE_REMOTE_MARK);
        sql.append("(");
        sql.append("type");
        sql.append(" INTEGER,");
        sql.append("id");
        sql.append(" NUMERIC,");
        sql.append("strId");
        sql.append(" LONGVARCHAR,");
        sql.append("status");
        sql.append(" INTEGER ");
        sql.append(")");
        db.execSQL(sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRemoteMark(Context ctx, int type, long id) {
        UCDBHelper helper;
        UCDBRemoteMark._log(UCDBRemoteMark.class.getSimpleName(), "addRemoteMark....(" + type + "," + id + ")");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("type", type);
                values.put("id", id);
                values.put("status", 1);
                db.insert(TABLE_REMOTE_MARK, null, values);
            }
            finally {
                UCDBRemoteMark.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRemoteMark(Context ctx, int type, String strId) {
        UCDBHelper helper;
        UCDBRemoteMark._log(UCDBRemoteMark.class.getSimpleName(), "addRemoteMark....(" + type + "," + strId + ")");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("type", type);
                values.put("strId", strId);
                values.put("status", 1);
                db.insert(TABLE_REMOTE_MARK, null, values);
            }
            finally {
                UCDBRemoteMark.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRemoteMark(Context ctx, int type, long id) {
        UCDBHelper helper;
        UCDBRemoteMark._log(UCDBRemoteMark.class.getSimpleName(), "deleteItem....(" + type + "," + id + ")");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_REMOTE_MARK, "type = ? and id = ? ", new String[]{String.valueOf(type), String.valueOf(id)});
            }
            finally {
                UCDBRemoteMark.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteRemoteMark(Context ctx, int type, String strId) {
        UCDBHelper helper;
        UCDBRemoteMark._log(UCDBRemoteMark.class.getSimpleName(), "deleteItem....(" + type + "," + strId + ")");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_REMOTE_MARK, "type = ? and strId = ? ", new String[]{String.valueOf(type), strId});
            }
            finally {
                UCDBRemoteMark.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<RemoteMark> getRemoteMarkNotFinishList(Context ctx, int type) {
        UCDBHelper helper;
        UCDBRemoteMark._log(UCDBRemoteMark.class.getSimpleName(), "getRemoteMarkNotFinishList....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            Cursor cursor = null;
            ArrayList<RemoteMark> remoteMarkList = new ArrayList<RemoteMark>();
            try {
                db = helper.getReadableDatabase();
                cursor = db.query(TABLE_REMOTE_MARK, RemoteMarkDBConst.selectColumns, "status=? and type=?", new String[]{String.valueOf(1), String.valueOf(type)}, null, null, null, null);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        RemoteMark item = new RemoteMark();
                        RemoteMarkDBConst.setRemoteMarkValue(cursor, item);
                        remoteMarkList.add(item);
                    } while (cursor.moveToNext());
                }
            }
            catch (Throwable throwable) {
                UCDBRemoteMark.closeCursor(cursor);
                UCDBRemoteMark.closeDb(db);
                throw throwable;
            }
            UCDBRemoteMark.closeCursor(cursor);
            UCDBRemoteMark.closeDb(db);
            return remoteMarkList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllRemoteMarks(Context ctx) {
        UCDBHelper helper;
        UCDBRemoteMark._log(UCDBRemoteMark.class.getSimpleName(), "deleteAllRemoteMarks....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_REMOTE_MARK, null, null);
            }
            finally {
                UCDBRemoteMark.closeDb(db);
            }
        }
    }

    public static void addSyncChatRoomRemoteMark(Context ctx, String strId) {
        UCDBRemoteMark.addRemoteMark(ctx, 12, strId);
    }

    public static void deleteSyncChatRoomRemoteMark(Context ctx, String strId) {
        UCDBRemoteMark.deleteRemoteMark(ctx, 12, strId);
    }

    public static List<RemoteMark> getSyncChatRoomRemoteMarkList(Context ctx) {
        return UCDBRemoteMark.getRemoteMarkNotFinishList(ctx, 12);
    }
}

