/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.client.bean.SysSummaryItem;
import com.blisscloud.ezuc.client.customer.CustomerNameUtil;
import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import com.blisscloud.mobile.ezuc.db.UCDBRecording;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class UCDBSummary
extends UCDBBase {
    public static final String TABLE_CONTACT_SUMMARY_DOC = "ContactSummary";
    public static final String KEY_CONTACT_LOG_ID = "contactLogId";
    public static final String KEY_UNIQUE_ID = "uniqueId";
    public static final String KEY_CATEGORY_ID = "categoryId";
    public static final String KEY_OUTCOME_ID = "outcomeId";
    public static final String KEY_CATEGORY_IDS = "categoryIds";
    public static final String KEY_OUTCOME_IDS = "outcomeIds";
    public static final String KEY_NOTE = "note";
    public static final String KEY_APP_ID = "appId";
    public static final String KEY_CUSTOMER_ID = "customerId";
    public static final String KEY_CUSTOMER_NAME = "customerName";
    public static final String KEY_CUSTOMER_NO = "customerNo";
    public static final String KEY_TIMESTAMP = "timestamp";
    public static final String[] selectColumnsOld = new String[]{"contactLogId", "uniqueId", "categoryId", "outcomeId", "categoryIds", "outcomeIds", "note", "customerId", "customerName", "customerNo", "timestamp"};
    public static final String[] selectColumns = new String[]{"contactLogId", "uniqueId", "categoryIds", "outcomeIds", "note", "appId", "customerId", "customerName", "customerNo", "timestamp"};

    public static void createSummaryTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS ContactSummary");
        String CREATE_TABLE_SQL = "CREATE TABLE ContactSummary(contactLogId INTEGER PRIMARY KEY IDENTITY, uniqueId LONGVARCHAR, categoryIds LONGVARCHAR, outcomeIds LONGVARCHAR, appId INTEGER, note LONGVARCHAR, customerId INTEGER, customerName LONGVARCHAR, customerNo LONGVARCHAR, timestamp NUMERIC)";
        db.execSQL(CREATE_TABLE_SQL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSummary(Context ctx, JSONObject contactSummaryObj) {
        UCDBHelper helper;
        UCDBSummary._log(UCDBSummary.class.getSimpleName(), "addSummary");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.insert(TABLE_CONTACT_SUMMARY_DOC, null, UCDBSummary.createContentValues(contactSummaryObj));
            }
            catch (Throwable e) {
                Log.w(UCDBSummary.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
            finally {
                UCDBSummary.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSummary(Context ctx, Long contactLogId, JSONObject contactSummaryObj) {
        UCDBHelper helper;
        UCDBSummary._log(UCDBRecording.class.getSimpleName(), "updateSummary");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.update(TABLE_CONTACT_SUMMARY_DOC, UCDBSummary.createContentValues(contactSummaryObj), "contactLogId = ?", new String[]{String.valueOf(contactLogId)});
            }
            catch (Throwable e) {
                Log.w(UCDBRecording.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
            }
            finally {
                UCDBSummary.closeDb(db);
            }
        }
    }

    public static ContentValues createContentValues(JSONObject contactSummaryObj) throws JSONException {
        String ids;
        ContentValues values = new ContentValues();
        values.put(KEY_CONTACT_LOG_ID, contactSummaryObj.getLong("id"));
        values.put(KEY_UNIQUE_ID, contactSummaryObj.getString(KEY_UNIQUE_ID));
        if (contactSummaryObj.has("summaryCategoryIds")) {
            ids = contactSummaryObj.getString("summaryCategoryIds");
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                values.put(KEY_CATEGORY_IDS, "," + ids + ",");
            } else {
                values.put(KEY_CATEGORY_IDS, "");
            }
        } else if (contactSummaryObj.has("summaryCategory")) {
            ids = String.valueOf(contactSummaryObj.getLong("summaryCategory"));
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                values.put(KEY_CATEGORY_IDS, "," + ids + ",");
            } else {
                values.put(KEY_CATEGORY_IDS, "");
            }
        }
        if (contactSummaryObj.has("summaryOutcomeIds")) {
            ids = contactSummaryObj.getString("summaryOutcomeIds");
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                values.put(KEY_OUTCOME_IDS, "," + ids + ",");
            } else {
                values.put(KEY_OUTCOME_IDS, "");
            }
        } else if (contactSummaryObj.has("summaryOutcome")) {
            ids = String.valueOf(contactSummaryObj.getLong("summaryOutcome"));
            if (StringUtils.isNotBlank((CharSequence)ids)) {
                values.put(KEY_OUTCOME_IDS, "," + ids + ",");
            } else {
                values.put(KEY_OUTCOME_IDS, "");
            }
        }
        values.put(KEY_NOTE, contactSummaryObj.getString("summaryNote"));
        if (contactSummaryObj.has(KEY_APP_ID)) {
            values.put(KEY_APP_ID, contactSummaryObj.getLong(KEY_APP_ID));
        }
        values.put(KEY_TIMESTAMP, contactSummaryObj.getLong("summaryLastUpdateTime"));
        if (contactSummaryObj.has(KEY_CUSTOMER_ID)) {
            Long customerId = contactSummaryObj.getLong(KEY_CUSTOMER_ID);
            if (customerId > 0L) {
                values.put(KEY_CUSTOMER_ID, customerId);
                String lastName = null;
                String otherName = null;
                String firstName = null;
                String customerNo = null;
                if (contactSummaryObj.has("customerLastName")) {
                    lastName = contactSummaryObj.getString("customerLastName");
                }
                if (contactSummaryObj.has("customerOtherName")) {
                    otherName = contactSummaryObj.getString("customerOtherName");
                }
                if (contactSummaryObj.has("customerFirstName")) {
                    firstName = contactSummaryObj.getString("customerFirstName");
                }
                if (contactSummaryObj.has(KEY_CUSTOMER_NO)) {
                    customerNo = contactSummaryObj.getString(KEY_CUSTOMER_NO);
                }
                String name = UCDBSummary.getName(lastName, otherName, firstName);
                values.put(KEY_CUSTOMER_NAME, name);
                values.put(KEY_CUSTOMER_NO, customerNo);
            } else {
                String customerIdStr = null;
                String customerName = null;
                String customerNo = null;
                values.put(KEY_CUSTOMER_ID, customerIdStr);
                values.put(KEY_CUSTOMER_NAME, customerName);
                values.put(KEY_CUSTOMER_NO, customerNo);
            }
        }
        return values;
    }

    public static String getName(String lastName, String otherName, String firstName) {
        return CustomerNameUtil.getCustomerName(null, lastName, otherName, firstName, false);
    }

    public static boolean containsHanScript(String s) {
        int codepoint;
        for (int i = 0; i < s.length(); i += Character.charCount(codepoint)) {
            codepoint = s.codePointAt(i);
            if (Character.UnicodeScript.of(codepoint) != Character.UnicodeScript.HAN) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SysSummaryItem getSummaryItemById(Context ctx, Long contactLogId) {
        UCDBHelper helper;
        UCDBSummary._log(UCDBSummary.class.getSimpleName(), "getSummaryItemById....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                SysSummaryItem sysSummaryItem;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    cursor = db.query(TABLE_CONTACT_SUMMARY_DOC, selectColumns, "contactLogId=?", new String[]{contactLogId.toString()}, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    SysSummaryItem item = new SysSummaryItem();
                    UCDBSummary.setSummaryValue(cursor, item);
                    sysSummaryItem = item;
                }
                catch (Throwable throwable) {
                    UCDBSummary.closeCursor(cursor);
                    UCDBSummary.closeDb(db);
                    throw throwable;
                }
                UCDBSummary.closeCursor(cursor);
                UCDBSummary.closeDb(db);
                return sysSummaryItem;
            }
            SysSummaryItem sysSummaryItem = null;
            UCDBSummary.closeCursor(cursor);
            UCDBSummary.closeDb(db);
            return sysSummaryItem;
        }
    }

    public static void setSummaryValueOld(Cursor cursor, SysSummaryItem item) {
        item.setId(cursor.getLong(0));
        item.setUniqueId(cursor.getString(1));
        item.setSummaryCategory(cursor.getLong(2));
        item.setSummaryOutcome(cursor.getLong(3));
        item.setSummaryCategoryIds(cursor.getString(4));
        item.setSummaryOutcomeIds(cursor.getString(5));
        item.setSummaryNote(cursor.getString(6));
        item.setCustomerId(cursor.getLong(7));
        item.setCustomerName(cursor.getString(8));
        item.setCustomerNo(cursor.getString(9));
        item.setSummaryLastUpdateTime(cursor.getLong(10));
    }

    public static void setSummaryValue(Cursor cursor, SysSummaryItem item) {
        item.setId(cursor.getLong(0));
        item.setUniqueId(cursor.getString(1));
        item.setSummaryCategoryIds(cursor.getString(2));
        item.setSummaryOutcomeIds(cursor.getString(3));
        item.setSummaryNote(cursor.getString(4));
        item.setAppId(cursor.getLong(5));
        item.setCustomerId(cursor.getLong(6));
        item.setCustomerName(cursor.getString(7));
        item.setCustomerNo(cursor.getString(8));
        item.setSummaryLastUpdateTime(cursor.getLong(9));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllSummaryItems(Context ctx) {
        UCDBHelper helper;
        UCDBSummary._log(UCDBSummary.class.getSimpleName(), "deleteAllSummaryItems....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_CONTACT_SUMMARY_DOC, null, null);
            }
            finally {
                UCDBSummary.closeDb(db);
            }
        }
    }
}

