/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.db;

import com.blisscloud.ezuc.client.util.simulate.ContentValues;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Cursor;
import com.blisscloud.ezuc.client.util.simulate.DatabaseUtils;
import com.blisscloud.ezuc.client.util.simulate.sqlite.SQLiteDatabase;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.db.ContactDataHelper;
import com.blisscloud.mobile.ezuc.db.UCDBBase;
import com.blisscloud.mobile.ezuc.db.UCDBHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class UCDBVoiceMsg
extends UCDBBase {
    public static final String TABLE_VOICE = "VoiceMessage";
    public static String[] voiceSelectColumns = new String[]{"id", "callerType", "startTime", "endTime", "callerDbId", "listen", "read", "callerIdName", "callerIdNumber", "callerSite", "type", "url", "chatPocketId", "outboundTrunk"};

    public static void createVoiceTable(SQLiteDatabase db) {
        db.execSQL("DROP TABLE IF EXISTS VoiceMessage");
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE ");
        sql.append(TABLE_VOICE);
        sql.append("(");
        sql.append("id");
        sql.append(" LONGVARCHAR,");
        sql.append("callerType");
        sql.append(" LONGVARCHAR,");
        sql.append("startTime");
        sql.append(" NUMERIC,");
        sql.append("endTime");
        sql.append(" NUMERIC,");
        sql.append("callerDbId");
        sql.append(" LONGVARCHAR,");
        sql.append("listen");
        sql.append(" INTEGER DEFAULT 0,");
        sql.append("read");
        sql.append(" INTEGER DEFAULT 0,");
        sql.append("callerIdName");
        sql.append(" LONGVARCHAR,");
        sql.append("callerIdNumber");
        sql.append(" LONGVARCHAR,");
        sql.append("callerSite");
        sql.append(" LONGVARCHAR,");
        sql.append("type");
        sql.append(" LONGVARCHAR,");
        sql.append("url");
        sql.append(" LONGVARCHAR,");
        sql.append("chatPocketId");
        sql.append(" LONGVARCHAR,");
        sql.append("outboundTrunk");
        sql.append(" INTEGER DEFAULT 0)");
        db.execSQL(sql.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VoiceItem getVoiceItemByPacketId(Context ctx, String packetId) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "getVoiceItemByPacketId...." + packetId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db;
            Cursor cursor;
            block5: {
                VoiceItem voiceItem2;
                cursor = null;
                db = null;
                try {
                    db = helper.getReadableDatabase();
                    String whereClause = "chatPocketId=?";
                    String[] whereArgs = new String[]{String.valueOf(packetId)};
                    cursor = db.query(TABLE_VOICE, voiceSelectColumns, whereClause, whereArgs, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    VoiceItem voiceItem = new VoiceItem();
                    ContactDataHelper.setVoiceValue(cursor, voiceItem);
                    voiceItem2 = voiceItem;
                }
                catch (Throwable throwable) {
                    UCDBVoiceMsg.closeCursor(cursor);
                    UCDBVoiceMsg.closeDb(db);
                    throw throwable;
                }
                UCDBVoiceMsg.closeCursor(cursor);
                UCDBVoiceMsg.closeDb(db);
                return voiceItem2;
            }
            VoiceItem voiceItem = null;
            UCDBVoiceMsg.closeCursor(cursor);
            UCDBVoiceMsg.closeDb(db);
            return voiceItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VoiceItem getVoiceItem(Context ctx, Long id, int type) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "getVoiceItem...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            Cursor cursor;
            SQLiteDatabase db;
            block5: {
                VoiceItem voiceItem2;
                db = null;
                cursor = null;
                try {
                    db = helper.getReadableDatabase();
                    String whereClause = "id=? And type=?";
                    String[] whereArgs = new String[]{String.valueOf(id), String.valueOf(type)};
                    cursor = db.query(TABLE_VOICE, voiceSelectColumns, whereClause, whereArgs, null, null, null, null);
                    if (cursor == null || !cursor.moveToFirst()) break block5;
                    VoiceItem voiceItem = new VoiceItem();
                    ContactDataHelper.setVoiceValue(cursor, voiceItem);
                    voiceItem2 = voiceItem;
                }
                catch (Throwable throwable) {
                    UCDBVoiceMsg.closeCursor(cursor);
                    UCDBVoiceMsg.closeDb(db);
                    throw throwable;
                }
                UCDBVoiceMsg.closeCursor(cursor);
                UCDBVoiceMsg.closeDb(db);
                return voiceItem2;
            }
            VoiceItem voiceItem = null;
            UCDBVoiceMsg.closeCursor(cursor);
            UCDBVoiceMsg.closeDb(db);
            return voiceItem;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addVoiceItem(Context ctx, VoiceItem item) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "addVoiceItem....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.insert(TABLE_VOICE, null, ContactDataHelper.createVocieValues(item));
            }
            finally {
                UCDBVoiceMsg.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteVoiceItem(Context ctx, String ids, int type) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "deleteVoiceItem...." + ids + "," + type);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                HashSet<String> idset = new HashSet<String>();
                String[] idarray = ids.split(",");
                for (int i = 0; i < idarray.length; ++i) {
                    idset.add(idarray[i].trim());
                }
                String whereClause = "id IN ( " + UCDBVoiceMsg.jidsStrToQueryStr(idset) + " ) And type=?";
                String[] whereArgs = new String[]{String.valueOf(type)};
                db.delete(TABLE_VOICE, whereClause, whereArgs);
            }
            finally {
                UCDBVoiceMsg.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteVoiceItem(Context ctx, long id, int type) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "deleteVoiceItem...." + id + "," + type);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                String whereClause = "id=? And type=?";
                String[] whereArgs = new String[]{String.valueOf(id), String.valueOf(type)};
                db.delete(TABLE_VOICE, whereClause, whereArgs);
            }
            finally {
                UCDBVoiceMsg.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateVoiceItem(Context ctx, String ids, int type, boolean isRead, boolean isListen) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "updateVoiceItem...." + ids + "," + type + "," + isRead + "," + isListen);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                HashSet<String> idset = new HashSet<String>();
                String[] idarray = ids.split(",");
                for (int i = 0; i < idarray.length; ++i) {
                    idset.add(idarray[i].trim());
                }
                String whereClause = "id IN ( " + UCDBVoiceMsg.jidsStrToQueryStr(idset) + " ) And type=?";
                String[] whereArgs = new String[]{String.valueOf(type)};
                ContentValues values = null;
                values = new ContentValues();
                values.put("read", isRead ? 1 : 0);
                values.put("listen", isListen ? 1 : 0);
                db.update(TABLE_VOICE, values, whereClause, whereArgs);
            }
            finally {
                UCDBVoiceMsg.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getMaxVoiceRecordTimestamp(Context ctx) {
        UCDBHelper helper;
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            long l;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                StringBuilder sql = new StringBuilder();
                sql.append("SELECT MAX(startTime) FROM VoiceMessage");
                long maxTimestamp = -1L;
                cursor = db.rawQuery(sql.toString(), null);
                if (cursor != null && cursor.moveToFirst()) {
                    maxTimestamp = cursor.getLong(0);
                }
                l = maxTimestamp;
            }
            catch (Throwable throwable) {
                UCDBVoiceMsg.closeCursor(cursor);
                UCDBVoiceMsg.closeDb(db);
                throw throwable;
            }
            UCDBVoiceMsg.closeCursor(cursor);
            UCDBVoiceMsg.closeDb(db);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVoiceUnreadCount(Context ctx, int type) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "getVoiceUnreadCount....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            int n;
            SQLiteDatabase db = null;
            try {
                int count;
                db = helper.getReadableDatabase();
                String selection = "type =? And listen = ?";
                String[] selectionArgs = new String[]{String.valueOf(type), String.valueOf(0)};
                n = count = (int)DatabaseUtils.queryNumEntries(db, TABLE_VOICE, selection, selectionArgs);
            }
            catch (Throwable throwable) {
                UCDBVoiceMsg.closeDb(db);
                throw throwable;
            }
            UCDBVoiceMsg.closeDb(db);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVoiceUnreadCount(Context ctx) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "getVoiceUnreadCount....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            int n;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                String selection = "type in (0,1,2) And listen = ?";
                String[] selectionArgs = new String[]{String.valueOf(0)};
                n = (int)DatabaseUtils.queryNumEntries(db, TABLE_VOICE, selection, selectionArgs);
            }
            catch (Throwable throwable) {
                UCDBVoiceMsg.closeDb(db);
                throw throwable;
            }
            UCDBVoiceMsg.closeDb(db);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getVoiceUnreadCount(Context ctx, int type, long timestamp) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "getVoiceUnreadCount....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            int n;
            SQLiteDatabase db = null;
            try {
                db = helper.getReadableDatabase();
                String selection = "type =? And listen = ? And startTime> ?";
                String[] selectionArgs = new String[]{String.valueOf(type), String.valueOf(0), String.valueOf(timestamp)};
                n = (int)DatabaseUtils.queryNumEntries(db, TABLE_VOICE, selection, selectionArgs);
            }
            catch (Throwable throwable) {
                UCDBVoiceMsg.closeDb(db);
                throw throwable;
            }
            UCDBVoiceMsg.closeDb(db);
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<VoiceItem> getVoiceRecordList(Context ctx, int type) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "getVoiceRecordList...." + type);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<VoiceItem> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<VoiceItem> data = new ArrayList<VoiceItem>();
                String selection = "type=?";
                String[] selectionArgs = new String[]{String.valueOf(type)};
                String orderBy = "startTime DESC";
                cursor = db.query(TABLE_VOICE, null, selection, selectionArgs, null, null, orderBy);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        VoiceItem item = new VoiceItem();
                        ContactDataHelper.setVoiceValue(cursor, item);
                        data.add(item);
                    } while (cursor.moveToNext());
                }
                arrayList = data;
            }
            catch (Throwable throwable) {
                UCDBVoiceMsg.closeCursor(cursor);
                UCDBVoiceMsg.closeDb(db);
                throw throwable;
            }
            UCDBVoiceMsg.closeCursor(cursor);
            UCDBVoiceMsg.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<VoiceItem> getVoiceRecordList(Context ctx, int[] type) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "getVoiceRecordList...." + String.valueOf(type));
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            ArrayList<VoiceItem> arrayList;
            SQLiteDatabase db = null;
            Cursor cursor = null;
            try {
                db = helper.getReadableDatabase();
                ArrayList<VoiceItem> data = new ArrayList<VoiceItem>();
                String selection = "type in (" + UCDBVoiceMsg.prepareInSql(type) + ")";
                String orderBy = "startTime DESC";
                cursor = db.query(TABLE_VOICE, null, selection, null, null, null, orderBy);
                if (cursor != null && cursor.moveToFirst()) {
                    do {
                        VoiceItem item = new VoiceItem();
                        ContactDataHelper.setVoiceValue(cursor, item);
                        data.add(item);
                    } while (cursor.moveToNext());
                }
                arrayList = data;
            }
            catch (Throwable throwable) {
                UCDBVoiceMsg.closeCursor(cursor);
                UCDBVoiceMsg.closeDb(db);
                throw throwable;
            }
            UCDBVoiceMsg.closeCursor(cursor);
            UCDBVoiceMsg.closeDb(db);
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllVoiceData(Context ctx) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "deleteAllVoiceData....");
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_VOICE, null, null);
            }
            finally {
                UCDBVoiceMsg.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateVoiceMsgReadStatus(Context ctx, long id) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "updateVoiceMsgReadStatus...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("read", 1);
                db.update(TABLE_VOICE, values, "id=?", new String[]{String.valueOf(id)});
            }
            finally {
                UCDBVoiceMsg.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateVoiceMsgPlayedStatus(Context ctx, long id, String packetId) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "updateVoiceMsgPlayedStatus...." + id + ", " + packetId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                ContentValues values = new ContentValues();
                values.put("listen", 1);
                db.update(TABLE_VOICE, values, "id=? or chatPocketId=?", new String[]{String.valueOf(id), packetId});
            }
            finally {
                UCDBVoiceMsg.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteVoiceMsg(Context ctx, long id) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "deleteVoiceMsgPlayStatus...." + id);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_VOICE, "id=?", new String[]{String.valueOf(id)});
            }
            finally {
                UCDBVoiceMsg.closeDb(db);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteVoiceMsgByPacketId(Context ctx, String packetId) {
        UCDBHelper helper;
        UCDBVoiceMsg._log(UCDBVoiceMsg.class.getSimpleName(), "deleteVoiceMsgByPacketId...." + packetId);
        UCDBHelper uCDBHelper = helper = UCDBHelper.getDB(ctx);
        synchronized (uCDBHelper) {
            SQLiteDatabase db = null;
            try {
                db = helper.getWritableDatabase();
                db.delete(TABLE_VOICE, "chatPocketId=?", new String[]{packetId});
            }
            finally {
                UCDBVoiceMsg.closeDb(db);
            }
        }
    }
}

