/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ContactScope;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AddressBookScopeManager {
    public static synchronized void changeScope(Context context, JSONObject dataObj) {
        try {
            boolean isInit = PreferencesUtil.isAddressBookInit();
            if (isInit) {
                AddressBookScopeManager.handleInit(context, dataObj);
            } else {
                AddressBookScopeManager.handleUpdate(context, dataObj);
            }
            if (!PreferencesUtil.isAddressBookSyncDone(context)) {
                WebAgent.getInstance().reloadDirtyEmployeeList(-1L);
            } else {
                long timestamp = PreferencesUtil.getTimeStamp(context, "employee.getEmployeeList.TimeStamp.20200730");
                WebAgent.getInstance().getDirtyEmployeeListByPage(timestamp, -1L);
            }
        }
        catch (Exception e) {
            Log.e(AddressBookScopeManager.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    private static void setScope(Context context, JSONObject dataObj) throws JSONException {
        boolean isWholeCompany = dataObj.getBoolean("wholeCompany");
        HashSet<Long> scopeEmpSet = new HashSet<Long>();
        if (dataObj.has("scopeEmployeeIdList")) {
            JSONArray scopeListArray = dataObj.getJSONArray("scopeEmployeeIdList");
            for (int i = 0; scopeListArray != null && i < scopeListArray.length(); ++i) {
                scopeEmpSet.add(scopeListArray.getLong(i));
            }
        }
        HashSet<Long> extraEmpSet = new HashSet<Long>();
        if (dataObj.has("extraEmployeeIdList")) {
            JSONArray extraListArray = dataObj.getJSONArray("extraEmployeeIdList");
            for (int i = 0; extraListArray != null && i < extraListArray.length(); ++i) {
                extraEmpSet.add(extraListArray.getLong(i));
            }
        }
        PreferencesUtil.setAddressBookScopeWholeCompany(context, isWholeCompany);
        PreferencesUtil.setAddressBookScopeEmpList(context, scopeEmpSet);
        PreferencesUtil.setAddressBookExtraEmpList(context, extraEmpSet);
    }

    private static void handleInit(Context context, JSONObject dataObj) throws JSONException {
        long addressBookUpdateTime = dataObj.getLong("addressBookUpdateTime");
        AddressBookScopeManager.setScope(context, dataObj);
        PreferencesUtil.setTimeStamp(context, "ADDRESSBOOK_SCOPE_SAVED_TIMESTAMP", addressBookUpdateTime);
    }

    private static void handleUpdate(Context context, JSONObject dataObj) throws JSONException {
        long addressBookUpdateTime = dataObj.getLong("addressBookUpdateTime");
        long oldTimestamp = PreferencesUtil.getTimeStamp(context, "ADDRESSBOOK_SCOPE_SAVED_TIMESTAMP");
        if (oldTimestamp >= addressBookUpdateTime) {
            return;
        }
        boolean oldIsWholeCompany = PreferencesUtil.isAddressBookScopeWholeCompany(context);
        AddressBookScopeManager.setScope(context, dataObj);
        boolean isWholeCompany = PreferencesUtil.isAddressBookScopeWholeCompany(context);
        Set<Long> scopeEmpSet = PreferencesUtil.getAddressBookScopeEmpList(context);
        Set<Long> extraEmpSet = PreferencesUtil.getAddressBookExtraEmpList(context);
        if (isWholeCompany) {
            if (!oldIsWholeCompany) {
                PreferencesUtil.setAddressBookSyncUndone(context);
                PreferencesUtil.setTimeStamp(context, "employee.getEmployeeList.TimeStamp.20200730", -1L);
            }
        } else {
            List<ContactScope> existEmpsList = UCDBContact.findAllContactsIdList(context);
            HashSet<Long> currentEmpInScopeSet = new HashSet<Long>();
            currentEmpInScopeSet.addAll(scopeEmpSet);
            currentEmpInScopeSet.addAll(extraEmpSet);
            HashSet<Long> toBeHideSet = new HashSet<Long>();
            for (ContactScope emp : existEmpsList) {
                toBeHideSet.add(emp.getEmployeeId());
            }
            toBeHideSet.removeAll(currentEmpInScopeSet);
            for (Long empId : toBeHideSet) {
                UCDBContact.updateContactScope(context, empId, 0);
            }
            BroadcastUtil.sendContactListChangedEvent(context, 0);
            PreferencesUtil.setAddressBookSyncUndone(context);
            PreferencesUtil.setTimeStamp(context, "employee.getEmployeeList.TimeStamp.20200730", -1L);
        }
        PreferencesUtil.setTimeStamp(context, "ADDRESSBOOK_SCOPE_SAVED_TIMESTAMP", addressBookUpdateTime);
    }
}

