/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.chat.RoomMember;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.bean.ActionNode;
import com.blisscloud.ezuc.client.bean.ExtenNode;
import com.blisscloud.ezuc.client.bean.ExtendedSysNode;
import com.blisscloud.ezuc.client.bean.Node;
import com.blisscloud.ezuc.client.phone.PhonePickerDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.LiteContactHelper;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.FileBean;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MessageHeader;
import com.blisscloud.mobile.ezuc.bean.MsgBean;
import com.blisscloud.mobile.ezuc.bean.NoticeBean;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.manager.DeletedContactManager;
import com.blisscloud.mobile.ezuc.manager.DialoutManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.task.ChatEventDownloadController;
import com.blisscloud.mobile.ezuc.manager.task.FetchEmpTaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.EmpExtendedSysPhoneConfig;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.Component;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.JFrame;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChatRoomManager {
    private static final String PATH_EMOTICON_V1_SMALL = "images/emoticon_v1_small/";
    private static final String PATH_EMOTICON_V1_LARGE = "images/emoticon_v1_large/";
    private static final String PATH_EMOTICON_V2_SMALL = "images/emoticon_v2_small/";
    private static final String PATH_EMOTICON_V2_LARGE = "images/emoticon_v2_large/";
    private static List<String> emoticonOldKeys;
    private static Properties emoticonOldPathMap;
    private static List<String> emoticonKeys;
    private static Properties emoticonPathMap;
    private static Properties emoticonLargeURLMap;
    private static Properties emoticonSmallURLMap;
    private static List<String> stickerKeys;
    private static Properties stickerPathMap;
    private static Properties stickerURLMap;
    private static List<String> idiomKeys;
    private static Properties idiomMap;
    private static List<String> symbolKeys;
    private static Properties symbolMap;
    private static Properties phoneIconPathMap;
    private static Properties phoneIconURLMap;
    private static Object chatRoomLock;
    private static Object chatRoomParticipantLock;

    public static List<String> getEmoticonKeys() {
        ArrayList<String> updateList = new ArrayList<String>();
        for (String x : emoticonKeys) {
            if (x.equals("[emo028]")) continue;
            updateList.add(x);
        }
        return updateList;
    }

    public static boolean isOldEmoticon(String emoticonKey) {
        return emoticonOldKeys.contains(emoticonKey);
    }

    public static String getEmoticonLargePath(String emoticonKey) {
        if (emoticonOldPathMap.containsKey(emoticonKey)) {
            return PATH_EMOTICON_V1_LARGE + emoticonOldPathMap.getProperty(emoticonKey);
        }
        if (emoticonPathMap.containsKey(emoticonKey)) {
            return PATH_EMOTICON_V2_LARGE + emoticonPathMap.getProperty(emoticonKey);
        }
        return null;
    }

    public static String getEmoticonSmallPath(String emoticonKey) {
        if (emoticonOldPathMap.containsKey(emoticonKey)) {
            return PATH_EMOTICON_V1_SMALL + emoticonOldPathMap.getProperty(emoticonKey);
        }
        if (emoticonPathMap.containsKey(emoticonKey)) {
            return PATH_EMOTICON_V2_SMALL + emoticonPathMap.getProperty(emoticonKey);
        }
        return null;
    }

    public static String getEmoticonLargeURL(String emoticonKey) {
        return emoticonLargeURLMap.getProperty(emoticonKey);
    }

    public static String getEmoticonSmallURL(String emoticonKey) {
        return emoticonSmallURLMap.getProperty(emoticonKey);
    }

    public static List<String> getStickerKeys() {
        return Collections.unmodifiableList(stickerKeys);
    }

    public static String getStickerPath(String stickerKey) {
        return stickerPathMap.getProperty(stickerKey);
    }

    public static String getStickerURL(String stickerKey) {
        return stickerURLMap.getProperty(stickerKey);
    }

    public static List<String> getIdiomKeys() {
        return Collections.unmodifiableList(idiomKeys);
    }

    public static String getIdiom(String idiomKey) {
        return idiomMap.getProperty(idiomKey);
    }

    public static List<String> getSymbolKeys() {
        return Collections.unmodifiableList(symbolKeys);
    }

    public static String getSymbol(String symbolKey) {
        return symbolMap.getProperty(symbolKey);
    }

    public static String getPhoneIconPath(String phoneKey) {
        return phoneIconPathMap.getProperty(phoneKey);
    }

    public static String getPhoneIconURL(String phoneKey) {
        return phoneIconURLMap.getProperty(phoneKey);
    }

    public static boolean nameExist(ChatRoomInfo chatRoomInfo) {
        return ChatRoomManager.validateName(chatRoomInfo.getSubject());
    }

    public static boolean isInMyFavorite(String jid) {
        if (JidUtil.isChatConfJid(jid)) {
            return ContactManager.isInMyFavorite(UCChatClient.context, jid, 3);
        }
        if (JidUtil.isEmployeeJid(jid)) {
            LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, jid);
            if (contact != null) {
                Long empId = ChatRoomManager.getEmpId(contact);
                String id = String.valueOf(empId);
                return ContactManager.isInMyFavorite(UCChatClient.context, id, 1);
            }
            return false;
        }
        return false;
    }

    public static boolean switchMyFavorite(String jid) {
        LiteContact contact;
        if (!WebAgent.isLogin) {
            ChatRoomManager.showUnableConnectAlert();
            return false;
        }
        boolean isInFavorite = ChatRoomManager.isInMyFavorite(jid);
        Activity ctx = UCChatClient.context;
        if (JidUtil.isChatConfJid(jid)) {
            if (isInFavorite) {
                WebAgent.getInstance().removeFavorite(jid, 3);
                return false;
            }
            WebAgent.getInstance().addFavorite(jid, 3);
            return true;
        }
        if (JidUtil.isEmployeeJid(jid) && (contact = ContactManager.getContact((Context)ctx, jid)) != null) {
            Long empId = ChatRoomManager.getEmpId(contact);
            String id = String.valueOf(empId);
            isInFavorite = ContactManager.isInMyFavorite(ctx, id, 1);
            if (isInFavorite) {
                WebAgent.getInstance().removeFavorite(id, 1);
                return false;
            }
            WebAgent.getInstance().addFavorite(id, 1);
            return true;
        }
        return false;
    }

    public static boolean isInMyChatRoom(String jid) {
        if (JidUtil.isChatJid(jid)) {
            return ContactManager.isInMyChatRoom(UCChatClient.context, jid);
        }
        return false;
    }

    public static boolean switchMyChatRoom(String jid) {
        if (!WebAgent.isLogin) {
            ChatRoomManager.showUnableConnectAlert();
            return false;
        }
        boolean isInMyChatRoom = ChatRoomManager.isInMyChatRoom(jid);
        if (JidUtil.isChatJid(jid)) {
            if (isInMyChatRoom) {
                WebAgent.getInstance().removeMyChatRoom(jid);
                return false;
            }
            WebAgent.getInstance().addMychatRoom(jid);
            return true;
        }
        return false;
    }

    public static void showUnableConnectAlert() {
        ToastUtil.showErrorLong(String.format(I18NUtil.getString("network_server_connect_fail_try_later"), I18NUtil.getAppName()));
    }

    private static Long getEmpId(LiteContact contact) {
        if (contact == null || contact.getId() == null) {
            return -1L;
        }
        return contact.getId();
    }

    public static void startDialOut(Component c, String chatId) {
        Log.i(ChatRoomManager.class.getSimpleName(), "startDialOut==> " + chatId);
        Activity ctx = UCChatClient.context;
        ChatRoomManager.checkAndGenerateChatRoomData(UCChatClient.context, chatId, null, false, false);
        ChatRoomInfo info = ChatRoomManager.getChatRoom(ctx, chatId);
        if (info == null) {
            return;
        }
        int chatType = info.getType();
        if (chatType == 3) {
            if (chatId.indexOf("_@@_") != -1) {
                String[] phoneNum = chatId.split("_@@_");
                DialoutManager.dialOtherContactNumber(ctx, phoneNum[1]);
            } else {
                DialoutManager.dialOtherContactNumberWithPrefix(ctx, chatId);
            }
        } else if (chatType == 0) {
            if (JidUtil.isEmployeeJid(chatId)) {
                ChatRoomManager.handleEmpContactPickResult(c, chatId);
            }
        } else if (chatType == 4) {
            LiteContact contact = ContactManager.getContact((Context)ctx, chatId);
            if (contact != null && JidUtil.isLocationJid(contact.getJid())) {
                DialoutManager.dialLocation(ctx, contact);
            }
        } else if (chatType == 5) {
            ChatRoomManager.handleMyContactPickResult(c, chatId);
        } else if (chatType == 2 || chatType == 1) {
            ChatRoomManager.doConfDialOut(chatId);
        }
    }

    private static void doConfDialOut(String callJid) {
        Activity ctx = UCChatClient.context;
        DialoutManager.dialChatRoom(ctx, callJid);
    }

    private static void handleEmpContactPickResult(Component c, String jid) {
        String label;
        Activity ctx = UCChatClient.context;
        List<LiteSite> siteList = UCDBSite.getAllSites(ctx);
        boolean showSite = siteList != null && siteList.size() > 1;
        LiteContact contact = ContactManager.getContact((Context)ctx, jid);
        if (contact == null) {
            return;
        }
        ArrayList<Node> list = new ArrayList<Node>();
        LiteContactHelper.addExtNoByContact(ctx, list, false, contact);
        EmpExtendedSysPhoneConfig config = PreferencesUtil.getEmpExtendedSysPhoneConfig(ctx);
        if (config.isEmpExtendedSystemPhoneFlag1() && StringUtils.isNotBlank((CharSequence)contact.getExtendedPhoneNumber1())) {
            label = config.getEmpExtendedSysPhoneName1(I18NUtil.getAppLocale());
            list.add(new ExtendedSysNode(contact.getJid(), label, contact.getExtendedPhoneNumber1(), false));
        }
        if (config.isEmpExtendedSystemPhoneFlag2() && StringUtils.isNotBlank((CharSequence)contact.getExtendedPhoneNumber2())) {
            label = config.getEmpExtendedSysPhoneName2(I18NUtil.getAppLocale());
            list.add(new ExtendedSysNode(contact.getJid(), label, contact.getExtendedPhoneNumber2(), false));
        }
        if (config.isEmpExtendedSystemPhoneFlag3() && StringUtils.isNotBlank((CharSequence)contact.getExtendedPhoneNumber3())) {
            label = config.getEmpExtendedSysPhoneName3(I18NUtil.getAppLocale());
            list.add(new ExtendedSysNode(contact.getJid(), label, contact.getExtendedPhoneNumber3(), false));
        }
        if (config.isEmpExtendedSystemPhoneFlag4() && StringUtils.isNotBlank((CharSequence)contact.getExtendedPhoneNumber4())) {
            label = config.getEmpExtendedSysPhoneName4(I18NUtil.getAppLocale());
            list.add(new ExtendedSysNode(contact.getJid(), label, contact.getExtendedPhoneNumber4(), false));
        }
        LiteContactHelper.addTelephonesByContact(ctx, list, contact.getMobilePhone(), contact.getHomePhone(), contact.getJid());
        if (list.isEmpty()) {
            ToastUtil.show(ctx, I18NUtil.getString("call_no_phone_num_to_dial"), 10);
        } else if (list.size() == 1) {
            Node node = list.get(0);
            ChatRoomManager.handleContactNodeDialout(node);
        } else {
            PhonePickerDialog dialog = new PhonePickerDialog((JFrame)UCChatClient.getInstance(), showSite);
            dialog.setLocationRelativeTo(c);
            Node node = dialog.showDialog(list);
            ChatRoomManager.handleContactNodeDialout(node);
        }
    }

    private static void handleContactNodeDialout(Node node) {
        Activity ctx = UCChatClient.context;
        if (node instanceof ActionNode) {
            ActionNode actionNode = (ActionNode)node;
            String targetJid = node.getJid();
            if (JidUtil.isEmployeeJid(targetJid)) {
                DialoutManager.dialEmpOutboundNumber(ctx, actionNode.getSubText(), actionNode.getJid());
            }
        } else if (node instanceof ExtenNode) {
            ExtenNode extNode = (ExtenNode)node;
            String targetJid = node.getJid();
            if (JidUtil.isEmployeeJid(targetJid)) {
                DialoutManager.dialEmpExt(ctx, extNode.getSubText(), extNode.getSiteId(), extNode.getJid());
            } else if (JidUtil.isLocationJid(targetJid)) {
                LiteContact location = ContactManager.getContact((Context)ctx, extNode.getJid());
                DialoutManager.dialLocation(ctx, location);
            }
        } else if (node instanceof ExtendedSysNode) {
            ExtendedSysNode extNode = (ExtendedSysNode)node;
            String targetJid = node.getJid();
            if (JidUtil.isEmployeeJid(targetJid)) {
                DialoutManager.dialEmpExtendedSys(ctx, extNode.getSubText(), extNode.getJid());
            }
        }
    }

    private static void handleMyContactPickResult(Component c, String jid) {
        Activity ctx = UCChatClient.context;
        long idLong = JidUtil.trimExternalContactId(jid);
        LiteMyContact contact = ContactManager.getExternalContact((Context)ctx, idLong);
        if (contact == null) {
            return;
        }
        ArrayList<Node> list = new ArrayList<Node>();
        String companyTel = contact.getCompanyTel();
        if (TextUtils.isNotBlank((CharSequence)companyTel)) {
            list.add(new Node(jid, I18NUtil.getString("abook_office"), companyTel.trim(), false));
        }
        LiteContactHelper.addTelephonesByMyContact(ctx, list, contact.getOfficePhone(), contact.getMobilePhone(), contact.getHomePhone(), jid);
        if (list == null || list.size() == 0) {
            ToastUtil.show(ctx, I18NUtil.getString("call_no_phone_num_to_dial"), 10);
        } else if (list.size() == 1) {
            Node node = (Node)list.get(0);
            ChatRoomManager.handleMyContactNodeDialout(node);
        } else {
            PhonePickerDialog dialog = new PhonePickerDialog((JFrame)UCChatClient.getInstance(), false);
            dialog.setLocationRelativeTo(c);
            Node node = dialog.showDialog(list);
            ChatRoomManager.handleMyContactNodeDialout(node);
        }
    }

    private static void handleMyContactNodeDialout(Node node) {
        Activity ctx = UCChatClient.context;
        DialoutManager.dialMyContactNumber(ctx, node.getSubText(), node.getJid());
    }

    public static void errReceived(Context ctx, long chatEventId, String roomJid, String fromJID, String toJID, String text, boolean isRead, boolean isPlayed, boolean isOldEvent) {
        Log.i(ChatRoomManager.class.getSimpleName(), "errReceived()");
        String packetId = ChatRoomManager.genNewPacketId();
        MsgBean bean = new MsgBean();
        bean.setChatEventId(chatEventId);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(roomJid);
        bean.setPacketId(packetId);
        bean.setStatus("R");
        bean.setFromJid(fromJID);
        bean.setToJid(toJID);
        bean.setContent(text);
        bean.setMsgType(0);
        bean.setDuration(0L);
        bean.setRead(isRead);
        bean.setPlayed(isPlayed);
        bean.setReadCount(0);
        bean.setReaderList(null);
        bean.setLazy(false);
        ChatRoomManager.newChatMsg(ctx, roomJid, bean, isOldEvent);
    }

    public static String genNewPacketId() {
        return "BLMSG-" + CommonUtil.randomString(15);
    }

    public static String newInboundNumRecordMsg(Context ctx, long duration, String number, String siteId, long startime, boolean isRead, boolean isPlayed, int type, JSONObject props, boolean isOldEvent) {
        String roomJid = ChatRoomManager.prepareExternalPhoneRoom(ctx);
        String packetId = ChatRoomManager.genNewPacketId();
        String myJid = PreferencesUtil.getUserJid(ctx);
        MsgBean bean = new MsgBean();
        bean.setChatEventId(-1L);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(roomJid);
        bean.setPacketId(packetId);
        bean.setStatus("R");
        bean.setFromJid(roomJid);
        bean.setToJid(myJid);
        bean.setContent(null);
        bean.setMsgType(type);
        bean.setDuration(duration);
        bean.setRead(isRead);
        bean.setPlayed(isPlayed);
        bean.setReadCount(0);
        bean.setReaderList(null);
        bean.setLazy(false);
        bean.setPhoneNumber(number);
        bean.setProps(props != null ? props.toString() : null);
        UCDBMessage.addMessage(ctx, bean, startime, isOldEvent);
        if (!isOldEvent) {
            BroadcastUtil.sendContactHistoryChangedEvent(ctx);
            BroadcastUtil.sendMsgChangedEvent(ctx, roomJid);
        }
        if (!isOldEvent && ChatRoomManager.isNotificationEnabled(ctx, roomJid) && !isRead) {
            BroadcastUtil.sendNotificationPopupEvent(ctx, roomJid, packetId);
        }
        return packetId;
    }

    public static String newOutboundNumRecordMsg(Context ctx, long duration, String siteId, String number, boolean isOutboundTrunk, long startime, boolean isPlayed, int type, JSONObject props, boolean isOldEvent) {
        String roomJid = ChatRoomManager.prepareExternalPhoneRoom(ctx);
        String packetId = ChatRoomManager.genNewPacketId();
        String myJid = PreferencesUtil.getUserJid(ctx);
        MsgBean bean = new MsgBean();
        bean.setChatEventId(-1L);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(roomJid);
        bean.setPacketId(packetId);
        bean.setStatus("V");
        bean.setFromJid(myJid);
        bean.setToJid(roomJid);
        bean.setContent(null);
        bean.setMsgType(type);
        bean.setDuration(duration);
        bean.setRead(true);
        bean.setPlayed(isPlayed);
        bean.setReadCount(0);
        bean.setReaderList(null);
        bean.setLazy(false);
        bean.setPhoneNumber(number);
        bean.setProps(props != null ? props.toString() : null);
        bean.setOutboundTrunk(isOutboundTrunk);
        UCDBMessage.addMessage(ctx, bean, startime, isOldEvent);
        if (!isOldEvent) {
            BroadcastUtil.sendContactHistoryChangedEvent(ctx);
            BroadcastUtil.sendMsgChangedEvent(ctx, roomJid);
        }
        return packetId;
    }

    public static String newInboundRecordMsg(Context ctx, long duration, String number, String chatRoomName, String roomJid, String fromJid, long startime, boolean isRead, boolean isPlayed, int type, JSONObject props, boolean isOldEvent) {
        ChatRoomManager.checkAndGenerateChatRoomData(ctx, roomJid, chatRoomName, isOldEvent, true);
        String packetId = ChatRoomManager.genNewPacketId();
        String myJid = PreferencesUtil.getUserJid(ctx);
        MsgBean bean = new MsgBean();
        bean.setChatEventId(-1L);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(roomJid);
        bean.setPacketId(packetId);
        bean.setStatus("R");
        bean.setFromJid(fromJid);
        bean.setToJid(myJid);
        bean.setContent(null);
        bean.setMsgType(type);
        bean.setDuration(duration);
        bean.setRead(isRead);
        bean.setPlayed(isPlayed);
        bean.setReadCount(0);
        bean.setReaderList(null);
        bean.setLazy(false);
        bean.setPhoneNumber(number);
        bean.setProps(props != null ? props.toString() : null);
        UCDBMessage.addMessage(ctx, bean, startime, isOldEvent);
        if (!isOldEvent) {
            BroadcastUtil.sendContactHistoryChangedEvent(ctx);
            BroadcastUtil.sendMsgChangedEvent(ctx, roomJid);
        }
        if (!isOldEvent && ChatRoomManager.isNotificationEnabled(ctx, roomJid) && !isRead) {
            BroadcastUtil.sendNotificationPopupEvent(ctx, roomJid, packetId);
        }
        return packetId;
    }

    public static String newOutboundRecordMsg(Context ctx, long duration, String number, String chatRoomName, String roomJid, String toJid, long startime, boolean isPlayed, int type, JSONObject props, boolean isOldEvent) {
        ChatRoomManager.checkAndGenerateChatRoomData(ctx, roomJid, chatRoomName, isOldEvent, true);
        String packetId = ChatRoomManager.genNewPacketId();
        String myJid = PreferencesUtil.getUserJid(ctx);
        MsgBean bean = new MsgBean();
        bean.setChatEventId(-1L);
        bean.setSyncEventId(-1L);
        bean.setChatRoomId(roomJid);
        bean.setPacketId(packetId);
        bean.setStatus("V");
        bean.setFromJid(myJid);
        bean.setToJid(toJid);
        bean.setContent(null);
        bean.setMsgType(type);
        bean.setDuration(duration);
        bean.setRead(true);
        bean.setPlayed(isPlayed);
        bean.setReadCount(0);
        bean.setReaderList(null);
        bean.setLazy(false);
        bean.setPhoneNumber(number);
        bean.setProps(props != null ? props.toString() : null);
        UCDBMessage.addMessage(ctx, bean, startime, isOldEvent);
        if (!isOldEvent) {
            BroadcastUtil.sendContactHistoryChangedEvent(ctx);
            BroadcastUtil.sendMsgChangedEvent(ctx, roomJid);
        }
        return packetId;
    }

    public static void checkAndGenerateChatRoomData(Context ctx, String chatRoomJid, String name, boolean isOldEvent, boolean addRelation) {
        boolean newAdd;
        if (chatRoomJid == null) {
            Log.w(ChatRoomManager.class.getSimpleName(), "checkAndGenerateChatRoomData chatRoomJid is null, skip!");
            return;
        }
        if (JidUtil.isEmployeeJid(chatRoomJid)) {
            Set<Long> oldExtraEmpSet = PreferencesUtil.getAddressBookExtraEmpList(ctx);
            HashSet<String> empJidSet = new HashSet<String>();
            LiteContact contact = UCDBContact.getContactByJid(ctx, chatRoomJid);
            if (contact != null) {
                if (!oldExtraEmpSet.contains(contact.getId()) && !DeletedContactManager.existDeletedContact(ctx, chatRoomJid)) {
                    empJidSet.add(chatRoomJid);
                }
                ChatRoomManager.prepareOne2OneRoom(ctx, chatRoomJid, ContactManager.getContactShortName(ctx, contact));
            } else {
                if (!DeletedContactManager.existDeletedContact(ctx, chatRoomJid)) {
                    empJidSet.add(chatRoomJid);
                }
                ChatRoomManager.prepareOne2OneRoom(ctx, chatRoomJid, name);
            }
            if (addRelation && empJidSet.size() > 0) {
                WebAgent.getInstance().addExtraAddressBookByJids(empJidSet);
            }
        } else if (JidUtil.isLocationJid(chatRoomJid)) {
            LiteContact contact = UCDBContact.getContactByJid(ctx, chatRoomJid);
            if (contact != null) {
                ChatRoomManager.prepareLocationRoom(ctx, chatRoomJid, ContactManager.getContactFullName(ctx, contact, chatRoomJid));
            } else {
                ChatRoomManager.prepareLocationRoom(ctx, chatRoomJid, name);
            }
        } else if (JidUtil.isCustomerJid(chatRoomJid)) {
            LiteCustomer customer = CustomerManager.getCustomerInfo(ctx, JidUtil.convertKey(chatRoomJid));
            if (customer != null) {
                ChatRoomManager.prepareCustomerRoom(ctx, chatRoomJid, customer.getNickname());
            } else {
                ChatRoomManager.prepareCustomerRoom(ctx, chatRoomJid, name);
            }
        } else if (JidUtil.isMyContactJid(chatRoomJid)) {
            ChatRoomManager.prepareMyContactRoom(ctx, chatRoomJid, name);
        } else if (JidUtil.isAPIUserJid(chatRoomJid)) {
            ChatRoomManager.prepareApiUserRoom(ctx, chatRoomJid, name);
        } else if (JidUtil.isMobileContactJid(chatRoomJid)) {
            ChatRoomManager.prepareMobileContactRoom(ctx, chatRoomJid, name);
        } else if (JidUtil.isBcAnnouncerJid(chatRoomJid)) {
            ChatRoomManager.prepareOne2OneRoom(ctx, chatRoomJid, name);
        } else if (JidUtil.isChatConfJid(chatRoomJid) && (newAdd = ChatRoomManager.prepareChatRoom(ctx, chatRoomJid))) {
            WebAgent.getInstance().getOneRoomSync(chatRoomJid);
        }
    }

    public static boolean isMessageExist(Context ctx, String roomJid, String packetId, String fromJid, String toJid) {
        return UCDBMessage.isMessageExist(ctx, roomJid, packetId, fromJid, toJid);
    }

    public static void newChatMsg(Context ctx, String roomJid, MsgBean bean, boolean isOldEvent) {
        ChatRoomManager.checkAndGenerateChatRoomData(ctx, roomJid, null, isOldEvent, true);
        UCDBMessage.newCurrentMessage(ctx, bean);
    }

    public static void newChatMsg(Context ctx, String roomJid, MsgBean bean, long serverReceiveTime, boolean isOldEvent) {
        ChatRoomManager.checkAndGenerateChatRoomData(ctx, roomJid, null, isOldEvent, true);
        UCDBMessage.addMessage(ctx, bean, serverReceiveTime, isOldEvent);
    }

    public static void newOutChatMsg(Context ctx, String roomJid, MsgBean bean) {
        ChatRoomManager.checkAndGenerateChatRoomData(ctx, roomJid, null, false, true);
        UCDBMessage.newCurrentMessage(ctx, bean);
    }

    public static void newChatFile(Context ctx, String roomJid, FileBean bean) {
        ChatRoomManager.checkAndGenerateChatRoomData(ctx, roomJid, null, false, true);
        UCDBMessage.addFile(ctx, bean);
    }

    public static void newChatFile(Context ctx, String roomJid, FileBean bean, long serverReceiveTime, boolean isOldEvent) {
        ChatRoomManager.checkAndGenerateChatRoomData(ctx, roomJid, null, isOldEvent, true);
        UCDBMessage.addFile(ctx, bean, serverReceiveTime, isOldEvent);
    }

    public static void newNoticeMsg(Context ctx, NoticeBean bean, long serverReceiveTime, boolean isOldEvent) {
        ChatRoomManager.checkAndGenerateChatRoomData(ctx, "bc_announcer_blisscloud@blisscloud.com", null, isOldEvent, false);
        UCDBMessage.addNoticeMessage(ctx, bean, serverReceiveTime, isOldEvent);
    }

    public static void newIncomingChatMsg(Context ctx, String roomJid, MsgBean bean, long serverReceiveTime, boolean isOldEvent) {
        ChatRoomManager.checkAndGenerateChatRoomData(ctx, roomJid, null, isOldEvent, true);
        UCDBMessage.addIncomingMessage(ctx, bean, serverReceiveTime, isOldEvent);
    }

    public static void newIncomingChatFile(Context ctx, String roomJid, FileBean bean, long serverReceiveTime, boolean isOldEvent) {
        ChatRoomManager.checkAndGenerateChatRoomData(ctx, roomJid, null, isOldEvent, true);
        UCDBMessage.addIncomingFile(ctx, bean, serverReceiveTime, isOldEvent);
    }

    public static int getNoReadMsgCount(Context ctx) {
        String myJid = PreferencesUtil.getUserJid(ctx);
        return UCDBMessage.countNoReadChatMsg(ctx, myJid);
    }

    public static int getNoReadCallCount(Context ctx) {
        String myJid = PreferencesUtil.getUserJid(ctx);
        return UCDBMessage.lastExternalCallUnread(ctx, myJid);
    }

    public static List<MessageHeader> getChatMsgsBefore(Context ctx, String roomJid, long timestamp, Integer limit) {
        return UCDBMessage.findMsgsBefore(ctx, roomJid, timestamp, limit);
    }

    public static List<MessageHeader> getChatMsgsAfter(Context ctx, String roomJid, long timestamp, Integer limit) {
        return UCDBMessage.findMsgsAfter(ctx, roomJid, timestamp, limit);
    }

    public static Message findLastMsg(Context ctx, String roomJid, long timestamp) {
        return UCDBMessage.findLastMsg(ctx, roomJid, timestamp);
    }

    public static List<Message> findUnreadVociemailMsgIds(Context ctx, String roomJid) {
        return UCDBMessage.findUnreadVociemailMsgIds(ctx, roomJid);
    }

    public static List<Message> findUnreadPersonalRecordMsgIds(Context ctx, String roomJid) {
        return UCDBMessage.findUnreadPersonalRecordMsgIds(ctx, roomJid);
    }

    public static List<Long[]> findUnreadMsgIds(Context ctx, String roomJid) {
        return UCDBMessage.findUnreadMsgIds(ctx, roomJid);
    }

    public static List<Long[]> findUnreadPhoneMsgIds(Context ctx, String myJid) {
        return UCDBMessage.findUnreadPhoneMsgIds(ctx, myJid);
    }

    public static List<MessageHeader> getChatMsgsInit(Context ctx, String roomJid, int limit) {
        return UCDBMessage.findMsgsInit(ctx, roomJid, limit);
    }

    public static ChatRoomInfo getChatRoom(Context ctx, String jid) {
        return UCDBChatRoom.getChatRoom(ctx, jid);
    }

    public static List<ChatRoomInfo> getMultiChatRooms(Context ctx) {
        return UCDBChatRoom.getMultiChatRooms(ctx);
    }

    private static void checkLoadDataRequired(Context ctx, String inviteeJID) {
        LiteContact contact = ContactManager.getContact(ctx, inviteeJID);
        if (contact == null) {
            FetchEmpTaskController.getInstance(ctx).addTaskNoScopeCheck(inviteeJID);
        } else {
            FetchEmpTaskController.getInstance(ctx).addTask(contact);
        }
    }

    public static void updateChatSubject(Context ctx, String roomId, String subject, String byParticipantJid) {
        UCDBChatRoom.updateChatRoomSubject(ctx, roomId, subject, byParticipantJid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareOne2OneRoom(Context ctx, String jid, String name) {
        if (jid == null) {
            Log.w(ChatRoomManager.class.getSimpleName(), "direct chat jid is null, ignore !");
            return;
        }
        Object object = chatRoomLock;
        synchronized (object) {
            if (!UCDBChatRoom.existChatRoomById(ctx, jid)) {
                ChatRoomInfo newChatRoom = new ChatRoomInfo();
                newChatRoom.setChatRoomId(jid);
                newChatRoom.setSubject(name);
                newChatRoom.setType(0);
                UCDBChatRoom.addChatRoom(ctx, newChatRoom);
                Log.i(ChatRoomManager.class.getSimpleName(), "create chatroom " + jid + " now .....................");
            } else {
                ChatRoomInfo info = UCDBChatRoom.getChatRoom(ctx, jid);
                if (info.getType() != 0) {
                    UCDBChatRoom.updateChatRoomType(ctx, jid, 0);
                }
                if (info != null && TextUtils.isBlank((CharSequence)info.getSubject()) && TextUtils.isNotBlank((CharSequence)name)) {
                    UCDBChatRoom.updateChatRoomSubject(ctx, jid, name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareCustomerRoom(Context ctx, String jid, String name) {
        if (jid == null) {
            Log.w(ChatRoomManager.class.getSimpleName(), "direct chat jid is null, ignore !");
            return;
        }
        Object object = chatRoomLock;
        synchronized (object) {
            if (!UCDBChatRoom.existChatRoomById(ctx, jid)) {
                ChatRoomInfo newChatRoom = new ChatRoomInfo();
                newChatRoom.setChatRoomId(jid);
                newChatRoom.setSubject(name);
                newChatRoom.setType(0);
                UCDBChatRoom.addChatRoom(ctx, newChatRoom);
                Log.i(ChatRoomManager.class.getSimpleName(), "create chatroom " + jid + " now .....................");
            } else {
                ChatRoomInfo info = UCDBChatRoom.getChatRoom(ctx, jid);
                if (info.getType() != 0) {
                    UCDBChatRoom.updateChatRoomType(ctx, jid, 0);
                }
                if (info != null && TextUtils.isEmpty((CharSequence)info.getSubject()) && !TextUtils.isEmpty((CharSequence)name)) {
                    UCDBChatRoom.updateChatRoomSubject(ctx, jid, name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareApiUserRoom(Context ctx, String jid, String name) {
        if (jid == null) {
            Log.w(ChatRoomManager.class.getSimpleName(), "direct chat jid is null, ignore !");
            return;
        }
        Object object = chatRoomLock;
        synchronized (object) {
            if (!UCDBChatRoom.existChatRoomById(ctx, jid)) {
                ChatRoomInfo newChatRoom = new ChatRoomInfo();
                newChatRoom.setChatRoomId(jid);
                newChatRoom.setSubject(name);
                newChatRoom.setType(7);
                UCDBChatRoom.addChatRoom(ctx, newChatRoom);
                Log.i(ChatRoomManager.class.getSimpleName(), "create chatroom " + jid + " now .....................");
            } else {
                ChatRoomInfo info = UCDBChatRoom.getChatRoom(ctx, jid);
                if (info.getType() != 7) {
                    UCDBChatRoom.updateChatRoomType(ctx, jid, 7);
                }
                if (info != null && TextUtils.isEmpty((CharSequence)info.getSubject()) && !TextUtils.isEmpty((CharSequence)name)) {
                    UCDBChatRoom.updateChatRoomSubject(ctx, jid, name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareMyContactRoom(Context ctx, String jid, String name) {
        if (jid == null) {
            Log.w(ChatRoomManager.class.getSimpleName(), "direct chat jid is null, ignore !");
            return;
        }
        Object object = chatRoomLock;
        synchronized (object) {
            if (!UCDBChatRoom.existChatRoomById(ctx, jid)) {
                ChatRoomInfo newChatRoom = new ChatRoomInfo();
                newChatRoom.setChatRoomId(jid);
                newChatRoom.setSubject(name);
                newChatRoom.setType(5);
                UCDBChatRoom.addChatRoom(ctx, newChatRoom);
                Log.i(ChatRoomManager.class.getSimpleName(), "create chatroom " + jid + " now .....................");
            } else {
                ChatRoomInfo info = UCDBChatRoom.getChatRoom(ctx, jid);
                if (info.getType() != 5) {
                    UCDBChatRoom.updateChatRoomType(ctx, jid, 5);
                }
                if (info != null && TextUtils.isBlank((CharSequence)info.getSubject()) && TextUtils.isNotBlank((CharSequence)name)) {
                    UCDBChatRoom.updateChatRoomSubject(ctx, jid, name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareMobileContactRoom(Context ctx, String jid, String name) {
        if (jid == null) {
            Log.w(ChatRoomManager.class.getSimpleName(), "direct chat jid is null, ignore !");
            return;
        }
        Object object = chatRoomLock;
        synchronized (object) {
            if (!UCDBChatRoom.existChatRoomById(ctx, jid)) {
                ChatRoomInfo newChatRoom = new ChatRoomInfo();
                newChatRoom.setChatRoomId(jid);
                newChatRoom.setSubject(name);
                newChatRoom.setType(6);
                UCDBChatRoom.addChatRoom(ctx, newChatRoom);
                Log.i(ChatRoomManager.class.getSimpleName(), "create chatroom " + jid + " now .....................");
            } else {
                ChatRoomInfo info = UCDBChatRoom.getChatRoom(ctx, jid);
                if (info.getType() != 6) {
                    UCDBChatRoom.updateChatRoomType(ctx, jid, 6);
                }
                if (info != null && TextUtils.isBlank((CharSequence)info.getSubject()) && TextUtils.isNotBlank((CharSequence)name)) {
                    UCDBChatRoom.updateChatRoomSubject(ctx, jid, name);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void prepareLocationRoom(Context ctx, String jid, String name) {
        if (jid == null) {
            Log.w(ChatRoomManager.class.getSimpleName(), "direct chat jid is null, ignore !");
            return;
        }
        Object object = chatRoomLock;
        synchronized (object) {
            if (!UCDBChatRoom.existChatRoomById(ctx, jid)) {
                ChatRoomInfo newChatRoom = new ChatRoomInfo();
                newChatRoom.setChatRoomId(jid);
                newChatRoom.setSubject(name);
                newChatRoom.setType(4);
                UCDBChatRoom.addChatRoom(ctx, newChatRoom);
                Log.i(ChatRoomManager.class.getSimpleName(), "create chatroom " + jid + " now .....................");
            } else {
                ChatRoomInfo info = UCDBChatRoom.getChatRoom(ctx, jid);
                if (info.getType() != 4) {
                    UCDBChatRoom.updateChatRoomType(ctx, jid, 4);
                }
                if (info != null && TextUtils.isBlank((CharSequence)info.getSubject()) && TextUtils.isNotBlank((CharSequence)name)) {
                    UCDBChatRoom.updateChatRoomSubject(ctx, jid, name);
                }
            }
        }
    }

    public static boolean prepareChatRoom(Context ctx, String jid) {
        return ChatRoomManager.prepareChatRoom(ctx, jid, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean prepareChatRoom(Context ctx, String jid, String name) {
        if (jid == null) {
            Log.w(ChatRoomManager.class.getSimpleName(), "direct chat jid is null, ignore !");
            return false;
        }
        Object object = chatRoomLock;
        synchronized (object) {
            if (!UCDBChatRoom.existChatRoomById(ctx, jid)) {
                Log.d(ChatRoomManager.class.getSimpleName(), "==>not exist " + jid);
                ChatRoomInfo newChatRoom = new ChatRoomInfo();
                newChatRoom.setChatRoomId(jid);
                newChatRoom.setSubject(name);
                if (jid.startsWith("conferenceroom")) {
                    newChatRoom.setType(2);
                } else {
                    newChatRoom.setType(1);
                }
                UCDBChatRoom.addChatRoom(ctx, newChatRoom);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String prepareExternalPhoneRoom(Context ctx) {
        Object object = chatRoomLock;
        synchronized (object) {
            String roomJid = "__EXTERNAL_TRUNK_CALL_GROUP__";
            boolean exist = UCDBChatRoom.existChatRoomById(ctx, roomJid);
            if (exist) {
                return roomJid;
            }
            ChatRoomInfo newChatRoom = new ChatRoomInfo();
            newChatRoom.setChatRoomId(roomJid);
            newChatRoom.setType(3);
            newChatRoom.setSubject(roomJid);
            UCDBChatRoom.addChatRoom(ctx, newChatRoom);
            return roomJid;
        }
    }

    public static String selfCreateChatRoom(Context ctx, String subject, String creatorJid, String roomJid) {
        boolean newAdd = ChatRoomManager.prepareChatRoom(ctx, roomJid);
        if (newAdd) {
            WebAgent.getInstance().getOneRoomSync(roomJid);
        }
        UCDBChatRoom.updateChatRoomSubject(ctx, roomJid, subject, creatorJid);
        ChatRoomManager.checkAndAddParticipant(ctx, roomJid, creatorJid);
        return roomJid;
    }

    public static void notifySelfCreateChatRoomDone(Context ctx, String roomJid, String requestId) {
        BroadcastUtil.sendChatRoomCreateSucceedEvent(ctx, roomJid, requestId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifySelfCreateChatRoomFailed(Context ctx, String roomJid, String errorMsg) {
        Object object = chatRoomLock;
        synchronized (object) {
            UCDBChatRoom.deleteChatRoom(ctx, roomJid);
            WebAgent.getInstance().clearSyncRoomInfo(roomJid);
        }
        BroadcastUtil.sendChatRoomCreateFailedEvent(ctx, roomJid);
    }

    public static void initializeRoomMember(Context ctx, String roomJid, String actorJID, JSONArray roomMembers) {
        boolean doChanged = false;
        String domainName = actorJID.substring(actorJID.lastIndexOf("@") + 1);
        for (int i = 0; i < roomMembers.length(); ++i) {
            String roomMember = roomMembers.optString(i);
            Object roomMemberJid = null;
            roomMemberJid = roomMember.endsWith(domainName) ? roomMember : roomMember + "@" + domainName;
            boolean result = ChatRoomManager.checkAndAddParticipant(ctx, roomJid, (String)roomMemberJid);
            if (!result) continue;
            doChanged = true;
        }
        if (doChanged) {
            BroadcastUtil.sendParticipantChangedEvent(ctx, roomJid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean userAdd(Context ctx, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent) throws JSONException {
        Object object = chatRoomLock;
        synchronized (object) {
            String subject = data.optString("roomSubject", null);
            String roomJid = data.getString("roomJid");
            String affiliation = data.getString("affiliation");
            boolean byServer = data.getBoolean("byServer");
            JSONArray roomMembers = data.getJSONArray("roomMemberJids");
            String actorJid = data.getString("actorJid");
            long serverReceiveTime = data.getLong("timestamp");
            Log.d(ChatRoomManager.class.getName(), "notifyRoomUserAdded roomJID:" + roomJid + ", affiliation:" + affiliation + ", byServer:" + byServer + "]");
            boolean showMarkRead = false;
            String myJid = PreferencesUtil.getUserJid(ctx);
            boolean newAdd = ChatRoomManager.prepareChatRoom(ctx, roomJid, subject);
            if (newAdd) {
                WebAgent.getInstance().getOneRoomSync(roomJid);
            }
            if (!isOldEvent) {
                ChatRoomManager.checkAndAddParticipant(ctx, roomJid, myJid);
            }
            String packetId = ChatRoomManager.genNewPacketId();
            MsgBean bean = new MsgBean();
            bean.setChatEventId(chatEventId);
            bean.setSyncEventId(-1L);
            bean.setChatRoomId(roomJid);
            bean.setPacketId(packetId);
            bean.setStatus("R");
            bean.setFromJid(actorJid);
            bean.setToJid(myJid);
            bean.setContent(null);
            bean.setDuration(0L);
            bean.setReadCount(0);
            bean.setReaderList(null);
            bean.setLazy(false);
            if (byServer || actorJid == null) {
                bean.setMsgType(251);
                bean.setRead(true);
                bean.setPlayed(true);
                showMarkRead = true;
            } else if (actorJid.equals(myJid)) {
                bean.setMsgType(252);
                bean.setRead(true);
                bean.setPlayed(true);
                showMarkRead = true;
            } else {
                ChatRoomManager.checkLoadDataRequired(ctx, actorJid);
                bean.setMsgType(253);
                bean.setRead(isRead);
                bean.setPlayed(isPlayed);
                showMarkRead = false;
            }
            ChatRoomManager.newChatMsg(ctx, roomJid, bean, serverReceiveTime, isOldEvent);
            if (!isOldEvent) {
                BroadcastUtil.sendContactHistoryChangedEvent(ctx);
                BroadcastUtil.sendParticipantChangedEvent(ctx, roomJid);
                BroadcastUtil.sendMsgChangedEvent(ctx, roomJid);
                ChatRoomManager.initializeRoomMember(ctx, roomJid, actorJid, roomMembers);
            }
            if (!isOldEvent && ChatRoomManager.isNotificationEnabled(ctx, roomJid) && !bean.isRead()) {
                BroadcastUtil.sendNotificationPopupEvent(ctx, roomJid, packetId);
            }
            return showMarkRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean memberAdd(Context ctx, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent) throws JSONException {
        Object object = chatRoomLock;
        synchronized (object) {
            String roomJid = data.getString("roomJid");
            String affiliation = data.getString("affiliation");
            boolean byServer = data.getBoolean("byServer");
            JSONArray members = data.getJSONArray("memberJids");
            String actorJid = data.getString("actorJid");
            long serverReceiveTime = data.getLong("timestamp");
            Log.d(ChatRoomManager.class.getName(), "notifyRoomMembersAdded roomJid:" + roomJid + ", memberJIDs:" + members.toString() + ", affiliation:" + affiliation + ", by:" + String.valueOf(byServer ? "server" : Boolean.valueOf(byServer)));
            boolean hasSelfAdd = false;
            String myJid = PreferencesUtil.getUserJid(ctx);
            StringBuffer v = new StringBuffer();
            int k = 0;
            for (int i = 0; members != null && i < members.length(); ++i) {
                String memberJid = (String)members.get(i);
                if (myJid.equals(memberJid)) {
                    hasSelfAdd = true;
                } else {
                    ChatRoomManager.checkLoadDataRequired(ctx, memberJid);
                    if (k != 0) {
                        v.append(",");
                    }
                    v.append(memberJid);
                    ++k;
                }
                if (isOldEvent) continue;
                ChatRoomManager.checkAndAddParticipant(ctx, roomJid, memberJid);
            }
            String addJidStr = v.toString();
            boolean newAdd = ChatRoomManager.prepareChatRoom(ctx, roomJid);
            if (newAdd) {
                WebAgent.getInstance().getOneRoomSync(roomJid);
            }
            boolean shouldMarkRead = false;
            String packetId = ChatRoomManager.genNewPacketId();
            MsgBean bean = new MsgBean();
            bean.setChatEventId(chatEventId);
            bean.setSyncEventId(-1L);
            bean.setChatRoomId(roomJid);
            bean.setPacketId(packetId);
            bean.setStatus("R");
            bean.setContent(null);
            bean.setDuration(0L);
            bean.setReadCount(0);
            bean.setReaderList(null);
            bean.setLazy(false);
            bean.setToJid(addJidStr);
            if (hasSelfAdd) {
                if (members.length() <= 1) {
                    if (byServer || actorJid == null) {
                        bean.setFromJid(null);
                        bean.setMsgType(251);
                        bean.setRead(true);
                        bean.setPlayed(true);
                        shouldMarkRead = true;
                    } else if (actorJid.equals(myJid)) {
                        bean.setFromJid(myJid);
                        bean.setMsgType(252);
                        bean.setRead(true);
                        bean.setPlayed(true);
                        shouldMarkRead = true;
                    } else {
                        bean.setFromJid(actorJid);
                        bean.setMsgType(253);
                        bean.setRead(isRead);
                        bean.setPlayed(isPlayed);
                        shouldMarkRead = false;
                    }
                } else if (byServer || actorJid == null) {
                    bean.setFromJid(null);
                    bean.setMsgType(254);
                    bean.setRead(true);
                    bean.setPlayed(true);
                    shouldMarkRead = true;
                } else if (actorJid.equals(myJid)) {
                    bean.setFromJid(myJid);
                    bean.setMsgType(255);
                    bean.setRead(true);
                    bean.setPlayed(true);
                    shouldMarkRead = true;
                } else {
                    bean.setFromJid(actorJid);
                    bean.setMsgType(256);
                    bean.setRead(isRead);
                    bean.setPlayed(isPlayed);
                    shouldMarkRead = false;
                }
            } else {
                if (byServer || actorJid == null) {
                    bean.setFromJid(null);
                    bean.setMsgType(257);
                } else if (actorJid.equals(myJid)) {
                    bean.setFromJid(myJid);
                    bean.setMsgType(258);
                } else {
                    bean.setFromJid(actorJid);
                    bean.setMsgType(259);
                }
                bean.setRead(true);
                bean.setPlayed(true);
                shouldMarkRead = true;
            }
            ChatRoomManager.newChatMsg(ctx, roomJid, bean, serverReceiveTime, isOldEvent);
            if (!isOldEvent) {
                BroadcastUtil.sendPhoneInfoChanged(ctx);
                BroadcastUtil.sendContactHistoryChangedEvent(ctx);
                BroadcastUtil.sendParticipantChangedEvent(ctx, roomJid);
                BroadcastUtil.sendMsgChangedEvent(ctx, roomJid);
                ChatRoomManager.initializeRoomMember(ctx, roomJid, actorJid, members);
            }
            if (!isOldEvent && ChatRoomManager.isNotificationEnabled(ctx, roomJid) && !bean.isRead()) {
                BroadcastUtil.sendNotificationPopupEvent(ctx, roomJid, packetId);
            }
            return shouldMarkRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean userRemoved(Context ctx, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent) throws JSONException {
        Object object = chatRoomLock;
        synchronized (object) {
            String actorJid = data.getString("actorJid");
            String roomJid = data.getString("roomJid");
            String reason = data.getString("reason");
            long serverReceiveTime = data.getLong("timestamp");
            boolean byServer = data.getBoolean("byServer");
            Log.d(ChatRoomManager.class.getName(), "notifyRoomUserRemoved roomJID:" + roomJid + ", reason:" + reason);
            boolean shouldMarkRead = false;
            if (JidUtil.isChatJid(roomJid)) {
                String myJid = PreferencesUtil.getUserJid(ctx);
                String packetId = ChatRoomManager.genNewPacketId();
                MsgBean bean = new MsgBean();
                bean.setChatEventId(chatEventId);
                bean.setSyncEventId(-1L);
                bean.setChatRoomId(roomJid);
                bean.setPacketId(packetId);
                bean.setStatus("R");
                bean.setToJid(myJid);
                bean.setContent(null);
                bean.setDuration(0L);
                bean.setReadCount(0);
                bean.setReaderList(null);
                bean.setLazy(false);
                if (byServer || actorJid == null) {
                    bean.setFromJid(null);
                    bean.setMsgType(261);
                    bean.setRead(true);
                    bean.setPlayed(true);
                    shouldMarkRead = true;
                } else if (actorJid.equals(myJid)) {
                    bean.setFromJid(myJid);
                    bean.setMsgType(262);
                    bean.setRead(true);
                    bean.setPlayed(true);
                    shouldMarkRead = true;
                } else {
                    bean.setFromJid(actorJid);
                    bean.setMsgType(263);
                    bean.setRead(isRead);
                    bean.setPlayed(isPlayed);
                    shouldMarkRead = false;
                }
                ChatRoomManager.newChatMsg(ctx, roomJid, bean, serverReceiveTime, isOldEvent);
                if (!isOldEvent && ChatRoomManager.isNotificationEnabled(ctx, roomJid) && !bean.isRead()) {
                    BroadcastUtil.sendNotificationPopupEvent(ctx, roomJid, packetId, false);
                }
                ChatRoomManager.selfLeaveChatRoom(ctx, roomJid);
            } else {
                boolean newAdd = ChatRoomManager.prepareChatRoom(ctx, roomJid);
                if (newAdd) {
                    WebAgent.getInstance().getOneRoomSync(roomJid);
                }
                String myJid = PreferencesUtil.getUserJid(ctx);
                String packetId = ChatRoomManager.genNewPacketId();
                MsgBean bean = new MsgBean();
                bean.setChatEventId(chatEventId);
                bean.setSyncEventId(-1L);
                bean.setChatRoomId(roomJid);
                bean.setPacketId(packetId);
                bean.setStatus("R");
                bean.setToJid(myJid);
                bean.setContent(null);
                bean.setDuration(0L);
                bean.setReadCount(0);
                bean.setReaderList(null);
                bean.setLazy(false);
                if (byServer || actorJid == null) {
                    bean.setFromJid(null);
                    bean.setMsgType(261);
                    bean.setRead(true);
                    bean.setPlayed(true);
                    shouldMarkRead = true;
                } else if (actorJid.equals(myJid)) {
                    bean.setFromJid(myJid);
                    bean.setMsgType(262);
                    bean.setRead(true);
                    bean.setPlayed(true);
                    shouldMarkRead = true;
                } else {
                    bean.setFromJid(actorJid);
                    bean.setMsgType(263);
                    bean.setRead(isRead);
                    bean.setPlayed(isPlayed);
                    shouldMarkRead = false;
                }
                ChatRoomManager.newChatMsg(ctx, roomJid, bean, serverReceiveTime, isOldEvent);
                if (!isOldEvent && ChatRoomManager.isNotificationEnabled(ctx, roomJid) && !bean.isRead()) {
                    BroadcastUtil.sendNotificationPopupEvent(ctx, roomJid, packetId);
                }
                ChatRoomManager.selfLeaveConfRoom(ctx, roomJid, isOldEvent);
            }
            if (!isOldEvent) {
                BroadcastUtil.sendChatRoomRemovedEvent(ctx, roomJid);
                BroadcastUtil.sendContactHistoryChangedEvent(ctx);
                BroadcastUtil.sendParticipantChangedEvent(ctx, roomJid);
                BroadcastUtil.sendMsgChangedEvent(ctx, roomJid);
            }
            return shouldMarkRead;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean memberRemoved(Context ctx, long chatEventId, JSONObject data, boolean isRead, boolean isPlayed, boolean isOldEvent) throws JSONException {
        Object object = chatRoomLock;
        synchronized (object) {
            String actorJid = data.getString("actorJid");
            String roomJid = data.getString("roomJid");
            JSONArray members = data.getJSONArray("memberJids");
            String reason = data.getString("reason");
            long serverReceiveTime = data.getLong("timestamp");
            boolean byServer = data.getBoolean("byServer");
            if (members == null) {
                return true;
            }
            Log.d(ChatRoomManager.class.getName(), "notifyRoomMembersRemoved roomJID:" + roomJid + ", memberJIDs:" + members.toString() + ", reason:" + reason);
            boolean shouldMarkRead = false;
            String myJid = PreferencesUtil.getUserJid(ctx);
            boolean hasSelfLeave = false;
            StringBuffer v = new StringBuffer();
            int k = 0;
            for (int i = 0; members != null && i < members.length(); ++i) {
                String memberJid = (String)members.get(i);
                if (myJid.equals(memberJid)) {
                    hasSelfLeave = true;
                    continue;
                }
                ChatRoomManager.checkLoadDataRequired(ctx, memberJid);
                if (k != 0) {
                    v.append(",");
                }
                v.append(memberJid);
                ++k;
            }
            String leaveJidStr = v.toString();
            if (hasSelfLeave) {
                if (JidUtil.isChatJid(roomJid)) {
                    ChatRoomManager.selfLeaveChatRoom(ctx, roomJid);
                    shouldMarkRead = true;
                } else {
                    boolean newAdd = ChatRoomManager.prepareChatRoom(ctx, roomJid);
                    if (newAdd) {
                        WebAgent.getInstance().getOneRoomSync(roomJid);
                    }
                    String packetId = ChatRoomManager.genNewPacketId();
                    MsgBean bean = new MsgBean();
                    bean.setChatEventId(chatEventId);
                    bean.setSyncEventId(-1L);
                    bean.setChatRoomId(roomJid);
                    bean.setPacketId(packetId);
                    bean.setStatus("R");
                    bean.setContent(null);
                    bean.setDuration(0L);
                    bean.setReadCount(0);
                    bean.setReaderList(null);
                    bean.setLazy(false);
                    bean.setToJid(leaveJidStr);
                    if (members.length() <= 1) {
                        if (byServer || actorJid == null) {
                            bean.setFromJid(null);
                            bean.setMsgType(261);
                            bean.setRead(true);
                            bean.setPlayed(true);
                            shouldMarkRead = true;
                        } else if (actorJid.equals(myJid)) {
                            bean.setFromJid(myJid);
                            bean.setMsgType(262);
                            bean.setRead(true);
                            bean.setPlayed(true);
                            shouldMarkRead = true;
                        } else {
                            bean.setFromJid(actorJid);
                            bean.setMsgType(263);
                            bean.setRead(isRead);
                            bean.setPlayed(isPlayed);
                            shouldMarkRead = false;
                        }
                    } else if (byServer || actorJid == null) {
                        bean.setFromJid(null);
                        bean.setMsgType(264);
                        bean.setRead(true);
                        bean.setPlayed(true);
                        shouldMarkRead = true;
                    } else if (actorJid.equals(myJid)) {
                        bean.setFromJid(myJid);
                        bean.setMsgType(265);
                        bean.setRead(true);
                        bean.setPlayed(true);
                        shouldMarkRead = true;
                    } else {
                        bean.setFromJid(actorJid);
                        bean.setMsgType(266);
                        bean.setRead(isRead);
                        bean.setPlayed(isPlayed);
                        shouldMarkRead = false;
                    }
                    ChatRoomManager.newChatMsg(ctx, roomJid, bean, serverReceiveTime, isOldEvent);
                    ChatRoomManager.selfLeaveConfRoom(ctx, roomJid, isOldEvent);
                    if (!isOldEvent && ChatRoomManager.isNotificationEnabled(ctx, roomJid) && !bean.isRead()) {
                        BroadcastUtil.sendNotificationPopupEvent(ctx, roomJid, packetId);
                    }
                }
                if (!isOldEvent) {
                    BroadcastUtil.sendChatRoomRemovedEvent(ctx, roomJid);
                }
            } else {
                boolean newAdd = ChatRoomManager.prepareChatRoom(ctx, roomJid);
                if (newAdd) {
                    WebAgent.getInstance().getOneRoomSync(roomJid);
                }
                if (!isOldEvent) {
                    for (int i = 0; members != null && i < members.length(); ++i) {
                        String memberJid = (String)members.get(i);
                        UCDBChatRoom.deleteChatRoomParticipant(ctx, roomJid, memberJid);
                    }
                }
                String packetId = ChatRoomManager.genNewPacketId();
                MsgBean bean = new MsgBean();
                bean.setChatEventId(chatEventId);
                bean.setSyncEventId(-1L);
                bean.setChatRoomId(roomJid);
                bean.setPacketId(packetId);
                bean.setStatus("R");
                bean.setContent(null);
                bean.setDuration(0L);
                bean.setReadCount(0);
                bean.setReaderList(null);
                bean.setLazy(false);
                bean.setToJid(leaveJidStr);
                if (byServer || actorJid == null) {
                    bean.setFromJid(null);
                    bean.setMsgType(267);
                } else if (actorJid.equals(myJid)) {
                    bean.setFromJid(actorJid);
                    bean.setMsgType(268);
                } else {
                    bean.setFromJid(actorJid);
                    bean.setMsgType(269);
                }
                bean.setRead(true);
                bean.setPlayed(true);
                shouldMarkRead = true;
                ChatRoomManager.newChatMsg(ctx, roomJid, bean, serverReceiveTime, isOldEvent);
                if (!isOldEvent && ChatRoomManager.isNotificationEnabled(ctx, roomJid) && !bean.isRead()) {
                    BroadcastUtil.sendNotificationPopupEvent(ctx, roomJid, packetId);
                }
            }
            if (!isOldEvent) {
                BroadcastUtil.sendPhoneInfoChanged(ctx);
                BroadcastUtil.sendContactHistoryChangedEvent(ctx);
                BroadcastUtil.sendParticipantChangedEvent(ctx, roomJid);
                BroadcastUtil.sendMsgChangedEvent(ctx, roomJid);
            }
            return shouldMarkRead;
        }
    }

    public static void createRoomForSelfJoin(Context ctx, String roomJid, long serverReceiveTime, boolean isOldEvent) {
        boolean newAdd = ChatRoomManager.prepareChatRoom(ctx, roomJid);
        if (newAdd) {
            WebAgent.getInstance().getOneRoomSync(roomJid);
        }
    }

    public static boolean isNotificationEnabled(Context context, String jid) {
        UserDatabase database = UserDatabase.getDB(UCChatClient.context);
        if (!database.isNotifyMessageOn()) {
            return false;
        }
        return !database.isDisableNotification(jid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyEnterRoomSucceed(Context ctx, String roomJid) {
        Object object = chatRoomLock;
        synchronized (object) {
            if (UCDBChatRoom.existChatRoomById(ctx, roomJid)) {
                Log.d(ChatRoomManager.class.getSimpleName(), "---------------------------> updateChatRoomStatus: " + roomJid);
            } else {
                Log.e(ChatRoomManager.class.getSimpleName(), "Imposible 1... chat room not exist: " + roomJid);
            }
        }
    }

    public static boolean isNotificationDisabled(Context ctx, String jid) {
        UserDatabase db2 = UserDatabase.getDB(ctx);
        if (!db2.isNotifyMessageOn()) {
            return true;
        }
        boolean isDisabled = db2.isDisableNotification(jid);
        return isDisabled;
    }

    public static boolean validateName(String name) {
        return name != null && !"".equalsIgnoreCase(name) && !name.equalsIgnoreCase("-subject-") && !name.equalsIgnoreCase("i18n.multi.conference");
    }

    public static void markSendinMsgAsError(Context ctx) {
        UCDBMessage.updateSendingMsgsAsError(ctx);
    }

    public static void updateMessageStatusWithEvent(Context ctx, String receiverJID, String packetId, String errorMes, String status, boolean isOldEvent) {
        UCDBMessage.updateChatMsgStatus(ctx, packetId, status);
        if (!isOldEvent) {
            BroadcastUtil.sendMsgStatusChangedEvent(ctx, receiverJID, packetId, status, errorMes);
        }
    }

    public static String getResource() {
        String resource = "ucChatClient_Desktop_" + CommonUtil.randomString(20);
        return resource;
    }

    public static String getRequestId(Context ctx) {
        Long id = PreferencesUtil.getUserId(ctx);
        StringBuilder result = new StringBuilder(String.valueOf(id));
        while (result.length() < 10) {
            result.insert(0, 0);
        }
        result.insert(0, System.currentTimeMillis());
        return result.toString();
    }

    public static void selfLeaveChatRoom(Context ctx, String roomJid) {
        boolean isMyChatRoom;
        if (roomJid == null) {
            return;
        }
        boolean isDisable = UserDatabase.getDB(ctx).isDisableNotification(roomJid);
        if (isDisable) {
            WebAgent.getInstance().enableChatRoomNotice(roomJid, true);
        }
        ChatRoomManager.clearChatMsg(ctx, roomJid);
        UCDBChatRoom.deleteChatRoomParticipants(ctx, roomJid);
        UCDBChatRoom.deleteChatRoom(ctx, roomJid);
        WebAgent.getInstance().clearSyncRoomInfo(roomJid);
        LiteConferenceRoom room = MeetmeManager.getMeetme(ctx, roomJid);
        if (room != null) {
            UserDatabase.getDB(ctx).deleteConferenceRoleInfo(room.getRoomId());
            MeetmeManager.deleteAllConfRoomUsers(ctx, room.getRoomId());
            MeetmeManager.deleteConfRoomById(ctx, room.getRoomId(), roomJid);
        }
        UserDatabase.getDB(ctx).deletePendingMessage(roomJid);
        boolean isMyFavorite = ContactManager.isInMyFavorite(ctx, roomJid, 3);
        if (isMyFavorite) {
            WebAgent.getInstance().removeFavorite(roomJid, 3);
        }
        if (isMyChatRoom = ContactManager.isInMyChatRoom(ctx, roomJid)) {
            WebAgent.getInstance().removeMyChatRoom(roomJid);
        }
    }

    public static void selfLeaveConfRoom(Context ctx, String roomJid, boolean isOldEvent) {
        if (roomJid == null) {
            return;
        }
        if (!isOldEvent) {
            UCDBChatRoom.deleteChatRoomParticipants(ctx, roomJid);
        }
        UserDatabase.getDB(ctx).deletePendingMessage(roomJid);
        LiteConferenceRoom room = MeetmeManager.getMeetme(ctx, roomJid);
        if (room != null) {
            MeetmeManager.deleteAllConfRoomUsers(ctx, room.getRoomId());
        }
    }

    public static void cleanChatRoom(Context ctx, String roomJid, boolean isOldEvent) {
        if (roomJid == null) {
            return;
        }
        if (JidUtil.isChatJid(roomJid)) {
            ChatRoomManager.selfLeaveChatRoom(ctx, roomJid);
        } else {
            ChatRoomManager.selfLeaveConfRoom(ctx, roomJid, isOldEvent);
        }
    }

    public static boolean checkLoginUserIsOwner(Context ctx, JSONArray ownerObj) throws JSONException {
        List list = (List)new Gson().fromJson(ownerObj.toString(), new TypeToken<List<RoomMember>>(){}.getType());
        String myJid = PreferencesUtil.getUserJid(ctx);
        if (list != null && !list.isEmpty()) {
            for (RoomMember member : list) {
                String jid = member.getJid();
                if (!myJid.equalsIgnoreCase(jid)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean parseChatRoomParticipant(Context ctx, JSONArray ownerObj, String roomJid) throws JSONException {
        ArrayList<String> existParticipantList = UCDBChatRoom.findChatRoomParticipants(ctx, roomJid);
        boolean addOwner = ChatRoomManager.syncChatRoomParticipantInfo(ctx, ownerObj, 2, existParticipantList, roomJid);
        boolean deleteParticipant = false;
        if (existParticipantList.size() > 0) {
            deleteParticipant = true;
            for (String jid : existParticipantList) {
                Log.d(ChatRoomManager.class.getSimpleName(), "remove participant:" + jid + " to room:" + roomJid);
                UCDBChatRoom.deleteChatRoomParticipant(ctx, roomJid, jid);
            }
        }
        return addOwner || deleteParticipant;
    }

    public static boolean syncChatRoomParticipantInfo(Context ctx, JSONArray arr, int participantRole, List<String> existParticipantList, String roomJid) {
        List list = (List)new Gson().fromJson(arr.toString(), new TypeToken<List<RoomMember>>(){}.getType());
        boolean result = false;
        if (list != null && !list.isEmpty()) {
            for (RoomMember member : list) {
                boolean newRecord;
                String jid = member.getJid();
                LiteContact contact = ContactManager.getContact(ctx, jid);
                if (contact == null) {
                    FetchEmpTaskController.getInstance(ctx).addTaskNoScopeCheck(jid);
                }
                if (newRecord = ChatRoomManager.checkAndAddParticipant(ctx, roomJid, jid)) {
                    result = true;
                }
                existParticipantList.remove(jid);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkAndAddParticipant(Context ctx, String roomJid, String jid) {
        boolean result = false;
        if (jid == null) {
            return result;
        }
        Object object = chatRoomParticipantLock;
        synchronized (object) {
            if (!UCDBChatRoom.existChatRoomParticipantById(ctx, roomJid, jid)) {
                Log.d(ChatRoomManager.class.getSimpleName(), "add participant:" + jid + " to room:" + roomJid);
                UCDBChatRoom.addChatRoomParticipant(ctx, roomJid, 2, jid);
                result = true;
            }
        }
        return result;
    }

    public static void markMsgAsRead(Context ctx, Message msg) {
        if (msg == null || msg.isRead()) {
            return;
        }
        msg.setRead(true);
        UCDBMessage.updateChatRoomMsgReadStatus(ctx, msg.getId());
        if (msg.getChatEventId() > 0L) {
            UCDBRemoteMark.deleteRemoteMark(ctx, 3, msg.getChatEventId());
            WebAgent.getInstance().markChatEventAsRead(msg.getChatEventId());
        }
    }

    public static void markMsgAsPlayed(Context ctx, Message msg) {
        if (msg == null || msg.isPlayed()) {
            return;
        }
        msg.setPlayed(true);
        UCDBMessage.updateChatRoomMsgPlayedStatus(ctx, msg.getId());
        if (msg.getChatEventId() > 0L) {
            UCDBRemoteMark.deleteRemoteMark(ctx, 9, msg.getChatEventId());
            WebAgent.getInstance().markChatEventAsPlayed(msg.getChatEventId());
        }
    }

    public static Message getMsg(Context ctx, long msgId) {
        Message msg = UCDBMessage.getMsg(ctx, msgId);
        ChatRoomManager.checkLazy(ctx, msg);
        return msg;
    }

    public static void checkLazy(Context ctx, Message msg) {
        if (!msg.isLazyContent()) {
            return;
        }
        int msgType = msg.getMsgType();
        if (msgType == 5 || msgType == 4 || msgType == 1 || msgType == 6) {
            if (msg.getContent() == null) {
                ChatEventDownloadController.getInstance(ctx).addTask(msg.getChatEventId());
            }
        } else if (msgType == 11) {
            if (msg.getContent() == null && msg.getFileNameForDisp() != null && msg.getFileNameForDisp().endsWith(".tiff")) {
                ChatEventDownloadController.getInstance(ctx).addTask(msg.getChatEventId());
            }
        } else if (msgType == 99 && msg.getNoticeThumbnail() != null && "<LAZY>".equals(msg.getNoticeThumbnail())) {
            ChatEventDownloadController.getInstance(ctx).addTask(msg.getChatEventId());
        }
    }

    public static void clearChatMsg(Context ctx, String roomJid) {
        Long oldFirstEventId = UCDBMessage.getOldestEventId(ctx);
        List<String[]> urlList = UCDBMessage.findMsgUrlList(ctx, roomJid);
        for (String[] url : urlList) {
            ChatRoomManager.cleanCacheFileUrl(url[0]);
            ChatRoomManager.cleanCacheFileName(url[1]);
        }
        UCDBMessage.deleteMessages(ctx, roomJid);
        Long newFirstEventId = UCDBMessage.getOldestEventId(ctx);
        if (newFirstEventId != 0L) {
            if (oldFirstEventId != newFirstEventId) {
                WebAgent.getInstance().updateOldestChatEventId(newFirstEventId);
            }
        } else {
            WebAgent.getInstance().updateOldestChatEventIdToCurrent();
        }
    }

    public static void clearChatMsgByTimestamp(Context ctx, String roomJid, long timestamp) {
        Long oldFirstEventId = UCDBMessage.getOldestEventId(ctx);
        List<String[]> urlList = UCDBMessage.findMsgUrlList(ctx, roomJid, timestamp);
        for (String[] url : urlList) {
            ChatRoomManager.cleanCacheFileUrl(url[0]);
            ChatRoomManager.cleanCacheFileName(url[1]);
        }
        UCDBMessage.deleteMessages(ctx, roomJid, timestamp);
        Long newFirstEventId = UCDBMessage.getOldestEventId(ctx);
        if (newFirstEventId != 0L) {
            if (oldFirstEventId != newFirstEventId) {
                WebAgent.getInstance().updateOldestChatEventId(newFirstEventId);
            }
        } else {
            WebAgent.getInstance().updateOldestChatEventIdToCurrent();
        }
    }

    public static void clearSpecificChatMsg(Context ctx, Long msgId) {
        Long oldFirstEventId = UCDBMessage.getOldestEventId(ctx);
        String[] url = UCDBMessage.findMsgUrlListByMsgId(ctx, msgId);
        if (url != null) {
            ChatRoomManager.cleanCacheFileUrl(url[0]);
            ChatRoomManager.cleanCacheFileName(url[1]);
        }
        UCDBMessage.deleteMessage(ctx, msgId);
        Long newFirstEventId = UCDBMessage.getOldestEventId(ctx);
        if (newFirstEventId != 0L) {
            if (oldFirstEventId != newFirstEventId) {
                WebAgent.getInstance().updateOldestChatEventId(newFirstEventId);
            }
        } else {
            WebAgent.getInstance().updateOldestChatEventIdToCurrent();
        }
    }

    public static void clearSpecificChatMsg(Context ctx, String packetId) {
        Long oldFirstEventId = UCDBMessage.getOldestEventId(ctx);
        String[] url = UCDBMessage.findMsgUrlListPacketId(ctx, packetId);
        if (url != null) {
            ChatRoomManager.cleanCacheFileUrl(url[0]);
            ChatRoomManager.cleanCacheFileName(url[1]);
        }
        UCDBMessage.deleteChatRoomMsg(ctx, packetId);
        Long newFirstEventId = UCDBMessage.getOldestEventId(ctx);
        if (newFirstEventId != 0L) {
            if (oldFirstEventId != newFirstEventId) {
                WebAgent.getInstance().updateOldestChatEventId(newFirstEventId);
            }
        } else {
            WebAgent.getInstance().updateOldestChatEventIdToCurrent();
        }
    }

    public static void clearAllChatMsg(Context ctx) {
        UCDBMessage.deleteAllMessages(ctx);
        WebAgent.getInstance().updateOldestChatEventIdToCurrent();
    }

    private static void cleanCacheFileUrl(String url) {
        try {
            if (StringUtils.isBlank((CharSequence)url)) {
                return;
            }
            File cacheFile = FileUtil.getDownloadCacheFile(url);
            if (cacheFile.exists()) {
                cacheFile.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void cleanCacheFileName(String fileName) {
        try {
            if (StringUtils.isBlank((CharSequence)fileName)) {
                return;
            }
            File validNameFile = new File(FileUtil.getTempDir(), FileUtil.extractFileName(fileName));
            if (validNameFile != null && validNameFile.exists()) {
                validNameFile.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void recallMsg(Context ctx, String packetId) {
        Message msg = UCDBMessage.findMsgByPacketId(ctx, packetId);
        if (msg == null) {
            return;
        }
        String[] urlFileResult = UCDBMessage.findMsgUrlListPacketId(ctx, packetId);
        if (urlFileResult != null) {
            ChatRoomManager.cleanCacheFileUrl(urlFileResult[0]);
            ChatRoomManager.cleanCacheFileName(urlFileResult[1]);
        }
        UCDBMessage.recallChatRoomMsg(ctx, packetId);
    }

    static {
        String emoticonSmallURI;
        String emoticonSmallPath;
        String emoticonLargeURI;
        String emoticonLargePath;
        Enumeration<?> en;
        InputStreamReader ris;
        InputStream is;
        emoticonOldKeys = new ArrayList<String>();
        emoticonOldPathMap = new Properties();
        emoticonKeys = new ArrayList<String>();
        emoticonPathMap = new Properties();
        emoticonLargeURLMap = new Properties();
        emoticonSmallURLMap = new Properties();
        stickerKeys = new ArrayList<String>();
        stickerPathMap = new Properties();
        stickerURLMap = new Properties();
        idiomKeys = new ArrayList<String>();
        idiomMap = new Properties();
        symbolKeys = new ArrayList<String>();
        symbolMap = new Properties();
        phoneIconPathMap = new Properties();
        phoneIconURLMap = new Properties();
        try {
            is = ChatRoomManager.class.getClassLoader().getResourceAsStream("emoticon_v1.properties");
            ris = new InputStreamReader(is, "UTF-8");
            emoticonOldPathMap.load(ris);
            en = emoticonOldPathMap.propertyNames();
            emoticonOldKeys = Collections.list(en);
            Collections.sort(emoticonOldKeys);
            for (String emoticonKey : emoticonOldKeys) {
                emoticonLargePath = PATH_EMOTICON_V1_LARGE + emoticonOldPathMap.getProperty(emoticonKey);
                emoticonLargeURI = ChatRoomManager.class.getClassLoader().getResource(emoticonLargePath).toURI().toString();
                emoticonLargeURLMap.put(emoticonKey, emoticonLargeURI);
                emoticonSmallPath = PATH_EMOTICON_V1_SMALL + emoticonOldPathMap.getProperty(emoticonKey);
                emoticonSmallURI = ChatRoomManager.class.getClassLoader().getResource(emoticonSmallPath).toURI().toString();
                emoticonSmallURLMap.put(emoticonKey, emoticonSmallURI);
            }
            ris.close();
            is.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            is = ChatRoomManager.class.getClassLoader().getResourceAsStream("emoticon_v2.properties");
            ris = new InputStreamReader(is, "UTF-8");
            emoticonPathMap.load(ris);
            en = emoticonPathMap.propertyNames();
            emoticonKeys = Collections.list(en);
            Collections.sort(emoticonKeys);
            for (String emoticonKey : emoticonKeys) {
                emoticonLargePath = PATH_EMOTICON_V2_LARGE + emoticonPathMap.getProperty(emoticonKey);
                emoticonLargeURI = ChatRoomManager.class.getClassLoader().getResource(emoticonLargePath).toURI().toString();
                emoticonLargeURLMap.put(emoticonKey, emoticonLargeURI);
                emoticonSmallPath = PATH_EMOTICON_V2_SMALL + emoticonPathMap.getProperty(emoticonKey);
                emoticonSmallURI = ChatRoomManager.class.getClassLoader().getResource(emoticonSmallPath).toURI().toString();
                emoticonSmallURLMap.put(emoticonKey, emoticonSmallURI);
            }
            ris.close();
            is.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            is = ChatRoomManager.class.getClassLoader().getResourceAsStream("sticker.properties");
            ris = new InputStreamReader(is, "UTF-8");
            stickerPathMap.load(ris);
            en = stickerPathMap.propertyNames();
            stickerKeys = Collections.list(en);
            Collections.sort(stickerKeys);
            for (String stickerKey : stickerKeys) {
                String stickerPath = stickerPathMap.getProperty(stickerKey);
                String stickerURI = ChatRoomManager.class.getClassLoader().getResource(stickerPath).toURI().toString();
                stickerURLMap.put(stickerKey, stickerURI);
            }
            ris.close();
            is.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            is = ChatRoomManager.class.getClassLoader().getResourceAsStream("symbol.properties");
            ris = new InputStreamReader(is, "UTF-8");
            symbolMap.load(ris);
            en = symbolMap.propertyNames();
            symbolKeys = Collections.list(en);
            Collections.sort(symbolKeys);
            ris.close();
            is.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            is = ChatRoomManager.class.getClassLoader().getResourceAsStream("idiom.properties");
            ris = new InputStreamReader(is, "UTF-8");
            idiomMap.load(ris);
            en = idiomMap.propertyNames();
            idiomKeys = Collections.list(en);
            Collections.sort(idiomKeys);
            ris.close();
            is.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        try {
            phoneIconPathMap.put("[PHONE_TALKING]", "images/phone/chatcall_s.png");
            phoneIconPathMap.put("[PHONE_CANCEL]", "images/phone/chatcall_miss_s.png");
            phoneIconPathMap.put("[PHONE_CANCEL_IN]", "images/phone/chatcall_miss_s.png");
            phoneIconPathMap.put("[PHONE_CANCEL_OUT]", "images/phone/chatcall_miss_s.png");
            phoneIconPathMap.put("[PHONE_VOICEMAIL]", "images/phone/voicemail.png");
            phoneIconPathMap.put("[PHONE_RECORDING]", "images/phone/recording.png");
            phoneIconURLMap.put("[PHONE_TALKING]", ChatRoomManager.class.getClassLoader().getResource("images/phone/chatcall_s.png").toURI().toString());
            phoneIconURLMap.put("[PHONE_CANCEL]", ChatRoomManager.class.getClassLoader().getResource("images/phone/chatcall_miss_s.png").toURI().toString());
            phoneIconURLMap.put("[PHONE_CANCEL_IN]", ChatRoomManager.class.getClassLoader().getResource("images/phone/chatcall_miss_s.png").toURI().toString());
            phoneIconURLMap.put("[PHONE_CANCEL_OUT]", ChatRoomManager.class.getClassLoader().getResource("images/phone/chatcall_miss_s.png").toURI().toString());
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        chatRoomLock = new Object();
        chatRoomParticipantLock = new Object();
    }
}

