/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoomAuthType;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.annotation.MigratedFromMobileApp;
import com.blisscloud.ezuc.client.component.GlassPanelCallback;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.ConferenceUtil;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.VerifyPinCodePanel;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@MigratedFromMobileApp
public class ConferenceHelper {
    private IntentFilter mFilter;
    private VerifyBroadcastReceiver mReceiver;
    private Context mCtx;
    private String mChatRoomId;
    private long mRoomId;
    private Long mEmpId;
    private String mRole;
    private String mRoomName;
    private LiteConferenceRoom mConferenceRoom;
    private VerifyResult mVerifyCallback;
    private VerifyPinCodePanel mPanelVerifyPinCode;
    private boolean pinCodeVerifyDone;

    public ConferenceHelper(Context ctx, long roomId, VerifyResult verifyResultCallback) {
        this.mCtx = ctx;
        this.mVerifyCallback = verifyResultCallback;
        this.mRoomId = roomId;
        this.mConferenceRoom = MeetmeManager.getMeetme(this.mCtx, roomId);
        if (this.mConferenceRoom != null) {
            this.mChatRoomId = this.mConferenceRoom.getChatRoomId();
            this.mRoomName = this.mConferenceRoom.getName();
        }
        this.mFilter = new IntentFilter();
        this.mFilter.addAction("ezuc.intent.action.event.VERIFY_CONFERENCE_PIN_CODE_RESULT");
        this.mFilter.addAction("ezuc.intent.action.event.FETCH_CONFERENCE_ROOM_MEMBER_LIST");
        this.mFilter.addAction("ezuc.intent.action.event.EXE_CHATROOM_JOIN_DONE");
        this.mReceiver = new VerifyBroadcastReceiver();
        this.mCtx.registerReceiver(this.mReceiver, this.mFilter);
    }

    public void release() {
        this.mCtx.unregisterReceiver(this.mReceiver);
        if (this.mPanelVerifyPinCode != null && !this.pinCodeVerifyDone) {
            this.mPanelVerifyPinCode.verifyPinCodeCancelled();
        }
    }

    public void doVerify() {
        long userid = PreferencesUtil.getUserId(this.mCtx);
        this.mRole = ConferenceUtil.getRole(this.mConferenceRoom, this.mCtx, userid);
        if (this.isInChatRoom(this.mChatRoomId)) {
            if (TextUtils.isBlank((CharSequence)this.mRole)) {
                this.mRole = "user";
            }
            if (this.mVerifyCallback != null) {
                this.mVerifyCallback.verifyOK();
            }
            return;
        }
        if ("admin".equals(this.mRole)) {
            this.joinConference();
        } else if ("user".equals(this.mRole) || "member".equals(this.mRole)) {
            if (this.mConferenceRoom.isLocked()) {
                this.verifyFailed(506, "Room " + this.mRoomName + " is locked, cannot join.", I18NUtil.getString("conference_notice_join_failed_locked"));
                return;
            }
            this.joinConference();
        } else {
            LiteConferenceRoomAuthType type = this.mConferenceRoom.getAuthType();
            Long roomid = this.mConferenceRoom.getRoomId();
            if (type.equals((Object)LiteConferenceRoomAuthType.PIN_CODE)) {
                this.showVerifyDialog();
            } else if (type.equals((Object)LiteConferenceRoomAuthType.MEMBER_COMPARE)) {
                WebAgent.getInstance().getConferenceRoomMemberList(roomid);
            } else {
                this.verifyFailed(507, "Room " + this.mRoomName + " got fail authType:" + type.toString(), null);
            }
        }
    }

    private void handleChatRoomJoinResult(Context context, Intent intent) {
        String chatRoomId = intent.getStringExtra("chatId");
        if (this.mConferenceRoom != null && !this.mConferenceRoom.getChatRoomId().equals(chatRoomId)) {
            return;
        }
        String doneInfo = String.format(I18NUtil.getString("conference_notice_join_done"), this.mConferenceRoom.getName());
        ToastUtil.show(context, doneInfo, 10);
        this.pinCodeVerifyDone = true;
        if (this.mPanelVerifyPinCode != null) {
            this.mPanelVerifyPinCode.verifyPinCodeSucceed(doneInfo);
        }
        if (this.mVerifyCallback != null) {
            this.mVerifyCallback.verifyOK();
        }
    }

    private void handleMemberVerifyCompareResult(Intent intent) {
        try {
            long roomId = intent.getLongExtra("roomId", -1L);
            if (this.mConferenceRoom != null && this.mConferenceRoom.getRoomId() != roomId) {
                return;
            }
            int retCode = intent.getIntExtra("returnCode", -1);
            if (retCode != 0) {
                this.verifyFailed(500, "Check room " + this.mRoomName + " member list, reutn code is " + retCode);
                return;
            }
            String obj = intent.getStringExtra("jsonData");
            Log.i(this.getClass().getSimpleName(), "VERIFY_MEMBER_LIST_EVENTR obj:" + obj);
            String role = null;
            if (this.mEmpId == null) {
                String jid = PreferencesUtil.getUserJid(this.mCtx);
                this.mEmpId = UCDBContact.getEmpIdByJid(this.mCtx, jid);
            }
            JSONArray jarr = new JSONArray(obj);
            int length = jarr.length();
            for (int i = 0; i < length; ++i) {
                JSONObject json = (JSONObject)jarr.get(i);
                long empid = json.getLong("employeeId");
                if (this.mEmpId != empid) continue;
                role = json.getString("role");
                break;
            }
            if (TextUtils.isBlank(role)) {
                this.verifyFailed(501, "Check room " + this.mRoomName + " member list, role is empty.");
                return;
            }
            if ("CHAIRMAN".equals(role) && "MANAGER".equals(role)) {
                role = "admin";
            } else if ("MEMBER".equals(role)) {
                role = "member";
            }
            this.mRole = role;
            if (this.mConferenceRoom.isLocked() && !"admin".equals(this.mRole)) {
                this.verifyFailed(502, "Check room " + this.mRoomName + " member list, room is locked, no permission to join.", I18NUtil.getString("conference_notice_join_failed_locked"));
                return;
            }
            UserDatabase database = UserDatabase.getDB(this.mCtx);
            long id = database.insertConferenceRoleInfo(role, this.mRoomId);
            if (id == -1L) {
                this.verifyFailed(503, "Check room " + this.mRoomName + " member list, save role failed.");
                return;
            }
            this.joinConference();
        }
        catch (JSONException e) {
            Log.e(this.getClass().getSimpleName(), "VERIFY_MEMBER_LIST fail!:", e);
            this.verifyFailed(504, "Check room " + this.mRoomName + " member list, save role failed.");
        }
    }

    private void verifyFailed(int errorCode, String errorMsg, String alertMsg) {
        Log.e(this.getClass().getSimpleName(), errorMsg);
        if (StringUtils.isNotBlank((CharSequence)alertMsg)) {
            ToastUtil.showErrorShort(alertMsg);
        }
        if (this.mVerifyCallback != null) {
            this.mVerifyCallback.verifyFailed(errorCode, errorMsg);
        }
    }

    private void verifyFailed(int errorCode, String errorMsg) {
        this.verifyFailed(errorCode, errorMsg, I18NUtil.getString("conference_notice_join_failed_unknown"));
    }

    private void handlePinCodeVerifyResult(Intent intent) {
        try {
            long roomId = intent.getLongExtra("roomId", -1L);
            if (this.mConferenceRoom != null && this.mConferenceRoom.getRoomId() != roomId) {
                return;
            }
            int retCode = intent.getIntExtra("returnCode", -1);
            if (retCode != 0) {
                this.showPinCodeGeneralFailedError();
                return;
            }
            String obj = intent.getStringExtra("jsonData");
            Log.i(this.getClass().getSimpleName(), "VERIFY_PIN_CODE_EVENT:" + obj);
            JSONObject json = new JSONObject(obj);
            String role = json.getString("result");
            if ("fail".equals(role)) {
                this.showPinCodeGeneralFailedError();
                return;
            }
            this.mRole = role;
            if (this.mConferenceRoom.isLocked() && !"admin".equals(this.mRole)) {
                this.showPinCodeFailedError(I18NUtil.getString("conference_notice_join_failed_locked"));
                return;
            }
            UserDatabase database = UserDatabase.getDB(this.mCtx);
            long id = database.insertConferenceRoleInfo(role, this.mRoomId);
            if (id == -1L) {
                Log.e(this.getClass().getSimpleName(), " insert fail!:" + id);
                this.showPinCodeGeneralFailedError();
                return;
            }
            this.joinConference();
        }
        catch (JSONException e) {
            this.showPinCodeGeneralFailedError();
        }
    }

    private void showPinCodeFailedError(String msg) {
        Log.e(this.getClass().getSimpleName(), "VERIFY_PIN_CODE_FAILED: " + msg);
        if (this.mPanelVerifyPinCode != null) {
            this.mPanelVerifyPinCode.verifyPinCodeFailed(msg);
        }
    }

    private void showPinCodeGeneralFailedError() {
        this.showPinCodeFailedError(I18NUtil.getString("conference_notice_pin_error"));
    }

    private void showVerifyDialog() {
        this.mPanelVerifyPinCode = new VerifyPinCodePanel(this.mRoomId);
        UCChatClient.getInstance().showGlassPanel(this.mPanelVerifyPinCode, true, new GlassPanelCallback(){

            @Override
            public void onHide() {
                ConferenceHelper.this.mPanelVerifyPinCode = null;
                if (!ConferenceHelper.this.pinCodeVerifyDone) {
                    ConferenceHelper.this.verifyFailed(505, "Room " + ConferenceHelper.this.mRoomName + " pin code verify cancelled.", null);
                }
            }
        });
        this.mPanelVerifyPinCode.focusTextField();
    }

    private boolean isInChatRoom(String chatRoomId) {
        if (TextUtils.isNotBlank((CharSequence)chatRoomId)) {
            return UCDBChatRoom.hasParticipants(this.mCtx, chatRoomId);
        }
        return false;
    }

    private void joinConference() {
        WebAgent.getInstance().joinChatRoom(this.mChatRoomId);
    }

    protected void finalize() {
        Log.i(ConferenceHelper.class.getSimpleName(), "finalize conference helper for room " + this.mRoomName);
    }

    public static interface VerifyResult {
        public void verifyOK();

        public void verifyFailed(int var1, String var2);
    }

    private class VerifyBroadcastReceiver
    extends BroadcastReceiver {
        private VerifyBroadcastReceiver() {
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("ezuc.intent.action.event.VERIFY_CONFERENCE_PIN_CODE_RESULT".equals(action)) {
                ConferenceHelper.this.handlePinCodeVerifyResult(intent);
            } else if ("ezuc.intent.action.event.FETCH_CONFERENCE_ROOM_MEMBER_LIST".equals(action)) {
                ConferenceHelper.this.handleMemberVerifyCompareResult(intent);
            } else if ("ezuc.intent.action.event.EXE_CHATROOM_JOIN_DONE".equals(action)) {
                ConferenceHelper.this.handleChatRoomJoinResult(context, intent);
            }
        }
    }

    private class MemberListResult {
        private static final String MEMBER = "MEMBER";
        private static final String CHAIRMAN = "CHAIRMAN";
        private static final String MANAGER = "MANAGER";

        private MemberListResult(ConferenceHelper conferenceHelper) {
        }
    }
}

