/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.Device;
import com.blisscloud.mobile.ezuc.bean.LoginDeviceItem;
import com.blisscloud.mobile.ezuc.callback.WebConnectionListener;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.DeviceKey;
import com.blisscloud.mobile.ezuc.manager.SiteManager;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceManager {
    private static final String KEY_SITEID = "siteId";
    private static final String KEY_DEVICEINFO = "deviceInfos";
    private static final String KEY_RINGIN = "ringInFlag";
    private static final String KEY_RINGOUT = "ringOutFlag";
    private static final String KEY_DEVICETYPE = "deviceType";
    private static final String KEY_REGISTERED = "registerFlag";
    private static final String KEY_DEVICEID = "deviceId";
    private static final String KEY_DEVICE_DESCR = "descr";

    public static synchronized Map<Long, List<Device>> getDeviceInfos(Context context) {
        String deviceinfoJson = PreferencesUtil.getDeviceInfo(context);
        return DeviceManager.parseDeviceInfo(deviceinfoJson);
    }

    private static synchronized Map<Long, List<Device>> parseDeviceInfo(String obj) {
        HashMap<Long, List<Device>> map = new HashMap<Long, List<Device>>();
        if (TextUtils.isBlank((CharSequence)obj)) {
            return map;
        }
        JSONArray array = null;
        try {
            array = new JSONArray(obj);
            int size = array.length();
            for (int i = 0; i < size; ++i) {
                JSONArray siteArray;
                JSONObject item = array.getJSONObject(i);
                long siteid = item.getInt(KEY_SITEID);
                if (!item.has(KEY_DEVICEINFO) || (siteArray = item.getJSONArray(KEY_DEVICEINFO)).length() <= 0) continue;
                ArrayList<Device> data = DeviceManager.parseSingleSiteDeviceInfo(siteArray, siteid);
                map.put(siteid, data);
            }
        }
        catch (JSONException e) {
            Log.e(DeviceManager.class.getSimpleName(), "parseDeviceInfo", e);
        }
        return map;
    }

    private static synchronized ArrayList<Device> parseSingleSiteDeviceInfo(JSONArray arr, long siteId) {
        ArrayList<Device> data = new ArrayList<Device>();
        try {
            if (arr != null) {
                int size = arr.length();
                for (int i = 0; i < size; ++i) {
                    int lastIndex;
                    String descr;
                    JSONObject o = (JSONObject)arr.get(i);
                    boolean registered = o.getBoolean(KEY_REGISTERED);
                    boolean ringIn = o.getBoolean(KEY_RINGIN);
                    boolean ringOut = o.getBoolean(KEY_RINGOUT);
                    String deviceId = o.getString(KEY_DEVICEID);
                    int deviceType = o.getInt(KEY_DEVICETYPE);
                    String string = descr = o.has(KEY_DEVICE_DESCR) ? o.getString(KEY_DEVICE_DESCR) : "";
                    if (deviceType == 1 && TextUtils.isNotBlank((CharSequence)descr) && (lastIndex = descr.lastIndexOf("-")) != -1) {
                        descr = descr.substring(0, lastIndex);
                    }
                    Device d = new Device();
                    d.setDeviceId(deviceId);
                    d.setDescr(descr);
                    d.setDeviceType(deviceType);
                    d.setRegistered(registered);
                    d.setRingIn(ringIn);
                    d.setRingOut(ringOut);
                    d.setSiteId(siteId);
                    data.add(d);
                }
            }
        }
        catch (JSONException e) {
            Log.e(DeviceManager.class.getSimpleName(), "parseSingleSiteDeviceInfo", e);
        }
        return data;
    }

    public static synchronized void updateDeviceInfos(Context ctx, String loginSipId) {
        Map<Long, List<Device>> originalDeviceInfos = DeviceManager.getDeviceInfos(ctx);
        Set<Long> sites = originalDeviceInfos.keySet();
        Iterator<Long> i = sites.iterator();
        JSONArray jarr = new JSONArray();
        try {
            while (i.hasNext()) {
                Long site = i.next();
                JSONObject siteObj = new JSONObject();
                siteObj.put(KEY_SITEID, site);
                List<Device> devices = originalDeviceInfos.get(site);
                for (int x = 0; devices != null && x < devices.size(); ++x) {
                    Device d = devices.get(x);
                    if (d.getDeviceId() == null || loginSipId == null || !d.getDeviceId().equals(loginSipId)) continue;
                    d.setRingIn(!d.isRingIn());
                    d.setRingOut(!d.isRingOut());
                }
                JSONArray deviceArr = DeviceManager.getDeviceArray(devices);
                siteObj.put(KEY_DEVICEINFO, deviceArr);
                jarr.put(siteObj);
            }
            WebAgent.getInstance().updateDeviceInfo(jarr.toString());
        }
        catch (JSONException e) {
            Log.e(DeviceManager.class.getSimpleName(), "saveChange", e);
        }
    }

    private static synchronized JSONArray getDeviceArray(List<Device> devices) {
        JSONArray jarr = new JSONArray();
        try {
            for (Device d : devices) {
                JSONObject temp = new JSONObject();
                temp.put(KEY_DEVICEID, d.getDeviceId());
                temp.put(KEY_DEVICETYPE, d.getDeviceType());
                temp.put(KEY_RINGIN, d.isRingIn());
                temp.put(KEY_RINGOUT, d.isRingOut());
                temp.put(KEY_REGISTERED, d.isRegistered());
                jarr.put(temp);
            }
        }
        catch (JSONException e) {
            Log.e(DeviceManager.class.getSimpleName(), "getDeviceArray", e);
        }
        return jarr;
    }

    public static synchronized void updateLoginDeviceList(Context ctx, Object dataArray) {
        if (dataArray == null) {
            return;
        }
        String oldDeviceInfoStr = PreferencesUtil.getDeviceInfo(ctx);
        Set<DeviceKey> hardPhoneDeviceIdSet = DeviceManager.getHardPhoneDeviceKeySet(DeviceManager.parseDeviceInfo(oldDeviceInfoStr));
        int otherDeviceCount = hardPhoneDeviceIdSet.size();
        String thisDeviceId = PreferencesUtil.getString(ctx, "DEVICEID", "");
        String oldLoginDeviceStr = PreferencesUtil.getString(ctx, "LOGIN_DEVICES", "");
        Set<String> oldLoginDeviceIdSet = DeviceManager.getDeviceIdSet(DeviceManager.getLoginDeviceItemListByStr(oldLoginDeviceStr));
        PreferencesUtil.putString(ctx, "LOGIN_DEVICES", dataArray.toString());
        List<LoginDeviceItem> newLoginDeviceList = DeviceManager.getLoginDeviceItemListByStr(dataArray.toString());
        ArrayList<LoginDeviceItem> newLoginList = new ArrayList<LoginDeviceItem>();
        for (int i = 0; newLoginDeviceList != null && i < newLoginDeviceList.size(); ++i) {
            LoginDeviceItem item = newLoginDeviceList.get(i);
            String newDeviceUniqueId = item.getDeviceUniqueId();
            if (!thisDeviceId.equalsIgnoreCase(newDeviceUniqueId)) {
                ++otherDeviceCount;
            }
            boolean isNewOne = true;
            if (oldLoginDeviceIdSet.contains(newDeviceUniqueId)) {
                isNewOne = false;
            }
            if (thisDeviceId.equalsIgnoreCase(newDeviceUniqueId)) {
                isNewOne = false;
            }
            if (!isNewOne) continue;
            newLoginList.add(item);
        }
        if (newLoginList.size() != 0) {
            PreferencesUtil.setMultiLoginAlertFlag(true);
        } else if (otherDeviceCount == 0) {
            PreferencesUtil.setMultiLoginAlertFlag(false);
        }
        BroadcastUtil.sendMultiLoginDeviceFlashEvent(ctx, otherDeviceCount);
    }

    public static synchronized void updateDeviceInfoList(Context ctx, JSONArray dataArray) {
        if (dataArray == null) {
            return;
        }
        int otherDeviceCount = 0;
        String oldDeviceInfoStr = PreferencesUtil.getDeviceInfo(ctx);
        Set<DeviceKey> oldHardPhoneDeviceIdSet = DeviceManager.getHardPhoneDeviceKeySet(DeviceManager.parseDeviceInfo(oldDeviceInfoStr));
        Set<DeviceKey> newHardPhoneDeviceIdSet = DeviceManager.getHardPhoneDeviceKeySet(DeviceManager.parseDeviceInfo(dataArray.toString()));
        otherDeviceCount = newHardPhoneDeviceIdSet.size();
        HashSet<DeviceKey> keepDeviceIdSet = new HashSet<DeviceKey>(oldHardPhoneDeviceIdSet);
        keepDeviceIdSet.retainAll(newHardPhoneDeviceIdSet);
        newHardPhoneDeviceIdSet.removeAll(keepDeviceIdSet);
        PreferencesUtil.setDeviceInfo(ctx, dataArray.toString());
        DeviceManager.setIsMakeCallRingMe(ctx, dataArray);
        String thisDeviceId = PreferencesUtil.getString(ctx, "DEVICEID", "");
        String oldLoginDeviceStr = PreferencesUtil.getString(ctx, "LOGIN_DEVICES", "");
        List<LoginDeviceItem> newLoginDeviceList = DeviceManager.getLoginDeviceItemListByStr(oldLoginDeviceStr);
        for (int i = 0; newLoginDeviceList != null && i < newLoginDeviceList.size(); ++i) {
            LoginDeviceItem item = newLoginDeviceList.get(i);
            String newDeviceUniqueId = item.getDeviceUniqueId();
            if (thisDeviceId.equalsIgnoreCase(newDeviceUniqueId)) continue;
            ++otherDeviceCount;
        }
        if (newHardPhoneDeviceIdSet.size() != 0) {
            PreferencesUtil.setMultiLoginAlertFlag(true);
        } else if (otherDeviceCount == 0) {
            PreferencesUtil.setMultiLoginAlertFlag(false);
        }
        BroadcastUtil.sendMultiLoginDeviceFlashEvent(ctx, otherDeviceCount);
    }

    private static Set<String> getDeviceIdSet(List<LoginDeviceItem> loginDeviceList) {
        if (loginDeviceList == null) {
            return new HashSet<String>();
        }
        HashSet<String> deviceIdSet = new HashSet<String>();
        if (loginDeviceList != null && loginDeviceList.size() > 0) {
            for (LoginDeviceItem item : loginDeviceList) {
                deviceIdSet.add(item.getDeviceUniqueId());
            }
        }
        return deviceIdSet;
    }

    private static Set<DeviceKey> getHardPhoneDeviceKeySet(Map<Long, List<Device>> deviceSiteMap) {
        if (deviceSiteMap == null) {
            return new HashSet<DeviceKey>();
        }
        HashSet<DeviceKey> deviceKeySet = new HashSet<DeviceKey>();
        if (deviceSiteMap != null) {
            Set<Long> keySet = deviceSiteMap.keySet();
            for (Long siteId : keySet) {
                List<Device> deviceInfo = deviceSiteMap.get(siteId);
                for (int a = 0; deviceInfo != null && a < deviceInfo.size(); ++a) {
                    Device d = deviceInfo.get(a);
                    if (!d.isRegistered() || d.getDeviceType() != 0) continue;
                    DeviceKey deviceKey = new DeviceKey();
                    deviceKey.setSiteId(siteId);
                    deviceKey.setDeviceId(d.getDeviceId());
                    deviceKeySet.add(deviceKey);
                }
            }
        }
        return deviceKeySet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<LoginDeviceItem> getLoginDeviceItemListByStr(String oldLoginDeviceStr) {
        ArrayList<LoginDeviceItem> newLoginDeviceList;
        block13: {
            newLoginDeviceList = new ArrayList<LoginDeviceItem>();
            if (!TextUtils.isBlank((CharSequence)oldLoginDeviceStr)) break block13;
            ArrayList<LoginDeviceItem> arrayList = newLoginDeviceList;
            return arrayList;
        }
        try {
            JSONArray ary = new JSONArray(oldLoginDeviceStr);
            for (int i = 0; ary != null && i < ary.length(); ++i) {
                LoginDeviceItem item = new LoginDeviceItem();
                JSONObject deviceObj = ary.getJSONObject(i);
                if (deviceObj.has("deviceName")) {
                    item.setDeviceName(deviceObj.getString("deviceName"));
                }
                if (deviceObj.has("deviceUniqueId")) {
                    item.setDeviceUniqueId(deviceObj.getString("deviceUniqueId"));
                }
                if (deviceObj.has("appType")) {
                    item.setAppType(deviceObj.getString("appType"));
                }
                if (deviceObj.has("loginSip")) {
                    item.setLoginSipAccount(deviceObj.getString("loginSip"));
                }
                if (deviceObj.has("loginSiteId")) {
                    item.setLoginSiteId(deviceObj.getLong("loginSiteId"));
                }
                if (deviceObj.has("productType")) {
                    item.setProductType(deviceObj.getString("productType"));
                } else {
                    item.setProductType("0");
                }
                newLoginDeviceList.add(item);
            }
            ArrayList<LoginDeviceItem> arrayList = newLoginDeviceList;
            return arrayList;
        }
        catch (JSONException e) {
            Log.e(ContactManager.class.getSimpleName(), "parseLoginDeviceJson", e);
            List<LoginDeviceItem> list = null;
            return list;
        }
    }

    private static List<LoginDeviceItem> getCurrentLoginDeviceItemList(Context context) {
        String oldLoginDeviceStr = PreferencesUtil.getString(context, "LOGIN_DEVICES", "");
        return DeviceManager.getLoginDeviceItemListByStr(oldLoginDeviceStr);
    }

    public static void setIsMakeCallRingMe(Context context, JSONArray array) {
        if (array == null) {
            return;
        }
        long siteId = PreferencesUtil.getSipUsePbxSite(context);
        String sipName = PreferencesUtil.getSipUserName(context);
        if (siteId != -1L && TextUtils.isNotBlank((CharSequence)sipName)) {
            try {
                int size = array.length();
                for (int i = 0; i < size; ++i) {
                    JSONObject item = array.getJSONObject(i);
                    if (!item.has(KEY_SITEID) || siteId != item.getLong(KEY_SITEID)) continue;
                    JSONArray deviceInfos = item.getJSONArray(KEY_DEVICEINFO);
                    int jsize = deviceInfos.length();
                    for (int j = 0; j < jsize; ++j) {
                        JSONObject js = deviceInfos.getJSONObject(j);
                        if (!js.has(KEY_DEVICEID) || !sipName.equals(js.getString(KEY_DEVICEID)) || !js.has(KEY_RINGOUT)) continue;
                        PreferencesUtil.setMakeCallRingMe(context, js.getBoolean(KEY_RINGOUT));
                        Log.d(WebConnectionListener.class.getSimpleName(), "===== setIsMakeCallRingMe site:" + siteId + " " + sipName + " ringOutFlag:" + js.getBoolean(KEY_RINGOUT));
                    }
                    break;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public static List<LoginDeviceItem> getLoginDeviceItemList(Context context) {
        ArrayList<LoginDeviceItem> list = new ArrayList<LoginDeviceItem>();
        Map<Long, List<Device>> deviceInfos = DeviceManager.getDeviceInfos(context);
        List<LoginDeviceItem> loginDeviceList = DeviceManager.getCurrentLoginDeviceItemList(context);
        if (loginDeviceList != null) {
            for (LoginDeviceItem item : loginDeviceList) {
                if (TextUtils.isNotBlank((CharSequence)item.getLoginSipAccount()) && deviceInfos != null) {
                    Set<Long> keySet = deviceInfos.keySet();
                    for (Long key : keySet) {
                        List<Device> deviceInfo = deviceInfos.get(key);
                        for (int a = 0; deviceInfo != null && a < deviceInfo.size(); ++a) {
                            Device d = deviceInfo.get(a);
                            if (d.getDeviceId() == null || !d.getDeviceId().equals(item.getLoginSipAccount()) || item.getLoginSiteId() != -1L && d.getSiteId() != item.getLoginSiteId()) continue;
                            item.setDevice(d);
                            break;
                        }
                        if (item.getDevice() == null) continue;
                        break;
                    }
                }
                list.add(item);
            }
        }
        if (deviceInfos != null) {
            boolean mShowSite;
            Set<Long> keySet = deviceInfos.keySet();
            Iterator<Long> i = keySet.iterator();
            List<LiteSite> siteList = UCDBSite.getAllSites(context);
            boolean bl = mShowSite = siteList != null && siteList.size() > 1;
            while (i.hasNext()) {
                Long key;
                key = i.next();
                LiteSite site = SiteManager.getSite(context, key);
                List<Device> deviceInfo = deviceInfos.get(key);
                for (int a = 0; deviceInfo != null && a < deviceInfo.size(); ++a) {
                    Device d = deviceInfo.get(a);
                    if (!d.isRegistered() || d.getDeviceType() != 0) continue;
                    LoginDeviceItem item = new LoginDeviceItem();
                    item.setProductType(null);
                    item.setAppType("-1");
                    item.setDeviceUniqueId(d.getDeviceId());
                    item.setDevice(d);
                    if (mShowSite) {
                        item.setDeviceName("[" + site.getName() + "] " + I18NUtil.getString("logindevice_type_hardphone"));
                    } else {
                        item.setDeviceName(I18NUtil.getString("logindevice_type_hardphone"));
                    }
                    list.add(item);
                }
            }
        }
        return list;
    }
}

