/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteOutboundPrefix;
import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcher;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcherResult;
import com.blisscloud.mobile.ezuc.manager.SiteManager;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PhoneNoUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class DialoutManager {
    public static boolean verifyCondForLine(Context ctx) {
        if (!PreferencesUtil.hasPhoneCallLicense(ctx)) {
            ToastUtil.show(ctx, I18NUtil.getString("permission_no_voice_license"), 10);
            return false;
        }
        if (PhoneAgent.isRegistered != PhoneAgent.STAT_REGISTERED) {
            ToastUtil.show(ctx, I18NUtil.getString("phone_notice_not_connected"), 10);
            return false;
        }
        if (PhoneAgent.getInstance().isAvailableToCall() == PhoneAgent.LineAvailableType.NONE) {
            ToastUtil.show(ctx, I18NUtil.getString("phone_notice_in_call_now"), 10);
            return false;
        }
        return true;
    }

    public static void dialChatRoom(Context ctx, String chatRoomJid) {
        if (!DialoutManager.verifyCondForLine(ctx)) {
            return;
        }
        if (TextUtils.isBlank((CharSequence)chatRoomJid)) {
            Log.w(DialoutManager.class.getSimpleName(), "Invalid parameters, chatRoomJid is empty.");
            return;
        }
        PhoneLineInfo info = new PhoneLineInfo();
        ChatRoomInfo chatRoom = UCDBChatRoom.getChatRoom(ctx, chatRoomJid);
        LiteConferenceRoom confRoom = UCDBConf.getConfRoomByChatRoomId(ctx, chatRoom.getChatRoomId());
        String ext = null;
        if (confRoom != null) {
            String prefix = OutboundPrefixManager.getMeetmePrefix(ctx);
            ext = prefix + confRoom.getRoomNo();
        }
        if (chatRoom.getType() == 1) {
            name = ChatRoomUtil.getChatRoomTitle(ctx, chatRoom);
            info.setType(4);
            info.setJid(chatRoom.getChatRoomId());
            info.setSiteId(null);
            info.setNumberWithClean(ext);
            info.setName1(name);
            info.setName2(null);
        } else if (chatRoom.getType() == 2) {
            if (confRoom == null) {
                name = ChatRoomUtil.getChatRoomTitle(ctx, chatRoom);
                info.setType(4);
                info.setJid(chatRoom.getChatRoomId());
                info.setSiteId(null);
                info.setNumberWithClean(ext);
                info.setName1(name);
                info.setName2(null);
            } else {
                info.setType(5);
                info.setJid(chatRoom.getChatRoomId());
                info.setSiteId(null);
                info.setNumberWithClean(ext);
                info.setName1(confRoom.getName());
                info.setName2(null);
            }
        }
        if (JidUtil.isChatConfJid(chatRoomJid) && ext != null) {
            int lineId = PhoneAgent.getInstance().callChatRoomDir(ext, info);
            if (lineId == -1) {
                ToastUtil.show(UCChatClient.context, I18NUtil.getString("phone_notice_in_call_now"), 10);
            }
        } else if (ApiVersion.isApi17Later()) {
            PhoneAgent.getInstance().findChatRoomNumThenDial(info, chatRoomJid);
        } else {
            ToastUtil.show(UCChatClient.context, "indirectly to join conference is not supported.", 10);
        }
    }

    public static void dialEmp(Context ctx, String empJid) {
        if (!DialoutManager.verifyCondForLine(ctx)) {
            return;
        }
        if (TextUtils.isBlank((CharSequence)empJid)) {
            Log.w(DialoutManager.class.getSimpleName(), "Invalid parameters, empJid is empty.");
            return;
        }
        LiteContact callee = ContactManager.getContact(ctx, empJid);
        if (callee == null) {
            Log.w(DialoutManager.class.getSimpleName(), "Cannot find contact [" + empJid + "] to dial, skip!");
            return;
        }
        long mySiteId = PreferencesUtil.getSipUsePbxSite(ctx);
        String mySitePrefix = SiteManager.getSitePrefixById(ctx, mySiteId);
        ArrayList<String> extList = callee.getExtList();
        if (extList == null || extList.size() == 0) {
            return;
        }
        String destSitePrefix = null;
        String destSiteExt = null;
        for (String s : extList) {
            String[] siext = s.split("_");
            if (siext.length != 2) continue;
            destSitePrefix = siext[0];
            destSiteExt = siext[1];
            if (!mySitePrefix.equals(destSitePrefix)) continue;
            break;
        }
        if (destSiteExt == null) {
            ToastUtil.show(ctx, I18NUtil.getString("call_no_phone_num_to_dial"), 10);
            return;
        }
        LiteSite targetSite = UCDBSite.getSiteByPrefix(ctx, destSitePrefix);
        String[] sitePrefix = DialoutManager.getCrossSitePrefix(ctx, targetSite);
        String numberToDial = sitePrefix[0] + destSiteExt;
        PhoneLineInfo info = new PhoneLineInfo();
        info.setType(1);
        info.setJid(empJid);
        info.setEmpId(callee.getId());
        info.setSiteId(targetSite.getId());
        info.setNumber(sitePrefix[1], destSiteExt);
        info.setName1(ContactManager.getNonEnglishName(callee));
        info.setName2(ContactManager.getFullEnglishName(callee));
        DialoutManager.dialout(ctx, numberToDial, info, false);
    }

    private static String[] getCrossSitePrefix(Context ctx, LiteSite targetSite) {
        long mySiteId = PreferencesUtil.getSipUsePbxSite(ctx);
        String[] sitePrefix = new String[]{"", ""};
        if (targetSite != null && targetSite.getId() != mySiteId) {
            sitePrefix[0] = targetSite.getPrefix();
            sitePrefix[1] = targetSite.getName();
        }
        return sitePrefix;
    }

    public static void dialEmpNumberWithPrefix(Context ctx, String phoneNumber, String empJid) {
        if (!DialoutManager.verifyCondForLine(ctx)) {
            return;
        }
        if (TextUtils.isBlank((CharSequence)empJid) || TextUtils.isBlank((CharSequence)phoneNumber)) {
            Log.w(DialoutManager.class.getSimpleName(), "Invalid parameters, empJid or phoneNumber is empty.");
            return;
        }
        String numCleaned = PhoneNoUtil.cleanPhoneNo(phoneNumber);
        if (TextUtils.isBlank((CharSequence)numCleaned)) {
            return;
        }
        LiteContact callee = ContactManager.getContact(ctx, empJid);
        if (callee == null) {
            Log.w(DialoutManager.class.getSimpleName(), "Cannot find contact [" + empJid + "] to dial, skip!");
            return;
        }
        PhoneLineInfo info = new PhoneLineInfo();
        info.setType(1);
        info.setJid(callee.getJid());
        info.setEmpId(callee.getId());
        info.setSiteId(null);
        info.setNumberWithClean(phoneNumber);
        info.setName1(ContactManager.getNonEnglishName(callee));
        info.setName2(ContactManager.getFullEnglishName(callee));
        DialoutManager.dialout(ctx, phoneNumber, info, true);
    }

    public static boolean dialEmpExtendedSys(Context ctx, String phoneNumber, String empJid) {
        if (!DialoutManager.verifyCondForLine(ctx)) {
            return false;
        }
        if (TextUtils.isBlank((CharSequence)empJid) || TextUtils.isBlank((CharSequence)phoneNumber)) {
            Log.w(DialoutManager.class.getSimpleName(), "Invalid parameters, empJid or phoneNumber is empty.");
            return false;
        }
        String numCleaned = PhoneNoUtil.cleanPhoneNo(phoneNumber);
        if (TextUtils.isBlank((CharSequence)numCleaned)) {
            return false;
        }
        LiteContact callee = ContactManager.getContact(ctx, empJid);
        if (callee == null) {
            Log.w(DialoutManager.class.getSimpleName(), "Cannot find contact [" + empJid + "] to dial, skip!");
            return false;
        }
        String numberToDial = phoneNumber;
        PhoneLineInfo info = new PhoneLineInfo();
        info.setType(1);
        info.setJid(callee.getJid());
        info.setEmpId(callee.getId());
        info.setSiteId(null);
        info.setNumberWithClean(numberToDial);
        info.setName1(ContactManager.getNonEnglishName(callee));
        info.setName2(ContactManager.getFullEnglishName(callee));
        DialoutManager.dialout(ctx, numberToDial, info, false);
        return true;
    }

    public static boolean dialEmpExt(Context ctx, String phoneNumber, Long phoneSiteId, String empJid) {
        return DialoutManager.dialEmpExt(ctx, phoneNumber, phoneSiteId, empJid, null);
    }

    public static boolean dialEmpExt(Context ctx, String phoneNumber, Long phoneSiteId, String empJid, String linkId) {
        long mySiteId;
        if (!DialoutManager.verifyCondForLine(ctx)) {
            return false;
        }
        if (TextUtils.isBlank((CharSequence)empJid) || TextUtils.isBlank((CharSequence)phoneNumber)) {
            Log.w(DialoutManager.class.getSimpleName(), "Invalid parameters, empJid or phoneNumber is empty.");
            return false;
        }
        String numCleaned = PhoneNoUtil.cleanPhoneNo(phoneNumber);
        if (TextUtils.isBlank((CharSequence)numCleaned)) {
            return false;
        }
        LiteContact callee = ContactManager.getContact(ctx, empJid);
        if (callee == null) {
            Log.w(DialoutManager.class.getSimpleName(), "Cannot find contact [" + empJid + "] to dial, skip!");
            return false;
        }
        Long targetSiteId = phoneSiteId;
        if (targetSiteId == null && (mySiteId = PreferencesUtil.getSipUsePbxSite(ctx)) != -1L) {
            targetSiteId = mySiteId;
        }
        if (targetSiteId == null) {
            return false;
        }
        LiteSite targetSite = SiteManager.getSite(ctx, targetSiteId);
        String targetSitePrefix = targetSite.getPrefix();
        ArrayList<String> extList = callee.getExtList();
        String destSitePrefix = null;
        String destSiteExt = null;
        for (String s : extList) {
            String[] siext = s.split("_");
            if (siext.length != 2) continue;
            destSitePrefix = siext[0];
            destSiteExt = siext[1];
            if (!targetSitePrefix.equals(destSitePrefix) || !phoneNumber.equals(destSiteExt)) continue;
            String[] sitePrefix = DialoutManager.getCrossSitePrefix(ctx, targetSite);
            String numberToDial = sitePrefix[0] + destSiteExt;
            PhoneLineInfo info = new PhoneLineInfo();
            info.setType(1);
            info.setJid(empJid);
            info.setSiteId(phoneSiteId);
            info.setNumber(sitePrefix[1], destSiteExt);
            info.setName1(ContactManager.getNonEnglishName(callee));
            info.setName2(ContactManager.getFullEnglishName(callee));
            info.setLinkId(linkId);
            DialoutManager.dialout(ctx, numberToDial, info, false);
            return true;
        }
        return false;
    }

    public static void dialEmpOutboundNumber(Context ctx, String phoneNumber, String empJid) {
        if (!DialoutManager.verifyCondForLine(ctx)) {
            return;
        }
        if (TextUtils.isBlank((CharSequence)phoneNumber) || TextUtils.isBlank((CharSequence)empJid)) {
            Log.w(DialoutManager.class.getSimpleName(), "Invalid parameters, number or empJid is empty.");
            return;
        }
        String numCleaned = PhoneNoUtil.cleanPhoneNo(phoneNumber);
        if (TextUtils.isBlank((CharSequence)numCleaned)) {
            return;
        }
        LiteContact callee = ContactManager.getContact(ctx, empJid);
        if (callee == null) {
            Log.w(DialoutManager.class.getSimpleName(), "Cannot find contact [" + empJid + "] to dial, skip!");
            return;
        }
        long mySiteId = PreferencesUtil.getSipUsePbxSite(ctx);
        LiteOutboundPrefix outboundPrefix = ContactManager.getContactOutboundPrefix(ctx, callee, mySiteId);
        String numberToDial = DialoutManager.prepareOutboundNumber(ctx, outboundPrefix, phoneNumber);
        PhoneLineInfo info = new PhoneLineInfo();
        info.setType(1);
        info.setJid(callee.getJid());
        info.setEmpId(callee.getId());
        info.setSiteId(null);
        info.setNumberWithClean(numberToDial);
        info.setName1(ContactManager.getNonEnglishName(callee));
        info.setName2(ContactManager.getFullEnglishName(callee));
        DialoutManager.dialout(ctx, numberToDial, info, true);
    }

    private static String prepareOutboundNumberForCurrentSite(Context ctx, String phoneNumber) {
        return DialoutManager.prepareOutboundNumber(ctx, null, phoneNumber);
    }

    private static String prepareOutboundNumber(Context ctx, LiteOutboundPrefix outboundPrefix, String phoneNumber) {
        if (!ApiVersion.isApi14Later()) {
            return DialoutManager.prepareOutboundNumberForOld(ctx, phoneNumber);
        }
        if (outboundPrefix == null) {
            outboundPrefix = ContactManager.getMySelfOutboundPrefix(ctx);
        }
        if (outboundPrefix == null) {
            return DialoutManager.prepareOutboundNumberForOld(ctx, phoneNumber);
        }
        return DialoutManager.genOutboundNumberForOutboundPrefix(outboundPrefix.getPrefix(), phoneNumber);
    }

    private static String prepareOutboundNumberForOld(Context ctx, String phoneNumber) {
        long mySiteId = PreferencesUtil.getSipUsePbxSite(ctx);
        LiteSite targetSite = SiteManager.getSite(ctx, mySiteId);
        return DialoutManager.genOutboundNumberForOutboundPrefix(targetSite.getOutboundPrefix(), phoneNumber);
    }

    private static String genOutboundNumberForOutboundPrefix(String outboundPrefix, String phoneNumber) {
        if (phoneNumber.startsWith("+")) {
            return phoneNumber;
        }
        return outboundPrefix + phoneNumber;
    }

    public static void dialLocation(Context ctx, LiteContact location) {
        DialoutManager.dialLocation(ctx, location, null);
    }

    public static void dialLocation(Context ctx, LiteContact location, String linkId) {
        if (!DialoutManager.verifyCondForLine(ctx)) {
            return;
        }
        if (location == null) {
            Log.w(DialoutManager.class.getSimpleName(), "Invalid parameters, location is null.");
            return;
        }
        if (TextUtils.isBlank((CharSequence)location.getExt()) || "null".equals(location.getExt()) || TextUtils.isBlank((CharSequence)location.getJid())) {
            Log.w(DialoutManager.class.getSimpleName(), "Invalid parameters, ext or jid is empty.");
            return;
        }
        long mySiteId = PreferencesUtil.getSipUsePbxSite(ctx);
        String mySitePrefix = SiteManager.getSitePrefixById(ctx, mySiteId);
        ArrayList<String> extList = location.getExtList();
        if (extList == null || extList.size() == 0) {
            return;
        }
        String destSitePrefix = null;
        String destSiteExt = null;
        for (String s : extList) {
            String[] siext = s.split("_");
            if (siext.length != 2) continue;
            destSitePrefix = siext[0];
            destSiteExt = siext[1];
            if (!mySitePrefix.equals(destSitePrefix)) continue;
            break;
        }
        if (destSiteExt == null) {
            ToastUtil.show(ctx, I18NUtil.getString("call_no_phone_num_to_dial"), 10);
            return;
        }
        LiteSite targetSite = UCDBSite.getSiteByPrefix(ctx, destSitePrefix);
        String[] sitePrefix = DialoutManager.getCrossSitePrefix(ctx, targetSite);
        String numberToDial = sitePrefix[0] + destSiteExt;
        PhoneLineInfo info = new PhoneLineInfo();
        info.setType(2);
        info.setJid(location.getJid());
        info.setSiteId(targetSite.getId());
        info.setNumber(sitePrefix[1], destSiteExt);
        info.setName1(ContactManager.getContactFullName(location));
        info.setName2(null);
        info.setLinkId(linkId);
        DialoutManager.dialout(ctx, numberToDial, info, false);
    }

    public static void dialMyContactNumber(Context ctx, String phoneNumber, String contactJid) {
        if (!DialoutManager.verifyCondForLine(ctx)) {
            return;
        }
        if (TextUtils.isBlank((CharSequence)phoneNumber) || TextUtils.isBlank((CharSequence)contactJid)) {
            Log.w(DialoutManager.class.getSimpleName(), "Invalid parameters, phoneNumber or contactJid is empty.");
            return;
        }
        String numCleaned = PhoneNoUtil.cleanPhoneNo(phoneNumber);
        if (TextUtils.isBlank((CharSequence)numCleaned)) {
            return;
        }
        long myContactId = JidUtil.trimExternalContactId(contactJid);
        LiteMyContact myContact = UCDBExternalContact.getExternalContactById(ctx, myContactId);
        if (myContact == null) {
            Log.w(DialoutManager.class.getSimpleName(), "Cannot find myContact [" + contactJid + "] to dial, skip!");
            return;
        }
        String numberToDial = DialoutManager.prepareOutboundNumberForCurrentSite(ctx, phoneNumber);
        PhoneLineInfo info = new PhoneLineInfo();
        info.setType(6);
        info.setJid(contactJid);
        info.setContactId(myContactId);
        info.setSiteId(null);
        info.setNumberWithClean(numberToDial);
        info.setName1(myContact.getName());
        info.setName2(null);
        DialoutManager.dialout(ctx, numberToDial, info, true);
    }

    public static void dialMyContactNumberWithPrefix(Context ctx, String phoneNumber, String contactJid) {
        if (!DialoutManager.verifyCondForLine(ctx)) {
            return;
        }
        if (TextUtils.isBlank((CharSequence)phoneNumber) || TextUtils.isBlank((CharSequence)contactJid)) {
            Log.w(DialoutManager.class.getSimpleName(), "Invalid parameters, phoneNumber or contactJid is empty.");
            return;
        }
        String numCleaned = PhoneNoUtil.cleanPhoneNo(phoneNumber);
        if (TextUtils.isBlank((CharSequence)numCleaned)) {
            return;
        }
        long myContactId = JidUtil.trimExternalContactId(contactJid);
        LiteMyContact myContact = UCDBExternalContact.getExternalContactById(ctx, myContactId);
        if (myContact == null) {
            Log.w(DialoutManager.class.getSimpleName(), "Cannot find myContact [" + contactJid + "] to dial, skip!");
            return;
        }
        PhoneLineInfo info = new PhoneLineInfo();
        info.setType(6);
        info.setJid(contactJid);
        info.setContactId(myContactId);
        info.setSiteId(null);
        info.setNumberWithClean(phoneNumber);
        info.setName1(myContact.getName());
        info.setName2(null);
        DialoutManager.dialout(ctx, phoneNumber, info, true);
    }

    public static void dialOtherContactNumber(Context ctx, String phoneNumber) {
        if (!DialoutManager.verifyCondForLine(ctx)) {
            return;
        }
        if (TextUtils.isBlank((CharSequence)phoneNumber)) {
            Log.w(DialoutManager.class.getSimpleName(), "Invalid parameters, phoneNumber is empty.");
            return;
        }
        String xx = PhoneNoUtil.cleanPhoneNo(phoneNumber);
        if (TextUtils.isBlank((CharSequence)xx)) {
            return;
        }
        String macthedJid = UCDBContact.getMatchedContactJidByPhoneNo(ctx, phoneNumber, false);
        if (macthedJid != null) {
            DialoutManager.dialEmpOutboundNumber(ctx, phoneNumber, macthedJid);
            return;
        }
        long macthedCid = UCDBExternalContact.getMatchedExternalContactIdByPhoneNo(ctx, phoneNumber, false);
        if (macthedCid != -1L) {
            DialoutManager.dialMyContactNumber(ctx, phoneNumber, macthedCid + "@externalcontact");
            return;
        }
        String numberToDial = DialoutManager.prepareOutboundNumberForCurrentSite(ctx, phoneNumber);
        PhoneLineInfo info = new PhoneLineInfo();
        info.setType(8);
        info.setJid(null);
        info.setSiteId(null);
        info.setNumberWithClean(numberToDial);
        info.setName1(null);
        info.setName2(null);
        DialoutManager.dialout(ctx, numberToDial, info, true);
    }

    public static void dialOtherContactNumberWithPrefix(Context ctx, String phoneNumber) {
        if (!DialoutManager.verifyCondForLine(ctx)) {
            return;
        }
        if (TextUtils.isBlank((CharSequence)phoneNumber)) {
            Log.w(DialoutManager.class.getSimpleName(), "Invalid parameters, phoneNumber or phoneSiteId is empty.");
            return;
        }
        String xx = PhoneNoUtil.cleanPhoneNo(phoneNumber);
        if (TextUtils.isBlank((CharSequence)xx)) {
            return;
        }
        PhoneLineInfo info = new PhoneLineInfo();
        info.setType(8);
        info.setJid(null);
        info.setSiteId(null);
        info.setNumberWithClean(phoneNumber);
        info.setName1(null);
        info.setName2(null);
        DialoutManager.dialout(ctx, phoneNumber, info, true);
    }

    public static void doDialOut(Context ctx, JSONObject paramObj) {
        try {
            String phoneNum = paramObj.getString("phoneNum");
            JSONObject lineInfoObj = paramObj.getJSONObject("lineInfo");
            PhoneLineInfo lineInfo = new PhoneLineInfo();
            lineInfo.convertToPhoneLineInfo(lineInfoObj);
            int lineId = PhoneAgent.getInstance().call(phoneNum, lineInfo);
            if (lineId == -1) {
                ToastUtil.show(ctx, I18NUtil.getString("phone_notice_in_call_now"), 10);
            }
            if (StringUtils.isNotBlank((CharSequence)lineInfo.getToken())) {
                long mySiteId = PreferencesUtil.getSipUsePbxSite(ctx);
                WebAgent.getInstance().matchEmployeeByOutgoingPhoneNo(lineInfo.getToken(), mySiteId, phoneNum);
            }
        }
        catch (Throwable t) {
            Log.e(DialoutManager.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    private static void dialout(Context ctx, String numberToDial, PhoneLineInfo info, boolean check) {
        if (!check || !PreferencesUtil.isRemoteCheckOutboundNumber(ctx)) {
            int lineId = PhoneAgent.getInstance().call(numberToDial, info);
            if (lineId == -1) {
                ToastUtil.show(ctx, I18NUtil.getString("phone_notice_in_call_now"), 10);
            }
            if (StringUtils.isNotBlank((CharSequence)info.getToken())) {
                long mySiteId = PreferencesUtil.getSipUsePbxSite(ctx);
                WebAgent.getInstance().matchEmployeeByOutgoingPhoneNo(info.getToken(), mySiteId, numberToDial);
            }
            return;
        }
        WebAgent.getInstance().checkRecentCallRecords(numberToDial, info);
    }

    public static void directDialNumberForPad(Context ctx, String phoneNumber, String linkId) {
        if (!DialoutManager.verifyCondForLine(ctx)) {
            return;
        }
        if (TextUtils.isBlank((CharSequence)phoneNumber)) {
            Log.w(DialoutManager.class.getSimpleName(), "Invalid parameter, phoneNumber is empty.");
            return;
        }
        String numCleaned = PhoneNoUtil.cleanPhoneNo(phoneNumber);
        if (TextUtils.isBlank((CharSequence)numCleaned)) {
            return;
        }
        PhoneMatcherResult result = PhoneMatcher.match(ctx, phoneNumber, true);
        if (result != null) {
            if (result.getMatchType() == 0) {
                DialoutManager.dialEmpExt(ctx, result.getExt(), result.getTargetSiteId(), result.getTargetJid(), linkId);
                return;
            }
            if (result.getMatchType() == 1) {
                LiteContact location = ContactManager.getContact(ctx, result.getTargetJid());
                DialoutManager.dialLocation(ctx, location, linkId);
                return;
            }
            if (result.getMatchType() == 2) {
                if (JidUtil.isConfJid(result.getTargetJid())) {
                    PhoneLineInfo info = new PhoneLineInfo();
                    info.setType(5);
                    info.setJid(result.getTargetJid());
                    info.setSiteId(null);
                    info.setNumberWithClean(phoneNumber);
                    info.setName1(result.getTargetName());
                    info.setName2(null);
                    info.setLinkId(linkId);
                    DialoutManager.dialout(ctx, phoneNumber, info, false);
                    return;
                }
                if (JidUtil.isChatJid(result.getTargetJid())) {
                    PhoneLineInfo info = new PhoneLineInfo();
                    info.setType(4);
                    info.setJid(result.getTargetJid());
                    info.setSiteId(null);
                    info.setNumberWithClean(phoneNumber);
                    info.setName1(result.getTargetName());
                    info.setName2(null);
                    info.setLinkId(linkId);
                    DialoutManager.dialout(ctx, phoneNumber, info, false);
                    return;
                }
            } else {
                if (result.getMatchType() == 4) {
                    PhoneLineInfo info = new PhoneLineInfo();
                    info.setType(1);
                    info.setJid(result.getTargetJid());
                    if (result.getContact() != null) {
                        info.setEmpId(result.getContact().getId());
                    }
                    info.setSiteId(null);
                    info.setNumberWithClean(phoneNumber);
                    info.setName1(result.getTargetName());
                    info.setName2(result.getTargetEngName());
                    info.setLinkId(linkId);
                    DialoutManager.dialout(ctx, phoneNumber, info, true);
                    return;
                }
                if (result.getMatchType() == 5) {
                    PhoneLineInfo info = new PhoneLineInfo();
                    info.setType(6);
                    info.setJid(result.getTargetJid());
                    if (result.getMyContact() != null) {
                        info.setContactId(result.getMyContact().getId());
                    }
                    info.setSiteId(null);
                    info.setNumberWithClean(phoneNumber);
                    info.setName1(result.getTargetName());
                    info.setName2(null);
                    info.setLinkId(linkId);
                    DialoutManager.dialout(ctx, phoneNumber, info, true);
                    return;
                }
            }
        }
        String token = CommonUtil.randomString(20);
        PhoneLineInfo info = new PhoneLineInfo();
        info.setType(8);
        info.setJid(null);
        info.setSiteId(null);
        info.setNumberWithClean(phoneNumber);
        info.setName1(null);
        info.setName2(null);
        info.setToken(token);
        info.setLinkId(linkId);
        DialoutManager.dialout(ctx, phoneNumber, info, true);
    }
}

