/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.bean.PhotoLoadTask;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.DeletedContact;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.bean.MessageChannelPhotoTask;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.manager.DeletedContactManager;
import com.blisscloud.mobile.ezuc.manager.task.PhotoTaskController;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;

public class MessageChannelManager {
    public static Image getMessageChannelImage(MessageChannel channel, int photoSize, boolean noDefault, boolean roundImage) {
        Image contactImage = null;
        if (channel != null && channel.isPhotoFlag()) {
            contactImage = MessageChannelManager.getChannelPhotoWithType(UCChatClient.context, channel.getId());
        }
        if (contactImage == null && noDefault) {
            return null;
        }
        return GraphicUtil.getPresencedPersonalPhoto(photoSize, photoSize, contactImage, null, roundImage);
    }

    public static Image getChannelPhotoWithType(Context context, Long channelId) {
        BufferedImage img = MessageChannelManager.getPhotoWithRefresh(context, channelId);
        if (img != null) {
            return img;
        }
        return null;
    }

    public static String getChannelPhotoURI(long channelId) {
        File imageFile = new File(FileUtil.getPhotoRoot(), "msg_channel_" + channelId + ".png");
        if (imageFile.exists()) {
            return imageFile.toURI().toString();
        }
        return null;
    }

    public static BufferedImage getPhotoWithRefresh(Context context, Long id) {
        MessageChannel channel;
        if (id == null) {
            return null;
        }
        BufferedImage mBitmap = FileUtil.readMessageChannelPhoto(id);
        if (mBitmap == null && (channel = UCDBMessageChannel.getMessageChannelById(context, id)) != null && channel.isPhotoFlag()) {
            Log.i("JIM", "channel:" + channel.getId() + " " + channel.isPhotoFlag());
            MessageChannelManager.refreshContactPhoto(context, id);
        }
        return mBitmap;
    }

    private static void refreshContactPhoto(Context ctx, long channelId) {
        ArrayList<PhotoLoadTask> list = new ArrayList<PhotoLoadTask>();
        MessageChannelPhotoTask task = new MessageChannelPhotoTask();
        task.setId(channelId);
        list.add(task);
        MessageChannelManager.refreshPhotoList(ctx, list);
    }

    public static List<MessageChannel> parseApiUserJson(JSONArray dataArray) {
        if (dataArray == null) {
            return null;
        }
        return (List)new Gson().fromJson(dataArray.toString(), new TypeToken<List<MessageChannel>>(){}.getType());
    }

    public static List<Long> parseDeletedApiUserJson(JSONArray dataArray) {
        if (dataArray == null) {
            return null;
        }
        return (List)new Gson().fromJson(dataArray.toString(), new TypeToken<List<Long>>(){}.getType());
    }

    public static void refreshPhotoList(Context ctx, List<PhotoLoadTask> channelPhotoTasks) {
        if (channelPhotoTasks == null) {
            return;
        }
        PhotoTaskController.getInstance(ctx).addTask(channelPhotoTasks);
    }

    public static String getFullName(Context ctx, MessageChannel channel, String jid) {
        if (channel != null) {
            return channel.getName();
        }
        DeletedContact delContact = DeletedContactManager.getDeletedContact(ctx, jid);
        if (delContact != null) {
            return delContact.getOtherName();
        }
        return JidUtil.getJidName(jid);
    }
}

