/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager;

import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.manager.DataChangeEventManager;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SiteManager {
    private static HashMap<Long, LiteSite> sitemap = new HashMap();
    private static Object lock = new Object();

    public static String getSiteNameById(Context context, long siteId) {
        if (!sitemap.containsKey(siteId)) {
            LiteSite site = UCDBSite.getSite(context, siteId);
            sitemap.put(siteId, site);
        }
        if (sitemap.get(siteId) != null) {
            return sitemap.get(siteId).getName();
        }
        return "";
    }

    public static String getSitePrefixById(Context context, long siteId) {
        if (!sitemap.containsKey(siteId)) {
            LiteSite site = UCDBSite.getSite(context, siteId);
            sitemap.put(siteId, site);
        }
        if (sitemap.get(siteId) != null) {
            return sitemap.get(siteId).getPrefix();
        }
        return "";
    }

    public static LiteSite getSite(Context context, long siteId) {
        LiteSite site = UCDBSite.getSite(context, siteId);
        if (site != null) {
            return site;
        }
        return null;
    }

    public static LiteSite getSiteByPrefix(Context context, String sitePrefix) {
        LiteSite site = UCDBSite.getSiteByPrefix(context, sitePrefix);
        if (site != null) {
            return site;
        }
        return null;
    }

    public static void parseSiteListResult(Context context, JSONArray dataArray) {
        try {
            boolean updatePrefix = false;
            for (int i = 0; dataArray != null && i < dataArray.length(); ++i) {
                LiteSite site = SiteManager.parseSiteResultObj(dataArray.getJSONObject(i));
                if (!SiteManager.addOrUpdateSite(context, site)) continue;
                updatePrefix = true;
            }
            if (updatePrefix) {
                DataChangeEventManager.fetchEmployeeInfo(context, "ALL");
            }
        }
        catch (JSONException e) {
            Log.e(SiteManager.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    private static LiteSite parseSiteResult(String dataObjStr) throws JSONException {
        try {
            return SiteManager.parseSiteResultObj(new JSONObject(dataObjStr));
        }
        catch (JSONException e) {
            Log.e(SiteManager.class.getSimpleName(), e.getLocalizedMessage(), e);
            throw e;
        }
    }

    private static LiteSite parseSiteResultObj(JSONObject dataObj) throws JSONException {
        try {
            LiteSite liteSite = new LiteSite();
            liteSite.setId(dataObj.getLong("id"));
            if (dataObj.has("name")) {
                liteSite.setName(dataObj.getString("name"));
            }
            if (dataObj.has("prefix")) {
                liteSite.setPrefix(dataObj.getString("prefix"));
            }
            if (dataObj.has("outboundPrefix")) {
                liteSite.setOutboundPrefix(dataObj.getString("outboundPrefix"));
            }
            return liteSite;
        }
        catch (JSONException e) {
            Log.e(SiteManager.class.getSimpleName(), e.getLocalizedMessage(), e);
            throw e;
        }
    }

    public static void deleteSite(Context context, long siteId) {
        UCDBSite.deleteSite(context, siteId);
        sitemap.remove(siteId);
    }

    public static boolean updateSite(Context context, String siteJsonStr) {
        try {
            LiteSite site = SiteManager.parseSiteResult(siteJsonStr);
            return SiteManager.addOrUpdateSite(context, site);
        }
        catch (JSONException e) {
            Log.e(SiteManager.class.getSimpleName(), e.getLocalizedMessage(), e);
            return false;
        }
    }

    public static boolean addSite(Context context, String siteJsonStr) {
        try {
            LiteSite site = SiteManager.parseSiteResult(siteJsonStr);
            return SiteManager.addOrUpdateSite(context, site);
        }
        catch (JSONException e) {
            Log.e(SiteManager.class.getSimpleName(), e.getLocalizedMessage(), e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addOrUpdateSite(Context ctx, LiteSite site) {
        Object object = lock;
        synchronized (object) {
            boolean prefixUpdated = false;
            LiteSite currentSite = UCDBSite.getSite(ctx, site.getId());
            if (currentSite != null) {
                if (!StringUtils.equals((CharSequence)currentSite.getPrefix(), (CharSequence)site.getPrefix())) {
                    prefixUpdated = true;
                }
                UCDBSite.updateSite(ctx, site);
            } else {
                UCDBSite.addSite(ctx, site);
            }
            sitemap.put(site.getId(), site);
            return prefixUpdated;
        }
    }
}

