/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.MsgState;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventController
extends Thread {
    public static final int GET_ALL_EMP_PHONE_STATUS = 4;
    public static final int EMP_PHONE_STATUS = 5;
    public static final int GET_UNREAD_CHAT_EVENT_ID_LIST = 6;
    public static final int GET_ALL_LOC_PHONE_STATUS = 7;
    public static final int LOC_PHONE_STATUS = 8;
    private List<Event> mList = Collections.synchronizedList(new LinkedList());
    private boolean mTerminated = false;
    private static EventController mInstance;

    public static EventController getInstance() {
        if (mInstance == null) {
            mInstance = new EventController();
        }
        return mInstance;
    }

    private EventController() {
        super("EZEventController");
        this.start();
    }

    public synchronized void addEvent(Context ctx, Object dataObj, int eventType) {
        Event event = new Event();
        event.setType(eventType);
        event.setData(dataObj);
        event.setContext(ctx);
        this.mList.add(event);
        this.notifyAll();
    }

    public void terminate() {
        this.mTerminated = true;
        if (this.mList != null) {
            this.mList.clear();
        }
        this.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.mTerminated) {
                EventController eventController = this;
                synchronized (eventController) {
                    if (this.mList.isEmpty()) {
                        Log.i(this.getClass().getSimpleName(), " wait for chatRoomEvent");
                        this.wait();
                    }
                }
                if (this.mList.size() <= 0) continue;
                Event event = this.mList.remove(0);
                switch (event.getType()) {
                    case 5: {
                        if (!(event.getData() instanceof JSONObject)) break;
                        this.parsePhoneStatus((JSONObject)event.getData(), event.getContext());
                        break;
                    }
                    case 4: {
                        if (!(event.getData() instanceof JSONArray)) break;
                        this.updatePhoneStatusArray((JSONArray)event.getData(), event.getContext());
                        break;
                    }
                    case 7: {
                        if (!(event.getData() instanceof JSONArray)) break;
                        this.updateLocPhoneStatusArray((JSONArray)event.getData(), event.getContext());
                        break;
                    }
                    case 8: {
                        if (!(event.getData() instanceof JSONObject)) break;
                        this.parseLocPhoneStatus((JSONObject)event.getData(), event.getContext());
                        break;
                    }
                    case 6: {
                        if (!(event.getData() instanceof JSONArray)) break;
                        this.updateChatEventReadStatus((JSONArray)event.getData(), event.getContext());
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            Log.i(this.getClass().getSimpleName(), "terminate ParseChatRoomEventTask");
            mInstance = null;
        }
    }

    private void parsePhoneStatus(JSONObject dataObj, Context context) {
        try {
            String empIdStr = null;
            if (!dataObj.has("ids")) {
                return;
            }
            empIdStr = dataObj.getString("ids");
            ArrayList<String> phoneStatusList = new ArrayList<String>();
            JSONObject exteaJson = dataObj.getJSONObject("extra");
            if (exteaJson.has("phoneStatus")) {
                String phoneStatus = exteaJson.getString("phoneStatus");
                ContactManager.setPhoneEmpStatus(empIdStr, phoneStatus);
                if (!phoneStatusList.contains(empIdStr)) {
                    phoneStatusList.add(empIdStr);
                }
            }
            if (!phoneStatusList.isEmpty()) {
                BroadcastUtil.sendEmpPhoneStatusChangedEvent(context, phoneStatusList);
            }
        }
        catch (JSONException e) {
            Log.e(this.getClass().getSimpleName(), "parseChatPresence", e);
        }
    }

    private void parseLocPhoneStatus(JSONObject dataObj, Context context) {
        try {
            String locJidStr = null;
            if (!dataObj.has("ids")) {
                return;
            }
            locJidStr = dataObj.getString("ids");
            ArrayList<String> phoneStatusList = new ArrayList<String>();
            JSONObject exteaJson = dataObj.getJSONObject("extra");
            if (exteaJson.has("phoneStatus")) {
                String phoneStatus = exteaJson.getString("phoneStatus");
                ContactManager.setPhoneLocStatus(locJidStr, phoneStatus);
                if (!phoneStatusList.contains(locJidStr)) {
                    phoneStatusList.add(locJidStr);
                }
            }
            if (!phoneStatusList.isEmpty()) {
                BroadcastUtil.sendLocPhoneStatusChangedEvent(context, phoneStatusList);
            }
        }
        catch (JSONException e) {
            Log.e(this.getClass().getSimpleName(), "parseChatPresence", e);
        }
    }

    public void updateChatEventReadStatus(JSONArray dataArray, Context ctx) {
        HashSet<Long> unreadChatEventIdSet = new HashSet<Long>();
        try {
            if (dataArray != null) {
                int size = dataArray.length();
                for (int i = 0; i < size; ++i) {
                    long eventId = dataArray.getLong(i);
                    unreadChatEventIdSet.add(eventId);
                }
            }
            List<Long[]> msgIdList = UCDBMessage.findUnreadMsgIds(ctx);
            boolean hasMsgChanged = false;
            for (int i = 0; msgIdList != null && i < msgIdList.size(); ++i) {
                Long[] xx = msgIdList.get(i);
                Long localUnreadMsgId = xx[0];
                Long localUnreadEventId = xx[1];
                if (xx == null || localUnreadMsgId == null || localUnreadEventId == null || unreadChatEventIdSet.contains(localUnreadEventId)) continue;
                UCDBMessage.updateChatRoomMsgReadStatus(ctx, localUnreadMsgId);
                hasMsgChanged = true;
            }
            try {
                HashSet<Long> remoteUnreadEventIds = new HashSet<Long>();
                Long localOldestEventId = UCDBMessage.getOldestEventId(ctx);
                if (dataArray != null) {
                    int size = dataArray.length();
                    for (int i = 0; i < size; ++i) {
                        long remoteUnreadEventId = dataArray.getLong(i);
                        if (localOldestEventId == 0L || localOldestEventId > remoteUnreadEventId) continue;
                        remoteUnreadEventIds.add(remoteUnreadEventId);
                    }
                }
                Set<MsgState> localSet = UCDBMessage.findAllMsgIds(ctx, remoteUnreadEventIds);
                for (MsgState stat : localSet) {
                    if (stat.getPlayStatus() != 1) continue;
                    UCDBRemoteMark.addRemoteMark(ctx, 3, stat.getId());
                    WebAgent.getInstance().markChatEventAsRead(stat.getId());
                }
            }
            catch (Throwable t) {
                Log.e(EventController.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
            }
            if (hasMsgChanged && PreferencesUtil.isSyncOldChatEventDone(ctx)) {
                BroadcastUtil.sendMsgChangedEvent(ctx);
                BroadcastUtil.sendContactHistoryChangedEvent(ctx);
            }
        }
        catch (JSONException e) {
            Log.e(this.getClass().getSimpleName(), "updatePresenceArray", e);
        }
    }

    public void updateLocPhoneStatusArray(JSONArray arr, Context ctx) {
        try {
            ContactManager.clearPhoneLocStatusCache();
            if (arr != null) {
                ArrayList<String> locPhoneStatusList = new ArrayList<String>();
                int size = arr.length();
                for (int i = 0; i < size && !this.mTerminated; ++i) {
                    JSONObject item = arr.getJSONObject(i);
                    String phoneStatus = null;
                    if (!item.has("phoneStatus")) continue;
                    phoneStatus = item.getString("phoneStatus");
                    String locJidsStr = null;
                    if (!item.has("ids")) continue;
                    locJidsStr = item.getString("ids");
                    String[] locJidsAry = locJidsStr.split(",");
                    for (int x = 0; locJidsAry != null && x < locJidsAry.length; ++x) {
                        ContactManager.setPhoneLocStatus(locJidsAry[x], phoneStatus);
                        if (locPhoneStatusList.contains(locJidsAry[x])) continue;
                        locPhoneStatusList.add(locJidsAry[x]);
                    }
                }
                if (!locPhoneStatusList.isEmpty()) {
                    BroadcastUtil.sendLocPhoneStatusChangedEvent(ctx, locPhoneStatusList);
                }
            }
        }
        catch (JSONException e) {
            Log.e(this.getClass().getSimpleName(), "updatePresenceArray", e);
        }
    }

    public void updatePhoneStatusArray(JSONArray arr, Context ctx) {
        try {
            ContactManager.clearPhoneEmpStatusCache();
            if (arr != null) {
                ArrayList<String> phoneStatusList = new ArrayList<String>();
                int size = arr.length();
                for (int i = 0; i < size && !this.mTerminated; ++i) {
                    JSONObject item = arr.getJSONObject(i);
                    String phoneStatus = null;
                    if (!item.has("phoneStatus")) continue;
                    phoneStatus = item.getString("phoneStatus");
                    String empIdsStr = null;
                    if (!item.has("ids")) continue;
                    empIdsStr = item.getString("ids");
                    String[] empIdAry = empIdsStr.split(",");
                    for (int x = 0; empIdAry != null && x < empIdAry.length; ++x) {
                        ContactManager.setPhoneEmpStatus(empIdAry[x], phoneStatus);
                        if (phoneStatusList.contains(empIdAry[x])) continue;
                        phoneStatusList.add(empIdAry[x]);
                    }
                }
                if (!phoneStatusList.isEmpty()) {
                    BroadcastUtil.sendEmpPhoneStatusChangedEvent(ctx, phoneStatusList);
                }
            }
        }
        catch (JSONException e) {
            Log.e(this.getClass().getSimpleName(), "updatePresenceArray", e);
        }
    }

    private static class Event {
        private Context mCtx;
        private Object mData;
        private int mType;

        private Event() {
        }

        public Context getContext() {
            return this.mCtx;
        }

        public void setContext(Context context) {
            this.mCtx = context.getApplicationContext();
        }

        public Object getData() {
            return this.mData;
        }

        public void setData(Object data) {
            this.mData = data;
        }

        public int getType() {
            return this.mType;
        }

        public void setType(int type) {
            this.mType = type;
        }
    }
}

