/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.manager.DeletedContactManager;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FetchEmpTaskController
extends ExThread {
    private static FetchEmpTaskController mInstance;
    private List<String> mQueue = Collections.synchronizedList(new ArrayList());
    private boolean suspend = false;

    public synchronized void setSuspend(boolean suspend) {
        this.suspend = suspend;
        if (!suspend && !this.mQueue.isEmpty()) {
            this.notifyAll();
        }
    }

    public static FetchEmpTaskController getInstance(Context ctx) {
        if (mInstance == null) {
            mInstance = new FetchEmpTaskController(ctx);
        }
        return mInstance;
    }

    public static void stopInstance() {
        if (mInstance != null) {
            mInstance.terminate();
            mInstance = null;
        }
    }

    public static void suspendInstance(boolean s) {
        if (mInstance != null) {
            mInstance.setSuspend(s);
        }
    }

    private FetchEmpTaskController(Context ctx) {
        super(ctx, "PhotoTaskController");
        this.start();
    }

    public synchronized void addTaskNoScopeCheck(String jid) {
        if (TextUtils.isBlank((CharSequence)jid)) {
            return;
        }
        if (!JidUtil.isEmployeeJid(jid)) {
            return;
        }
        if (this.existTask(jid)) {
            return;
        }
        if (DeletedContactManager.existDeletedContact(this.mCtx, jid)) {
            return;
        }
        this.mQueue.add(jid);
        this.notifyAll();
    }

    public synchronized void addTask(LiteContact contact) {
        if (contact == null) {
            return;
        }
        if (this.existTask(contact.getJid())) {
            return;
        }
        boolean isWholeCompany = PreferencesUtil.isAddressBookScopeWholeCompany(this.mCtx);
        Set<Long> scopeEmpSet = PreferencesUtil.getAddressBookScopeEmpList(this.mCtx);
        Set<Long> extraEmpSet = PreferencesUtil.getAddressBookExtraEmpList(this.mCtx);
        if (isWholeCompany || scopeEmpSet.contains(contact.getId()) || extraEmpSet.contains(contact.getId())) {
            return;
        }
        if (DeletedContactManager.existDeletedContact(this.mCtx, contact.getJid())) {
            return;
        }
        this.mQueue.add(contact.getJid());
        this.notifyAll();
    }

    private boolean existTask(String jid) {
        for (String existJid : this.mQueue) {
            if (!existJid.equalsIgnoreCase(jid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (!this.isTerminate()) {
                FetchEmpTaskController fetchEmpTaskController = this;
                synchronized (fetchEmpTaskController) {
                    if (this.suspend || this.mQueue.isEmpty()) {
                        this.wait();
                    }
                }
                if (this.suspend) continue;
                HashSet jidSet = new HashSet();
                FetchEmpTaskController fetchEmpTaskController2 = this;
                synchronized (fetchEmpTaskController2) {
                    if (!this.mQueue.isEmpty()) {
                        for (int i = 0; i < 30 && !this.mQueue.isEmpty(); ++i) {
                            jidSet.add(this.mQueue.remove(0));
                        }
                    }
                }
                if (jidSet.size() <= 0) continue;
                WebAgent.getInstance().queryEmployeeListByJids(jidSet);
            }
        }
        catch (InterruptedException e) {
            Log.e(this.getClass().getSimpleName(), e.getLocalizedMessage(), e);
        }
        finally {
            Log.i(this.getClass().getSimpleName(), "Clear instance");
            FetchEmpTaskController fetchEmpTaskController = this;
            synchronized (fetchEmpTaskController) {
                this.mQueue.clear();
            }
            this.mQueue = null;
            mInstance = null;
        }
    }
}

