/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class GetBulletinSubjectPhotoTask
extends ExThread {
    private long mBulletinId = -1L;
    private String mSubjectPhotoUrl = null;

    public GetBulletinSubjectPhotoTask(Context context, long bulletinId, String subjectPhotoUrl) {
        super(context, "GetBulletinSubjectPhotoTask");
        this.mBulletinId = bulletinId;
        this.mSubjectPhotoUrl = subjectPhotoUrl;
    }

    @Override
    public void run() {
        try {
            String downloadUrl = "https://" + CommonUtil.getHttpsIpPort(this.mCtx) + this.mSubjectPhotoUrl.substring(this.mSubjectPhotoUrl.indexOf("/ucrm"));
            boolean isDone = this.getPhotoFromWeb(downloadUrl);
            if (isDone) {
                BroadcastUtil.sendBulletinSubjectPhotoReadyEvent(this.mCtx, this.mBulletinId);
            }
        }
        catch (Exception e) {
            Log.e(GetBulletinSubjectPhotoTask.class.getSimpleName(), "GetLogoTask fail", e);
        }
        this.cleanUp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean getPhotoFromWeb(String url) {
        InputStream is = null;
        HttpClient mHttpClient = null;
        try {
            mHttpClient = CommonUtil.getHttpsClient(this.mCtx, true);
            if (mHttpClient == null) {
                boolean bl = false;
                return bl;
            }
            HttpGet request = new HttpGet();
            request.setURI(new URI(url));
            HttpResponse response = mHttpClient.execute((HttpUriRequest)request);
            if (response.getStatusLine().getStatusCode() != 200) {
                request.abort();
                boolean bl = false;
                return bl;
            }
            is = response.getEntity().getContent();
            FileUtil.writeBulletinSubjectPhoto(this.mBulletinId, is);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            Log.e(GetBulletinSubjectPhotoTask.class.getSimpleName(), "getPhotoFromWeb fail:" + t.getLocalizedMessage(), t);
            boolean bl = false;
            return bl;
        }
        finally {
            if (is != null) {
                try {
                    try {
                        is.close();
                        is = null;
                    }
                    catch (IOException e) {
                        Log.e(GetBulletinSubjectPhotoTask.class.getSimpleName(), "getPhotoFromWeb fail", e);
                        is = null;
                    }
                }
                catch (Throwable throwable) {
                    is = null;
                    throw throwable;
                }
            }
        }
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }

    @Override
    public String toString() {
        return "GetLogoTask - " + super.toString();
    }
}

