/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.bean.LiteGroupMember;
import com.blisscloud.ezuc.bean.LiteMyGroup;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBGroup;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.List;
import org.json.JSONArray;

public class GetGroupDataTask
extends ExThread {
    private final JSONArray mDataArray;
    private final long returnTimeStamp;

    public GetGroupDataTask(Context context, JSONArray dataArray, long returnTimeStamp) {
        super(context, "GetGroupDataTask");
        this.mDataArray = dataArray;
        this.returnTimeStamp = returnTimeStamp;
    }

    @Override
    public void run() {
        List<LiteMyGroup> groups = ContactManager.parseLiteGroupJson(this.mDataArray);
        if (groups == null || groups.size() == 0) {
            Log.i(this.getClass().getSimpleName(), "GetGroupDataTask groups is null or size is 0");
            return;
        }
        for (LiteMyGroup liteGroup : groups) {
            if (this.isTerminate()) {
                Log.i(this.getClass().getSimpleName(), "GetGroupDataTask terminated!");
                UCDBGroup.deleteGroups(this.mCtx);
                return;
            }
            ContactManager.setWSGroupData(this.mCtx, liteGroup);
            List<LiteGroupMember> members = liteGroup.getMembers();
            for (int i = 0; members != null && i < members.size(); ++i) {
                boolean newAdd;
                LiteGroupMember member = members.get(i);
                if (!JidUtil.isChatJid(member.getMemberId()) || !(newAdd = ChatRoomManager.prepareChatRoom(this.mCtx, member.getMemberId()))) continue;
                WebAgent.getInstance().getOneRoomSync(member.getMemberId());
            }
        }
        PreferencesUtil.setTimeStamp(this.mCtx, "group.getMyGroupList.20150921.TimeStamp", this.returnTimeStamp);
        BroadcastUtil.sendGroupListChangedEvent(this.mCtx);
        this.cleanUp();
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }

    @Override
    public String toString() {
        return "GetGroupDataTask - " + super.toString();
    }
}

