/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.HashSet;
import java.util.List;

public class GetMeetmeRoomDataTask
extends ExThread {
    private List<LiteConferenceRoom> rooms;

    public GetMeetmeRoomDataTask(Context context, List<LiteConferenceRoom> rooms) {
        super(context, "GetMeetmeRoomDataTask");
        this.rooms = rooms;
    }

    @Override
    public void run() {
        Log.i(GetMeetmeRoomDataTask.class.getSimpleName(), "GetMeetmeRoomDataTask start .... ");
        try {
            List<LiteConferenceRoom> allConfRooms = MeetmeManager.getStaticMeetmeList(this.mCtx);
            for (LiteConferenceRoom existRoom : allConfRooms) {
                boolean keep = false;
                if (this.rooms != null) {
                    for (LiteConferenceRoom liteConferenceRoom : this.rooms) {
                        if (existRoom.getRoomId().longValue() != liteConferenceRoom.getRoomId().longValue()) continue;
                        keep = true;
                    }
                }
                if (keep) continue;
                ChatRoomManager.selfLeaveConfRoom(this.mCtx, existRoom.getChatRoomId(), false);
                MeetmeManager.deleteConfRoomById(this.mCtx, existRoom.getRoomId(), null);
            }
            HashSet<Long> empIdSet = new HashSet<Long>();
            for (LiteConferenceRoom room : this.rooms) {
                LiteContact liteContact;
                List<Long> cidList = room.getChairmanIds();
                if (cidList != null) {
                    for (Long cid : cidList) {
                        LiteContact managerContact2 = UCDBContact.getContactByEmpId(UCChatClient.context, cid);
                        if (managerContact2 != null) continue;
                        empIdSet.add(cid);
                    }
                }
                if ((liteContact = UCDBContact.getContactByEmpId(UCChatClient.context, room.getManagerId())) == null) {
                    empIdSet.add(room.getManagerId());
                }
                MeetmeManager.addOrUpdateConfRoom(this.mCtx, room);
                WebAgent.getInstance().getOneRoomSync(room.getChatRoomId());
            }
            if (empIdSet.size() > 0) {
                WebAgent.getInstance().queryEmployeeListByIds(empIdSet);
            }
            if (PreferencesUtil.isSyncOldChatEventDone(this.mCtx)) {
                BroadcastUtil.sendMeetmeListChangedEvent(this.mCtx);
                BroadcastUtil.sendContactHistoryChangedEvent(this.mCtx);
            }
        }
        catch (Throwable e) {
            Log.e(GetMeetmeRoomDataTask.class.getSimpleName(), "ERROR:" + e.getLocalizedMessage(), e);
        }
        this.cleanUp();
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }
}

