/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.List;
import javax.swing.SwingUtilities;

public class SyncChatRoomInfoTask
extends ExThread {
    public SyncChatRoomInfoTask(Context ctx) {
        super(ctx, "SyncChatRoomInfoTask");
    }

    @Override
    public void run() {
        if (!this.isTerminate()) {
            boolean syncDone = PreferencesUtil.isSyncOldChatEventDone(this.mCtx);
            if (!syncDone) {
                PreferencesUtil.setSyncOldChatEventDone(this.mCtx, true);
                PreferencesUtil.setSyncDataFlag(this.mCtx, false);
                WebAgent.getInstance().clearSyncRoomInfo();
                SwingUtilities.invokeLater(new Runnable(this){

                    @Override
                    public void run() {
                        UCChatClient.getInstance().updateImportProgress(100);
                    }
                });
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                BroadcastUtil.sendDataDownloadEndEvent(this.mCtx);
            }
            List<ChatRoomInfo> oldRoomList = ChatRoomManager.getMultiChatRooms(this.mCtx);
            for (int i = 0; oldRoomList != null && i < oldRoomList.size() && !this.isTerminate(); ++i) {
                ChatRoomInfo info = oldRoomList.get(i);
                Log.i(SyncChatRoomInfoTask.class.getSimpleName(), "INFO:" + info.getSubject() + " JID:" + info.getChatRoomId());
                WebAgent.getInstance().getOneRoomSync(info.getChatRoomId());
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        this.cleanUp();
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }
}

