/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.task.ExThread;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.manager.task.UpdateSingleChatRoomInfoTask;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UpdateSingleChatRoomMembersTask
extends ExThread {
    private final JSONObject mRoomObj;

    public UpdateSingleChatRoomMembersTask(Context context, JSONObject temp) {
        super(context, "UpdateSingleChatRoomMembersTask");
        this.mRoomObj = temp;
    }

    @Override
    public void run() {
        this.doAction();
        this.cleanUp();
    }

    private void doAction() {
        try {
            boolean isInitDone;
            if (this.mRoomObj == null) {
                return;
            }
            if (!this.mRoomObj.has("roomJid")) {
                return;
            }
            String chatRoomJid = this.mRoomObj.getString("roomJid");
            JSONArray ownerObj = this.mRoomObj.getJSONArray("owners");
            boolean syncDone = PreferencesUtil.isSyncOldChatEventDone(this.mCtx);
            boolean dirty = false;
            LiteConferenceRoom confRoom = UCDBConf.getConfRoomByChatRoomId(this.mCtx, chatRoomJid);
            if (confRoom != null && !(isInitDone = UCDBConf.isConfInitDone(this.mCtx, confRoom))) {
                UCDBConf.updateConfRoomInitDoneState(this.mCtx, confRoom.getRoomId(), true);
                dirty = true;
                Log.d(UpdateSingleChatRoomMembersTask.class.getSimpleName(), "dirty room " + chatRoomJid + " init done");
                if (syncDone) {
                    BroadcastUtil.sendMeetmeListChangedEvent(this.mCtx);
                }
            }
            if (!ChatRoomManager.checkLoginUserIsOwner(this.mCtx, ownerObj)) {
                ChatRoomManager.cleanChatRoom(this.mCtx, chatRoomJid, false);
                dirty = true;
                Log.d(UpdateSingleChatRoomInfoTask.class.getSimpleName(), "dirty room " + chatRoomJid + " clean room 1");
            } else {
                ChatRoomManager.prepareChatRoom(this.mCtx, chatRoomJid);
                boolean updateParticipant = ChatRoomManager.parseChatRoomParticipant(this.mCtx, ownerObj, chatRoomJid);
                if (updateParticipant) {
                    dirty = true;
                    Log.d(UpdateSingleChatRoomMembersTask.class.getSimpleName(), "dirty room " + chatRoomJid + " updateParticipant");
                }
                if (updateParticipant && syncDone) {
                    BroadcastUtil.sendParticipantChangedEvent(this.mCtx, chatRoomJid);
                }
                if (confRoom != null && syncDone) {
                    WebAgent.getInstance().queryMeetMeListUser(confRoom.getRoomId());
                }
            }
            if (syncDone && dirty) {
                BroadcastUtil.sendMsgChangedEvent(this.mCtx, chatRoomJid);
                BroadcastUtil.sendContactHistoryChangedEvent(this.mCtx);
            }
        }
        catch (JSONException e) {
            Log.e(ChatRoomManager.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    private void cleanUp() {
        TaskController.getInstance().removeTask(this);
    }
}

