/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.AsyncTask;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.DataCleanUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.ICheckCompleteListener;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class VerifyEnterpriseIpTask
extends AsyncTask<Void, Void, Integer> {
    private ICheckCompleteListener mListener = null;
    private Context mCtx = null;
    private String newEnterpriseIp = null;

    public VerifyEnterpriseIpTask(Context context, String enterpriseIp, ICheckCompleteListener listener) {
        this.mListener = listener;
        this.newEnterpriseIp = enterpriseIp;
        this.mCtx = context;
    }

    protected Integer doInBackground(Void ... params) {
        if (TextUtils.isBlank((CharSequence)this.newEnterpriseIp)) {
            return 1;
        }
        String targetHost = null;
        int targetPort = 8443;
        int index = this.newEnterpriseIp.lastIndexOf(":");
        if (index == -1) {
            targetHost = this.newEnterpriseIp;
            targetPort = 8443;
        } else {
            targetHost = this.newEnterpriseIp.substring(0, index);
            try {
                targetPort = Integer.parseInt(this.newEnterpriseIp.substring(index + 1));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Integer result = this.officeCheckConnection(targetHost, targetPort);
        if (result == null) {
            return 1;
        }
        String oldEnterpriseIp = PreferencesUtil.getEnterpriseIp(this.mCtx);
        String oldEnterpriseMode = PreferencesUtil.getEnterpriseNoMode(this.mCtx);
        if ("MODE_ENT_NO".equalsIgnoreCase(oldEnterpriseMode) || TextUtils.isNotBlank((CharSequence)oldEnterpriseIp) && !this.newEnterpriseIp.equals(oldEnterpriseIp)) {
            PreferencesUtil.cleanConnectionData(this.mCtx);
            DataCleanUtil.cleanUserData(this.mCtx);
            FileUtil.deleteRegistrationBackgtoundFile();
            FileUtil.deleteRegistrationLogoFile();
        }
        PreferencesUtil.setEnterpriseNoMode(this.mCtx, "MODE_ENT_IP");
        PreferencesUtil.setEnterpriseIp(this.mCtx, this.newEnterpriseIp);
        PreferencesUtil.setEnterpriseNo(this.mCtx, null);
        PreferencesUtil.setHost(this.mCtx, targetHost);
        PreferencesUtil.setExternalHost(this.mCtx, targetHost);
        if (index != -1) {
            PreferencesUtil.setExternalPort(this.mCtx, targetPort);
        }
        return 0;
    }

    private Integer officeCheckConnection(String ip, int port) {
        HttpClient httpclient = CommonUtil.getHttpsClient(this.mCtx, 8443, true, 20000, 20000);
        String link = "https://" + ip + ":" + port + "/index.jsp";
        Log.i(VerifyEnterpriseIpTask.class.getSimpleName(), "checkInOffice start ..... link:" + link);
        HttpPost httpPost = null;
        try {
            httpPost = new HttpPost(link);
            HttpResponse response = httpclient.execute((HttpUriRequest)httpPost);
            StatusLine statusLine = response.getStatusLine();
            Log.i(CommonUtil.class.getSimpleName(), "StatusLine:" + String.valueOf(statusLine));
            HttpEntity entity = response.getEntity();
            String responseString = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
            if (responseString.contains("/ucrm") || responseString.contains("/ucpbx")) {
                return response.getStatusLine().getStatusCode();
            }
            return null;
        }
        catch (Throwable e) {
            Log.e(CommonUtil.class.getSimpleName(), "doHttpRequest", e);
            httpPost.abort();
            return null;
        }
    }

    @Override
    protected void onPostExecute(Integer result) {
        if (this.mListener != null && result != null) {
            this.mListener.onCheckCompleted(this.newEnterpriseIp, result);
        }
    }
}

