/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.manager.task;

import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.AsyncTask;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.bean.EnterpriseInfo;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.DataCleanUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.ICheckCompleteListener;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.blisscloud.mobile.ezuc.util.UCDSUtil;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class VerifyEnterpriseNoTask
extends AsyncTask<Void, Void, Integer> {
    private ICheckCompleteListener mListener = null;
    private Context mCtx = null;
    private String newEnterpriseNo = null;

    public VerifyEnterpriseNoTask(Context context, String enterpriseNo, ICheckCompleteListener listener) {
        this.mListener = listener;
        this.newEnterpriseNo = enterpriseNo;
        this.mCtx = context;
    }

    protected Integer doInBackground(Void ... params) {
        List<String> mIPList = UCDSUtil.getServerIpList(this.mCtx);
        EnterpriseInfo info = null;
        for (int i = 0; mIPList != null && i < mIPList.size(); ++i) {
            String ip = mIPList.get(i);
            String url = String.format("https://%s", ip) + "/ucds/mobileTenant/verifyNo";
            String resultStr = CommonUtil.doHttpRequest(this.mCtx, this.newEnterpriseNo, url, new JSONObject(), null, true);
            if (TextUtils.isBlank((CharSequence)resultStr)) continue;
            JSONObject obj = null;
            try {
                obj = new JSONObject(resultStr);
                int resultCode = obj.getInt("returnCode");
                if (resultCode != 0) {
                    return 2;
                }
                info = this.getEnterpriseInfo(obj);
                if (info != null) break;
                continue;
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        if (info == null) {
            return 1;
        }
        String ip = info.getServerIp();
        if (TextUtils.isBlank((CharSequence)ip)) {
            return 1;
        }
        String oldEnterpriseNo = PreferencesUtil.getEnterpriseNo(this.mCtx);
        String oldEnterpriseMode = PreferencesUtil.getEnterpriseNoMode(this.mCtx);
        if ("MODE_ENT_IP".equalsIgnoreCase(oldEnterpriseMode) || TextUtils.isNotBlank((CharSequence)oldEnterpriseNo) && !this.newEnterpriseNo.equals(oldEnterpriseNo)) {
            PreferencesUtil.cleanConnectionData(this.mCtx);
            DataCleanUtil.cleanUserData(this.mCtx);
            FileUtil.deleteRegistrationBackgtoundFile();
            FileUtil.deleteRegistrationLogoFile();
        }
        PreferencesUtil.setEnterpriseNoMode(this.mCtx, "MODE_ENT_NO");
        PreferencesUtil.setEnterpriseNo(this.mCtx, this.newEnterpriseNo);
        PreferencesUtil.setEnterpriseIp(this.mCtx, null);
        PreferencesUtil.setHost(this.mCtx, ip);
        PreferencesUtil.setExternalHost(this.mCtx, info.getUcrmExternalIp());
        PreferencesUtil.setExternalPort(this.mCtx, info.getUcrmExternalPort());
        UCDSUtil.updateServerIpList(this.mCtx, info.getServerIpList());
        return 0;
    }

    private EnterpriseInfo getEnterpriseInfo(JSONObject obj) throws JSONException {
        EnterpriseInfo info = new EnterpriseInfo();
        JSONObject data = obj.getJSONObject("returnData");
        info.setCreateTime(data.getString("createTime"));
        info.setId(data.getInt("id"));
        info.setLastUpdate(data.getString("lastUpdateTime"));
        info.setName(data.getString("name"));
        info.setNo(data.getString("no"));
        info.setServerIp(data.getString("ucrmServerIp"));
        info.setUcrmExternalIp(data.getString("ucrmServerExternalIp"));
        info.setUcrmExternalPort(data.getInt("ucrmServerExternalPort"));
        if (data.has("serverIpList")) {
            info.setServerIpList(data.getJSONArray("serverIpList").toString());
        }
        return info;
    }

    @Override
    protected void onPostExecute(Integer result) {
        if (this.mListener != null && result != null) {
            this.mListener.onCheckCompleted(this.newEnterpriseNo, result);
        }
    }
}

