/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.util;

import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.io.File;

public class MediaFileUtil
extends FileUtil {
    public static final String MEDIA_RING_PATH = "media/phone/";
    public static final String MEDIA_NOTICE_PATH = "media/notice/";

    private static String convert(String id) {
        String[] args;
        if (id != null && (args = id.split("@")).length >= 1) {
            return args[0];
        }
        return id;
    }

    public static void cleanChatMedia(Context context) {
        File chatDir = MediaFileUtil.getChatRoot(context);
        MediaFileUtil.deleteDirectory(chatDir);
    }

    public static void cleanDocMedia(Context context) {
        File chatDir = MediaFileUtil.getDocRoot(context);
        MediaFileUtil.deleteDirectory(chatDir);
    }

    public static void cleanFaxMedia(Context context) {
        File faxDir = MediaFileUtil.getFaxRoot(context);
        MediaFileUtil.deleteDirectory(faxDir);
    }

    public static void cleanVoicemailMedia(Context context) {
        File voicemailDir = MediaFileUtil.getVoicemailRoot(context);
        MediaFileUtil.deleteDirectory(voicemailDir);
    }

    public static void cleanRecordingMedia(Context context) {
        File recordingDir = MediaFileUtil.getRecordingRoot(context);
        MediaFileUtil.deleteDirectory(recordingDir);
    }

    public static void cleanSysRecordingMedia(Context context) {
        File sysRecordingDir = MediaFileUtil.getSysRecordingRoot(context);
        MediaFileUtil.deleteDirectory(sysRecordingDir);
    }

    public static File getRecordingRoot(Context context) {
        File recordingDir = context.getExternalFilesDir("recording");
        MediaFileUtil.checkAndCreate(recordingDir);
        return recordingDir;
    }

    public static File getSysRecordingRoot(Context context) {
        File recordingDir = context.getExternalFilesDir("recording_sys");
        MediaFileUtil.checkAndCreate(recordingDir);
        return recordingDir;
    }

    public static File getFaxRoot(Context context) {
        File faxDir = context.getExternalFilesDir("fax");
        MediaFileUtil.checkAndCreate(faxDir);
        return faxDir;
    }

    public static File getVoicemailRoot(Context context) {
        File voicemailDir = context.getExternalFilesDir("voicemail");
        MediaFileUtil.checkAndCreate(voicemailDir);
        return voicemailDir;
    }

    private static File getChatRoot(Context context) {
        File chatDir = context.getExternalFilesDir("chat");
        MediaFileUtil.checkAndCreate(chatDir);
        return chatDir;
    }

    public static File getDocRoot(Context context) {
        File chatDir = context.getExternalFilesDir("doc");
        MediaFileUtil.checkAndCreate(chatDir);
        return chatDir;
    }

    private static void checkAndCreate(File checkDir) {
        if (!checkDir.exists()) {
            checkDir.mkdirs();
        }
    }

    public static File getImportMediaFileDir(Context context) {
        File dir = new File(MediaFileUtil.getChatRoot(context).getAbsolutePath() + "/import");
        MediaFileUtil.checkAndCreate(dir);
        return dir;
    }

    public static File getTempMediaFileDir(Context context) {
        File dir = new File(MediaFileUtil.getChatRoot(context).getAbsolutePath() + "/media_temp");
        MediaFileUtil.checkAndCreate(dir);
        return dir;
    }

    public static File getActualMediaFileDir(Context context, String chatroomId) {
        File dir = new File(MediaFileUtil.getChatRoot(context).getAbsolutePath() + "/" + MediaFileUtil.convert(chatroomId));
        MediaFileUtil.checkAndCreate(dir);
        return dir;
    }

    public static File getActualMediaFile(Context context, String chatroomId, int type, long messageId) {
        return new File(MediaFileUtil.getActualMediaFileDir(context, chatroomId), MediaFileUtil.getFileName(type, messageId));
    }

    private static String getFileName(int type, long messageId) {
        if (type == 0) {
            return "MESSAGE-" + messageId;
        }
        return "MESSAGE-" + type + "-" + messageId;
    }

    public static String getWavFileNameForRing(int option) {
        if (option == 0) {
            return "ringin.wav";
        }
        if (option == 1) {
            return "best_tone.wav";
        }
        if (option == 2) {
            return "classic.wav";
        }
        if (option == 3) {
            return "despacito.wav";
        }
        if (option == 4) {
            return "morning.wav";
        }
        if (option == 5) {
            return "nice.wav";
        }
        if (option == 6) {
            return "phone.wav";
        }
        if (option == 7) {
            return "popular.wav";
        }
        if (option == 8) {
            return "comeCall.wav";
        }
        return "ringin.wav";
    }

    public static String getWavFileNameForNotice(int option) {
        if (option == 1) {
            return "farSound.wav";
        }
        if (option == 2) {
            return "on.wav";
        }
        if (option == 3) {
            return "off.wav";
        }
        if (option == 4) {
            return "gling.wav";
        }
        if (option == 5) {
            return "dingdong.wav";
        }
        if (option == 6) {
            return "doorbell.wav";
        }
        if (option == 7) {
            return "echobel2.wav";
        }
        if (option == 8) {
            return "diamond.wav";
        }
        if (option == 9) {
            return "niceding.wav";
        }
        if (option == 10) {
            return "bigben.wav";
        }
        return null;
    }
}

