/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.mobile.ezuc.util;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.LastMsg;
import com.blisscloud.ezuc.client.util.MsgUtil;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.MessageChannelManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PhoneNoUtil;
import com.blisscloud.mobile.ezuc.util.PopupMsg;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;

public class PopupMsgUtil {
    public static PopupMsg convertPopupMsg(Context ctx, String targetJid, String packetId) {
        String ownerName;
        Message msg = UCDBMessage.findMsgByPacketId(ctx, packetId);
        if (msg == null) {
            Log.w(PopupMsgUtil.class.getSimpleName(), "msg is null targetJid: " + targetJid + ", packetId:" + packetId);
            return null;
        }
        boolean isFuzzy = JidUtil.isFakeExternalCallJid(targetJid) && PreferencesUtil.isFuzzyOutboundNumber(ctx);
        boolean isConfRoom = false;
        boolean isChatRoom = false;
        String title = "";
        if (JidUtil.isEmployeeJid(targetJid) || JidUtil.isLocationJid(targetJid)) {
            LiteContact contact = ContactManager.getContact(ctx, targetJid);
            if (contact == null) {
                return null;
            }
            title = ContactManager.getContactFullName(contact);
        } else if (JidUtil.isCustomerJid(targetJid)) {
            LiteCustomer customer = CustomerManager.getCustomerInfo(ctx, JidUtil.convertKey(targetJid));
            if (customer == null) {
                return null;
            }
            title = customer.getNickname();
        } else if (JidUtil.isMyContactJid(targetJid)) {
            long myContactId = JidUtil.trimExternalContactId(targetJid);
            LiteMyContact myContact = UCDBExternalContact.getExternalContactById(ctx, myContactId);
            if (myContact == null) {
                return null;
            }
            title = myContact.getName();
        } else if (JidUtil.isAPIUserJid(targetJid)) {
            MessageChannel msgChannel = UCDBMessageChannel.getMessageChannelByJid(ctx, targetJid);
            title = MessageChannelManager.getFullName(ctx, msgChannel, targetJid);
        } else if (JidUtil.isChatJid(targetJid)) {
            isChatRoom = true;
            ChatRoomInfo chatRoomInfo = ChatRoomManager.getChatRoom(ctx, targetJid);
            ArrayList<String> participants = UCDBChatRoom.findChatRoomParticipants(ctx, chatRoomInfo.getChatRoomId());
            title = ChatRoomUtil.getChatRoomTitleForList(ctx, chatRoomInfo, participants, null);
        } else if (JidUtil.isConfJid(targetJid)) {
            isConfRoom = true;
            ChatRoomInfo chatRoomInfo = ChatRoomManager.getChatRoom(ctx, targetJid);
            LiteConferenceRoom room = MeetmeManager.getStaticMeetme(ctx, chatRoomInfo.getChatRoomId());
            title = ChatRoomUtil.getConfRoomTitle(ctx, chatRoomInfo, room);
        } else if (JidUtil.isBcAnnouncerJid(targetJid)) {
            title = I18NUtil.getAppName();
        } else if (JidUtil.isPhoneNumberJid(targetJid)) {
            title = JidUtil.trimPhoneNumber(targetJid);
        } else if (JidUtil.isPhoneNumberJid2(targetJid)) {
            title = targetJid;
            String[] keys = targetJid.split("_@@_");
            if (keys.length == 2) {
                String siteId = keys[0];
                String phoneNum = keys[1];
                title = PhoneNoUtil.getPhoneNumDisp(ctx, siteId, phoneNum);
            }
        } else if (JidUtil.isFakeExternalCallJid(targetJid)) {
            title = I18NUtil.getString("phone_history_label_external");
        } else if (JidUtil.isFakeFaxDocJid(targetJid)) {
            title = I18NUtil.getString("fax_doc_label_external");
        } else {
            title = targetJid;
            if (targetJid.contains("_@@_")) {
                String[] titles = targetJid.split("_@@_");
                title = PhoneNoUtil.getPhoneNumDisp(ctx, titles[0], titles[1]);
            }
        }
        HashMap<String, LiteContact> userCacheMap = new HashMap<String, LiteContact>();
        LastMsg lastMsgObj = MsgUtil.getLastMsgUtil(ctx, msg, userCacheMap, isChatRoom, isFuzzy);
        Object content = lastMsgObj.getDispContentShort();
        if (lastMsgObj.isShowMsgSenderName() && (isChatRoom || isConfRoom) && StringUtils.isNotBlank((CharSequence)(ownerName = ContactManager.getContactShortName(ctx, userCacheMap, msg.getFromJid())))) {
            content = ownerName + ": " + (String)content;
        }
        return new PopupMsg(title, (String)content);
    }
}

