/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.aac;

public final class ChannelConfiguration {
    public static final ChannelConfiguration CHANNEL_CONFIG_UNSUPPORTED = new ChannelConfiguration(-1, "invalid");
    public static final ChannelConfiguration CHANNEL_CONFIG_NONE = new ChannelConfiguration(0, "No channel");
    public static final ChannelConfiguration CHANNEL_CONFIG_MONO = new ChannelConfiguration(1, "Mono");
    public static final ChannelConfiguration CHANNEL_CONFIG_STEREO = new ChannelConfiguration(2, "Stereo");
    public static final ChannelConfiguration CHANNEL_CONFIG_STEREO_PLUS_CENTER = new ChannelConfiguration(3, "Stereo+Center");
    public static final ChannelConfiguration CHANNEL_CONFIG_STEREO_PLUS_CENTER_PLUS_REAR_MONO = new ChannelConfiguration(4, "Stereo+Center+Rear");
    public static final ChannelConfiguration CHANNEL_CONFIG_FIVE = new ChannelConfiguration(5, "Five channels");
    public static final ChannelConfiguration CHANNEL_CONFIG_FIVE_PLUS_ONE = new ChannelConfiguration(6, "Five channels+LF");
    public static final ChannelConfiguration CHANNEL_CONFIG_SEVEN_PLUS_ONE = new ChannelConfiguration(8, "Seven channels+LF");
    private final int chCount;
    private final String descr;

    public static ChannelConfiguration forInt(int i) {
        return switch (i) {
            case 0 -> CHANNEL_CONFIG_NONE;
            case 1 -> CHANNEL_CONFIG_MONO;
            case 2 -> CHANNEL_CONFIG_STEREO;
            case 3 -> CHANNEL_CONFIG_STEREO_PLUS_CENTER;
            case 4 -> CHANNEL_CONFIG_STEREO_PLUS_CENTER_PLUS_REAR_MONO;
            case 5 -> CHANNEL_CONFIG_FIVE;
            case 6 -> CHANNEL_CONFIG_FIVE_PLUS_ONE;
            case 7, 8 -> CHANNEL_CONFIG_SEVEN_PLUS_ONE;
            default -> CHANNEL_CONFIG_UNSUPPORTED;
        };
    }

    private ChannelConfiguration(int chCount, String descr) {
        this.chCount = chCount;
        this.descr = descr;
    }

    public int getChannelCount() {
        return this.chCount;
    }

    public String getDescription() {
        return this.descr;
    }

    public String toString() {
        return this.descr;
    }
}

