/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.vpx.vp9;

import java.util.ArrayList;
import java.util.List;
import org.jcodec.codecs.vpx.VPXBooleanDecoder;
import org.jcodec.codecs.vpx.vp9.CodedBlock;
import org.jcodec.codecs.vpx.vp9.Consts;
import org.jcodec.codecs.vpx.vp9.DecodingContext;
import org.jcodec.codecs.vpx.vp9.Probabilities;

public class CodedSuperBlock {
    private CodedBlock[] codedBlocks;

    public CodedSuperBlock(CodedBlock[] codedBlocks) {
        this.codedBlocks = codedBlocks;
    }

    public CodedBlock[] getCodedBlocks() {
        return this.codedBlocks;
    }

    public static CodedSuperBlock read(int miCol, int miRow, VPXBooleanDecoder decoder, Probabilities probStore, DecodingContext c) {
        ArrayList<CodedBlock> blocks = new ArrayList<CodedBlock>();
        CodedSuperBlock.readCodedBlocks(miCol, miRow, 3, decoder, probStore, c, blocks);
        return new CodedSuperBlock(blocks.toArray(CodedBlock.EMPTY_ARR));
    }

    private static void readCodedBlocks(int miCol, int miRow, int logBlkSize, VPXBooleanDecoder decoder, Probabilities probStore, DecodingContext c, List<CodedBlock> blocks) {
        int part = CodedSuperBlock.readPartition(miCol, miRow, logBlkSize, decoder, probStore, c);
        int nextBlkSize = 1 << logBlkSize >> 1;
        if (part == 0) {
            CodedBlock blk = CodedBlock.read(miCol, miRow, Consts.blSizeLookup[logBlkSize][logBlkSize], decoder, probStore, c);
            blocks.add(blk);
            CodedSuperBlock.saveAboveSizes(miCol, logBlkSize, c);
            CodedSuperBlock.saveLeftSizes(miRow, logBlkSize, c);
        } else if (part == 1) {
            CodedBlock blk = CodedBlock.read(miCol, miRow, Consts.blSizeLookup[logBlkSize][logBlkSize], decoder, probStore, c);
            blocks.add(blk);
            CodedSuperBlock.saveAboveSizes(miCol, nextBlkSize, c);
            if (miCol + nextBlkSize < c.getTileWidth()) {
                blk = CodedBlock.read(miCol + nextBlkSize, miRow, Consts.blSizeLookup[logBlkSize][logBlkSize], decoder, probStore, c);
                blocks.add(blk);
                CodedSuperBlock.saveAboveSizes(miCol + nextBlkSize, nextBlkSize, c);
            }
            CodedSuperBlock.saveLeftSizes(miRow, logBlkSize, c);
        } else if (part == 2) {
            CodedBlock blk = CodedBlock.read(miCol, miRow, Consts.blSizeLookup[logBlkSize][logBlkSize], decoder, probStore, c);
            blocks.add(blk);
            CodedSuperBlock.saveLeftSizes(miRow, nextBlkSize, c);
            if (miRow + nextBlkSize < c.getTileHeight()) {
                blk = CodedBlock.read(miCol, miRow + nextBlkSize, Consts.blSizeLookup[logBlkSize][logBlkSize], decoder, probStore, c);
                blocks.add(blk);
                CodedSuperBlock.saveAboveSizes(miCol, logBlkSize, c);
            }
            CodedSuperBlock.saveLeftSizes(miRow + nextBlkSize, nextBlkSize, c);
        } else if (nextBlkSize > 0) {
            CodedSuperBlock.readCodedBlocks(miCol, miRow, logBlkSize - 1, decoder, probStore, c, blocks);
            if (miCol + nextBlkSize < c.getTileWidth()) {
                CodedSuperBlock.readCodedBlocks(miCol + nextBlkSize, miRow, logBlkSize - 1, decoder, probStore, c, blocks);
            }
            if (miRow + nextBlkSize < c.getTileHeight()) {
                CodedSuperBlock.readCodedBlocks(miCol, miRow + nextBlkSize, logBlkSize - 1, decoder, probStore, c, blocks);
            }
            if (miCol + nextBlkSize < c.getTileWidth() && miRow + nextBlkSize < c.getTileHeight()) {
                CodedSuperBlock.readCodedBlocks(miCol + nextBlkSize, miRow + nextBlkSize, logBlkSize - 1, decoder, probStore, c, blocks);
            }
        } else {
            CodedBlock blk = CodedBlock.read(miCol, miRow, Consts.blSizeLookup[logBlkSize][logBlkSize], decoder, probStore, c);
            blocks.add(blk);
            CodedSuperBlock.saveAboveSizes(miCol, nextBlkSize, c);
            CodedSuperBlock.saveLeftSizes(miRow, nextBlkSize, c);
            if (miCol + nextBlkSize < c.getTileWidth()) {
                blk = CodedBlock.read(miCol + nextBlkSize, miRow, Consts.blSizeLookup[logBlkSize][logBlkSize], decoder, probStore, c);
                blocks.add(blk);
                CodedSuperBlock.saveAboveSizes(miCol + nextBlkSize, nextBlkSize, c);
            }
            if (miRow + nextBlkSize < c.getTileHeight()) {
                blk = CodedBlock.read(miCol, miRow + nextBlkSize, Consts.blSizeLookup[logBlkSize][logBlkSize], decoder, probStore, c);
                blocks.add(blk);
                CodedSuperBlock.saveLeftSizes(miRow + nextBlkSize, nextBlkSize, c);
            }
            if (miCol + nextBlkSize < c.getTileWidth() && miRow + nextBlkSize < c.getTileHeight()) {
                blk = CodedBlock.read(miCol + nextBlkSize, miRow + nextBlkSize, Consts.blSizeLookup[logBlkSize][logBlkSize], decoder, probStore, c);
                blocks.add(blk);
            }
        }
    }

    private static void saveLeftSizes(int miRow, int logBlkSize, DecodingContext c) {
        int miBlkSize = 1 << logBlkSize;
        int[] leftSizes = c.getLeftPartitionSizes();
        for (int i = 0; i < miBlkSize; ++i) {
            leftSizes[miRow % 8 + i] = logBlkSize;
        }
    }

    private static void saveAboveSizes(int miCol, int logBlkSize, DecodingContext c) {
        int miBlkSize = 1 << logBlkSize;
        int[] aboveSizes = c.getAbovePartitionSizes();
        for (int i = 0; i < miBlkSize; ++i) {
            aboveSizes[miCol + i] = logBlkSize;
        }
    }

    private static int readPartition(int miCol, int miRow, int blkSize, VPXBooleanDecoder decoder, Probabilities probStore, DecodingContext c) {
        boolean bottomEdge;
        int ctx = CodedSuperBlock.calcPartitionContext(miCol, miRow, blkSize, c);
        int[] probs = probStore.getPartitionProbs(ctx);
        int halfBlk = 1 << blkSize >> 1;
        boolean rightEdge = miCol + halfBlk < c.getTileWidth();
        boolean bl = bottomEdge = miRow + halfBlk < c.getTileHeight();
        if (rightEdge && bottomEdge) {
            return 3;
        }
        if (rightEdge) {
            return decoder.readBit(probs[0]) == 1 ? 2 : 0;
        }
        if (bottomEdge) {
            return decoder.readBit(probs[1]) == 1 ? 1 : 0;
        }
        return decoder.readTree(Consts.TREE_PARTITION, probs);
    }

    private static int calcPartitionContext(int miCol, int miRow, int blkSize, DecodingContext c) {
        boolean left = false;
        boolean above = false;
        int miBlkSize = 1 << blkSize;
        int[] aboveSizes = c.getAbovePartitionSizes();
        for (int i = 0; i < miBlkSize; ++i) {
            above |= aboveSizes[miCol + i] <= blkSize;
        }
        int[] leftSizes = c.getLeftPartitionSizes();
        for (int i = 0; i < miBlkSize; ++i) {
            left |= leftSizes[miRow % 8 + i] <= blkSize;
        }
        return blkSize * 4 + (above ? 2 : 0) + (left ? 1 : 0);
    }
}

