/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.MidiOutDevice;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Printer;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.spi.MidiDeviceProvider;

public class MidiOutDeviceProvider
extends MidiDeviceProvider {
    private static MidiOutDeviceInfo[] infos;
    private static MidiOutDevice[] devices;
    static /* synthetic */ Class class$com$sun$media$sound$MidiOutDeviceProvider;

    public MidiOutDeviceProvider() {
        if (Printer.trace) {
            Printer.trace("MidiOutDeviceProvider: constructor");
        }
    }

    public MidiDevice.Info[] getDeviceInfo() {
        MidiDevice.Info[] localArray = new MidiDevice.Info[infos.length];
        System.arraycopy(infos, 0, localArray, 0, infos.length);
        return localArray;
    }

    public MidiDevice getDevice(MidiDevice.Info info) {
        if (!(info instanceof MidiOutDeviceInfo)) {
            throw new IllegalArgumentException("MidiDevice " + info.toString() + " not supported by this provider.");
        }
        MidiOutDeviceInfo midiOutInfo = (MidiOutDeviceInfo)info;
        int i = 0;
        while (i < infos.length) {
            if (midiOutInfo == infos[i]) {
                int index = midiOutInfo.getIndex();
                if (devices[index] == null) {
                    MidiOutDeviceProvider.devices[index] = new MidiOutDevice(midiOutInfo);
                }
                return devices[index];
            }
            ++i;
        }
        throw new IllegalArgumentException("MidiDevice " + info.toString() + " not supported by this provider.");
    }

    private static native int nGetNumDevices();

    private static native String nGetName(int var0);

    private static native String nGetVendor(int var0);

    private static native String nGetDescription(int var0);

    private static native String nGetVersion(int var0);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (Printer.trace) {
            Printer.trace("MidiOutDeviceProvider: static");
        }
        Platform.initialize();
        int numDevices = MidiOutDeviceProvider.nGetNumDevices();
        infos = new MidiOutDeviceInfo[numDevices];
        devices = new MidiOutDevice[numDevices];
        int i = 0;
        while (i < infos.length) {
            String name = MidiOutDeviceProvider.nGetName(i);
            String vendor = MidiOutDeviceProvider.nGetVendor(i);
            String description = MidiOutDeviceProvider.nGetDescription(i);
            String version = MidiOutDeviceProvider.nGetVersion(i);
            MidiOutDeviceProvider.infos[i] = new MidiOutDeviceInfo(name, vendor, description, version, i, class$com$sun$media$sound$MidiOutDeviceProvider == null ? MidiOutDeviceProvider.class$("com.sun.media.sound.MidiOutDeviceProvider") : class$com$sun$media$sound$MidiOutDeviceProvider);
            ++i;
        }
        if (Printer.trace) {
            Printer.trace("MidiOutDeviceProvider: static: found numDevices: " + numDevices);
        }
    }

    static class MidiOutDeviceInfo
    extends MidiDevice.Info {
        private int index;
        private Class providerClass;

        private MidiOutDeviceInfo(String name, String vendor, String description, String version, int index, Class providerClass) {
            super(name, vendor, description, version);
            this.index = index;
            this.providerClass = providerClass;
        }

        int getIndex() {
            return this.index;
        }
    }
}

