/*
 * Decompiled with CFR 0.152.
 */
package com.github.stuxuhai.jpinyin;

import com.github.stuxuhai.jpinyin.ChineseHelper;
import com.github.stuxuhai.jpinyin.PinyinFormat;
import com.github.stuxuhai.jpinyin.PinyinResource;
import java.util.LinkedHashSet;
import java.util.Properties;

public class PinyinHelper {
    private static final Properties PINYIN_TABLE = PinyinResource.getPinyinTable();
    private static final Properties MUTIL_PINYIN_TABLE = PinyinResource.getMutilPintinTable();
    private static final String PINYIN_SEPARATOR = ",";
    private static final String ALL_UNMARKED_VOWEL = "aeiouv";
    private static final String ALL_MARKED_VOWEL = "\u0101\u00e1\u01ce\u00e0\u0113\u00e9\u011b\u00e8\u012b\u00ed\u01d0\u00ec\u014d\u00f3\u01d2\u00f2\u016b\u00fa\u01d4\u00f9\u01d6\u01d8\u01da\u01dc";

    private static String[] convertWithToneNumber(String pinyinArrayString) {
        String[] pinyinArray = pinyinArrayString.split(PINYIN_SEPARATOR);
        int i = pinyinArray.length - 1;
        while (i >= 0) {
            boolean hasMarkedChar = false;
            String originalPinyin = pinyinArray[i].replaceAll("\u00fc", "v");
            int j = originalPinyin.length() - 1;
            while (j >= 0) {
                char originalChar = originalPinyin.charAt(j);
                if (originalChar < 'a' || originalChar > 'z') {
                    int indexInAllMarked = ALL_MARKED_VOWEL.indexOf(originalChar);
                    int toneNumber = indexInAllMarked % 4 + 1;
                    char replaceChar = ALL_UNMARKED_VOWEL.charAt((indexInAllMarked - indexInAllMarked % 4) / 4);
                    pinyinArray[i] = String.valueOf(originalPinyin.replaceAll(String.valueOf(originalChar), String.valueOf(replaceChar))) + toneNumber;
                    hasMarkedChar = true;
                    break;
                }
                --j;
            }
            if (!hasMarkedChar) {
                pinyinArray[i] = String.valueOf(originalPinyin) + "5";
            }
            --i;
        }
        return pinyinArray;
    }

    private static String[] convertWithoutTone(String pinyinArrayString) {
        int i = ALL_MARKED_VOWEL.length() - 1;
        while (i >= 0) {
            char originalChar = ALL_MARKED_VOWEL.charAt(i);
            char replaceChar = ALL_UNMARKED_VOWEL.charAt((i - i % 4) / 4);
            pinyinArrayString = pinyinArrayString.replaceAll(String.valueOf(originalChar), String.valueOf(replaceChar));
            --i;
        }
        String[] pinyinArray = pinyinArrayString.replaceAll("\u00fc", "v").split(PINYIN_SEPARATOR);
        LinkedHashSet<String> pinyinSet = new LinkedHashSet<String>();
        String[] stringArray = pinyinArray;
        int n = pinyinArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pinyin = stringArray[n2];
            pinyinSet.add(pinyin);
            ++n2;
        }
        return pinyinSet.toArray(new String[pinyinSet.size()]);
    }

    private static String[] formatPinyin(String pinyinString, PinyinFormat pinyinFormat) {
        if (pinyinFormat == PinyinFormat.WITH_TONE_MARK) {
            return pinyinString.split(PINYIN_SEPARATOR);
        }
        if (pinyinFormat == PinyinFormat.WITH_TONE_NUMBER) {
            return PinyinHelper.convertWithToneNumber(pinyinString);
        }
        if (pinyinFormat == PinyinFormat.WITHOUT_TONE) {
            return PinyinHelper.convertWithoutTone(pinyinString);
        }
        return null;
    }

    public static String[] convertToPinyinArray(char c, PinyinFormat pinyinFormat) {
        String pinyin = PINYIN_TABLE.getProperty(String.valueOf(c));
        if (pinyin != null && !pinyin.equals("null")) {
            return PinyinHelper.formatPinyin(pinyin, pinyinFormat);
        }
        return null;
    }

    public static String[] convertToPinyinArray(char c) {
        return PinyinHelper.convertToPinyinArray(c, PinyinFormat.WITH_TONE_MARK);
    }

    public static String convertToPinyinString(String str, String separator, PinyinFormat pinyinFormat) {
        str = ChineseHelper.convertToSimplifiedChinese(str);
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int len = str.length();
        while (i < len) {
            char c = str.charAt(i);
            if (ChineseHelper.isChinese(c) || c == '\u3007') {
                boolean isFoundFlag = false;
                int rightMove = 3;
                int rightIndex = i + rightMove < len ? i + rightMove : len - 1;
                while (rightIndex > i) {
                    String cizu = str.substring(i, rightIndex + 1);
                    if (MUTIL_PINYIN_TABLE.containsKey(cizu)) {
                        String[] pinyinArray = PinyinHelper.formatPinyin(MUTIL_PINYIN_TABLE.getProperty(cizu), pinyinFormat);
                        int j = 0;
                        int l = pinyinArray.length;
                        while (j < l) {
                            sb.append(pinyinArray[j]);
                            if (j < l - 1) {
                                sb.append(separator);
                            }
                            ++j;
                        }
                        i = rightIndex;
                        isFoundFlag = true;
                        break;
                    }
                    --rightIndex;
                }
                if (!isFoundFlag) {
                    String[] pinyinArray = PinyinHelper.convertToPinyinArray(str.charAt(i), pinyinFormat);
                    if (pinyinArray != null) {
                        sb.append(pinyinArray[0]);
                    } else {
                        sb.append(str.charAt(i));
                    }
                }
                if (i < len - 1) {
                    sb.append(separator);
                }
            } else {
                sb.append(c);
                if (i + 1 < len && ChineseHelper.isChinese(str.charAt(i + 1))) {
                    sb.append(separator);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public static String convertToPinyinString(String str, String separator) {
        return PinyinHelper.convertToPinyinString(str, separator, PinyinFormat.WITH_TONE_MARK);
    }

    public static boolean hasMultiPinyin(char c) {
        String[] pinyinArray = PinyinHelper.convertToPinyinArray(c);
        return pinyinArray != null && pinyinArray.length > 1;
    }

    public static String getShortPinyin(String str) {
        String separator = "#";
        StringBuilder sb = new StringBuilder();
        char[] charArray = new char[str.length()];
        int i = 0;
        int len = str.length();
        while (i < len) {
            char c = str.charAt(i);
            if (!ChineseHelper.isChinese(c) && c != '\u3007') {
                charArray[i] = c;
            } else {
                String[] pinyinArray;
                int j = i + 1;
                sb.append(c);
                while (j < len && (ChineseHelper.isChinese(str.charAt(j)) || str.charAt(j) == '\u3007')) {
                    sb.append(str.charAt(j));
                    ++j;
                }
                String hanziPinyin = PinyinHelper.convertToPinyinString(sb.toString(), separator, PinyinFormat.WITHOUT_TONE);
                String[] stringArray = pinyinArray = hanziPinyin.split(separator);
                int n = pinyinArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String string = stringArray[n2];
                    charArray[i] = string.charAt(0);
                    ++i;
                    ++n2;
                }
                --i;
                sb.delete(0, sb.toString().length());
                sb.trimToSize();
            }
            ++i;
        }
        return String.valueOf(charArray);
    }
}

