/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.png;

import com.drew.imaging.png.PngColorType;
import com.drew.imaging.png.PngProcessingException;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.annotations.NotNull;
import java.io.IOException;

public class PngHeader {
    private int _imageWidth;
    private int _imageHeight;
    private byte _bitsPerSample;
    @NotNull
    private PngColorType _colorType;
    private byte _compressionType;
    private byte _filterMethod;
    private byte _interlaceMethod;

    public PngHeader(@NotNull byte[] byArray) throws PngProcessingException {
        if (byArray.length != 13) {
            throw new PngProcessingException("PNG header chunk must have 13 data bytes");
        }
        SequentialByteArrayReader sequentialByteArrayReader = new SequentialByteArrayReader(byArray);
        try {
            this._imageWidth = sequentialByteArrayReader.getInt32();
            this._imageHeight = sequentialByteArrayReader.getInt32();
            this._bitsPerSample = sequentialByteArrayReader.getInt8();
            byte by = sequentialByteArrayReader.getInt8();
            PngColorType pngColorType = PngColorType.fromNumericValue(by);
            if (pngColorType == null) {
                throw new PngProcessingException("Unexpected PNG color type: " + by);
            }
            this._colorType = pngColorType;
            this._compressionType = sequentialByteArrayReader.getInt8();
            this._filterMethod = sequentialByteArrayReader.getInt8();
            this._interlaceMethod = sequentialByteArrayReader.getInt8();
        }
        catch (IOException iOException) {
            throw new PngProcessingException(iOException);
        }
    }

    public int getImageWidth() {
        return this._imageWidth;
    }

    public int getImageHeight() {
        return this._imageHeight;
    }

    public byte getBitsPerSample() {
        return this._bitsPerSample;
    }

    @NotNull
    public PngColorType getColorType() {
        return this._colorType;
    }

    public byte getCompressionType() {
        return this._compressionType;
    }

    public byte getFilterMethod() {
        return this._filterMethod;
    }

    public byte getInterlaceMethod() {
        return this._interlaceMethod;
    }
}

