/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.ico;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.ico.IcoDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IcoDescriptor
extends TagDescriptor<IcoDirectory> {
    public IcoDescriptor(@NotNull IcoDirectory icoDirectory) {
        super(icoDirectory);
    }

    @Override
    public String getDescription(int n) {
        switch (n) {
            case 1: {
                return this.getImageTypeDescription();
            }
            case 2: {
                return this.getImageWidthDescription();
            }
            case 3: {
                return this.getImageHeightDescription();
            }
            case 4: {
                return this.getColourPaletteSizeDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getImageTypeDescription() {
        return this.getIndexedDescription(1, 1, "Icon", "Cursor");
    }

    @Nullable
    public String getImageWidthDescription() {
        Integer n = ((IcoDirectory)this._directory).getInteger(2);
        if (n == null) {
            return null;
        }
        return (n == 0 ? 256 : n) + " pixels";
    }

    @Nullable
    public String getImageHeightDescription() {
        Integer n = ((IcoDirectory)this._directory).getInteger(3);
        if (n == null) {
            return null;
        }
        return (n == 0 ? 256 : n) + " pixels";
    }

    @Nullable
    public String getColourPaletteSizeDescription() {
        Integer n = ((IcoDirectory)this._directory).getInteger(4);
        if (n == null) {
            return null;
        }
        return n == 0 ? "No palette" : n + " colour" + (n == 1 ? "" : "s");
    }
}

