/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.png;

import com.drew.imaging.png.PngChunk;
import com.drew.imaging.png.PngChunkType;
import com.drew.imaging.png.PngProcessingException;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PngChunkReader {
    private static final byte[] PNG_SIGNATURE_BYTES = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};

    public Iterable<PngChunk> extract(@NotNull SequentialReader sequentialReader, @Nullable Set<PngChunkType> set) throws PngProcessingException, IOException {
        sequentialReader.setMotorolaByteOrder(true);
        if (!Arrays.equals(PNG_SIGNATURE_BYTES, sequentialReader.getBytes(PNG_SIGNATURE_BYTES.length))) {
            throw new PngProcessingException("PNG signature mismatch");
        }
        boolean bl = false;
        boolean bl2 = false;
        ArrayList<PngChunk> arrayList = new ArrayList<PngChunk>();
        HashSet<PngChunkType> hashSet = new HashSet<PngChunkType>();
        while (!bl2) {
            int n = sequentialReader.getInt32();
            PngChunkType pngChunkType = new PngChunkType(sequentialReader.getBytes(4));
            boolean bl3 = set == null || set.contains(pngChunkType);
            byte[] byArray = sequentialReader.getBytes(n);
            sequentialReader.skip(4L);
            if (bl3 && hashSet.contains(pngChunkType) && !pngChunkType.areMultipleAllowed()) {
                throw new PngProcessingException(String.format("Observed multiple instances of PNG chunk '%s', for which multiples are not allowed", pngChunkType));
            }
            if (pngChunkType.equals(PngChunkType.IHDR)) {
                bl = true;
            } else if (!bl) {
                throw new PngProcessingException(String.format("First chunk should be '%s', but '%s' was observed", PngChunkType.IHDR, pngChunkType));
            }
            if (pngChunkType.equals(PngChunkType.IEND)) {
                bl2 = true;
            }
            if (bl3) {
                arrayList.add(new PngChunk(pngChunkType, byArray));
            }
            hashSet.add(pngChunkType);
        }
        return arrayList;
    }
}

