/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Metadata {
    @NotNull
    private final List<Directory> _directories = new ArrayList<Directory>();

    @NotNull
    public Iterable<Directory> getDirectories() {
        return this._directories;
    }

    @Nullable
    public <T extends Directory> Collection<T> getDirectoriesOfType(Class<T> clazz) {
        ArrayList<Directory> arrayList = new ArrayList<Directory>();
        for (Directory directory : this._directories) {
            if (!clazz.isAssignableFrom(directory.getClass())) continue;
            arrayList.add(directory);
        }
        return arrayList;
    }

    public int getDirectoryCount() {
        return this._directories.size();
    }

    public <T extends Directory> void addDirectory(@NotNull T t) {
        this._directories.add(t);
    }

    @Nullable
    public <T extends Directory> T getFirstDirectoryOfType(@NotNull Class<T> clazz) {
        for (Directory directory : this._directories) {
            if (!clazz.isAssignableFrom(directory.getClass())) continue;
            return (T)directory;
        }
        return null;
    }

    public boolean containsDirectoryOfType(Class<? extends Directory> clazz) {
        for (Directory directory : this._directories) {
            if (!clazz.isAssignableFrom(directory.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrors() {
        for (Directory directory : this.getDirectories()) {
            if (!directory.hasErrors()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        int n = this.getDirectoryCount();
        return String.format("Metadata (%d %s)", n, n == 1 ? "directory" : "directories");
    }
}

