/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.imaging.tiff.TiffProcessingException;
import com.drew.imaging.tiff.TiffReader;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.RandomAccessReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifTiffHandler;
import java.io.IOException;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExifReader
implements JpegSegmentMetadataReader {
    public static final String JPEG_SEGMENT_PREAMBLE = "Exif\u0000\u0000";
    private boolean _storeThumbnailBytes = true;

    public boolean isStoreThumbnailBytes() {
        return this._storeThumbnailBytes;
    }

    public void setStoreThumbnailBytes(boolean bl) {
        this._storeThumbnailBytes = bl;
    }

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APP1);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> iterable, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        assert (jpegSegmentType == JpegSegmentType.APP1);
        for (byte[] byArray : iterable) {
            if (byArray.length < JPEG_SEGMENT_PREAMBLE.length() || !new String(byArray, 0, JPEG_SEGMENT_PREAMBLE.length()).equals(JPEG_SEGMENT_PREAMBLE)) continue;
            this.extract(new ByteArrayReader(byArray), metadata, JPEG_SEGMENT_PREAMBLE.length());
        }
    }

    public void extract(@NotNull RandomAccessReader randomAccessReader, @NotNull Metadata metadata) {
        this.extract(randomAccessReader, metadata, 0);
    }

    public void extract(@NotNull RandomAccessReader randomAccessReader, @NotNull Metadata metadata, int n) {
        this.extract(randomAccessReader, metadata, n, null);
    }

    public void extract(@NotNull RandomAccessReader randomAccessReader, @NotNull Metadata metadata, int n, @Nullable Directory directory) {
        try {
            new TiffReader().processTiff(randomAccessReader, new ExifTiffHandler(metadata, this._storeThumbnailBytes, directory), n);
        }
        catch (TiffProcessingException tiffProcessingException) {
            tiffProcessingException.printStackTrace(System.err);
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
        }
    }
}

