/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.makernotes;

import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.exif.makernotes.OlympusCameraSettingsMakernoteDirectory;
import java.text.DecimalFormat;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OlympusCameraSettingsMakernoteDescriptor
extends TagDescriptor<OlympusCameraSettingsMakernoteDirectory> {
    private static final HashMap<Integer, String> _filters = new HashMap();

    public OlympusCameraSettingsMakernoteDescriptor(@NotNull OlympusCameraSettingsMakernoteDirectory olympusCameraSettingsMakernoteDirectory) {
        super(olympusCameraSettingsMakernoteDirectory);
    }

    @Override
    @Nullable
    public String getDescription(int n) {
        switch (n) {
            case 0: {
                return this.getCameraSettingsVersionDescription();
            }
            case 256: {
                return this.getPreviewImageValidDescription();
            }
            case 512: {
                return this.getExposureModeDescription();
            }
            case 513: {
                return this.getAeLockDescription();
            }
            case 514: {
                return this.getMeteringModeDescription();
            }
            case 515: {
                return this.getExposureShiftDescription();
            }
            case 516: {
                return this.getNdFilterDescription();
            }
            case 768: {
                return this.getMacroModeDescription();
            }
            case 769: {
                return this.getFocusModeDescription();
            }
            case 770: {
                return this.getFocusProcessDescription();
            }
            case 771: {
                return this.getAfSearchDescription();
            }
            case 772: {
                return this.getAfAreasDescription();
            }
            case 773: {
                return this.getAfPointSelectedDescription();
            }
            case 774: {
                return this.getAfFineTuneDescription();
            }
            case 1024: {
                return this.getFlashModeDescription();
            }
            case 1027: {
                return this.getFlashRemoteControlDescription();
            }
            case 1028: {
                return this.getFlashControlModeDescription();
            }
            case 1029: {
                return this.getFlashIntensityDescription();
            }
            case 1030: {
                return this.getManualFlashStrengthDescription();
            }
            case 1280: {
                return this.getWhiteBalance2Description();
            }
            case 1281: {
                return this.getWhiteBalanceTemperatureDescription();
            }
            case 1283: {
                return this.getCustomSaturationDescription();
            }
            case 1284: {
                return this.getModifiedSaturationDescription();
            }
            case 1285: {
                return this.getContrastSettingDescription();
            }
            case 1286: {
                return this.getSharpnessSettingDescription();
            }
            case 1287: {
                return this.getColorSpaceDescription();
            }
            case 1289: {
                return this.getSceneModeDescription();
            }
            case 1290: {
                return this.getNoiseReductionDescription();
            }
            case 1291: {
                return this.getDistortionCorrectionDescription();
            }
            case 1292: {
                return this.getShadingCompensationDescription();
            }
            case 1295: {
                return this.getGradationDescription();
            }
            case 1312: {
                return this.getPictureModeDescription();
            }
            case 1313: {
                return this.getPictureModeSaturationDescription();
            }
            case 1315: {
                return this.getPictureModeContrastDescription();
            }
            case 1316: {
                return this.getPictureModeSharpnessDescription();
            }
            case 1317: {
                return this.getPictureModeBWFilterDescription();
            }
            case 1318: {
                return this.getPictureModeToneDescription();
            }
            case 1319: {
                return this.getNoiseFilterDescription();
            }
            case 1321: {
                return this.getArtFilterDescription();
            }
            case 1324: {
                return this.getMagicFilterDescription();
            }
            case 1325: {
                return this.getPictureModeEffectDescription();
            }
            case 1326: {
                return this.getToneLevelDescription();
            }
            case 1327: {
                return this.getArtFilterEffectDescription();
            }
            case 1536: {
                return this.getDriveModeDescription();
            }
            case 1537: {
                return this.getPanoramaModeDescription();
            }
            case 1539: {
                return this.getImageQuality2Description();
            }
            case 1540: {
                return this.getImageStabilizationDescription();
            }
            case 2052: {
                return this.getStackedImageDescription();
            }
            case 2304: {
                return this.getManometerPressureDescription();
            }
            case 2305: {
                return this.getManometerReadingDescription();
            }
            case 2306: {
                return this.getExtendedWBDetectDescription();
            }
            case 2307: {
                return this.getRollAngleDescription();
            }
            case 2308: {
                return this.getPitchAngleDescription();
            }
            case 2312: {
                return this.getDateTimeUTCDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getCameraSettingsVersionDescription() {
        return this.getVersionBytesDescription(0, 4);
    }

    @Nullable
    public String getPreviewImageValidDescription() {
        return this.getIndexedDescription(256, "No", "Yes");
    }

    @Nullable
    public String getExposureModeDescription() {
        return this.getIndexedDescription(512, 1, "Manual", "Program", "Aperture-priority AE", "Shutter speed priority", "Program-shift");
    }

    @Nullable
    public String getAeLockDescription() {
        return this.getIndexedDescription(513, "Off", "On");
    }

    @Nullable
    public String getMeteringModeDescription() {
        Integer n = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(514);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 2: {
                return "Center-weighted average";
            }
            case 3: {
                return "Spot";
            }
            case 5: {
                return "ESP";
            }
            case 261: {
                return "Pattern+AF";
            }
            case 515: {
                return "Spot+Highlight control";
            }
            case 1027: {
                return "Spot+Shadow control";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getExposureShiftDescription() {
        return this.getRationalOrDoubleString(515);
    }

    @Nullable
    public String getNdFilterDescription() {
        return this.getIndexedDescription(516, "Off", "On");
    }

    @Nullable
    public String getMacroModeDescription() {
        return this.getIndexedDescription(768, "Off", "On", "Super Macro");
    }

    @Nullable
    public String getFocusModeDescription() {
        Comparable<Integer> comparable;
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(769);
        if (nArray == null) {
            comparable = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(769);
            if (comparable == null) {
                return null;
            }
            nArray = new int[]{(Integer)comparable};
        }
        if (nArray.length == 0) {
            return null;
        }
        comparable = new StringBuilder();
        switch (nArray[0]) {
            case 0: {
                ((StringBuilder)comparable).append("Single AF");
                break;
            }
            case 1: {
                ((StringBuilder)comparable).append("Sequential shooting AF");
                break;
            }
            case 2: {
                ((StringBuilder)comparable).append("Continuous AF");
                break;
            }
            case 3: {
                ((StringBuilder)comparable).append("Multi AF");
                break;
            }
            case 4: {
                ((StringBuilder)comparable).append("Face detect");
                break;
            }
            case 10: {
                ((StringBuilder)comparable).append("MF");
                break;
            }
            default: {
                ((StringBuilder)comparable).append("Unknown (" + nArray[0] + ")");
            }
        }
        if (nArray.length > 1) {
            ((StringBuilder)comparable).append("; ");
            int n = nArray[1];
            if (n == 0) {
                ((StringBuilder)comparable).append("(none)");
            } else {
                if ((n & 1) > 0) {
                    ((StringBuilder)comparable).append("S-AF, ");
                }
                if ((n >> 2 & 1) > 0) {
                    ((StringBuilder)comparable).append("C-AF, ");
                }
                if ((n >> 4 & 1) > 0) {
                    ((StringBuilder)comparable).append("MF, ");
                }
                if ((n >> 5 & 1) > 0) {
                    ((StringBuilder)comparable).append("Face detect, ");
                }
                if ((n >> 6 & 1) > 0) {
                    ((StringBuilder)comparable).append("Imager AF, ");
                }
                if ((n >> 7 & 1) > 0) {
                    ((StringBuilder)comparable).append("Live View Magnification Frame, ");
                }
                if ((n >> 8 & 1) > 0) {
                    ((StringBuilder)comparable).append("AF sensor, ");
                }
                ((StringBuilder)comparable).setLength(((StringBuilder)comparable).length() - 2);
            }
        }
        return ((StringBuilder)comparable).toString();
    }

    @Nullable
    public String getFocusProcessDescription() {
        Comparable<Integer> comparable;
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(770);
        if (nArray == null) {
            comparable = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(770);
            if (comparable == null) {
                return null;
            }
            nArray = new int[]{(Integer)comparable};
        }
        if (nArray.length == 0) {
            return null;
        }
        comparable = new StringBuilder();
        switch (nArray[0]) {
            case 0: {
                ((StringBuilder)comparable).append("AF not used");
                break;
            }
            case 1: {
                ((StringBuilder)comparable).append("AF used");
                break;
            }
            default: {
                ((StringBuilder)comparable).append("Unknown (" + nArray[0] + ")");
            }
        }
        if (nArray.length > 1) {
            ((StringBuilder)comparable).append("; " + nArray[1]);
        }
        return ((StringBuilder)comparable).toString();
    }

    @Nullable
    public String getAfSearchDescription() {
        return this.getIndexedDescription(771, "Not Ready", "Ready");
    }

    @Nullable
    public String getAfAreasDescription() {
        Object object = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getObject(772);
        if (object == null || !(object instanceof long[])) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (long l : (long[])object) {
            if (l == 0L) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(", ");
            }
            if (l == 913916549L) {
                stringBuilder.append("Left ");
            } else if (l == 2038007173L) {
                stringBuilder.append("Center ");
            } else if (l == 3178875269L) {
                stringBuilder.append("Right ");
            }
            stringBuilder.append(String.format("(%d/255,%d/255)-(%d/255,%d/255)", l >> 24 & 0xFFL, l >> 16 & 0xFFL, l >> 8 & 0xFFL, l & 0xFFL));
        }
        return stringBuilder.length() == 0 ? null : stringBuilder.toString();
    }

    @Nullable
    public String getAfPointSelectedDescription() {
        Rational[] rationalArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getRationalArray(773);
        if (rationalArray == null) {
            return "n/a";
        }
        if (rationalArray.length < 4) {
            return null;
        }
        int n = 0;
        if (rationalArray.length == 5 && rationalArray[0].longValue() == 0L) {
            n = 1;
        }
        int n2 = (int)(rationalArray[n].doubleValue() * 100.0);
        int n3 = (int)(rationalArray[n + 1].doubleValue() * 100.0);
        int n4 = (int)(rationalArray[n + 2].doubleValue() * 100.0);
        int n5 = (int)(rationalArray[n + 3].doubleValue() * 100.0);
        return String.format("(%d%%,%d%%) (%d%%,%d%%)", n2, n3, n4, n5);
    }

    @Nullable
    public String getAfFineTuneDescription() {
        return this.getIndexedDescription(774, "Off", "On");
    }

    @Nullable
    public String getFlashModeDescription() {
        Integer n = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1024);
        if (n == null) {
            return null;
        }
        if (n == 0) {
            return "Off";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        if ((n2 & 1) != 0) {
            stringBuilder.append("On, ");
        }
        if ((n2 >> 1 & 1) != 0) {
            stringBuilder.append("Fill-in, ");
        }
        if ((n2 >> 2 & 1) != 0) {
            stringBuilder.append("Red-eye, ");
        }
        if ((n2 >> 3 & 1) != 0) {
            stringBuilder.append("Slow-sync, ");
        }
        if ((n2 >> 4 & 1) != 0) {
            stringBuilder.append("Forced On, ");
        }
        if ((n2 >> 5 & 1) != 0) {
            stringBuilder.append("2nd Curtain, ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    @Nullable
    public String getFlashRemoteControlDescription() {
        Integer n = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1027);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Off";
            }
            case 1: {
                return "Channel 1, Low";
            }
            case 2: {
                return "Channel 2, Low";
            }
            case 3: {
                return "Channel 3, Low";
            }
            case 4: {
                return "Channel 4, Low";
            }
            case 9: {
                return "Channel 1, Mid";
            }
            case 10: {
                return "Channel 2, Mid";
            }
            case 11: {
                return "Channel 3, Mid";
            }
            case 12: {
                return "Channel 4, Mid";
            }
            case 17: {
                return "Channel 1, High";
            }
            case 18: {
                return "Channel 2, High";
            }
            case 19: {
                return "Channel 3, High";
            }
            case 20: {
                return "Channel 4, High";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getFlashControlModeDescription() {
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1028);
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        switch (nArray[0]) {
            case 0: {
                stringBuilder.append("Off");
                break;
            }
            case 3: {
                stringBuilder.append("TTL");
                break;
            }
            case 4: {
                stringBuilder.append("Auto");
                break;
            }
            case 5: {
                stringBuilder.append("Manual");
                break;
            }
            default: {
                stringBuilder.append("Unknown (").append(nArray[0]).append(")");
            }
        }
        for (int i = 1; i < nArray.length; ++i) {
            stringBuilder.append("; ").append(nArray[i]);
        }
        return stringBuilder.toString();
    }

    @Nullable
    public String getFlashIntensityDescription() {
        Rational[] rationalArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getRationalArray(1029);
        if (rationalArray == null || rationalArray.length == 0) {
            return null;
        }
        if (rationalArray.length == 3) {
            if (rationalArray[0].getDenominator() == 0L && rationalArray[1].getDenominator() == 0L && rationalArray[2].getDenominator() == 0L) {
                return "n/a";
            }
        } else if (rationalArray.length == 4 && rationalArray[0].getDenominator() == 0L && rationalArray[1].getDenominator() == 0L && rationalArray[2].getDenominator() == 0L && rationalArray[3].getDenominator() == 0L) {
            return "n/a (x4)";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Rational rational : rationalArray) {
            stringBuilder.append(rational).append(", ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    @Nullable
    public String getManualFlashStrengthDescription() {
        Rational[] rationalArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getRationalArray(1030);
        if (rationalArray == null || rationalArray.length == 0) {
            return "n/a";
        }
        if (rationalArray.length == 3) {
            if (rationalArray[0].getDenominator() == 0L && rationalArray[1].getDenominator() == 0L && rationalArray[2].getDenominator() == 0L) {
                return "n/a";
            }
        } else if (rationalArray.length == 4 && rationalArray[0].getDenominator() == 0L && rationalArray[1].getDenominator() == 0L && rationalArray[2].getDenominator() == 0L && rationalArray[3].getDenominator() == 0L) {
            return "n/a (x4)";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Rational rational : rationalArray) {
            stringBuilder.append(rational).append(", ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    @Nullable
    public String getWhiteBalance2Description() {
        Integer n = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1280);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Auto (Keep Warm Color Off)";
            }
            case 16: {
                return "7500K (Fine Weather with Shade)";
            }
            case 17: {
                return "6000K (Cloudy)";
            }
            case 18: {
                return "5300K (Fine Weather)";
            }
            case 20: {
                return "3000K (Tungsten light)";
            }
            case 21: {
                return "3600K (Tungsten light-like)";
            }
            case 22: {
                return "Auto Setup";
            }
            case 23: {
                return "5500K (Flash)";
            }
            case 33: {
                return "6600K (Daylight fluorescent)";
            }
            case 34: {
                return "4500K (Neutral white fluorescent)";
            }
            case 35: {
                return "4000K (Cool white fluorescent)";
            }
            case 36: {
                return "White Fluorescent";
            }
            case 48: {
                return "3600K (Tungsten light-like)";
            }
            case 67: {
                return "Underwater";
            }
            case 256: {
                return "One Touch WB 1";
            }
            case 257: {
                return "One Touch WB 2";
            }
            case 258: {
                return "One Touch WB 3";
            }
            case 259: {
                return "One Touch WB 4";
            }
            case 512: {
                return "Custom WB 1";
            }
            case 513: {
                return "Custom WB 2";
            }
            case 514: {
                return "Custom WB 3";
            }
            case 515: {
                return "Custom WB 4";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getWhiteBalanceTemperatureDescription() {
        Integer n = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1281);
        if (n == null) {
            return null;
        }
        if (n == 0) {
            return "Auto";
        }
        return n.toString();
    }

    @Nullable
    public String getCustomSaturationDescription() {
        return this.getValueMinMaxDescription(1283);
    }

    @Nullable
    public String getModifiedSaturationDescription() {
        return this.getIndexedDescription(1284, "Off", "CM1 (Red Enhance)", "CM2 (Green Enhance)", "CM3 (Blue Enhance)", "CM4 (Skin Tones)");
    }

    @Nullable
    public String getContrastSettingDescription() {
        return this.getValueMinMaxDescription(1285);
    }

    @Nullable
    public String getSharpnessSettingDescription() {
        return this.getValueMinMaxDescription(1286);
    }

    @Nullable
    public String getColorSpaceDescription() {
        return this.getIndexedDescription(1287, "sRGB", "Adobe RGB", "Pro Photo RGB");
    }

    @Nullable
    public String getSceneModeDescription() {
        Integer n = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1289);
        if (n == null) {
            return null;
        }
        switch (n) {
            case 0: {
                return "Standard";
            }
            case 6: {
                return "Auto";
            }
            case 7: {
                return "Sport";
            }
            case 8: {
                return "Portrait";
            }
            case 9: {
                return "Landscape+Portrait";
            }
            case 10: {
                return "Landscape";
            }
            case 11: {
                return "Night Scene";
            }
            case 12: {
                return "Self Portrait";
            }
            case 13: {
                return "Panorama";
            }
            case 14: {
                return "2 in 1";
            }
            case 15: {
                return "Movie";
            }
            case 16: {
                return "Landscape+Portrait";
            }
            case 17: {
                return "Night+Portrait";
            }
            case 18: {
                return "Indoor";
            }
            case 19: {
                return "Fireworks";
            }
            case 20: {
                return "Sunset";
            }
            case 21: {
                return "Beauty Skin";
            }
            case 22: {
                return "Macro";
            }
            case 23: {
                return "Super Macro";
            }
            case 24: {
                return "Food";
            }
            case 25: {
                return "Documents";
            }
            case 26: {
                return "Museum";
            }
            case 27: {
                return "Shoot & Select";
            }
            case 28: {
                return "Beach & Snow";
            }
            case 29: {
                return "Self Portrait+Timer";
            }
            case 30: {
                return "Candle";
            }
            case 31: {
                return "Available Light";
            }
            case 32: {
                return "Behind Glass";
            }
            case 33: {
                return "My Mode";
            }
            case 34: {
                return "Pet";
            }
            case 35: {
                return "Underwater Wide1";
            }
            case 36: {
                return "Underwater Macro";
            }
            case 37: {
                return "Shoot & Select1";
            }
            case 38: {
                return "Shoot & Select2";
            }
            case 39: {
                return "High Key";
            }
            case 40: {
                return "Digital Image Stabilization";
            }
            case 41: {
                return "Auction";
            }
            case 42: {
                return "Beach";
            }
            case 43: {
                return "Snow";
            }
            case 44: {
                return "Underwater Wide2";
            }
            case 45: {
                return "Low Key";
            }
            case 46: {
                return "Children";
            }
            case 47: {
                return "Vivid";
            }
            case 48: {
                return "Nature Macro";
            }
            case 49: {
                return "Underwater Snapshot";
            }
            case 50: {
                return "Shooting Guide";
            }
            case 54: {
                return "Face Portrait";
            }
            case 57: {
                return "Bulb";
            }
            case 59: {
                return "Smile Shot";
            }
            case 60: {
                return "Quick Shutter";
            }
            case 63: {
                return "Slow Shutter";
            }
            case 64: {
                return "Bird Watching";
            }
            case 65: {
                return "Multiple Exposure";
            }
            case 66: {
                return "e-Portrait";
            }
            case 67: {
                return "Soft Background Shot";
            }
            case 142: {
                return "Hand-held Starlight";
            }
            case 154: {
                return "HDR";
            }
        }
        return "Unknown (" + n + ")";
    }

    @Nullable
    public String getNoiseReductionDescription() {
        Integer n = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1290);
        if (n == null) {
            return null;
        }
        if (n == 0) {
            return "(none)";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = n;
        if ((n2 & 1) != 0) {
            stringBuilder.append("Noise Reduction, ");
        }
        if ((n2 >> 1 & 1) != 0) {
            stringBuilder.append("Noise Filter, ");
        }
        if ((n2 >> 2 & 1) != 0) {
            stringBuilder.append("Noise Filter (ISO Boost), ");
        }
        if ((n2 >> 3 & 1) != 0) {
            stringBuilder.append("Auto, ");
        }
        return stringBuilder.length() != 0 ? stringBuilder.substring(0, stringBuilder.length() - 2) : "(none)";
    }

    @Nullable
    public String getDistortionCorrectionDescription() {
        return this.getIndexedDescription(1291, "Off", "On");
    }

    @Nullable
    public String getShadingCompensationDescription() {
        return this.getIndexedDescription(1292, "Off", "On");
    }

    @Nullable
    public String getGradationDescription() {
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1295);
        if (nArray == null || nArray.length < 3) {
            return null;
        }
        String string = String.format("%d %d %d", nArray[0], nArray[1], nArray[2]);
        String string2 = string.equals("0 0 0") ? "n/a" : (string.equals("-1 -1 1") ? "Low Key" : (string.equals("0 -1 1") ? "Normal" : (string.equals("1 -1 1") ? "High Key" : "Unknown (" + string + ")")));
        if (nArray.length > 3) {
            if (nArray[3] == 0) {
                string2 = string2 + "; User-Selected";
            } else if (nArray[3] == 1) {
                string2 = string2 + "; Auto-Override";
            }
        }
        return string2;
    }

    @Nullable
    public String getPictureModeDescription() {
        Comparable<Integer> comparable;
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1312);
        if (nArray == null) {
            comparable = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(1290);
            if (comparable == null) {
                return null;
            }
            nArray = new int[]{(Integer)comparable};
        }
        if (nArray.length == 0) {
            return null;
        }
        comparable = new StringBuilder();
        switch (nArray[0]) {
            case 1: {
                ((StringBuilder)comparable).append("Vivid");
                break;
            }
            case 2: {
                ((StringBuilder)comparable).append("Natural");
                break;
            }
            case 3: {
                ((StringBuilder)comparable).append("Muted");
                break;
            }
            case 4: {
                ((StringBuilder)comparable).append("Portrait");
                break;
            }
            case 5: {
                ((StringBuilder)comparable).append("i-Enhance");
                break;
            }
            case 256: {
                ((StringBuilder)comparable).append("Monotone");
                break;
            }
            case 512: {
                ((StringBuilder)comparable).append("Sepia");
                break;
            }
            default: {
                ((StringBuilder)comparable).append("Unknown (").append(nArray[0]).append(")");
            }
        }
        if (nArray.length > 1) {
            ((StringBuilder)comparable).append("; ").append(nArray[1]);
        }
        return ((StringBuilder)comparable).toString();
    }

    @Nullable
    public String getPictureModeSaturationDescription() {
        return this.getValueMinMaxDescription(1313);
    }

    @Nullable
    public String getPictureModeContrastDescription() {
        return this.getValueMinMaxDescription(1315);
    }

    @Nullable
    public String getPictureModeSharpnessDescription() {
        return this.getValueMinMaxDescription(1316);
    }

    @Nullable
    public String getPictureModeBWFilterDescription() {
        return this.getIndexedDescription(1317, "n/a", "Neutral", "Yellow", "Orange", "Red", "Green");
    }

    @Nullable
    public String getPictureModeToneDescription() {
        return this.getIndexedDescription(1318, "n/a", "Neutral", "Sepia", "Blue", "Purple", "Green");
    }

    @Nullable
    public String getNoiseFilterDescription() {
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1319);
        if (nArray == null) {
            return null;
        }
        String string = String.format("%d %d %d", nArray[0], nArray[1], nArray[2]);
        if (string.equals("0 0 0")) {
            return "n/a";
        }
        if (string.equals("-2 -2 1")) {
            return "Off";
        }
        if (string.equals("-1 -2 1")) {
            return "Low";
        }
        if (string.equals("0 -2 1")) {
            return "Standard";
        }
        if (string.equals("1 -2 1")) {
            return "High";
        }
        return "Unknown (" + string + ")";
    }

    @Nullable
    public String getArtFilterDescription() {
        return this.getFiltersDescription(1321);
    }

    @Nullable
    public String getMagicFilterDescription() {
        return this.getFiltersDescription(1324);
    }

    @Nullable
    public String getPictureModeEffectDescription() {
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1325);
        if (nArray == null) {
            return null;
        }
        String string = String.format("%d %d %d", nArray[0], nArray[1], nArray[2]);
        if (string.equals("0 0 0")) {
            return "n/a";
        }
        if (string.equals("-1 -1 1")) {
            return "Low";
        }
        if (string.equals("0 -1 1")) {
            return "Standard";
        }
        if (string.equals("1 -1 1")) {
            return "High";
        }
        return "Unknown (" + string + ")";
    }

    @Nullable
    public String getToneLevelDescription() {
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1326);
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            if (i == 1) {
                stringBuilder.append("Highlights ");
            } else if (i == 5) {
                stringBuilder.append("Shadows ");
            }
            stringBuilder.append(nArray[i]).append("; ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    @Nullable
    public String getArtFilterEffectDescription() {
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1327);
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            if (i == 0) {
                stringBuilder.append(_filters.containsKey(nArray[i]) ? _filters.get(nArray[i]) : "[unknown]");
            } else if (i == 4) {
                switch (nArray[i]) {
                    case 0: {
                        stringBuilder.append("No Effect");
                        break;
                    }
                    case 32784: {
                        stringBuilder.append("Star Light");
                        break;
                    }
                    case 32800: {
                        stringBuilder.append("Pin Hole");
                        break;
                    }
                    case 32816: {
                        stringBuilder.append("Frame");
                        break;
                    }
                    case 32832: {
                        stringBuilder.append("Soft Focus");
                        break;
                    }
                    case 32848: {
                        stringBuilder.append("White Edge");
                        break;
                    }
                    case 32864: {
                        stringBuilder.append("B&W");
                        break;
                    }
                    default: {
                        stringBuilder.append("Unknown (").append(nArray[i]).append(")");
                        break;
                    }
                }
            } else {
                stringBuilder.append(nArray[i]);
            }
            stringBuilder.append("; ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    @Nullable
    public String getDriveModeDescription() {
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1536);
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 0 || nArray[0] == 0) {
            return "Single Shot";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (nArray[0] == 5 && nArray.length >= 3) {
            int n = nArray[2];
            if ((n & 1) > 0) {
                stringBuilder.append("AE");
            }
            if ((n >> 1 & 1) > 0) {
                stringBuilder.append("WB");
            }
            if ((n >> 2 & 1) > 0) {
                stringBuilder.append("FL");
            }
            if ((n >> 3 & 1) > 0) {
                stringBuilder.append("MF");
            }
            if ((n >> 6 & 1) > 0) {
                stringBuilder.append("Focus");
            }
            stringBuilder.append(" Bracketing");
        } else {
            switch (nArray[0]) {
                case 1: {
                    stringBuilder.append("Continuous Shooting");
                    break;
                }
                case 2: {
                    stringBuilder.append("Exposure Bracketing");
                    break;
                }
                case 3: {
                    stringBuilder.append("White Balance Bracketing");
                    break;
                }
                case 4: {
                    stringBuilder.append("Exposure+WB Bracketing");
                    break;
                }
                default: {
                    stringBuilder.append("Unknown (").append(nArray[0]).append(")");
                }
            }
        }
        stringBuilder.append(", Shot ").append(nArray[1]);
        return stringBuilder.toString();
    }

    @Nullable
    public String getPanoramaModeDescription() {
        String string;
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(1537);
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 0 || nArray[0] == 0) {
            return "Off";
        }
        switch (nArray[0]) {
            case 1: {
                string = "Left to Right";
                break;
            }
            case 2: {
                string = "Right to Left";
                break;
            }
            case 3: {
                string = "Bottom to Top";
                break;
            }
            case 4: {
                string = "Top to Bottom";
                break;
            }
            default: {
                string = "Unknown (" + nArray[0] + ")";
            }
        }
        return String.format("%s, Shot %d", string, nArray[1]);
    }

    @Nullable
    public String getImageQuality2Description() {
        return this.getIndexedDescription(1539, 1, "SQ", "HQ", "SHQ", "RAW", "SQ (5)");
    }

    @Nullable
    public String getImageStabilizationDescription() {
        return this.getIndexedDescription(1540, "Off", "On, Mode 1", "On, Mode 2", "On, Mode 3", "On, Mode 4");
    }

    @Nullable
    public String getStackedImageDescription() {
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(2052);
        if (nArray == null || nArray.length < 2) {
            return null;
        }
        int n = nArray[0];
        int n2 = nArray[1];
        if (n == 0 && n2 == 0) {
            return "No";
        }
        if (n == 9 && n2 == 8) {
            return "Focus-stacked (8 images)";
        }
        return String.format("Unknown (%d %d)", n, n2);
    }

    @Nullable
    public String getManometerPressureDescription() {
        Integer n = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getInteger(2304);
        if (n == null) {
            return null;
        }
        return String.format("%s kPa", new DecimalFormat("#.##").format((double)n.intValue() / 10.0));
    }

    @Nullable
    public String getManometerReadingDescription() {
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(2305);
        if (nArray == null || nArray.length < 2) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        return String.format("%s m, %s ft", decimalFormat.format((double)nArray[0] / 10.0), decimalFormat.format((double)nArray[1] / 10.0));
    }

    @Nullable
    public String getExtendedWBDetectDescription() {
        return this.getIndexedDescription(2306, "Off", "On");
    }

    @Nullable
    public String getRollAngleDescription() {
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(2307);
        if (nArray == null || nArray.length < 2) {
            return null;
        }
        String string = nArray[0] != 0 ? Double.toString((double)(-nArray[0]) / 10.0) : "n/a";
        return String.format("%s %d", string, nArray[1]);
    }

    @Nullable
    public String getPitchAngleDescription() {
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(2308);
        if (nArray == null || nArray.length < 2) {
            return null;
        }
        String string = nArray[0] != 0 ? Double.toString((double)nArray[0] / 10.0) : "n/a";
        return String.format("%s %d", string, nArray[1]);
    }

    @Nullable
    public String getDateTimeUTCDescription() {
        Object object = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getObject(2312);
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    @Nullable
    private String getValueMinMaxDescription(int n) {
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(n);
        if (nArray == null || nArray.length < 3) {
            return null;
        }
        return String.format("%d (min %d, max %d)", nArray[0], nArray[1], nArray[2]);
    }

    private String getFiltersDescription(int n) {
        int[] nArray = ((OlympusCameraSettingsMakernoteDirectory)this._directory).getIntArray(n);
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nArray.length; ++i) {
            if (i == 0) {
                stringBuilder.append(_filters.containsKey(nArray[i]) ? _filters.get(nArray[i]) : "[unknown]");
            } else {
                stringBuilder.append(nArray[i]);
            }
            stringBuilder.append("; ");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 2);
    }

    static {
        _filters.put(0, "Off");
        _filters.put(1, "Soft Focus");
        _filters.put(2, "Pop Art");
        _filters.put(3, "Pale & Light Color");
        _filters.put(4, "Light Tone");
        _filters.put(5, "Pin Hole");
        _filters.put(6, "Grainy Film");
        _filters.put(9, "Diorama");
        _filters.put(10, "Cross Process");
        _filters.put(12, "Fish Eye");
        _filters.put(13, "Drawing");
        _filters.put(14, "Gentle Sepia");
        _filters.put(15, "Pale & Light Color II");
        _filters.put(16, "Pop Art II");
        _filters.put(17, "Pin Hole II");
        _filters.put(18, "Pin Hole III");
        _filters.put(19, "Grainy Film II");
        _filters.put(20, "Dramatic Tone");
        _filters.put(21, "Punk");
        _filters.put(22, "Soft Focus 2");
        _filters.put(23, "Sparkle");
        _filters.put(24, "Watercolor");
        _filters.put(25, "Key Line");
        _filters.put(26, "Key Line II");
        _filters.put(27, "Miniature");
        _filters.put(28, "Reflection");
        _filters.put(29, "Fragmented");
        _filters.put(31, "Cross Process II");
        _filters.put(32, "Dramatic Tone II");
        _filters.put(33, "Watercolor I");
        _filters.put(34, "Watercolor II");
        _filters.put(35, "Diorama II");
        _filters.put(36, "Vintage");
        _filters.put(37, "Vintage II");
        _filters.put(38, "Vintage III");
        _filters.put(39, "Partial Color");
        _filters.put(40, "Partial Color II");
        _filters.put(41, "Partial Color III");
    }
}

