/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.icc;

import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.icc.IccDirectory;
import com.drew.metadata.icc.IccReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DecimalFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IccDescriptor
extends TagDescriptor<IccDirectory> {
    private static final int ICC_TAG_TYPE_TEXT = 1952807028;
    private static final int ICC_TAG_TYPE_DESC = 1684370275;
    private static final int ICC_TAG_TYPE_SIG = 1936287520;
    private static final int ICC_TAG_TYPE_MEAS = 1835360627;
    private static final int ICC_TAG_TYPE_XYZ_ARRAY = 1482250784;
    private static final int ICC_TAG_TYPE_MLUC = 1835824483;
    private static final int ICC_TAG_TYPE_CURV = 1668641398;

    public IccDescriptor(@NotNull IccDirectory iccDirectory) {
        super(iccDirectory);
    }

    @Override
    public String getDescription(int n) {
        switch (n) {
            case 8: {
                return this.getProfileVersionDescription();
            }
            case 12: {
                return this.getProfileClassDescription();
            }
            case 40: {
                return this.getPlatformDescription();
            }
            case 64: {
                return this.getRenderingIntentDescription();
            }
        }
        if (n > 0x20202020 && n < 0x7A7A7A7A) {
            return this.getTagDataString(n);
        }
        return super.getDescription(n);
    }

    @Nullable
    private String getTagDataString(int n) {
        try {
            byte[] byArray = ((IccDirectory)this._directory).getByteArray(n);
            if (byArray == null) {
                return ((IccDirectory)this._directory).getString(n);
            }
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            int n2 = byteArrayReader.getInt32(0);
            switch (n2) {
                case 1952807028: {
                    try {
                        return new String(byArray, 8, byArray.length - 8 - 1, "ASCII");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        return new String(byArray, 8, byArray.length - 8 - 1);
                    }
                }
                case 1684370275: {
                    int n3 = byteArrayReader.getInt32(8);
                    return new String(byArray, 12, n3 - 1);
                }
                case 1936287520: {
                    return IccReader.getStringFromInt32(byteArrayReader.getInt32(8));
                }
                case 1835360627: {
                    String string;
                    String string2;
                    String string3;
                    int n4 = byteArrayReader.getInt32(8);
                    float f = byteArrayReader.getS15Fixed16(12);
                    float f2 = byteArrayReader.getS15Fixed16(16);
                    float f3 = byteArrayReader.getS15Fixed16(20);
                    int n5 = byteArrayReader.getInt32(24);
                    float f4 = byteArrayReader.getS15Fixed16(28);
                    int n6 = byteArrayReader.getInt32(32);
                    switch (n4) {
                        case 0: {
                            string3 = "Unknown";
                            break;
                        }
                        case 1: {
                            string3 = "1931 2\u00b0";
                            break;
                        }
                        case 2: {
                            string3 = "1964 10\u00b0";
                            break;
                        }
                        default: {
                            string3 = String.format("Unknown %d", n4);
                        }
                    }
                    switch (n5) {
                        case 0: {
                            string2 = "Unknown";
                            break;
                        }
                        case 1: {
                            string2 = "0/45 or 45/0";
                            break;
                        }
                        case 2: {
                            string2 = "0/d or d/0";
                            break;
                        }
                        default: {
                            string2 = String.format("Unknown %d", n4);
                        }
                    }
                    switch (n6) {
                        case 0: {
                            string = "unknown";
                            break;
                        }
                        case 1: {
                            string = "D50";
                            break;
                        }
                        case 2: {
                            string = "D65";
                            break;
                        }
                        case 3: {
                            string = "D93";
                            break;
                        }
                        case 4: {
                            string = "F2";
                            break;
                        }
                        case 5: {
                            string = "D55";
                            break;
                        }
                        case 6: {
                            string = "A";
                            break;
                        }
                        case 7: {
                            string = "Equi-Power (E)";
                            break;
                        }
                        case 8: {
                            string = "F8";
                            break;
                        }
                        default: {
                            string = String.format("Unknown %d", n6);
                        }
                    }
                    DecimalFormat decimalFormat = new DecimalFormat("0.###");
                    return String.format("%s Observer, Backing (%s, %s, %s), Geometry %s, Flare %d%%, Illuminant %s", string3, decimalFormat.format(f), decimalFormat.format(f2), decimalFormat.format(f3), string2, Math.round(f4 * 100.0f), string);
                }
                case 1482250784: {
                    StringBuilder stringBuilder = new StringBuilder();
                    DecimalFormat decimalFormat = new DecimalFormat("0.####");
                    int n7 = (byArray.length - 8) / 12;
                    for (int i = 0; i < n7; ++i) {
                        float f = byteArrayReader.getS15Fixed16(8 + i * 12);
                        float f5 = byteArrayReader.getS15Fixed16(8 + i * 12 + 4);
                        float f6 = byteArrayReader.getS15Fixed16(8 + i * 12 + 8);
                        if (i > 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append("(").append(decimalFormat.format(f)).append(", ").append(decimalFormat.format(f5)).append(", ").append(decimalFormat.format(f6)).append(")");
                    }
                    return stringBuilder.toString();
                }
                case 1835824483: {
                    int n8 = byteArrayReader.getInt32(8);
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(n8);
                    for (int i = 0; i < n8; ++i) {
                        String string;
                        String string4 = IccReader.getStringFromInt32(byteArrayReader.getInt32(16 + i * 12));
                        int n9 = byteArrayReader.getInt32(16 + i * 12 + 4);
                        int n10 = byteArrayReader.getInt32(16 + i * 12 + 8);
                        try {
                            string = new String(byArray, n10, n9, "UTF-16BE");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            string = new String(byArray, n10, n9);
                        }
                        stringBuilder.append(" ").append(string4).append("(").append(string).append(")");
                    }
                    return stringBuilder.toString();
                }
                case 1668641398: {
                    int n11 = byteArrayReader.getInt32(8);
                    StringBuilder stringBuilder = new StringBuilder();
                    for (int i = 0; i < n11; ++i) {
                        if (i != 0) {
                            stringBuilder.append(", ");
                        }
                        stringBuilder.append(IccDescriptor.formatDoubleAsString((double)byteArrayReader.getUInt16(12 + i * 2) / 65535.0, 7, false));
                    }
                    return stringBuilder.toString();
                }
            }
            return String.format("%s (0x%08X): %d bytes", IccReader.getStringFromInt32(n2), n2, byArray.length);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @NotNull
    public static String formatDoubleAsString(double d, int n, boolean bl) {
        int n2;
        long l;
        if (n < 1) {
            return "" + Math.round(d);
        }
        long l2 = Math.abs((long)d);
        long l3 = l = (long)((int)Math.round((Math.abs(d) - (double)l2) * Math.pow(10.0, n)));
        String string = "";
        for (n2 = n; n2 > 0; --n2) {
            byte by = (byte)Math.abs(l % 10L);
            l /= 10L;
            if (string.length() <= 0 && !bl && by == 0 && n2 != 1) continue;
            string = by + string;
        }
        n2 = d < 0.0 && ((l2 += l) != 0L || l3 != 0L) ? 1 : 0;
        return (n2 != 0 ? "-" : "") + l2 + "." + string;
    }

    @Nullable
    private String getRenderingIntentDescription() {
        return this.getIndexedDescription(64, "Perceptual", "Media-Relative Colorimetric", "Saturation", "ICC-Absolute Colorimetric");
    }

    @Nullable
    private String getPlatformDescription() {
        int n;
        String string = ((IccDirectory)this._directory).getString(40);
        if (string == null) {
            return null;
        }
        try {
            n = IccDescriptor.getInt32FromString(string);
        }
        catch (IOException iOException) {
            return string;
        }
        switch (n) {
            case 1095782476: {
                return "Apple Computer, Inc.";
            }
            case 1297303124: {
                return "Microsoft Corporation";
            }
            case 1397180704: {
                return "Silicon Graphics, Inc.";
            }
            case 1398099543: {
                return "Sun Microsystems, Inc.";
            }
            case 1413959252: {
                return "Taligent, Inc.";
            }
        }
        return String.format("Unknown (%s)", string);
    }

    @Nullable
    private String getProfileClassDescription() {
        int n;
        String string = ((IccDirectory)this._directory).getString(12);
        if (string == null) {
            return null;
        }
        try {
            n = IccDescriptor.getInt32FromString(string);
        }
        catch (IOException iOException) {
            return string;
        }
        switch (n) {
            case 1935896178: {
                return "Input Device";
            }
            case 1835955314: {
                return "Display Device";
            }
            case 1886549106: {
                return "Output Device";
            }
            case 1818848875: {
                return "DeviceLink";
            }
            case 1936744803: {
                return "ColorSpace Conversion";
            }
            case 1633842036: {
                return "Abstract";
            }
            case 1852662636: {
                return "Named Color";
            }
        }
        return String.format("Unknown (%s)", string);
    }

    @Nullable
    private String getProfileVersionDescription() {
        Integer n = ((IccDirectory)this._directory).getInteger(8);
        if (n == null) {
            return null;
        }
        int n2 = (n & 0xFF000000) >> 24;
        int n3 = (n & 0xF00000) >> 20;
        int n4 = (n & 0xF0000) >> 16;
        return String.format("%d.%d.%d", n2, n3, n4);
    }

    private static int getInt32FromString(@NotNull String string) throws IOException {
        byte[] byArray = string.getBytes();
        return new ByteArrayReader(byArray).getInt32(0);
    }
}

