/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.imaging.jpeg.JpegSegmentMetadataReader;
import com.drew.imaging.jpeg.JpegSegmentType;
import com.drew.lang.SequentialByteArrayReader;
import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.photoshop.DuckyDirectory;
import java.io.IOException;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DuckyReader
implements JpegSegmentMetadataReader {
    @NotNull
    private static final String JPEG_SEGMENT_PREAMBLE = "Ducky";

    @Override
    @NotNull
    public Iterable<JpegSegmentType> getSegmentTypes() {
        return Collections.singletonList(JpegSegmentType.APPC);
    }

    @Override
    public void readJpegSegments(@NotNull Iterable<byte[]> iterable, @NotNull Metadata metadata, @NotNull JpegSegmentType jpegSegmentType) {
        int n = JPEG_SEGMENT_PREAMBLE.length();
        for (byte[] byArray : iterable) {
            if (byArray.length < n || !JPEG_SEGMENT_PREAMBLE.equals(new String(byArray, 0, n))) continue;
            this.extract(new SequentialByteArrayReader(byArray, n), metadata);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void extract(@NotNull SequentialReader sequentialReader, @NotNull Metadata metadata) {
        DuckyDirectory duckyDirectory = new DuckyDirectory();
        metadata.addDirectory(duckyDirectory);
        try {
            block6: while (true) {
                int n;
                if ((n = sequentialReader.getUInt16()) == 0) {
                    return;
                }
                int n2 = sequentialReader.getUInt16();
                switch (n) {
                    case 1: {
                        if (n2 != 4) {
                            duckyDirectory.addError("Unexpected length for the quality tag");
                            return;
                        }
                        duckyDirectory.setInt(n, sequentialReader.getInt32());
                        continue block6;
                    }
                    case 2: 
                    case 3: {
                        sequentialReader.skip(4L);
                        duckyDirectory.setString(n, sequentialReader.getString(n2 - 4, "UTF-16BE"));
                        continue block6;
                    }
                }
                duckyDirectory.setByteArray(n, sequentialReader.getBytes(n2));
            }
        }
        catch (IOException iOException) {
            duckyDirectory.addError(iOException.getMessage());
        }
    }
}

