/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.annotations.NotNull;
import com.drew.lang.annotations.Nullable;
import com.drew.metadata.TagDescriptor;
import com.drew.metadata.photoshop.PsdHeaderDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PsdHeaderDescriptor
extends TagDescriptor<PsdHeaderDirectory> {
    public PsdHeaderDescriptor(@NotNull PsdHeaderDirectory psdHeaderDirectory) {
        super(psdHeaderDirectory);
    }

    @Override
    public String getDescription(int n) {
        switch (n) {
            case 1: {
                return this.getChannelCountDescription();
            }
            case 4: {
                return this.getBitsPerChannelDescription();
            }
            case 5: {
                return this.getColorModeDescription();
            }
            case 2: {
                return this.getImageHeightDescription();
            }
            case 3: {
                return this.getImageWidthDescription();
            }
        }
        return super.getDescription(n);
    }

    @Nullable
    public String getChannelCountDescription() {
        Integer n = ((PsdHeaderDirectory)this._directory).getInteger(1);
        if (n == null) {
            return null;
        }
        return n + " channel" + (n == 1 ? "" : "s");
    }

    @Nullable
    public String getBitsPerChannelDescription() {
        Integer n = ((PsdHeaderDirectory)this._directory).getInteger(4);
        if (n == null) {
            return null;
        }
        return n + " bit" + (n == 1 ? "" : "s") + " per channel";
    }

    @Nullable
    public String getColorModeDescription() {
        return this.getIndexedDescription(5, "Bitmap", "Grayscale", "Indexed", "RGB", "CMYK", null, null, "Multichannel", "Duotone", "Lab");
    }

    @Nullable
    public String getImageHeightDescription() {
        Integer n = ((PsdHeaderDirectory)this._directory).getInteger(2);
        if (n == null) {
            return null;
        }
        return n + " pixel" + (n == 1 ? "" : "s");
    }

    @Nullable
    public String getImageWidthDescription() {
        try {
            Integer n = ((PsdHeaderDirectory)this._directory).getInteger(3);
            if (n == null) {
                return null;
            }
            return n + " pixel" + (n == 1 ? "" : "s");
        }
        catch (Exception exception) {
            return null;
        }
    }
}

