/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.photoshop;

import com.drew.lang.SequentialReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.photoshop.PhotoshopReader;
import com.drew.metadata.photoshop.PsdHeaderDirectory;
import java.io.IOException;

public class PsdReader {
    public void extract(@NotNull SequentialReader sequentialReader, @NotNull Metadata metadata) {
        long l;
        PsdHeaderDirectory psdHeaderDirectory = new PsdHeaderDirectory();
        metadata.addDirectory(psdHeaderDirectory);
        try {
            int n = sequentialReader.getInt32();
            if (n != 943870035) {
                psdHeaderDirectory.addError("Invalid PSD file signature");
                return;
            }
            int n2 = sequentialReader.getUInt16();
            if (n2 != 1 && n2 != 2) {
                psdHeaderDirectory.addError("Invalid PSD file version (must be 1 or 2)");
                return;
            }
            sequentialReader.skip(6L);
            int n3 = sequentialReader.getUInt16();
            psdHeaderDirectory.setInt(1, n3);
            int n4 = sequentialReader.getInt32();
            psdHeaderDirectory.setInt(2, n4);
            int n5 = sequentialReader.getInt32();
            psdHeaderDirectory.setInt(3, n5);
            int n6 = sequentialReader.getUInt16();
            psdHeaderDirectory.setInt(4, n6);
            int n7 = sequentialReader.getUInt16();
            psdHeaderDirectory.setInt(5, n7);
        }
        catch (IOException iOException) {
            psdHeaderDirectory.addError("Unable to read PSD header");
            return;
        }
        try {
            l = sequentialReader.getUInt32();
            sequentialReader.skip(l);
        }
        catch (IOException iOException) {
            return;
        }
        try {
            l = sequentialReader.getUInt32();
            assert (l <= Integer.MAX_VALUE);
            new PhotoshopReader().extract(sequentialReader, (int)l, metadata);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

