/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.tiff;

import com.drew.imaging.tiff.TiffHandler;
import com.drew.lang.Rational;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectoryTiffHandler
implements TiffHandler {
    private final Stack<Directory> _directoryStack = new Stack();
    protected Directory _currentDirectory;
    protected final Metadata _metadata;

    protected DirectoryTiffHandler(Metadata metadata, Class<? extends Directory> clazz) {
        this._metadata = metadata;
        try {
            this._currentDirectory = clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        this._metadata.addDirectory(this._currentDirectory);
    }

    @Override
    public void endingIFD() {
        this._currentDirectory = this._directoryStack.empty() ? null : this._directoryStack.pop();
    }

    protected void pushDirectory(@NotNull Class<? extends Directory> clazz) {
        this._directoryStack.push(this._currentDirectory);
        try {
            Directory directory = clazz.newInstance();
            directory.setParent(this._currentDirectory);
            this._currentDirectory = directory;
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        this._metadata.addDirectory(this._currentDirectory);
    }

    @Override
    public void warn(@NotNull String string) {
        this._currentDirectory.addError(string);
    }

    @Override
    public void error(@NotNull String string) {
        this._currentDirectory.addError(string);
    }

    @Override
    public void setByteArray(int n, @NotNull byte[] byArray) {
        this._currentDirectory.setByteArray(n, byArray);
    }

    @Override
    public void setString(int n, @NotNull String string) {
        this._currentDirectory.setString(n, string);
    }

    @Override
    public void setRational(int n, @NotNull Rational rational) {
        this._currentDirectory.setRational(n, rational);
    }

    @Override
    public void setRationalArray(int n, @NotNull Rational[] rationalArray) {
        this._currentDirectory.setRationalArray(n, rationalArray);
    }

    @Override
    public void setFloat(int n, float f) {
        this._currentDirectory.setFloat(n, f);
    }

    @Override
    public void setFloatArray(int n, @NotNull float[] fArray) {
        this._currentDirectory.setFloatArray(n, fArray);
    }

    @Override
    public void setDouble(int n, double d) {
        this._currentDirectory.setDouble(n, d);
    }

    @Override
    public void setDoubleArray(int n, @NotNull double[] dArray) {
        this._currentDirectory.setDoubleArray(n, dArray);
    }

    @Override
    public void setInt8s(int n, byte by) {
        this._currentDirectory.setInt(n, by);
    }

    @Override
    public void setInt8sArray(int n, @NotNull byte[] byArray) {
        this._currentDirectory.setByteArray(n, byArray);
    }

    @Override
    public void setInt8u(int n, short s) {
        this._currentDirectory.setInt(n, s);
    }

    @Override
    public void setInt8uArray(int n, @NotNull short[] sArray) {
        this._currentDirectory.setObjectArray(n, sArray);
    }

    @Override
    public void setInt16s(int n, int n2) {
        this._currentDirectory.setInt(n, n2);
    }

    @Override
    public void setInt16sArray(int n, @NotNull short[] sArray) {
        this._currentDirectory.setObjectArray(n, sArray);
    }

    @Override
    public void setInt16u(int n, int n2) {
        this._currentDirectory.setInt(n, n2);
    }

    @Override
    public void setInt16uArray(int n, @NotNull int[] nArray) {
        this._currentDirectory.setObjectArray(n, nArray);
    }

    @Override
    public void setInt32s(int n, int n2) {
        this._currentDirectory.setInt(n, n2);
    }

    @Override
    public void setInt32sArray(int n, @NotNull int[] nArray) {
        this._currentDirectory.setIntArray(n, nArray);
    }

    @Override
    public void setInt32u(int n, long l) {
        this._currentDirectory.setLong(n, l);
    }

    @Override
    public void setInt32uArray(int n, @NotNull long[] lArray) {
        this._currentDirectory.setObjectArray(n, lArray);
    }
}

