/*
 * Decompiled with CFR 0.152.
 */
package com.github.stuxuhai.jpinyin;

import com.github.stuxuhai.jpinyin.PinyinResource;
import java.util.Map;
import java.util.Properties;

public class ChineseHelper {
    private static final Properties CHINESE_TABLE = PinyinResource.getChineseTable();

    public static char convertToSimplifiedChinese(char c) {
        if (ChineseHelper.isTraditionalChinese(c)) {
            return CHINESE_TABLE.getProperty(String.valueOf(c)).charAt(0);
        }
        return c;
    }

    public static char convertToTraditionalChinese(char c) {
        String hanzi = String.valueOf(c);
        if (CHINESE_TABLE.containsValue(hanzi)) {
            for (Map.Entry<Object, Object> e : CHINESE_TABLE.entrySet()) {
                if (!e.getValue().toString().equals(hanzi)) continue;
                return e.getKey().toString().charAt(0);
            }
        }
        return c;
    }

    public static String convertToSimplifiedChinese(String str) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int len = str.length();
        while (i < len) {
            char c = str.charAt(i);
            sb.append(ChineseHelper.convertToSimplifiedChinese(c));
            ++i;
        }
        return sb.toString();
    }

    public static String convertToTraditionalChinese(String str) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        int len = str.length();
        while (i < len) {
            char c = str.charAt(i);
            sb.append(ChineseHelper.convertToTraditionalChinese(c));
            ++i;
        }
        return sb.toString();
    }

    public static boolean isTraditionalChinese(char c) {
        return CHINESE_TABLE.containsKey(String.valueOf(c));
    }

    public static boolean isChinese(char c) {
        String regex = "[\\u4e00-\\u9fa5]";
        return String.valueOf(c).matches(regex);
    }
}

