/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.IChatroom;
import com.blisscloud.ezuc.client.chat.IMultiUserChatroom;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import javax.swing.SwingUtilities;

public class UIController {
    BroadcastReceiver receiver = null;
    IntentFilter filter = null;

    public UIController() {
        this.initReceiver();
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    Bundle bundle = intent.getExtras();
                    if (action.equals("ezphone.intent.action.event.CHAT_ROOM_CREATED_SUCCEED")) {
                        String roomJID = bundle.getString("roomJID");
                        UIController.this.chat_createRoomSucceed(roomJID);
                    } else if (action.equals("ezphone.intent.action.event.CHAT_ROOM_CREATED_FAILED")) {
                        String roomJID = bundle.getString("roomJID");
                        String errorMessage = bundle.getString("errorMsg");
                        UIController.this.chat_createRoomFailed(roomJID, errorMessage);
                    } else if (action.equals("ezphone.intent.action.event.CHAT_ROOM_INFO_UPDATE")) {
                        String roomJID = bundle.getString("roomJID");
                        UIController.this.chat_roomInfoUpdated(roomJID);
                    } else if (action.equals("ezphone.intent.action.event.CHAT_ROOM_EXITED_FAILED")) {
                        String roomJID = bundle.getString("chatId");
                        String errorMsg = bundle.getString("errorMsg");
                        UIController.this.chat_exitRoomFailed(roomJID, errorMsg);
                    }
                }
                catch (Throwable t) {
                    Log.e(UIController.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezphone.intent.action.event.CHAT_ROOM_CREATED_SUCCEED");
        this.filter.addAction("ezphone.intent.action.event.CHAT_ROOM_CREATED_FAILED");
        this.filter.addAction("ezphone.intent.action.event.CHAT_ROOM_INFO_UPDATE");
        this.filter.addAction("ezphone.intent.action.event.CHAT_ROOM_EXITED_FAILED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    private void chat_createRoomSucceed(final String roomJID) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
                if (JidUtil.isChatConfJid(roomJID)) {
                    mainPanel.showChatroom(roomJID);
                }
            }
        });
    }

    private void chat_createRoomFailed(String roomJID, String errorMsg) {
        if (JidUtil.isChatJid(roomJID)) {
            ToastUtil.showErrorLong(String.format(I18NUtil.getString("chatroom_notice_create_failed"), roomJID, errorMsg));
        } else if (JidUtil.isConfJid(roomJID)) {
            ToastUtil.showErrorLong(String.format(I18NUtil.getString("conference_notice_create_failed"), roomJID, errorMsg));
        }
    }

    private void chat_exitRoomFailed(String roomJID, String errorMsg) {
        if (JidUtil.isChatJid(roomJID)) {
            ToastUtil.showErrorLong(String.format(I18NUtil.getString("chatroom_notice_exit_failed"), roomJID, errorMsg));
        } else if (JidUtil.isConfJid(roomJID)) {
            ToastUtil.showErrorLong(String.format(I18NUtil.getString("conference_notice_exit_failed"), errorMsg));
        }
    }

    private void chat_roomInfoUpdated(final String roomJID) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IChatroom room;
                MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
                boolean opened = mainPanel.isChatroomOpened(roomJID);
                if (opened && (room = mainPanel.getChatroom(roomJID)) != null && room instanceof IMultiUserChatroom) {
                    ((IMultiUserChatroom)room).updateRoom();
                }
            }
        });
    }
}

