/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.addressbook;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.addressbook.AddressBookGroup;
import com.blisscloud.ezuc.client.addressbook.AddressBookSortingMode;
import com.blisscloud.ezuc.client.addressbook.ChatRoomEntryPanel;
import com.blisscloud.ezuc.client.addressbook.EmployeeEntryPanel;
import com.blisscloud.ezuc.client.addressbook.MeetmeEntryPanel;
import com.blisscloud.ezuc.client.addressbook.MyContactEntryPanel;
import com.blisscloud.ezuc.client.addressbook.SortingModePopup;
import com.blisscloud.ezuc.client.chat.IChatroom;
import com.blisscloud.ezuc.client.chat.IMultiUserChatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.ConferenceChatroom;
import com.blisscloud.ezuc.client.component.EntryPanel;
import com.blisscloud.ezuc.client.component.ExpandListener;
import com.blisscloud.ezuc.client.component.GroupPanel;
import com.blisscloud.ezuc.client.component.GroupPanelType;
import com.blisscloud.ezuc.client.component.SearchField;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.contact.AddMyContactDialog;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.sorter.ConferenceListSorter;
import com.blisscloud.ezuc.client.sorter.DepartmentContactListSorter;
import com.blisscloud.ezuc.client.sorter.LiteContactListGenericSorter;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.db.UCDBGroup;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class AddressBookPanel
extends JPanel
implements ExpandListener {
    private static final String CARD_COMPANY = "company";
    private static final String CARD_MY_ADDRESS_BOOK = "abook_label_my_contact";
    private static final String CARD_CONFERENCE_ROOM = "conferenceRoom";
    private static final String KEY_FAVORITE_MENU = "favoriteMenu";
    private static final Color BACKGROUND_SELECTED_TAB = Color.WHITE;
    private static final Color BACKGROUND_UNSELECTED_TAB = new Color(226, 226, 226);
    private static final Color BACKGROUND_TAB_SEPARATOR = new Color(209, 209, 209);
    static List<String> myAddressBookGroups = new ArrayList<String>();
    private JLabel btnFoldAll;
    private JLabel btnUnfoldAll;
    private JLabel btnCompanySort;
    private JLabel btnAddContact;
    private SortingModePopup popupSortingMode;
    private JPanel contentCompany;
    private JPanel contentMyAddressBook;
    private GroupPanel contentConferenceRoom;
    private JScrollPane spConferenceRoom;
    private JScrollPane spMyAddressBook;
    private JScrollPane spCompany;
    private SearchField sfCompany;
    private SearchField sfMyAddressBook;
    private SearchField sfConferenceRoom;
    private JPanel panelToolbar;
    private CardLayout panelToolbarLayout = new CardLayout();
    private JPanel toolbarConferenceRoom;
    private JPanel toolbarMyAddressBook;
    private JPanel toolbarCompany;
    private JSeparator jSeparator2;
    private JSeparator jSeparator1;
    private JPanel panelContent;
    private JLabel tablabelCompany;
    private JLabel tablabelMyAddressBook;
    private JLabel tablabelConferenceRoom;
    private JPanel tabArea;
    private JPanel tabContent;
    private CardLayout tabContentLayout = new CardLayout();
    private JPanel tabpanelConferenceRoom;
    private JPanel tabpanelMyAddressBook;
    private JPanel tabpanelCompany;
    private JPopupMenu popupEmployeeEntry;
    private JPopupMenu popupChatRoomEntry;
    private JPopupMenu popupConfRoomJoinEntry;
    private JPopupMenu popupConfRoomLeaveEntry;
    private JPopupMenu popupMyContactEntry;
    AddressBookSortingMode sortingMode = AddressBookSortingMode.alphabet;
    VoiceChatAction employeeVoiceChatAction;
    VoiceChatAction chatroomVoiceChatAction;
    VoiceChatAction confroomVoiceChatAction;
    FavoriteAction employeeFavoriteAction;
    FavoriteAction chatroomFavoriteAction;
    FavoriteAction confroomFavoriteAction;
    RemoveMyContactAction removeMyContactAction;
    Map<String, JLabel> tablabelMap = new HashMap<String, JLabel>();
    Map<String, GroupPanel> myAddressBookGroupMap = new Hashtable<String, GroupPanel>();
    Set<EntryPanel> historySelectedEntrySet = new HashSet<EntryPanel>();
    Map<EntryPanel, GroupPanel> entryPanelMap = new HashMap<EntryPanel, GroupPanel>();
    EntryPanelMouseListener epml = new EntryPanelMouseListener();
    BroadcastReceiver receiver = null;
    IntentFilter filter = null;
    private AtomicInteger refreshEmployeeCount = new AtomicInteger(0);
    private AtomicInteger refreshGroupCount = new AtomicInteger(0);
    private AtomicInteger refreshMyContactCount = new AtomicInteger(0);
    private AtomicInteger refreshMeetmeCount = new AtomicInteger(0);
    AtomicInteger seq = new AtomicInteger(0);
    private RefreshEmployeeListTask refreshEmployeeListTask = null;
    private RefreshGroupListTask refreshGroupListTask = null;
    private RefreshMyContactListTask refreshMyContactListTask = null;
    private RefreshMeetmeListTask refreshMeetmeListTask = null;
    EntryPanel selectedEntryPanel;
    private String refreshEmployeeListLock = "refreshEmployeeListLock";
    private String refreshGroupListLock = "refreshGroupListLock";
    private String refreshMyContactListLock = "refreshMyContactListLock";
    private String refreshMeetmeListLock = "refreshMeetmeListLock";
    EntryPanel menuDisplayedEntryPanel;
    MyPopupMenuListener myPopupMenuListener = new MyPopupMenuListener();

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new AddressBookPanel());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public AddressBookPanel() {
        int modeIndex = PreferencesUtil.getEmpBookMenuSelection(UCChatClient.context);
        if (modeIndex == 0) {
            this.sortingMode = AddressBookSortingMode.alphabet;
        } else if (modeIndex == 1) {
            this.sortingMode = AddressBookSortingMode.department;
        } else if (modeIndex == 2) {
            this.sortingMode = AddressBookSortingMode.status;
        }
        this.initGUI();
        this.initCards();
        this.initReceiver();
        this.initMyAddressBookDefaultGroups();
        this.initContactEntryMenu();
    }

    public void scrollTop() {
        if (this.spConferenceRoom != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddressBookPanel.this.spConferenceRoom.getVerticalScrollBar().setValue(0);
                }
            });
        }
        if (this.spMyAddressBook != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddressBookPanel.this.spMyAddressBook.getVerticalScrollBar().setValue(0);
                }
            });
        }
        if (this.spCompany != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AddressBookPanel.this.spCompany.getVerticalScrollBar().setValue(0);
                }
            });
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(300, 300));
            this.setBackground(Color.WHITE);
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent evt) {
                    AddressBookPanel.this.thisComponentShown(evt);
                }
            });
            this.panelToolbar = new JPanel();
            this.panelToolbar.setLayout(this.panelToolbarLayout);
            this.add((Component)this.panelToolbar, "North");
            this.panelToolbar.setBorder(UIConstants.BORDER_SEARCH_TOOLBAR);
            this.panelToolbar.setBackground(UIConstants.BACKGROUND_SELECTED_TAB);
            this.toolbarCompany = new JPanel();
            BorderLayout toolbarCompanyLayout = new BorderLayout();
            toolbarCompanyLayout.setHgap(5);
            this.toolbarCompany.setLayout(toolbarCompanyLayout);
            this.panelToolbar.add((Component)this.toolbarCompany, CARD_COMPANY);
            this.toolbarCompany.setOpaque(false);
            this.sfCompany = new SearchField();
            this.sfCompany.setSearchCallback(new SearchField.SearchCallback(){

                @Override
                public void doSearch(String key) {
                    AddressBookPanel.this.searchCompany(key, true);
                }
            });
            this.toolbarCompany.add((Component)this.sfCompany, "Center");
            JPanel p = new JPanel();
            p.setLayout(new BorderLayout());
            p.setBorder(BorderFactory.createEmptyBorder());
            this.toolbarCompany.add((Component)p, "East");
            p.setOpaque(false);
            this.btnFoldAll = new JLabel();
            p.add((Component)this.btnFoldAll, "West");
            this.btnFoldAll.setIcon(UIConstants.ICON_FOLDALL);
            this.btnFoldAll.setToolTipText(I18NUtil.getString("common_btn_foldall"));
            this.btnFoldAll.setPreferredSize(new Dimension(28, 28));
            this.btnFoldAll.setMinimumSize(new Dimension(28, 28));
            this.btnFoldAll.setCursor(UIConstants.CURSOR_HAND);
            this.btnFoldAll.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (AddressBookPanel.this.isEnabled()) {
                        AddressBookPanel.this.btnFoldAll.setIcon(UIConstants.ICON_FOLDALL);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (AddressBookPanel.this.isEnabled()) {
                        AddressBookPanel.this.btnFoldAll.setIcon(UIConstants.ICON_FOLDALL_OVER);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (AddressBookPanel.this.isEnabled()) {
                        AddressBookPanel.this.btnFoldAll.setIcon(UIConstants.ICON_FOLDALL_OVER);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    AddressBookPanel.this.foldAll();
                }
            });
            this.btnUnfoldAll = new JLabel();
            p.add((Component)this.btnUnfoldAll, "Center");
            this.btnUnfoldAll.setIcon(UIConstants.ICON_UNFOLDALL);
            this.btnUnfoldAll.setToolTipText(I18NUtil.getString("common_btn_unfoldall"));
            this.btnUnfoldAll.setPreferredSize(new Dimension(28, 28));
            this.btnUnfoldAll.setMinimumSize(new Dimension(28, 28));
            this.btnUnfoldAll.setCursor(UIConstants.CURSOR_HAND);
            this.btnUnfoldAll.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (AddressBookPanel.this.isEnabled()) {
                        AddressBookPanel.this.btnUnfoldAll.setIcon(UIConstants.ICON_UNFOLDALL);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (AddressBookPanel.this.isEnabled()) {
                        AddressBookPanel.this.btnUnfoldAll.setIcon(UIConstants.ICON_UNFOLDALL_OVER);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (AddressBookPanel.this.isEnabled()) {
                        AddressBookPanel.this.btnUnfoldAll.setIcon(UIConstants.ICON_UNFOLDALL_OVER);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    AddressBookPanel.this.unfoldAll();
                }
            });
            this.btnCompanySort = new JLabel();
            p.add((Component)this.btnCompanySort, "East");
            this.btnCompanySort.setIcon(UIConstants.ICON_SORT);
            this.btnCompanySort.setToolTipText(I18NUtil.getString("common_btn_sorting"));
            this.btnCompanySort.setPreferredSize(new Dimension(28, 28));
            this.btnCompanySort.setMinimumSize(new Dimension(28, 28));
            this.btnCompanySort.setCursor(UIConstants.CURSOR_HAND);
            this.btnCompanySort.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (AddressBookPanel.this.isEnabled()) {
                        AddressBookPanel.this.btnCompanySort.setIcon(UIConstants.ICON_SORT);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (AddressBookPanel.this.isEnabled()) {
                        AddressBookPanel.this.btnCompanySort.setIcon(UIConstants.ICON_SORT_OVER);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (AddressBookPanel.this.isEnabled()) {
                        AddressBookPanel.this.btnCompanySort.setIcon(UIConstants.ICON_SORT_OVER);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (AddressBookPanel.this.popupSortingMode == null) {
                        AddressBookPanel.this.initPopupSortingMode();
                    }
                    AddressBookPanel.this.popupSortingMode.show(AddressBookPanel.this.btnCompanySort, -13, AddressBookPanel.this.btnCompanySort.getHeight() - 2);
                }
            });
            this.toolbarMyAddressBook = new JPanel();
            BorderLayout toolbarMyAddressBookLayout = new BorderLayout();
            toolbarMyAddressBookLayout.setHgap(5);
            this.toolbarMyAddressBook.setLayout(toolbarMyAddressBookLayout);
            this.panelToolbar.add((Component)this.toolbarMyAddressBook, CARD_MY_ADDRESS_BOOK);
            this.toolbarMyAddressBook.setOpaque(false);
            this.sfMyAddressBook = new SearchField();
            this.sfMyAddressBook.setSearchCallback(new SearchField.SearchCallback(){

                @Override
                public void doSearch(String key) {
                    AddressBookPanel.this.searchMyAddressBook(key);
                }
            });
            this.toolbarMyAddressBook.add((Component)this.sfMyAddressBook, "Center");
            this.btnAddContact = new JLabel();
            this.toolbarMyAddressBook.add((Component)this.btnAddContact, "East");
            this.btnAddContact.setIcon(UIConstants.ICON_ADD_CONTACT);
            this.btnAddContact.setToolTipText(I18NUtil.getString("abook_btn_addcontact"));
            this.btnAddContact.setPreferredSize(new Dimension(28, 28));
            this.btnAddContact.setMinimumSize(new Dimension(28, 28));
            this.btnAddContact.setCursor(UIConstants.CURSOR_HAND);
            this.btnAddContact.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (AddressBookPanel.this.isEnabled()) {
                        AddressBookPanel.this.btnAddContact.setIcon(UIConstants.ICON_ADD_CONTACT);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (AddressBookPanel.this.isEnabled()) {
                        AddressBookPanel.this.btnAddContact.setIcon(UIConstants.ICON_ADD_CONTACT_OVER);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (AddressBookPanel.this.isEnabled()) {
                        AddressBookPanel.this.btnAddContact.setIcon(UIConstants.ICON_ADD_CONTACT_OVER);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (AddressBookPanel.this.isEnabled()) {
                        AddMyContactDialog acd = new AddMyContactDialog(UCChatClient.getInstance());
                        acd.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
                        acd.showDialog();
                    }
                }
            });
            this.toolbarConferenceRoom = new JPanel();
            BorderLayout toolbarConferenceRoomLayout = new BorderLayout();
            toolbarConferenceRoomLayout.setHgap(5);
            this.toolbarConferenceRoom.setLayout(toolbarConferenceRoomLayout);
            this.panelToolbar.add((Component)this.toolbarConferenceRoom, CARD_CONFERENCE_ROOM);
            this.toolbarConferenceRoom.setOpaque(false);
            this.sfConferenceRoom = new SearchField();
            this.sfConferenceRoom.setSearchCallback(new SearchField.SearchCallback(){

                @Override
                public void doSearch(String key) {
                    AddressBookPanel.this.searchConferenceRoom(key);
                }
            });
            this.toolbarConferenceRoom.add((Component)this.sfConferenceRoom, "Center");
            this.panelContent = new JPanel();
            BorderLayout panelContentLayout = new BorderLayout();
            this.panelContent.setLayout(panelContentLayout);
            this.add((Component)this.panelContent, "Center");
            this.tabArea = new JPanel();
            this.panelContent.add((Component)this.tabArea, "North");
            GridBagLayout tabAreaLayout = new GridBagLayout();
            this.tabArea.setLayout(tabAreaLayout);
            this.tablabelCompany = new JLabel();
            this.tabArea.add((Component)this.tablabelCompany, new GridBagConstraints(0, 0, 1, 1, 0.333, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 12));
            this.tablabelCompany.setBackground(BACKGROUND_SELECTED_TAB);
            this.tablabelCompany.setText(I18NUtil.getString("contact_toptab_business"));
            this.tablabelCompany.setFont(UIConstants.FONT_14_BOLD);
            this.tablabelCompany.setHorizontalAlignment(0);
            this.tablabelCompany.setOpaque(true);
            this.tablabelCompany.putClientProperty("tabName", CARD_COMPANY);
            this.tablabelCompany.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    AddressBookPanel.this.switchSelectedTab(AddressBookPanel.CARD_COMPANY);
                    if (evt.getButton() == 1 && evt.getClickCount() == 2) {
                        AddressBookPanel.this.toggleGroupPanelExpanded(AddressBookPanel.this.contentCompany);
                    }
                }
            });
            this.jSeparator1 = new JSeparator();
            this.tabArea.add((Component)this.jSeparator1, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator1.setOrientation(1);
            this.jSeparator1.setForeground(BACKGROUND_TAB_SEPARATOR);
            this.jSeparator1.setBackground(BACKGROUND_TAB_SEPARATOR);
            this.jSeparator1.setPreferredSize(new Dimension(1, 20));
            this.jSeparator1.setMinimumSize(new Dimension(1, 20));
            this.tablabelMyAddressBook = new JLabel();
            this.tabArea.add((Component)this.tablabelMyAddressBook, new GridBagConstraints(2, 0, 1, 1, 0.333, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 12));
            this.tablabelMyAddressBook.setBackground(BACKGROUND_UNSELECTED_TAB);
            this.tablabelMyAddressBook.setText(I18NUtil.getString("contact_toptab_personal"));
            this.tablabelMyAddressBook.setFont(UIConstants.FONT_14_BOLD);
            this.tablabelMyAddressBook.setHorizontalAlignment(0);
            this.tablabelMyAddressBook.setOpaque(true);
            this.tablabelMyAddressBook.putClientProperty("tabName", CARD_MY_ADDRESS_BOOK);
            this.tablabelMyAddressBook.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    AddressBookPanel.this.switchSelectedTab(AddressBookPanel.CARD_MY_ADDRESS_BOOK);
                    if (evt.getButton() == 1 && evt.getClickCount() == 2) {
                        AddressBookPanel.this.toggleGroupPanelExpanded(AddressBookPanel.this.contentMyAddressBook);
                    }
                }
            });
            this.jSeparator2 = new JSeparator();
            this.tabArea.add((Component)this.jSeparator2, new GridBagConstraints(3, 0, 1, 1, 0.0, 1.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator2.setOrientation(1);
            this.jSeparator2.setForeground(BACKGROUND_TAB_SEPARATOR);
            this.jSeparator2.setBackground(BACKGROUND_TAB_SEPARATOR);
            this.jSeparator2.setPreferredSize(new Dimension(1, 20));
            this.jSeparator2.setMinimumSize(new Dimension(1, 20));
            this.tablabelConferenceRoom = new JLabel();
            this.tabArea.add((Component)this.tablabelConferenceRoom, new GridBagConstraints(4, 0, 1, 1, 0.333, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 12));
            this.tablabelConferenceRoom.setBackground(BACKGROUND_UNSELECTED_TAB);
            this.tablabelConferenceRoom.setText(I18NUtil.getString("contact_toptab_meeting"));
            this.tablabelConferenceRoom.setFont(UIConstants.FONT_14_BOLD);
            this.tablabelConferenceRoom.setHorizontalAlignment(0);
            this.tablabelConferenceRoom.setOpaque(true);
            this.tablabelConferenceRoom.putClientProperty("tabName", CARD_CONFERENCE_ROOM);
            this.tablabelConferenceRoom.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    AddressBookPanel.this.switchSelectedTab(AddressBookPanel.CARD_CONFERENCE_ROOM);
                }
            });
            this.tabContent = new JPanel();
            this.tabContent.setLayout(this.tabContentLayout);
            this.panelContent.add((Component)this.tabContent, "Center");
            this.tabContent.setBackground(Color.WHITE);
            this.tabpanelCompany = new JPanel();
            BorderLayout tabpanelCompanyLayout = new BorderLayout();
            this.tabpanelCompany.setLayout(tabpanelCompanyLayout);
            this.tabContent.add((Component)this.tabpanelCompany, CARD_COMPANY);
            this.tabpanelCompany.setBackground(Color.WHITE);
            this.spCompany = new UCScrollPane(60);
            this.tabpanelCompany.add((Component)this.spCompany, "Center");
            this.spCompany.setHorizontalScrollBarPolicy(31);
            this.contentCompany = new JPanel(){

                @Override
                public Dimension getPreferredSize() {
                    int prefWidth = AddressBookPanel.this.tabpanelCompany.getWidth() - AddressBookPanel.this.spCompany.getVerticalScrollBar().getWidth();
                    int prefHeight = super.getPreferredSize().height;
                    return new Dimension(prefWidth, prefHeight);
                }
            };
            this.spCompany.setViewportView(this.contentCompany);
            BoxLayout contentCompanyLayout = new BoxLayout(this.contentCompany, 1);
            this.contentCompany.setLayout(contentCompanyLayout);
            this.contentCompany.setBackground(Color.WHITE);
            this.tabpanelMyAddressBook = new JPanel();
            BorderLayout tabpanelMyAddressBookLayout = new BorderLayout();
            this.tabpanelMyAddressBook.setLayout(tabpanelMyAddressBookLayout);
            this.tabContent.add((Component)this.tabpanelMyAddressBook, CARD_MY_ADDRESS_BOOK);
            this.tabpanelMyAddressBook.setBackground(Color.WHITE);
            this.spMyAddressBook = new UCScrollPane(60);
            this.tabpanelMyAddressBook.add((Component)this.spMyAddressBook, "Center");
            this.spMyAddressBook.setHorizontalScrollBarPolicy(31);
            this.contentMyAddressBook = new JPanel(){

                @Override
                public Dimension getPreferredSize() {
                    int prefWidth = AddressBookPanel.this.tabpanelMyAddressBook.getWidth() - AddressBookPanel.this.spMyAddressBook.getVerticalScrollBar().getWidth();
                    int prefHeight = super.getPreferredSize().height;
                    return new Dimension(prefWidth, prefHeight);
                }
            };
            this.spMyAddressBook.setViewportView(this.contentMyAddressBook);
            BoxLayout contentMyAddressBookLayout = new BoxLayout(this.contentMyAddressBook, 1);
            this.contentMyAddressBook.setLayout(contentMyAddressBookLayout);
            this.contentMyAddressBook.setBackground(Color.WHITE);
            this.tabpanelConferenceRoom = new JPanel();
            BorderLayout tabpanelConferenceRoomLayout = new BorderLayout();
            this.tabpanelConferenceRoom.setLayout(tabpanelConferenceRoomLayout);
            this.tabContent.add((Component)this.tabpanelConferenceRoom, CARD_CONFERENCE_ROOM);
            this.tabpanelConferenceRoom.setBackground(Color.WHITE);
            this.spConferenceRoom = new UCScrollPane(60);
            this.tabpanelConferenceRoom.add((Component)this.spConferenceRoom, "Center");
            this.spConferenceRoom.setHorizontalScrollBarPolicy(31);
            this.contentConferenceRoom = new GroupPanel("ConferenceRoom", "ConferenceRoom", false){

                @Override
                public Dimension getPreferredSize() {
                    int prefWidth = AddressBookPanel.this.tabpanelConferenceRoom.getWidth() - AddressBookPanel.this.spConferenceRoom.getVerticalScrollBar().getWidth();
                    int prefHeight = super.getPreferredSize().height;
                    return new Dimension(prefWidth, prefHeight);
                }
            };
            this.spConferenceRoom.setViewportView(this.contentConferenceRoom);
            this.contentConferenceRoom.setBackground(Color.WHITE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initCards() {
        this.tablabelMap.put(CARD_COMPANY, this.tablabelCompany);
        this.tablabelMap.put(CARD_MY_ADDRESS_BOOK, this.tablabelMyAddressBook);
        this.tablabelMap.put(CARD_CONFERENCE_ROOM, this.tablabelConferenceRoom);
        this.switchSelectedTab(CARD_COMPANY);
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    Bundle bundle = intent.getExtras();
                    Log.d(AddressBookPanel.class.getSimpleName(), " \u6536\u5230\u5ee3\u64ad:" + action);
                    if (action.equals("ezphone.intent.action.event.COMPANY_NAME_CHANGE")) {
                        AddressBookPanel.this.web_companyNameChanged();
                    } else if (action.equals("ezphone.intent.action.event.CONTACT_LIST_CHANGED")) {
                        int type = intent.getIntExtra("type", -1);
                        switch (type) {
                            case -1: {
                                break;
                            }
                            case 0: {
                                AddressBookPanel.this.web_employeeListChanged();
                                AddressBookPanel.this.web_groupListChanged();
                                break;
                            }
                            case 1: {
                                AddressBookPanel.this.web_employeeListChanged();
                                AddressBookPanel.this.web_groupListChanged();
                                break;
                            }
                            case 3: {
                                break;
                            }
                        }
                    } else if (action.equals("ezphone.intent.action.event.GROUP_LIST_CHANGED")) {
                        AddressBookPanel.this.web_groupListChanged();
                    } else if (action.equals("ezphone.intent.action.event.EXTERNAL_CONTACT_LIST_CHANGED")) {
                        AddressBookPanel.this.web_myContactListChanged();
                        AddressBookPanel.this.web_groupListChanged();
                    } else if (action.equals("ezphone.intent.action.event.MEETME_CHANGED")) {
                        long roomId = intent.getLongExtra("roomId", -1L);
                        AddressBookPanel.this.web_meetmeChanged(roomId);
                        if (intent.hasExtra("roomJID")) {
                            String roomJid = intent.getStringExtra("roomJID");
                            AddressBookPanel.this.chat_roomInfoUpdated(roomJid);
                        }
                    } else if (action.equals("ezphone.intent.action.event.MEETME_LIST_CHANGED")) {
                        AddressBookPanel.this.web_meetmeListChanged();
                    } else if (action.equals("ezphone.intent.action.event.MEETME_PHONE_PREFIX_CHANGED")) {
                        AddressBookPanel.this.web_meetmeListChanged();
                        AddressBookPanel.this.web_groupListChanged();
                    } else if (action.equals("ezphone.intent.action.event.MEETME_USER_LIST_CHANGED")) {
                        Long roomId;
                        if (intent.hasExtra("roomId") && (roomId = Long.valueOf(intent.getLongExtra("roomId", -1L))) != -1L) {
                            AddressBookPanel.this.web_meetmeListChanged();
                        }
                    } else if (action.equals("ezphone.intent.action.event.CHAT_PARTICIPANT_CHANGED")) {
                        AddressBookPanel.this.chat_participantChanged(intent);
                    } else if (action.equals("ezphone.intent.action.event.CHAT_ROOM_INFO_UPDATE")) {
                        String roomJid = bundle.getString("roomJID");
                        AddressBookPanel.this.chat_roomInfoUpdated(roomJid);
                    } else if (action.equals("ezphone.intent.action.event.CONTACT_PHOTO_CHANGED")) {
                        String jid = intent.getStringExtra("jid");
                        AddressBookPanel.this.web_photoChanged(jid);
                        AddressBookPanel.this.web_groupListChanged();
                    } else if (action.equals("ezphone.intent.action.event.EXTERNAL_PHOTO_CHANGED")) {
                        long contactId = intent.getLongExtra("id", -1L);
                        AddressBookPanel.this.web_externalPhotoChanged(contactId);
                    } else if (action.equals("ezphone.intent.action.event.PHONE_EMP_STATUS_CHANGED")) {
                        ArrayList<String> empIds = intent.getStringArrayListExtra("employeeIdList");
                        AddressBookPanel.this.phone_emp_statusChanged(empIds);
                    } else if (action.equals("ezphone.intent.action.event.PHONE_LOC_STATUS_CHANGED")) {
                        ArrayList<String> locJids = intent.getStringArrayListExtra("locationJidList");
                        AddressBookPanel.this.phone_loc_statusChanged(locJids);
                    }
                }
                catch (Throwable t) {
                    Log.e(AddressBookPanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezphone.intent.action.event.COMPANY_NAME_CHANGE");
        this.filter.addAction("ezphone.intent.action.event.CONTACT_LIST_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.GROUP_LIST_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.EXTERNAL_CONTACT_LIST_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.MEETME_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.MEETME_LIST_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.MEETME_USER_LIST_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.CHAT_PARTICIPANT_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.CHAT_ROOM_INFO_UPDATE");
        this.filter.addAction("ezphone.intent.action.event.CONTACT_PHOTO_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.EXTERNAL_PHOTO_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.PHONE_EMP_STATUS_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.PHONE_LOC_STATUS_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.MEETME_PHONE_PREFIX_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    private void initMyAddressBookDefaultGroups() {
        this.myAddressBookGroupMap.clear();
        this.contentMyAddressBook.removeAll();
        for (String myAddressBookGroup : myAddressBookGroups) {
            String groupName = null;
            GroupPanel groupPanel = null;
            if ("contactGroup.favorite".equals(myAddressBookGroup)) {
                groupName = I18NUtil.getString("abook_my_favorites");
                groupPanel = new GroupPanel(myAddressBookGroup, groupName, null, GroupPanelType.general, this);
            } else if ("contactGroup.myContact".equals(myAddressBookGroup)) {
                groupName = I18NUtil.getString("abook_mycontact_list");
                groupPanel = new GroupPanel(myAddressBookGroup, groupName, null, GroupPanelType.general, this);
            } else if ("contactGroup.myChatRoom".equals(myAddressBookGroup)) {
                groupName = I18NUtil.getString("abook_my_chatrooms");
                groupPanel = new GroupPanel(myAddressBookGroup, groupName, null, GroupPanelType.general, this);
            }
            if (groupPanel == null) continue;
            boolean collapse = PreferencesUtil.isGeneralBookGroupCollapsed(UCChatClient.context, myAddressBookGroup);
            groupPanel.setExpanded(!collapse);
            if (myAddressBookGroup.equals("abook_my_favorites")) {
                groupPanel.putClientProperty(KEY_FAVORITE_MENU, Boolean.TRUE);
            }
            this.myAddressBookGroupMap.put(myAddressBookGroup, groupPanel);
            this.contentMyAddressBook.add(groupPanel);
        }
        this.contentMyAddressBook.revalidate();
        this.contentMyAddressBook.repaint();
    }

    private void initContactEntryMenu() {
        this.popupEmployeeEntry = new JPopupMenu();
        this.popupEmployeeEntry.addPopupMenuListener(this.myPopupMenuListener);
        this.popupEmployeeEntry.add(new ChatAction());
        this.employeeVoiceChatAction = new VoiceChatAction();
        this.popupEmployeeEntry.add(this.employeeVoiceChatAction);
        this.popupEmployeeEntry.add(new DetailAction());
        this.popupEmployeeEntry.addSeparator();
        this.employeeFavoriteAction = new FavoriteAction();
        this.popupEmployeeEntry.add(this.employeeFavoriteAction);
        this.popupChatRoomEntry = new JPopupMenu();
        this.popupChatRoomEntry.addPopupMenuListener(this.myPopupMenuListener);
        this.popupChatRoomEntry.add(new ChatAction());
        this.chatroomVoiceChatAction = new VoiceChatAction();
        this.popupChatRoomEntry.add(this.chatroomVoiceChatAction);
        this.popupChatRoomEntry.addSeparator();
        this.chatroomFavoriteAction = new FavoriteAction();
        this.popupChatRoomEntry.add(this.chatroomFavoriteAction);
        this.popupConfRoomJoinEntry = new JPopupMenu();
        this.popupConfRoomJoinEntry.addPopupMenuListener(this.myPopupMenuListener);
        this.popupConfRoomJoinEntry.add(new ChatAction());
        this.confroomVoiceChatAction = new VoiceChatAction();
        this.popupConfRoomJoinEntry.add(this.confroomVoiceChatAction);
        this.popupConfRoomJoinEntry.addSeparator();
        this.confroomFavoriteAction = new FavoriteAction();
        this.popupConfRoomJoinEntry.add(this.confroomFavoriteAction);
        this.popupConfRoomJoinEntry.add(new ShowMeetmeMemberAction());
        this.popupConfRoomJoinEntry.add(new ExitMeetmeAction());
        this.popupConfRoomLeaveEntry = new JPopupMenu();
        this.popupConfRoomLeaveEntry.addPopupMenuListener(this.myPopupMenuListener);
        this.popupConfRoomLeaveEntry.add(new JoinMeetmeAction());
        this.popupMyContactEntry = new JPopupMenu();
        this.popupMyContactEntry.addPopupMenuListener(this.myPopupMenuListener);
        this.removeMyContactAction = new RemoveMyContactAction();
        this.popupMyContactEntry.add(this.removeMyContactAction);
    }

    private void initPopupSortingMode() {
        this.popupSortingMode = new SortingModePopup(UCChatClient.getInstance(), this.sortingMode, new SortingModePopup.SortingModeCallback(){

            @Override
            public void onSortingModeChanged(AddressBookSortingMode mode) {
                AddressBookPanel.this.sortingMode = mode;
                if (AddressBookPanel.this.sortingMode == AddressBookSortingMode.alphabet) {
                    PreferencesUtil.setEmpBookMenuSelection(UCChatClient.context, 0);
                } else if (AddressBookPanel.this.sortingMode == AddressBookSortingMode.department) {
                    PreferencesUtil.setEmpBookMenuSelection(UCChatClient.context, 1);
                } else if (AddressBookPanel.this.sortingMode == AddressBookSortingMode.status) {
                    PreferencesUtil.setEmpBookMenuSelection(UCChatClient.context, 2);
                }
                AddressBookPanel.this.refreshEmployeeList();
            }
        });
    }

    public void release() {
        this.sfCompany.clearSearchKey();
        this.sfMyAddressBook.clearSearchKey();
        this.sfConferenceRoom.clearSearchKey();
        this.entryPanelMap.clear();
        this.historySelectedEntrySet.clear();
        this.menuDisplayedEntryPanel = null;
        this.selectedEntryPanel = null;
        this.contentCompany.removeAll();
        this.contentCompany.revalidate();
        this.contentCompany.repaint();
        this.contentMyAddressBook.removeAll();
        this.contentMyAddressBook.revalidate();
        this.contentMyAddressBook.repaint();
        this.contentConferenceRoom.clearContentComponent();
        this.contentConferenceRoom.revalidate();
        this.contentConferenceRoom.repaint();
        this.initMyAddressBookDefaultGroups();
        this.switchSelectedTab(CARD_COMPANY);
    }

    private void searchCompany(String key, boolean expandGroup) {
        Object groupPane;
        String searchKey = key.toLowerCase();
        if (TextUtils.isBlank((CharSequence)searchKey)) {
            List<Component> groupPanes = GraphicUtil.getChildComponent(this.contentCompany, GroupPanel.class);
            for (Component groupPaneComp : groupPanes) {
                Component[] comps;
                GroupPanel groupPane2 = (GroupPanel)groupPaneComp;
                for (Component comp : comps = groupPane2.getContentComponents()) {
                    if (!(comp instanceof EntryPanel)) continue;
                    comp.setVisible(true);
                }
            }
            for (Component groupPaneComp : groupPanes) {
                GroupPanel groupPane2;
                groupPane2.setVisible((groupPane2 = (GroupPanel)groupPaneComp).getVisibleContentComponentCount() > 0);
                groupPane2.updateTitleByVisibleComponentCount();
            }
            return;
        }
        List groupList = null;
        HashSet<String> participaint = new HashSet<String>();
        switch (this.sortingMode) {
            case alphabet: {
                groupList = UCDBContact.getContactsOrderByName(UCChatClient.context, searchKey, -1, participaint);
                break;
            }
            case department: {
                groupList = UCDBContact.getContactsOrderByGroup(UCChatClient.context, searchKey, -1, participaint);
                Collections.sort(groupList, new DepartmentContactListSorter(UCChatClient.context));
                break;
            }
            case status: {
                groupList = UCDBContact.getContactsOrderByPresence(UCChatClient.context, searchKey, -1, participaint);
            }
        }
        LiteContactListGenericSorter sorter = new LiteContactListGenericSorter();
        if (groupList != null) {
            for (AddressBookGroup group : groupList) {
                Collections.sort(group.getDataList(), sorter);
            }
        }
        List<Component> groupPanes = GraphicUtil.getChildComponent(this.contentCompany, GroupPanel.class);
        for (Component component : groupPanes) {
            Component[] comps;
            groupPane = (GroupPanel)component;
            for (Component comp : comps = ((GroupPanel)groupPane).getContentComponents()) {
                if (!(comp instanceof EntryPanel)) continue;
                comp.setVisible(false);
            }
        }
        for (AddressBookGroup addressBookGroup : groupList) {
            groupPane = addressBookGroup.getDataList().iterator();
            while (groupPane.hasNext()) {
                LiteContact contact = (LiteContact)groupPane.next();
                Collection<EmployeeEntryPanel> entryPanels = this.findEmployeeEntryPanel(contact.getJid());
                for (EmployeeEntryPanel entryPanel : entryPanels) {
                    entryPanel.setVisible(true);
                }
            }
        }
        for (Component component : groupPanes) {
            ((JComponent)groupPane).setVisible(((GroupPanel)(groupPane = (GroupPanel)component)).getVisibleContentComponentCount() > 0);
            ((GroupPanel)groupPane).updateTitleByVisibleComponentCount();
        }
    }

    private void searchMyAddressBook(String key) {
        GroupPanel groupPane;
        String searchKey = key.toLowerCase();
        if (TextUtils.isBlank((CharSequence)searchKey)) {
            List<Component> groupPanes = GraphicUtil.getChildComponent(this.contentMyAddressBook, GroupPanel.class);
            for (Component groupPaneComp : groupPanes) {
                Component[] comps;
                GroupPanel groupPane2 = (GroupPanel)groupPaneComp;
                for (Component comp : comps = groupPane2.getContentComponents()) {
                    if (!(comp instanceof EntryPanel)) continue;
                    comp.setVisible(true);
                }
            }
            for (Component groupPaneComp : groupPanes) {
                GroupPanel groupPane2;
                groupPane2.setVisible((groupPane2 = (GroupPanel)groupPaneComp).getVisibleContentComponentCount() > 0);
                groupPane2.updateTitleByVisibleComponentCount();
                groupPane2.setMode(false);
            }
            return;
        }
        List<Object> resultList = UCDBGroup.findMyFavoriteGroup(UCChatClient.context, key, true, true);
        List<Object> chatRoomList = UCDBGroup.findMyChatRoomGroup(UCChatClient.context, key);
        List myContactGroupList = UCDBExternalContact.findExternalContacts(UCChatClient.context, key);
        if (resultList != null) {
            if (chatRoomList != null) {
                resultList.addAll(chatRoomList);
            }
        } else {
            resultList = chatRoomList;
        }
        if (myContactGroupList != null) {
            for (AddressBookGroup objList : myContactGroupList) {
                this.doUnionResult(objList.getDataList(), resultList);
            }
        }
        List<Component> groupPanes = GraphicUtil.getChildComponent(this.contentMyAddressBook, GroupPanel.class);
        for (Component groupPaneComp : groupPanes) {
            groupPane = (GroupPanel)groupPaneComp;
            Component[] comps = groupPane.getContentComponents();
            for (Component comp : comps) {
                if (!(comp instanceof EntryPanel)) continue;
                comp.setVisible(false);
            }
        }
        for (Object result : resultList) {
            Collection<EntryPanel> entryPanels;
            if (result instanceof LiteContact) {
                LiteContact contact = (LiteContact)result;
                entryPanels = this.findEmployeeEntryPanel(contact.getJid());
                for (EmployeeEntryPanel employeeEntryPanel : entryPanels) {
                    employeeEntryPanel.setVisible(true);
                }
                continue;
            }
            if (result instanceof ChatRoomInfo) {
                ChatRoomInfo chatroom = (ChatRoomInfo)result;
                Collection<MeetmeEntryPanel> meetmeEPs = this.findMeetmeEntryPanel(chatroom.getChatRoomId());
                for (MeetmeEntryPanel meetmeEntryPanel : meetmeEPs) {
                    meetmeEntryPanel.setVisible(true);
                }
                Collection<ChatRoomEntryPanel> chatroomEPs = this.findRoomEntryPanel(chatroom.getChatRoomId());
                for (ChatRoomEntryPanel entryPanel3 : chatroomEPs) {
                    entryPanel3.setVisible(true);
                }
                continue;
            }
            if (!(result instanceof LiteMyContact)) continue;
            LiteMyContact myContact = (LiteMyContact)result;
            entryPanels = this.findMyContactEntryPanel(myContact.getId());
            for (MyContactEntryPanel myContactEntryPanel : entryPanels) {
                myContactEntryPanel.setVisible(true);
            }
        }
        for (Component groupPaneComp : groupPanes) {
            groupPane.setVisible((groupPane = (GroupPanel)groupPaneComp).getVisibleContentComponentCount() > 0);
            groupPane.updateTitleByVisibleComponentCount();
            groupPane.setMode(true);
        }
    }

    private void doUnionResult(List<Object> dataList, List<Object> result) {
        for (Object i : dataList) {
            boolean inList;
            Object contact;
            if (i instanceof LiteContact) {
                contact = (LiteContact)i;
                inList = this.isInSearchList(result, (LiteContact)contact);
                if (inList) continue;
                result.add(contact);
                continue;
            }
            if (i instanceof LiteMyContact) {
                contact = (LiteMyContact)i;
                inList = this.isInSearchList(result, (LiteMyContact)contact);
                if (inList) continue;
                result.add(contact);
                continue;
            }
            if (!(i instanceof ChatRoomInfo) || (inList = this.isInSearchList(result, (ChatRoomInfo)(contact = (ChatRoomInfo)i)))) continue;
            result.add(contact);
        }
    }

    private boolean isInSearchList(List<Object> result, LiteContact data) {
        boolean inList = false;
        for (Object i : result) {
            if (!(i instanceof LiteContact)) continue;
            LiteContact contact = (LiteContact)i;
            if (data.getJid() == null || !data.getJid().equals(contact.getJid())) continue;
            inList = true;
            break;
        }
        return inList;
    }

    private boolean isInSearchList(List<Object> result, LiteMyContact data) {
        boolean inList = false;
        for (Object i : result) {
            if (!(i instanceof LiteMyContact)) continue;
            LiteMyContact contact = (LiteMyContact)i;
            if (data.getId().longValue() != contact.getId().longValue()) continue;
            inList = true;
            break;
        }
        return inList;
    }

    private boolean isInSearchList(List<Object> result, ChatRoomInfo data) {
        boolean inList = false;
        for (Object i : result) {
            if (!(i instanceof LiteContact)) continue;
            ChatRoomInfo contact = (ChatRoomInfo)i;
            if (!data.getChatRoomId().equals(contact.getChatRoomId())) continue;
            inList = true;
            break;
        }
        return inList;
    }

    private void searchConferenceRoom(String key) {
        Component[] entryPanels;
        key = key.toLowerCase();
        String meetmePrefix = OutboundPrefixManager.getMeetmePrefix(UCChatClient.context);
        for (Component entryPanelComp : entryPanels = this.contentConferenceRoom.getContentComponents(MeetmeEntryPanel.class)) {
            MeetmeEntryPanel entryPanel = (MeetmeEntryPanel)entryPanelComp;
            String displayName = entryPanel.getDisplayName() == null ? "" : entryPanel.getDisplayName().toLowerCase();
            String phoneNumber = entryPanel.getPhoneNumber() == null ? "" : meetmePrefix + entryPanel.getPhoneNumber().toLowerCase();
            String summary = entryPanel.getSummary() == null ? "" : entryPanel.getSummary().toLowerCase();
            entryPanel.setVisible(displayName != null && displayName.indexOf(key) >= 0 || phoneNumber != null && phoneNumber.indexOf(key) >= 0 || summary != null && summary.indexOf(key) >= 0);
        }
    }

    private EmployeeEntryPanel addEmployeeEntryPanel(LiteContact contact, String displayName, int index, GroupPanel groupPanel, boolean addHistorySet) {
        EmployeeEntryPanel eep = new EmployeeEntryPanel(contact, displayName);
        eep.setSelected(false);
        eep.addMouseListener(this.epml);
        groupPanel.addContentComponent(eep, index);
        groupPanel.revalidate();
        groupPanel.repaint();
        this.entryPanelMap.put(eep, groupPanel);
        if (addHistorySet) {
            this.historySelectedEntrySet.add(eep);
        }
        return eep;
    }

    private MeetmeEntryPanel addMeetmeEntryPanel(LiteConferenceRoom liteConfRoom, int index, GroupPanel groupPanel, boolean addHistorySet) {
        MeetmeEntryPanel mep = new MeetmeEntryPanel(liteConfRoom);
        mep.setSelected(false);
        mep.addMouseListener(this.epml);
        groupPanel.addContentComponent(mep, index);
        groupPanel.revalidate();
        groupPanel.repaint();
        this.entryPanelMap.put(mep, groupPanel);
        if (addHistorySet) {
            this.historySelectedEntrySet.add(mep);
        }
        return mep;
    }

    private ChatRoomEntryPanel addChatRoomEntryPanel(ChatRoomInfo chatRoomInfo, int index, GroupPanel groupPanel, boolean addHistorySet) {
        ChatRoomEntryPanel crep = new ChatRoomEntryPanel(chatRoomInfo);
        crep.setSelected(false);
        crep.addMouseListener(this.epml);
        groupPanel.addContentComponent(crep, index);
        groupPanel.revalidate();
        groupPanel.repaint();
        this.entryPanelMap.put(crep, groupPanel);
        if (addHistorySet) {
            this.historySelectedEntrySet.add(crep);
        }
        return crep;
    }

    private MyContactEntryPanel addMyContactEntryPanel(LiteMyContact myContact, int index, GroupPanel groupPanel, boolean addHistorySet) {
        MyContactEntryPanel mcep = new MyContactEntryPanel(myContact);
        mcep.setSelected(false);
        mcep.addMouseListener(this.epml);
        groupPanel.addContentComponent(mcep, index);
        groupPanel.revalidate();
        groupPanel.repaint();
        this.entryPanelMap.put(mcep, groupPanel);
        if (addHistorySet) {
            this.historySelectedEntrySet.add(mcep);
        }
        return mcep;
    }

    private void removeEntryPanel(EntryPanel ep) {
        GroupPanel groupPanel = this.entryPanelMap.get(ep);
        groupPanel.removeContentComponent(ep);
        groupPanel.revalidate();
        groupPanel.repaint();
        this.entryPanelMap.remove(ep);
        this.historySelectedEntrySet.remove(ep);
    }

    private void removeEntryPanel(String entryId, GroupPanel fromGroupPane) {
        Log.d(AddressBookPanel.class.getSimpleName(), "remove entryId:" + entryId + " fromGroupPane:" + String.valueOf(fromGroupPane));
        Collection<EntryPanel> eps = this.findEntryPanel(entryId);
        for (EntryPanel ep : eps) {
            GroupPanel groupPanel = this.entryPanelMap.get(ep);
            if (groupPanel != fromGroupPane) continue;
            groupPanel.removeContentComponent(ep);
            groupPanel.revalidate();
            groupPanel.repaint();
            this.entryPanelMap.remove(ep);
            this.historySelectedEntrySet.remove(ep);
            return;
        }
    }

    private void removeEntryPanel(GroupPanel fromGroupPane) {
        Log.d(AddressBookPanel.class.getSimpleName(), "remove fromGroupPane:" + String.valueOf(fromGroupPane));
        HashSet<EntryPanel> eps = new HashSet<EntryPanel>(this.entryPanelMap.keySet());
        for (EntryPanel ep : eps) {
            GroupPanel groupPanel = this.entryPanelMap.get(ep);
            if (groupPanel != fromGroupPane) continue;
            groupPanel.removeContentComponent(ep);
            this.entryPanelMap.remove(ep);
            this.historySelectedEntrySet.remove(ep);
        }
        fromGroupPane.revalidate();
        fromGroupPane.repaint();
    }

    private EntryPanel moveEntryPanel(String entryId, int index, GroupPanel fromGroupPane) {
        Log.d(AddressBookPanel.class.getSimpleName(), "moveEntryPanel:" + entryId + " index:" + index + " fromGroupPane:" + String.valueOf(fromGroupPane));
        Collection<EntryPanel> eps = this.findEntryPanel(entryId);
        for (EntryPanel ep : eps) {
            GroupPanel groupPanel = this.entryPanelMap.get(ep);
            if (groupPanel != fromGroupPane) continue;
            boolean selected = ep.isSelected();
            groupPanel.moveContentComponent(ep, index);
            ep.setSelected(selected);
            return ep;
        }
        return null;
    }

    private Collection<ChatRoomEntryPanel> findRoomEntryPanel(String roomJID) {
        ArrayList<ChatRoomEntryPanel> ret = new ArrayList<ChatRoomEntryPanel>();
        Set<EntryPanel> eps = this.entryPanelMap.keySet();
        for (EntryPanel ep : eps) {
            ChatRoomEntryPanel crep;
            if (!(ep instanceof ChatRoomEntryPanel) || !(crep = (ChatRoomEntryPanel)ep).getRoomJID().equals(roomJID)) continue;
            ret.add(crep);
        }
        return ret;
    }

    private Collection<MeetmeEntryPanel> findMeetmeEntryPanel(String roomJID) {
        ArrayList<MeetmeEntryPanel> ret = new ArrayList<MeetmeEntryPanel>();
        Set<EntryPanel> eps = this.entryPanelMap.keySet();
        for (EntryPanel ep : eps) {
            MeetmeEntryPanel mep;
            if (!(ep instanceof MeetmeEntryPanel) || !(mep = (MeetmeEntryPanel)ep).getRoomJID().equals(roomJID)) continue;
            ret.add(mep);
        }
        return ret;
    }

    private Collection<MeetmeEntryPanel> findMeetmeEntryPanel(long roomId) {
        ArrayList<MeetmeEntryPanel> ret = new ArrayList<MeetmeEntryPanel>();
        Set<EntryPanel> eps = this.entryPanelMap.keySet();
        for (EntryPanel ep : eps) {
            MeetmeEntryPanel mep;
            if (!(ep instanceof MeetmeEntryPanel) || (mep = (MeetmeEntryPanel)ep).getRoomId() != roomId) continue;
            ret.add(mep);
        }
        return ret;
    }

    private Collection<EmployeeEntryPanel> findEmployeeEntryPanel(String employeeJID) {
        ArrayList<EmployeeEntryPanel> ret = new ArrayList<EmployeeEntryPanel>();
        Set<EntryPanel> eps = this.entryPanelMap.keySet();
        for (EntryPanel ep : eps) {
            EmployeeEntryPanel eep;
            String chatId;
            if (!(ep instanceof EmployeeEntryPanel) || (chatId = (eep = (EmployeeEntryPanel)ep).getChatId()) == null || !chatId.equals(employeeJID)) continue;
            ret.add(eep);
        }
        return ret;
    }

    private Collection<MyContactEntryPanel> findMyContactEntryPanel(long contactId) {
        ArrayList<MyContactEntryPanel> ret = new ArrayList<MyContactEntryPanel>();
        Set<EntryPanel> eps = this.entryPanelMap.keySet();
        for (EntryPanel ep : eps) {
            MyContactEntryPanel mcep;
            long valueId;
            if (!(ep instanceof MyContactEntryPanel) || (valueId = Long.parseLong((mcep = (MyContactEntryPanel)ep).getValueId())) != contactId) continue;
            ret.add(mcep);
        }
        return ret;
    }

    private Collection<EntryPanel> findEntryPanel(String entryId) {
        ArrayList<EntryPanel> ret = new ArrayList<EntryPanel>();
        HashSet<EntryPanel> eps = new HashSet<EntryPanel>(this.entryPanelMap.keySet());
        for (EntryPanel ep : eps) {
            String _entryId = ep.getEntryId();
            if (_entryId == null || !_entryId.equals(entryId)) continue;
            ret.add(ep);
        }
        return ret;
    }

    private Map<String, GroupPanel> getGroupPanelMap(Container container) {
        Component[] comps;
        HashMap<String, GroupPanel> ret = new HashMap<String, GroupPanel>();
        for (Component comp : comps = container.getComponents()) {
            if (!(comp instanceof GroupPanel)) continue;
            GroupPanel gp = (GroupPanel)comp;
            ret.put(gp.getGroupId(), gp);
        }
        return ret;
    }

    public int getGroupPanelInsertIndex(Container container, String newGroupId, int fromIndex) {
        Component[] comps = container.getComponents();
        int compCount = comps.length;
        if (newGroupId.equalsIgnoreCase("#")) {
            return compCount;
        }
        for (int i = fromIndex; i < compCount; ++i) {
            if (!(comps[i] instanceof GroupPanel)) continue;
            GroupPanel groupPanel = (GroupPanel)comps[i];
            String groupId = groupPanel.getGroupId();
            if (groupId.equalsIgnoreCase("#")) {
                return i;
            }
            if (groupId.compareToIgnoreCase(newGroupId) <= 0) continue;
            return i;
        }
        return compCount;
    }

    private List<String> getEntryPanelIds(GroupPanel groupPanel) {
        Component[] comps;
        ArrayList<String> ret = new ArrayList<String>();
        for (Component comp : comps = groupPanel.getContentComponents()) {
            if (!(comp instanceof EntryPanel)) continue;
            EntryPanel ep = (EntryPanel)comp;
            ret.add(ep.getEntryId());
        }
        return ret;
    }

    private int getEntryPanelInsertIndex(GroupPanel groupPanel, String newEntryPanelDispName) {
        int index;
        Component[] comps = groupPanel.getContentComponents();
        for (index = 0; index < comps.length; ++index) {
            EntryPanel ep = (EntryPanel)comps[index];
            if (newEntryPanelDispName.toUpperCase().compareTo(ep.getDisplayName().toUpperCase()) >= 0) continue;
            return index;
        }
        return index;
    }

    public Collection<EntryPanel> getAllEntryPanel() {
        ArrayList<EntryPanel> ret = new ArrayList<EntryPanel>(this.entryPanelMap.keySet());
        return ret;
    }

    private void switchSelectedTab(String cardName) {
        for (JLabel tablabel : this.tablabelMap.values()) {
            tablabel.setBackground(BACKGROUND_UNSELECTED_TAB);
        }
        this.tablabelMap.get(cardName).setBackground(BACKGROUND_SELECTED_TAB);
        this.panelToolbarLayout.show(this.panelToolbar, cardName);
        this.tabContentLayout.show(this.tabContent, cardName);
    }

    private void toggleGroupPanelExpanded(JComponent container) {
        Component[] comps;
        Boolean expanded = (Boolean)container.getClientProperty("childrenExpanded");
        if (expanded == null) {
            expanded = Boolean.TRUE;
        }
        expanded = expanded == false;
        container.putClientProperty("childrenExpanded", expanded);
        for (Component comp : comps = container.getComponents()) {
            if (!(comp instanceof GroupPanel)) continue;
            GroupPanel groupPanel = (GroupPanel)comp;
            groupPanel.setExpanded(expanded);
        }
    }

    public void refreshCompanyName() {
    }

    public void refreshCompanyLogo() {
        BufferedImage companyLogo = FileUtil.readLogoBigPhoto();
        ImageIcon companyLogoIcon = companyLogo == null ? UIConstants.ICON_LOGO32 : GraphicUtil.getScaledIcon(companyLogo, 48, 48);
        this.tablabelCompany.setIcon(companyLogoIcon);
    }

    public void refreshLicenseControl() {
        Activity context = UCChatClient.context;
        this.tablabelConferenceRoom.setVisible(PreferencesUtil.hasConferenceLicense(context));
        this.myAddressBookGroupMap.get("contactGroup.myContact").setVisible(PreferencesUtil.hasPhoneCallLicense(context));
    }

    private void web_companyNameChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                AddressBookPanel.this.refreshCompanyName();
            }
        });
    }

    private void web_employeeListChanged() {
        if (this.isVisible()) {
            this.refreshEmployeeList();
        } else {
            this.refreshEmployeeCount.incrementAndGet();
        }
    }

    private void web_groupListChanged() {
        if (this.isVisible()) {
            this.refreshGroupList();
        } else {
            this.refreshGroupCount.incrementAndGet();
        }
    }

    private void web_myContactListChanged() {
        if (this.isVisible()) {
            this.refreshMyContactList();
        } else {
            this.refreshMyContactCount.incrementAndGet();
        }
    }

    private void web_meetmeListChanged() {
        if (this.isVisible()) {
            this.refreshMeetmeList();
        } else {
            this.refreshMeetmeCount.incrementAndGet();
        }
    }

    private void web_meetmeChanged(long roomId) {
        this.updateMeetme(roomId);
    }

    private void web_photoChanged(final String jid) {
        Log.d(AddressBookPanel.class.getSimpleName(), "web_photoChanged " + jid);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, jid);
                Image image = ContactManager.getContactImage(contact, 48, false, true);
                Collection<EmployeeEntryPanel> eeps = AddressBookPanel.this.findEmployeeEntryPanel(jid);
                for (EmployeeEntryPanel eep : eeps) {
                    eep.setPersonalPhoto(image);
                }
            }
        });
    }

    private void web_externalPhotoChanged(final Long contactId) {
        Log.d(AddressBookPanel.class.getSimpleName(), "web_externalPhotoChanged " + contactId);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LiteMyContact contact = ContactManager.getExternalContact((Context)UCChatClient.context, contactId);
                Image image = ContactManager.getExternalContactImage(contact, 48, false, true);
                Collection<MyContactEntryPanel> mceps = AddressBookPanel.this.findMyContactEntryPanel(contactId);
                for (MyContactEntryPanel mcep : mceps) {
                    mcep.setPersonalPhoto(image);
                }
            }
        });
    }

    private void chat_participantChanged(Intent intent) {
        final String roomJID = intent.getStringExtra("chatId");
        if (roomJID != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Collection<MeetmeEntryPanel> meps = AddressBookPanel.this.findMeetmeEntryPanel(roomJID);
                    for (MeetmeEntryPanel mep : meps) {
                        mep.updateMeetme();
                    }
                }
            });
        }
    }

    private void chat_roomInfoUpdated(final String roomJID) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(UCChatClient.context, roomJID);
                Collection<ChatRoomEntryPanel> crsps = AddressBookPanel.this.findRoomEntryPanel(roomJID);
                for (ChatRoomEntryPanel crsp : crsps) {
                    crsp.setChatRoomInfo(roomInfo);
                }
                Collection<MeetmeEntryPanel> meps = AddressBookPanel.this.findMeetmeEntryPanel(roomJID);
                for (MeetmeEntryPanel mep : meps) {
                    mep.updateMeetme();
                }
            }
        });
    }

    private void phone_emp_statusChanged(final List<String> empIds) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (String empId : empIds) {
                    LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, Long.parseLong(empId));
                    if (contact == null) continue;
                    String empJID = contact.getJid();
                    String status = ContactManager.getPhoneEmpStatus(empId);
                    Collection<EmployeeEntryPanel> eeps = AddressBookPanel.this.findEmployeeEntryPanel(empJID);
                    for (EmployeeEntryPanel eep : eeps) {
                        eep.setPhoneStatus(status);
                    }
                }
                if (AddressBookPanel.this.sortingMode == AddressBookSortingMode.status) {
                    AddressBookPanel.this.refreshEmployeeList();
                }
            }
        });
    }

    private void phone_loc_statusChanged(final List<String> locJids) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (String jid : locJids) {
                    LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, jid);
                    if (contact == null) continue;
                    String status = ContactManager.getPhoneLocStatus(jid);
                    Collection<EmployeeEntryPanel> eeps = AddressBookPanel.this.findEmployeeEntryPanel(jid);
                    for (EmployeeEntryPanel eep : eeps) {
                        eep.setPhoneStatus(status);
                    }
                }
                if (AddressBookPanel.this.sortingMode == AddressBookSortingMode.status) {
                    AddressBookPanel.this.refreshEmployeeList();
                }
            }
        });
    }

    private int getNextSeq() {
        int next;
        int current;
        while (!this.seq.compareAndSet(current, next = (current = this.seq.get()) >= Integer.MAX_VALUE ? 0 : current + 1)) {
        }
        return next;
    }

    public void refreshEmployeeList() {
        Log.i(AddressBookPanel.class.getSimpleName(), "refreshEmployeeList");
        if (this.refreshEmployeeListTask != null) {
            this.refreshEmployeeListTask.markCancel();
        }
        this.refreshEmployeeListTask = new RefreshEmployeeListTask(this.getNextSeq());
        this.refreshEmployeeListTask.start();
    }

    public void refreshGroupList() {
        Log.i(AddressBookPanel.class.getSimpleName(), "refreshGroupList");
        if (this.refreshGroupListTask != null) {
            this.refreshGroupListTask.markCancel();
        }
        this.refreshGroupListTask = new RefreshGroupListTask(this.getNextSeq());
        this.refreshGroupListTask.start();
    }

    public void refreshMyContactList() {
        Log.i(AddressBookPanel.class.getSimpleName(), "refreshMyContactList");
        if (this.refreshMyContactListTask != null) {
            this.refreshMyContactListTask.markCancel();
        }
        this.refreshMyContactListTask = new RefreshMyContactListTask(this.getNextSeq());
        this.refreshMyContactListTask.start();
    }

    public void refreshMeetmeList() {
        Log.i(AddressBookPanel.class.getSimpleName(), "refreshMeetmeList");
        if (this.refreshMeetmeListTask != null) {
            this.refreshMeetmeListTask.markCancel();
        }
        this.refreshMeetmeListTask = new RefreshMeetmeListTask(this.getNextSeq());
        this.refreshMeetmeListTask.start();
    }

    private void updateMeetme(final long roomId) {
        final LiteConferenceRoom confRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, roomId);
        if (confRoom == null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Collection<MeetmeEntryPanel> eps = AddressBookPanel.this.findMeetmeEntryPanel(roomId);
                    for (EntryPanel entryPanel : eps) {
                        AddressBookPanel.this.removeEntryPanel(entryPanel);
                    }
                }
            });
        } else {
            final Collection<MeetmeEntryPanel> meps = this.findMeetmeEntryPanel(roomId);
            if (meps.size() == 0) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String dispName = ChatRoomUtil.getConfRoomTitle(UCChatClient.context, null, confRoom, true, true);
                        int index = AddressBookPanel.this.getEntryPanelInsertIndex(AddressBookPanel.this.contentConferenceRoom, dispName);
                        AddressBookPanel.this.addMeetmeEntryPanel(confRoom, index, AddressBookPanel.this.contentConferenceRoom, true);
                    }
                });
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        for (MeetmeEntryPanel mep : meps) {
                            mep.updateMeetme();
                        }
                    }
                });
            }
        }
    }

    private GroupPanel getBelongingGroupPanel(Component cep) {
        Container groupPanel = cep.getParent();
        while (!(groupPanel instanceof GroupPanel)) {
            if (groupPanel == null || groupPanel == this) {
                return null;
            }
            groupPanel = groupPanel.getParent();
        }
        return (GroupPanel)groupPanel;
    }

    private void thisComponentShown(ComponentEvent evt) {
        if (this.refreshEmployeeCount.intValue() > 0) {
            this.refreshEmployeeCount.set(0);
            this.refreshEmployeeList();
        }
        if (this.refreshGroupCount.intValue() > 0) {
            this.refreshGroupCount.set(0);
            this.refreshGroupList();
        }
        if (this.refreshMyContactCount.intValue() > 0) {
            this.refreshMyContactCount.set(0);
            this.refreshMyContactList();
        }
        if (this.refreshMeetmeCount.intValue() > 0) {
            this.refreshMeetmeCount.set(0);
            this.refreshMeetmeList();
        }
    }

    private void switchSelectedEntryPanel(EntryPanel entryPanel, boolean isSwitchContactHistory) {
        if (this.selectedEntryPanel != entryPanel) {
            if (this.selectedEntryPanel != null) {
                this.selectedEntryPanel.setSelected(false);
            }
            this.selectedEntryPanel = entryPanel;
            this.selectedEntryPanel.setSelected(true);
        }
        if (isSwitchContactHistory) {
            this.switchContactHistory();
        }
    }

    private void switchContactHistory() {
        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
        EntryPanel.Type type = this.selectedEntryPanel.getType();
        switch (type) {
            case EMPLOYEE: {
                String chatId = this.selectedEntryPanel.getChatId();
                mainPanel.showChatroom(chatId);
                break;
            }
            case CHAT_ROOM: {
                String chatId = this.selectedEntryPanel.getChatId();
                mainPanel.showChatroom(chatId);
                break;
            }
            case CONFERENCE_ROOM: {
                String chatId = this.selectedEntryPanel.getChatId();
                Intent intent = new Intent();
                intent.putExtra("unjoined_display_mode", (Serializable)((Object)ConferenceChatroom.UnjoinedDisplayMode.JOIN));
                mainPanel.showChatroom(chatId, intent);
                break;
            }
            case MY_CONTACT: {
                long myContactId = Long.parseLong(this.selectedEntryPanel.getValueId());
                Intent intent = new Intent("com.blisscloud.mobile.ezphone.contact");
                intent.putExtra("contactid", myContactId);
                mainPanel.getViewContainer().showMyContactEditor(intent);
                break;
            }
        }
    }

    @Override
    public void onChanged() {
        this.checkAllFoldUnFold();
    }

    private void checkAllFoldUnFold() {
        Component[] comps;
        boolean containUnflod = false;
        for (Component comp : comps = this.contentCompany.getComponents()) {
            GroupPanel gp;
            if (!(comp instanceof GroupPanel) || !(gp = (GroupPanel)comp).isExpaned() || !gp.isVisible()) continue;
            containUnflod = true;
        }
        if (containUnflod) {
            this.btnFoldAll.setVisible(true);
            this.btnUnfoldAll.setVisible(false);
        } else {
            this.btnFoldAll.setVisible(false);
            this.btnUnfoldAll.setVisible(true);
        }
    }

    private void foldAll() {
        Component[] comps;
        for (Component comp : comps = this.contentCompany.getComponents()) {
            GroupPanel gp;
            if (!(comp instanceof GroupPanel) || !(gp = (GroupPanel)comp).isExpaned()) continue;
            gp.clickGroup();
        }
        this.checkAllFoldUnFold();
    }

    private void unfoldAll() {
        Component[] comps;
        for (Component comp : comps = this.contentCompany.getComponents()) {
            GroupPanel gp;
            if (!(comp instanceof GroupPanel) || (gp = (GroupPanel)comp).isExpaned()) continue;
            gp.clickGroup();
        }
        this.checkAllFoldUnFold();
    }

    public void switchAddressBookEntry(String chatId) {
        if (this.historySelectedEntrySet != null) {
            HashSet<EntryPanel> entrySet = new HashSet<EntryPanel>(this.historySelectedEntrySet);
            for (EntryPanel entry : entrySet) {
                if (!chatId.equals(entry.getChatId())) continue;
                this.switchSelectedEntryPanel(entry, false);
                return;
            }
        }
        if (this.selectedEntryPanel != null) {
            this.selectedEntryPanel.setSelected(false);
            this.selectedEntryPanel = null;
        }
    }

    public void setUnselectedAddressBookEntry() {
        if (this.selectedEntryPanel != null) {
            this.selectedEntryPanel.setSelected(false);
            this.selectedEntryPanel = null;
        }
    }

    static {
        myAddressBookGroups.add("contactGroup.favorite");
        myAddressBookGroups.add("contactGroup.myChatRoom");
        myAddressBookGroups.add("contactGroup.myContact");
    }

    class EntryPanelMouseListener
    extends MouseAdapter {
        EntryPanelMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.getButton() == 1) {
                AddressBookPanel.this.switchSelectedEntryPanel((EntryPanel)evt.getComponent(), true);
            }
            this.checkPopup(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.checkPopup(evt);
        }

        private void checkPopup(MouseEvent evt) {
            EntryPanel entryPanel;
            GroupPanel groupPanel;
            if (evt.isPopupTrigger() && (groupPanel = AddressBookPanel.this.getBelongingGroupPanel(entryPanel = (EntryPanel)evt.getComponent())) != null) {
                AddressBookPanel.this.menuDisplayedEntryPanel = entryPanel;
                AddressBookPanel.this.menuDisplayedEntryPanel.setMenuDisplayed(true);
                PhoneAgent.LineAvailableType ableToCall = PhoneAgent.getInstance().isAvailableToCall();
                EntryPanel.Type type = entryPanel.getType();
                switch (type) {
                    case EMPLOYEE: {
                        if (entryPanel instanceof EmployeeEntryPanel) {
                            EmployeeEntryPanel xx = (EmployeeEntryPanel)entryPanel;
                            String selfJid = PreferencesUtil.getUserJid(UCChatClient.context);
                            if (selfJid.equalsIgnoreCase(xx.getChatId())) {
                                return;
                            }
                        }
                        AddressBookPanel.this.employeeVoiceChatAction.setEnabled(ableToCall != PhoneAgent.LineAvailableType.NONE);
                        AddressBookPanel.this.employeeFavoriteAction.setFavorite(ChatRoomManager.isInMyFavorite(entryPanel.getChatId()));
                        AddressBookPanel.this.popupEmployeeEntry.show(entryPanel, evt.getX(), evt.getY());
                        break;
                    }
                    case CHAT_ROOM: {
                        AddressBookPanel.this.chatroomVoiceChatAction.setEnabled(ableToCall != PhoneAgent.LineAvailableType.NONE);
                        AddressBookPanel.this.chatroomFavoriteAction.setFavorite(ChatRoomManager.isInMyFavorite(entryPanel.getChatId()));
                        AddressBookPanel.this.popupChatRoomEntry.show(entryPanel, evt.getX(), evt.getY());
                        break;
                    }
                    case CONFERENCE_ROOM: {
                        boolean isJoin = UCDBChatRoom.hasParticipants(UCChatClient.context, entryPanel.getChatId());
                        if (isJoin) {
                            AddressBookPanel.this.confroomVoiceChatAction.setEnabled(ableToCall != PhoneAgent.LineAvailableType.NONE);
                            AddressBookPanel.this.confroomFavoriteAction.setFavorite(ChatRoomManager.isInMyFavorite(entryPanel.getChatId()));
                            AddressBookPanel.this.confroomFavoriteAction.setEnabled(true);
                            AddressBookPanel.this.popupConfRoomJoinEntry.show(entryPanel, evt.getX(), evt.getY());
                            break;
                        }
                        AddressBookPanel.this.popupConfRoomLeaveEntry.show(entryPanel, evt.getX(), evt.getY());
                        break;
                    }
                    case MY_CONTACT: {
                        AddressBookPanel.this.removeMyContactAction.setMyContact(((MyContactEntryPanel)entryPanel).getMyContact());
                        AddressBookPanel.this.popupMyContactEntry.show(entryPanel, evt.getX(), evt.getY());
                    }
                }
            }
        }
    }

    class RefreshEmployeeListTask
    extends Thread {
        private boolean cancel = false;

        public void markCancel() {
            this.cancel = true;
        }

        public RefreshEmployeeListTask(int seq) {
            this.setName("UC-RefreshEmployeeListTask-" + seq);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String string = AddressBookPanel.this.refreshEmployeeListLock;
            synchronized (string) {
                Log.d(AddressBookPanel.class.getSimpleName(), "run " + this.getName() + ": cancel:" + this.cancel);
                if (this.cancel) {
                    return;
                }
                String searchKey = null;
                List groupList = null;
                HashSet<String> participaint = new HashSet<String>();
                switch (AddressBookPanel.this.sortingMode) {
                    case alphabet: {
                        groupList = UCDBContact.getContactsOrderByName(UCChatClient.context, searchKey, -1, participaint);
                        break;
                    }
                    case department: {
                        groupList = UCDBContact.getContactsOrderByGroup(UCChatClient.context, searchKey, -1, participaint);
                        Collections.sort(groupList, new DepartmentContactListSorter(UCChatClient.context));
                        break;
                    }
                    case status: {
                        groupList = UCDBContact.getContactsOrderByPresence(UCChatClient.context, searchKey, -1, participaint);
                    }
                }
                LiteContactListGenericSorter sorter = new LiteContactListGenericSorter();
                if (groupList != null) {
                    for (AddressBookGroup group : groupList) {
                        Collections.sort(group.getDataList(), sorter);
                    }
                }
                final List dataList = groupList;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Map<String, GroupPanel> xGroupPanelMap = AddressBookPanel.this.getGroupPanelMap(AddressBookPanel.this.contentCompany);
                        for (Map.Entry<String, GroupPanel> entry : xGroupPanelMap.entrySet()) {
                            GroupPanel groupPanel = entry.getValue();
                            AddressBookPanel.this.removeEntryPanel(groupPanel);
                            groupPanel.clean();
                        }
                        AddressBookPanel.this.contentCompany.removeAll();
                        if (dataList != null && dataList.size() != 0) {
                            Map<Object, Object> groupPanelMap = new HashMap();
                            int insertIndex = 0;
                            for (AddressBookGroup addressBookGroup : dataList) {
                                insertIndex = AddressBookPanel.this.getGroupPanelInsertIndex(AddressBookPanel.this.contentCompany, addressBookGroup.getId(), insertIndex);
                                String newGroupId = addressBookGroup.getId();
                                String newGroupName = addressBookGroup.getDispName();
                                if (AddressBookPanel.this.sortingMode == AddressBookSortingMode.department && "location".equalsIgnoreCase(newGroupId)) {
                                    newGroupName = I18NUtil.getString("abook_label_public_phone");
                                }
                                GroupPanel newGroupPanel = null;
                                boolean collapse = false;
                                if (AddressBookPanel.this.sortingMode == AddressBookSortingMode.alphabet) {
                                    newGroupPanel = new GroupPanel(newGroupId, newGroupName, null, GroupPanelType.alphabet, AddressBookPanel.this);
                                    collapse = PreferencesUtil.isCompanyAddressBookGroupCollapsed(UCChatClient.context, newGroupId);
                                } else if (AddressBookPanel.this.sortingMode == AddressBookSortingMode.department) {
                                    newGroupPanel = new GroupPanel(newGroupId, newGroupName, null, GroupPanelType.department, AddressBookPanel.this);
                                    collapse = PreferencesUtil.isOrgAddressBookGroupCollapsed(UCChatClient.context, newGroupId);
                                } else if (AddressBookPanel.this.sortingMode == AddressBookSortingMode.status) {
                                    newGroupPanel = new GroupPanel(newGroupId, newGroupName, null, GroupPanelType.status, AddressBookPanel.this);
                                    collapse = PreferencesUtil.isStatusAddressBookGroupCollapsed(UCChatClient.context, newGroupId);
                                }
                                if (newGroupPanel == null) continue;
                                newGroupPanel.setExpanded(!collapse);
                                newGroupPanel.putClientProperty(AddressBookPanel.KEY_FAVORITE_MENU, Boolean.TRUE);
                                AddressBookPanel.this.contentCompany.add((Component)newGroupPanel, insertIndex);
                                ++insertIndex;
                            }
                            groupPanelMap = AddressBookPanel.this.getGroupPanelMap(AddressBookPanel.this.contentCompany);
                            int groupCount = dataList.size();
                            for (int groupIndex = 0; groupIndex < groupCount; ++groupIndex) {
                                AddressBookGroup addressBookGroup = (AddressBookGroup)dataList.get(groupIndex);
                                String groupId = addressBookGroup.getId();
                                List<LiteContact> employees = addressBookGroup.getDataList();
                                GroupPanel groupPanel = (GroupPanel)groupPanelMap.get(groupId);
                                List<String> oldEmpEntryIDs = AddressBookPanel.this.getEntryPanelIds(groupPanel);
                                ArrayList<String> unchangedEmpEntryIDs = new ArrayList<String>(oldEmpEntryIDs);
                                List<String> newEmpEntryIDs = RefreshEmployeeListTask.this.getEmployeeEntryIds(employees);
                                unchangedEmpEntryIDs.retainAll(newEmpEntryIDs);
                                newEmpEntryIDs.removeAll(unchangedEmpEntryIDs);
                                oldEmpEntryIDs.removeAll(unchangedEmpEntryIDs);
                                for (String oldEmployeeJID : oldEmpEntryIDs) {
                                    AddressBookPanel.this.removeEntryPanel(oldEmployeeJID, groupPanel);
                                }
                                int employeeCount = employees.size();
                                int employeeIndex = 0;
                                for (int i = 0; i < employeeCount; ++i) {
                                    LiteContact employee = employees.get(i);
                                    String empEntryId = EntryPanel.Type.EMPLOYEE.name() + "-" + employee.getId();
                                    String empDispName = ContactManager.getContactFullName(employee);
                                    if (unchangedEmpEntryIDs.contains(empEntryId)) {
                                        EmployeeEntryPanel eep = (EmployeeEntryPanel)AddressBookPanel.this.moveEntryPanel(empEntryId, employeeIndex, groupPanel);
                                        eep.setLiteContact(employee, empDispName);
                                    } else if (newEmpEntryIDs.contains(empEntryId)) {
                                        AddressBookPanel.this.addEmployeeEntryPanel(employee, empDispName, employeeIndex, groupPanel, true);
                                    }
                                    ++employeeIndex;
                                }
                            }
                        }
                        AddressBookPanel.this.searchCompany(AddressBookPanel.this.sfCompany.getSearchKey(), false);
                        AddressBookPanel.this.contentCompany.revalidate();
                        AddressBookPanel.this.contentCompany.repaint();
                        AddressBookPanel.this.checkAllFoldUnFold();
                    }
                });
            }
        }

        private List<String> getEmployeeEntryIds(List<LiteContact> employeeList) {
            ArrayList<String> ret = new ArrayList<String>();
            if (employeeList != null && employeeList.size() != 0) {
                for (LiteContact employee : employeeList) {
                    ret.add(String.valueOf((Object)EntryPanel.Type.EMPLOYEE) + "-" + employee.getId());
                }
            }
            return ret;
        }
    }

    class RefreshGroupListTask
    extends Thread {
        private boolean cancel = false;

        public void markCancel() {
            this.cancel = true;
        }

        public RefreshGroupListTask(int seq) {
            this.setName("UC-RefreshGroupListTask-" + seq);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String string = AddressBookPanel.this.refreshGroupListLock;
            synchronized (string) {
                Log.d(AddressBookPanel.class.getSimpleName(), "run " + this.getName() + ": cancel:" + this.cancel);
                if (this.cancel) {
                    return;
                }
                String searchKey = null;
                final List<Object> myFavoriteList = UCDBGroup.findMyFavoriteGroup(UCChatClient.context, searchKey, true, true);
                final List<Object> myChatRoomList = UCDBGroup.findMyChatRoomGroup(UCChatClient.context, searchKey);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GroupPanel groupPane_favorite = AddressBookPanel.this.myAddressBookGroupMap.get("contactGroup.favorite");
                        List<String> oldFavoriteEntryIDs = AddressBookPanel.this.getEntryPanelIds(groupPane_favorite);
                        ArrayList<String> unchangedFavoriteEntryIDs = new ArrayList<String>(oldFavoriteEntryIDs);
                        List<String> newFavoriteEntryIDs = RefreshGroupListTask.this.getFavoriteEntryIds(myFavoriteList);
                        unchangedFavoriteEntryIDs.retainAll(newFavoriteEntryIDs);
                        newFavoriteEntryIDs.removeAll(unchangedFavoriteEntryIDs);
                        oldFavoriteEntryIDs.removeAll(unchangedFavoriteEntryIDs);
                        if (myFavoriteList == null || myFavoriteList.size() == 0) {
                            groupPane_favorite.clearContentComponent();
                        } else {
                            for (String oldFavoriteID : oldFavoriteEntryIDs) {
                                AddressBookPanel.this.removeEntryPanel(oldFavoriteID, groupPane_favorite);
                            }
                            int favoriteCount = myFavoriteList.size();
                            int favoriteIndex = 0;
                            for (int i = 0; i < favoriteCount; ++i) {
                                Object favorite = myFavoriteList.get(i);
                                if (favorite instanceof ChatRoomInfo) {
                                    String roomEntryID;
                                    ChatRoomInfo chatRoomInfo = (ChatRoomInfo)favorite;
                                    String chatRoomId = chatRoomInfo.getChatRoomId();
                                    if (JidUtil.isChatJid(chatRoomId)) {
                                        roomEntryID = EntryPanel.Type.CHAT_ROOM.name() + "-" + chatRoomId;
                                        if (unchangedFavoriteEntryIDs.contains(roomEntryID)) {
                                            ChatRoomEntryPanel crep = (ChatRoomEntryPanel)AddressBookPanel.this.moveEntryPanel(roomEntryID, favoriteIndex, groupPane_favorite);
                                            crep.setChatRoomInfo(chatRoomInfo);
                                        } else if (newFavoriteEntryIDs.contains(roomEntryID)) {
                                            AddressBookPanel.this.addChatRoomEntryPanel(chatRoomInfo, favoriteIndex, groupPane_favorite, true);
                                        }
                                        ++favoriteIndex;
                                        continue;
                                    }
                                    if (!JidUtil.isConfJid(chatRoomId)) continue;
                                    roomEntryID = EntryPanel.Type.CONFERENCE_ROOM.name() + "-" + chatRoomId;
                                    if (unchangedFavoriteEntryIDs.contains(roomEntryID)) {
                                        MeetmeEntryPanel mep = (MeetmeEntryPanel)AddressBookPanel.this.moveEntryPanel(roomEntryID, favoriteIndex, groupPane_favorite);
                                        mep.updateMeetme();
                                    } else if (newFavoriteEntryIDs.contains(roomEntryID)) {
                                        LiteConferenceRoom confRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, chatRoomId);
                                        AddressBookPanel.this.addMeetmeEntryPanel(confRoom, favoriteIndex, groupPane_favorite, false);
                                    }
                                    ++favoriteIndex;
                                    continue;
                                }
                                if (favorite instanceof LiteMyContact) {
                                    LiteMyContact myContact = (LiteMyContact)favorite;
                                    String myContactEntryId = EntryPanel.Type.MY_CONTACT.name() + "-" + myContact.getId();
                                    if (unchangedFavoriteEntryIDs.contains(myContactEntryId)) {
                                        MyContactEntryPanel mcep = (MyContactEntryPanel)AddressBookPanel.this.moveEntryPanel(myContactEntryId, favoriteIndex, groupPane_favorite);
                                        mcep.setLiteMyContact(myContact);
                                    } else if (newFavoriteEntryIDs.contains(myContactEntryId)) {
                                        AddressBookPanel.this.addMyContactEntryPanel(myContact, favoriteIndex, groupPane_favorite, false);
                                    }
                                    ++favoriteIndex;
                                    continue;
                                }
                                if (favorite instanceof LiteContact) {
                                    LiteContact contact = (LiteContact)favorite;
                                    String contactEntryId = EntryPanel.Type.EMPLOYEE.name() + "-" + contact.getId();
                                    String contactDispName = ContactManager.getContactFullName(contact);
                                    if (unchangedFavoriteEntryIDs.contains(contactEntryId)) {
                                        EmployeeEntryPanel eep = (EmployeeEntryPanel)AddressBookPanel.this.moveEntryPanel(contactEntryId, favoriteIndex, groupPane_favorite);
                                        eep.setLiteContact(contact, contactDispName);
                                    } else if (newFavoriteEntryIDs.contains(contactEntryId)) {
                                        AddressBookPanel.this.addEmployeeEntryPanel(contact, contactDispName, favoriteIndex, groupPane_favorite, false);
                                    }
                                    ++favoriteIndex;
                                    continue;
                                }
                                Log.w(AddressBookPanel.class.getSimpleName(), "unexpected favorite type " + favorite.getClass().getName());
                            }
                        }
                        groupPane_favorite.revalidate();
                        groupPane_favorite.repaint();
                        GroupPanel groupPane_myChatRoom = AddressBookPanel.this.myAddressBookGroupMap.get("contactGroup.myChatRoom");
                        List<String> oldMyChatRoomEntryIDs = AddressBookPanel.this.getEntryPanelIds(groupPane_myChatRoom);
                        ArrayList<String> unchangedMyChatRoomEntryIDs = new ArrayList<String>(oldMyChatRoomEntryIDs);
                        List<String> newMyChatRoomEntryIDs = RefreshGroupListTask.this.getMyChatRoomEntryIds(myChatRoomList);
                        unchangedMyChatRoomEntryIDs.retainAll(newMyChatRoomEntryIDs);
                        newMyChatRoomEntryIDs.removeAll(unchangedMyChatRoomEntryIDs);
                        oldMyChatRoomEntryIDs.removeAll(unchangedMyChatRoomEntryIDs);
                        if (myChatRoomList == null || myChatRoomList.size() == 0) {
                            groupPane_myChatRoom.clearContentComponent();
                        } else {
                            for (String oldFavoriteID : oldMyChatRoomEntryIDs) {
                                AddressBookPanel.this.removeEntryPanel(oldFavoriteID, groupPane_myChatRoom);
                            }
                            int myChatRoomCount = myChatRoomList.size();
                            int myChatRoomIndex = 0;
                            for (int i = 0; i < myChatRoomCount; ++i) {
                                Object myChatRoom = myChatRoomList.get(i);
                                if (myChatRoom instanceof ChatRoomInfo) {
                                    String roomEntryID;
                                    ChatRoomInfo chatRoomInfo = (ChatRoomInfo)myChatRoom;
                                    String chatRoomId = chatRoomInfo.getChatRoomId();
                                    if (JidUtil.isChatJid(chatRoomId)) {
                                        roomEntryID = EntryPanel.Type.CHAT_ROOM.name() + "-" + chatRoomId;
                                        if (unchangedMyChatRoomEntryIDs.contains(roomEntryID)) {
                                            ChatRoomEntryPanel crep = (ChatRoomEntryPanel)AddressBookPanel.this.moveEntryPanel(roomEntryID, myChatRoomIndex, groupPane_myChatRoom);
                                            crep.setChatRoomInfo(chatRoomInfo);
                                        } else if (newMyChatRoomEntryIDs.contains(roomEntryID)) {
                                            AddressBookPanel.this.addChatRoomEntryPanel(chatRoomInfo, myChatRoomIndex, groupPane_myChatRoom, true);
                                        }
                                        ++myChatRoomIndex;
                                        continue;
                                    }
                                    if (!JidUtil.isConfJid(chatRoomId)) continue;
                                    roomEntryID = EntryPanel.Type.CONFERENCE_ROOM.name() + "-" + chatRoomId;
                                    if (unchangedMyChatRoomEntryIDs.contains(roomEntryID)) {
                                        MeetmeEntryPanel mep = (MeetmeEntryPanel)AddressBookPanel.this.moveEntryPanel(roomEntryID, myChatRoomIndex, groupPane_myChatRoom);
                                        mep.updateMeetme();
                                    } else if (newMyChatRoomEntryIDs.contains(roomEntryID)) {
                                        LiteConferenceRoom confRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, chatRoomId);
                                        AddressBookPanel.this.addMeetmeEntryPanel(confRoom, myChatRoomIndex, groupPane_myChatRoom, false);
                                    }
                                    ++myChatRoomIndex;
                                    continue;
                                }
                                Log.w(AddressBookPanel.class.getSimpleName(), "unexpected favorite type " + myChatRoom.getClass().getName());
                            }
                        }
                        groupPane_myChatRoom.revalidate();
                        groupPane_myChatRoom.repaint();
                        AddressBookPanel.this.searchMyAddressBook(AddressBookPanel.this.sfMyAddressBook.getSearchKey());
                    }
                });
            }
        }

        private List<String> getFavoriteEntryIds(List<Object> favoriteList) {
            ArrayList<String> ret = new ArrayList<String>();
            if (favoriteList != null && favoriteList.size() != 0) {
                for (Object favorite : favoriteList) {
                    if (favorite instanceof ChatRoomInfo) {
                        ChatRoomInfo chatRoomInfo = (ChatRoomInfo)favorite;
                        String chatRoomId = chatRoomInfo.getChatRoomId();
                        if (JidUtil.isChatJid(chatRoomId)) {
                            ret.add(EntryPanel.Type.CHAT_ROOM.name() + "-" + chatRoomInfo.getChatRoomId());
                            continue;
                        }
                        if (!JidUtil.isConfJid(chatRoomId)) continue;
                        ret.add(EntryPanel.Type.CONFERENCE_ROOM.name() + "-" + chatRoomInfo.getChatRoomId());
                        continue;
                    }
                    if (favorite instanceof LiteMyContact) {
                        LiteMyContact myContact = (LiteMyContact)favorite;
                        ret.add(EntryPanel.Type.MY_CONTACT.name() + "-" + myContact.getId());
                        continue;
                    }
                    if (!(favorite instanceof LiteContact)) continue;
                    LiteContact contact = (LiteContact)favorite;
                    ret.add(EntryPanel.Type.EMPLOYEE.name() + "-" + contact.getId());
                }
            }
            return ret;
        }

        private List<String> getMyChatRoomEntryIds(List<Object> chatRoomList) {
            ArrayList<String> ret = new ArrayList<String>();
            if (chatRoomList != null && chatRoomList.size() != 0) {
                for (Object chatRoom : chatRoomList) {
                    if (!(chatRoom instanceof ChatRoomInfo)) continue;
                    ChatRoomInfo chatRoomInfo = (ChatRoomInfo)chatRoom;
                    String chatRoomId = chatRoomInfo.getChatRoomId();
                    if (JidUtil.isChatJid(chatRoomId)) {
                        ret.add(EntryPanel.Type.CHAT_ROOM.name() + "-" + chatRoomInfo.getChatRoomId());
                        continue;
                    }
                    if (!JidUtil.isConfJid(chatRoomId)) continue;
                    ret.add(EntryPanel.Type.CONFERENCE_ROOM.name() + "-" + chatRoomInfo.getChatRoomId());
                }
            }
            return ret;
        }
    }

    class RefreshMyContactListTask
    extends Thread {
        private boolean cancel = false;

        public void markCancel() {
            this.cancel = true;
        }

        public RefreshMyContactListTask(int seq) {
            this.setName("UC-RefreshMyContactListTask-" + seq);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String string = AddressBookPanel.this.refreshMyContactListLock;
            synchronized (string) {
                Log.i(AddressBookPanel.class.getSimpleName(), "run " + this.getName() + ": cancel:" + this.cancel);
                if (this.cancel) {
                    return;
                }
                String searchKey = null;
                final List groupList = UCDBExternalContact.findExternalContacts(UCChatClient.context, searchKey);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GroupPanel groupPane_myContact = AddressBookPanel.this.myAddressBookGroupMap.get("contactGroup.myContact");
                        if (groupList == null || groupList.size() == 0) {
                            groupPane_myContact.clearContentComponent();
                        } else {
                            ArrayList<LiteMyContact> myContactList = new ArrayList<LiteMyContact>();
                            for (AddressBookGroup myContactGroup : groupList) {
                                if (myContactGroup == null) continue;
                                for (Object myContact : myContactGroup.getDataList()) {
                                    myContactList.add((LiteMyContact)myContact);
                                }
                            }
                            List<String> oldMyContactEntryIDs = AddressBookPanel.this.getEntryPanelIds(groupPane_myContact);
                            ArrayList<String> unchangedMyContactEntryIDs = new ArrayList<String>(oldMyContactEntryIDs);
                            List<String> newMyContactEntryIDs = RefreshMyContactListTask.this.getMyContactEntryIds(myContactList);
                            unchangedMyContactEntryIDs.retainAll(newMyContactEntryIDs);
                            newMyContactEntryIDs.removeAll(unchangedMyContactEntryIDs);
                            oldMyContactEntryIDs.removeAll(unchangedMyContactEntryIDs);
                            for (String oldMyContactID : oldMyContactEntryIDs) {
                                AddressBookPanel.this.removeEntryPanel(oldMyContactID, groupPane_myContact);
                            }
                            int myContactCount = myContactList.size();
                            for (int i = 0; i < myContactCount; ++i) {
                                LiteMyContact myContact = (LiteMyContact)myContactList.get(i);
                                String myContactEntryID = EntryPanel.Type.MY_CONTACT.name() + "-" + myContact.getId();
                                if (unchangedMyContactEntryIDs.contains(myContactEntryID)) {
                                    MyContactEntryPanel mcep = (MyContactEntryPanel)AddressBookPanel.this.moveEntryPanel(myContactEntryID, i, groupPane_myContact);
                                    mcep.setLiteMyContact(myContact);
                                    continue;
                                }
                                if (!newMyContactEntryIDs.contains(myContactEntryID)) continue;
                                AddressBookPanel.this.addMyContactEntryPanel(myContact, i, groupPane_myContact, true);
                            }
                        }
                        AddressBookPanel.this.searchMyAddressBook(AddressBookPanel.this.sfMyAddressBook.getSearchKey());
                        groupPane_myContact.revalidate();
                        groupPane_myContact.repaint();
                    }
                });
            }
        }

        private List<String> getMyContactEntryIds(List<LiteMyContact> myContactList) {
            ArrayList<String> ret = new ArrayList<String>();
            if (myContactList != null && myContactList.size() != 0) {
                for (LiteMyContact myContact : myContactList) {
                    ret.add(EntryPanel.Type.MY_CONTACT.name() + "-" + myContact.getId());
                }
            }
            return ret;
        }
    }

    class RefreshMeetmeListTask
    extends Thread {
        private boolean cancel = false;

        public void markCancel() {
            this.cancel = true;
        }

        public RefreshMeetmeListTask(int seq) {
            this.setName("UC-RefreshMeetmeListTask-" + seq);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            String string = AddressBookPanel.this.refreshMeetmeListLock;
            synchronized (string) {
                Log.i(AddressBookPanel.class.getSimpleName(), "run " + this.getName() + ": cancel:" + this.cancel);
                if (this.cancel) {
                    return;
                }
                final List<LiteConferenceRoom> meetmeList = MeetmeManager.getStaticMeetmeList(UCChatClient.context);
                if (meetmeList != null) {
                    Collections.sort(meetmeList, new ConferenceListSorter(UCChatClient.context));
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (meetmeList == null || meetmeList.size() == 0) {
                            AddressBookPanel.this.contentConferenceRoom.clearContentComponent();
                        } else {
                            List<String> oldMeetmeEntryIDs = AddressBookPanel.this.getEntryPanelIds(AddressBookPanel.this.contentConferenceRoom);
                            ArrayList<String> unchangedMeetmeEntryIDs = new ArrayList<String>(oldMeetmeEntryIDs);
                            List<String> newMeetmeEntryIDs = RefreshMeetmeListTask.this.getMeetmeEntryIds(meetmeList);
                            unchangedMeetmeEntryIDs.retainAll(newMeetmeEntryIDs);
                            newMeetmeEntryIDs.removeAll(unchangedMeetmeEntryIDs);
                            oldMeetmeEntryIDs.removeAll(unchangedMeetmeEntryIDs);
                            for (String oldMeetmeID : oldMeetmeEntryIDs) {
                                AddressBookPanel.this.removeEntryPanel(oldMeetmeID, AddressBookPanel.this.contentConferenceRoom);
                            }
                            int meetmeCount = meetmeList.size();
                            for (int i = 0; i < meetmeCount; ++i) {
                                LiteConferenceRoom meetme = (LiteConferenceRoom)meetmeList.get(i);
                                String meetmeEntryId = EntryPanel.Type.CONFERENCE_ROOM.name() + "-" + meetme.getRoomId();
                                if (unchangedMeetmeEntryIDs.contains(meetmeEntryId)) {
                                    MeetmeEntryPanel mep = (MeetmeEntryPanel)AddressBookPanel.this.moveEntryPanel(meetmeEntryId, i, AddressBookPanel.this.contentConferenceRoom);
                                    mep.updateMeetme();
                                    continue;
                                }
                                if (!newMeetmeEntryIDs.contains(meetmeEntryId)) continue;
                                AddressBookPanel.this.addMeetmeEntryPanel(meetme, i, AddressBookPanel.this.contentConferenceRoom, true);
                            }
                        }
                        AddressBookPanel.this.contentConferenceRoom.revalidate();
                        AddressBookPanel.this.contentConferenceRoom.repaint();
                    }
                });
            }
        }

        private List<String> getMeetmeEntryIds(List<LiteConferenceRoom> meetmeList) {
            ArrayList<String> ret = new ArrayList<String>();
            if (meetmeList != null && meetmeList.size() != 0) {
                for (LiteConferenceRoom meetme : meetmeList) {
                    ret.add(EntryPanel.Type.CONFERENCE_ROOM.name() + "-" + meetme.getRoomId());
                }
            }
            return ret;
        }
    }

    class MyPopupMenuListener
    implements PopupMenuListener {
        MyPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (AddressBookPanel.this.menuDisplayedEntryPanel != null && AddressBookPanel.this.menuDisplayedEntryPanel != AddressBookPanel.this.selectedEntryPanel) {
                AddressBookPanel.this.menuDisplayedEntryPanel.setMenuDisplayed(false);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    class ChatAction
    extends AbstractAction {
        public ChatAction() {
            this.putValue("Name", I18NUtil.getString("abook_popup_btn_chat"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddressBookPanel.this.menuDisplayedEntryPanel != null) {
                AddressBookPanel.this.switchSelectedEntryPanel(AddressBookPanel.this.menuDisplayedEntryPanel, true);
            }
        }
    }

    class VoiceChatAction
    extends AbstractAction {
        public VoiceChatAction() {
            this.putValue("Name", I18NUtil.getString("abook_popup_btn_talk"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddressBookPanel.this.menuDisplayedEntryPanel != null) {
                if (AddressBookPanel.this.menuDisplayedEntryPanel instanceof EmployeeEntryPanel) {
                    EmployeeEntryPanel eep = (EmployeeEntryPanel)AddressBookPanel.this.menuDisplayedEntryPanel;
                    eep.startDialOut();
                } else if (AddressBookPanel.this.menuDisplayedEntryPanel instanceof ChatRoomEntryPanel) {
                    ChatRoomEntryPanel crep = (ChatRoomEntryPanel)AddressBookPanel.this.menuDisplayedEntryPanel;
                    crep.startDialOut();
                } else if (AddressBookPanel.this.menuDisplayedEntryPanel instanceof MeetmeEntryPanel) {
                    MeetmeEntryPanel mep = (MeetmeEntryPanel)AddressBookPanel.this.menuDisplayedEntryPanel;
                    mep.startDialOut();
                }
            }
        }
    }

    class DetailAction
    extends AbstractAction {
        public DetailAction() {
            this.putValue("Name", I18NUtil.getString("abook_popup_btn_data"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddressBookPanel.this.menuDisplayedEntryPanel != null) {
                EmployeeEntryPanel eep = (EmployeeEntryPanel)AddressBookPanel.this.menuDisplayedEntryPanel;
                eep.showPersonalInfo();
            }
        }
    }

    class FavoriteAction
    extends AbstractAction {
        public FavoriteAction() {
            this.putValue("Name", I18NUtil.getString("abook_fun_add_to_my_favorites"));
        }

        public void setFavorite(boolean inFavorite) {
            if (inFavorite) {
                this.putValue("Name", I18NUtil.getString("abook_fun_remove_from_my_favorites"));
            } else {
                this.putValue("Name", I18NUtil.getString("abook_fun_add_to_my_favorites"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddressBookPanel.this.menuDisplayedEntryPanel != null) {
                ChatRoomManager.switchMyFavorite(AddressBookPanel.this.menuDisplayedEntryPanel.getChatId());
            }
        }
    }

    class ShowMeetmeMemberAction
    extends AbstractAction {
        public ShowMeetmeMemberAction() {
            this.putValue("Name", I18NUtil.getString("conference_member_details"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddressBookPanel.this.menuDisplayedEntryPanel != null) {
                AddressBookPanel.this.switchSelectedEntryPanel(AddressBookPanel.this.menuDisplayedEntryPanel, true);
                String roomJID = AddressBookPanel.this.menuDisplayedEntryPanel.getChatId();
                MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
                IChatroom room = mainPanel.getChatroom(roomJID);
                if (room != null) {
                    IMultiUserChatroom uRoom = (IMultiUserChatroom)room;
                    uRoom.execute("showMember");
                }
            }
        }
    }

    class ExitMeetmeAction
    extends AbstractAction {
        public ExitMeetmeAction() {
            this.putValue("Name", I18NUtil.getString("conference_btn_exit"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddressBookPanel.this.switchSelectedEntryPanel(AddressBookPanel.this.menuDisplayedEntryPanel, false);
            String roomJID = AddressBookPanel.this.menuDisplayedEntryPanel.getChatId();
            ConferenceChatroom.doExitMeetmeAction(roomJID);
        }
    }

    class JoinMeetmeAction
    extends AbstractAction {
        public JoinMeetmeAction() {
            this.putValue("Name", I18NUtil.getString("conference_btn_join"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddressBookPanel.this.switchSelectedEntryPanel(AddressBookPanel.this.menuDisplayedEntryPanel, true);
            if (AddressBookPanel.this.menuDisplayedEntryPanel instanceof MeetmeEntryPanel) {
                MeetmeEntryPanel p = (MeetmeEntryPanel)AddressBookPanel.this.menuDisplayedEntryPanel;
                p.meetmeJoinAction();
            }
        }
    }

    class RemoveMyContactAction
    extends AbstractAction {
        LiteMyContact mMyContact;

        public RemoveMyContactAction() {
            this.putValue("Name", I18NUtil.getString("abook_btn_removecontact"));
        }

        public void setMyContact(LiteMyContact myContact) {
            this.mMyContact = myContact;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int result;
            if (AddressBookPanel.this.menuDisplayedEntryPanel != null && AddressBookPanel.this.menuDisplayedEntryPanel.getType() == EntryPanel.Type.MY_CONTACT && (result = JOptionPane.showConfirmDialog(AddressBookPanel.this, I18NUtil.getString("abook_confirm_mycontact_delete"), I18NUtil.getString("common_title_warning"), 2, 2)) == 0) {
                String strId = String.valueOf(this.mMyContact.getId());
                boolean isMyFavorite = ContactManager.isInMyFavorite(UCChatClient.context, strId, 2);
                if (isMyFavorite) {
                    WebAgent.getInstance().removeFavorite(strId, 3);
                }
                WebAgent.getInstance().deleteExternalContact(strId);
                UCChatClient.getInstance().getMainPanel().getViewContainer().hideMyContactEditor();
                if (AddressBookPanel.this.menuDisplayedEntryPanel == AddressBookPanel.this.selectedEntryPanel) {
                    AddressBookPanel.this.selectedEntryPanel = null;
                }
                AddressBookPanel.this.menuDisplayedEntryPanel = null;
            }
        }
    }
}

